/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.ospf.controller.impl;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.onlab.packet.Ip4Address;
import org.onlab.util.Bandwidth;
import org.onosproject.ospf.controller.DeviceInformation;
import org.onosproject.ospf.controller.LinkInformation;
import org.onosproject.ospf.controller.OspfArea;
import org.onosproject.ospf.controller.OspfInterface;
import org.onosproject.ospf.controller.OspfLinkTed;
import org.onosproject.ospf.controller.OspfLsa;
import org.onosproject.ospf.controller.OspfLsaType;
import org.onosproject.ospf.controller.TopologyForDeviceAndLink;
import org.onosproject.ospf.controller.impl.DeviceInformationImpl;
import org.onosproject.ospf.controller.impl.LinkInformationImpl;
import org.onosproject.ospf.controller.impl.OspfLinkTedImpl;
import org.onosproject.ospf.protocol.lsa.linksubtype.LinkSubType;
import org.onosproject.ospf.protocol.lsa.linksubtype.LocalInterfaceIpAddress;
import org.onosproject.ospf.protocol.lsa.linksubtype.MaximumBandwidth;
import org.onosproject.ospf.protocol.lsa.linksubtype.MaximumReservableBandwidth;
import org.onosproject.ospf.protocol.lsa.linksubtype.RemoteInterfaceIpAddress;
import org.onosproject.ospf.protocol.lsa.linksubtype.TrafficEngineeringMetric;
import org.onosproject.ospf.protocol.lsa.linksubtype.UnreservedBandwidth;
import org.onosproject.ospf.protocol.lsa.subtypes.OspfLsaLink;
import org.onosproject.ospf.protocol.lsa.tlvtypes.LinkTlv;
import org.onosproject.ospf.protocol.lsa.types.NetworkLsa;
import org.onosproject.ospf.protocol.lsa.types.OpaqueLsa10;
import org.onosproject.ospf.protocol.lsa.types.RouterLsa;
import org.onosproject.ospf.protocol.lsa.types.TopLevelTlv;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TopologyForDeviceAndLinkImpl
implements TopologyForDeviceAndLink {
    private static final Logger log = LoggerFactory.getLogger(TopologyForDeviceAndLinkImpl.class);
    private Map<String, DeviceInformation> deviceInformationMap = new LinkedHashMap<String, DeviceInformation>();
    private Map<String, DeviceInformation> deviceInformationMapToDelete = new LinkedHashMap<String, DeviceInformation>();
    private HashMap<String, Set<OspfLsaLink>> deviceAndLinkInformation = new HashMap();
    private HashMap<String, OspfLinkTed> ospfLinkTedHashMap = new LinkedHashMap<String, OspfLinkTed>();
    private Ip4Address drRouter = Ip4Address.valueOf((String)"0.0.0.0");
    private Ip4Address drRouterOld = Ip4Address.valueOf((String)"0.0.0.0");
    private Ip4Address adRouterId = Ip4Address.valueOf((String)"0.0.0.0");
    private Map<String, LinkInformation> linkInformationMap = new LinkedHashMap<String, LinkInformation>();
    private List<String> toRemove = new ArrayList<String>();

    public Map<String, DeviceInformation> deviceInformationMap() {
        return this.deviceInformationMap;
    }

    public void setDeviceInformationMap(String key, DeviceInformation deviceInformationMap) {
        if (deviceInformationMap != null) {
            this.deviceInformationMap.put(key, deviceInformationMap);
        }
    }

    public Map<String, DeviceInformation> deviceInformationMapToDelete() {
        return this.deviceInformationMapToDelete;
    }

    public void setDeviceInformationMapToDelete(String key, DeviceInformation deviceInformationMapToDelete) {
        if (deviceInformationMapToDelete != null) {
            this.deviceInformationMapToDelete.put(key, deviceInformationMapToDelete);
        }
    }

    public void removeDeviceInformationMapFromDeleteMap(String key) {
        this.removeDeviceInformationMap(key);
        if (this.deviceInformationMapToDelete.containsKey(key)) {
            this.deviceInformationMapToDelete.remove(key);
        }
    }

    public DeviceInformation deviceInformation(String key) {
        DeviceInformation deviceInformation = this.deviceInformationMap.get(key);
        return deviceInformation;
    }

    public void removeDeviceInformationMap(String key) {
        if (this.deviceInformationMap.containsKey(key)) {
            this.deviceInformationMap.remove(key);
        }
    }

    public Map<String, LinkInformation> linkInformationMap() {
        return this.linkInformationMap;
    }

    public void setLinkInformationMap(String key, LinkInformation linkInformationMap) {
        if (!this.linkInformationMap.containsKey(key)) {
            this.linkInformationMap.put(key, linkInformationMap);
        }
    }

    public void removeLinkInformationMap(String key) {
        if (this.linkInformationMap.containsKey(key)) {
            this.linkInformationMap.remove(key);
        }
    }

    public OspfLinkTed getOspfLinkTedHashMap(String key) {
        OspfLinkTed ospfLinkTed = this.ospfLinkTedHashMap.get(key);
        return ospfLinkTed;
    }

    public void addLocalDevice(OspfLsa ospfLsa, OspfInterface ospfInterface, OspfArea ospfArea) {
        if (ospfLsa.getOspfLsaType().equals((Object)OspfLsaType.ROUTER)) {
            this.createDeviceAndLinkFromRouterLsa(ospfLsa, ospfArea);
        } else if (ospfLsa.getOspfLsaType().equals((Object)OspfLsaType.NETWORK)) {
            this.createDeviceAndLinkFromNetworkLsa(ospfLsa, ospfArea);
        } else if (ospfLsa.getOspfLsaType().equals((Object)OspfLsaType.AREA_LOCAL_OPAQUE_LSA)) {
            this.createDeviceAndLinkFromOpaqueLsa(ospfLsa, ospfArea);
        }
    }

    private DeviceInformation createDeviceInformation(boolean alreadyCreated, Ip4Address deviceId, Ip4Address neighborId, Ip4Address routerId, Ip4Address interfaceId, Ip4Address areaId, boolean isDr) {
        DeviceInformationImpl deviceInformation = new DeviceInformationImpl();
        deviceInformation.setAlreadyCreated(alreadyCreated);
        deviceInformation.setDeviceId(deviceId);
        deviceInformation.setNeighborId(neighborId);
        deviceInformation.setRouterId(routerId);
        deviceInformation.addInterfaceId(interfaceId);
        deviceInformation.setAreaId(areaId);
        deviceInformation.setDr(isDr);
        return deviceInformation;
    }

    private void createDeviceAndLinkFromRouterLsa(OspfLsa ospfLsa, OspfArea ospfArea) {
        Ip4Address advertisingRouterId;
        RouterLsa routerLsa = (RouterLsa)ospfLsa;
        List ospfLsaLinkList = routerLsa.routerLink();
        Iterator iterator = ospfLsaLinkList.iterator();
        this.adRouterId = advertisingRouterId = routerLsa.advertisingRouter();
        while (iterator.hasNext()) {
            String linkIdKey;
            String key;
            OspfLsaLink ospfLsaLink = (OspfLsaLink)iterator.next();
            Ip4Address linkId = Ip4Address.valueOf((String)ospfLsaLink.linkId());
            Ip4Address linkData = Ip4Address.valueOf((String)ospfLsaLink.linkData());
            if (ospfLsaLink.linkType() == 1) {
                if (advertisingRouterId.equals((Object)ospfArea.routerId()) || linkId.equals((Object)ospfArea.routerId())) {
                    System.out.println("OspfInterface information will not display in web ");
                    continue;
                }
                this.removeDevice(advertisingRouterId);
                this.removeLinks(advertisingRouterId);
                DeviceInformation deviceInformationPointToPoint = this.createDeviceInformation(false, linkId, linkId, advertisingRouterId, linkData, ospfArea.areaId(), false);
                key = "device:" + advertisingRouterId;
                this.setDeviceInformationMap(key, deviceInformationPointToPoint);
                linkIdKey = "linkId:" + advertisingRouterId + "-" + linkId;
                this.addLocalLink(linkIdKey, linkData, advertisingRouterId, linkId, true, false);
                continue;
            }
            if (ospfLsaLink.linkType() != 2) continue;
            if (advertisingRouterId.equals((Object)ospfArea.routerId()) || linkId.equals((Object)ospfArea.routerId())) {
                log.debug("OspfInterface information will not display in web ");
                continue;
            }
            if (linkId.equals((Object)linkData)) {
                String linkIdKey2;
                if (this.drRouter.equals((Object)Ip4Address.valueOf((String)"0.0.0.0"))) {
                    log.debug("drRouter not elected {} ", (Object)this.drRouter.toString());
                } else if (this.drRouterOld.equals((Object)linkId)) {
                    log.debug("drRouterOld same as link id {} ", (Object)this.drRouterOld.toString());
                } else {
                    String linkIdKey1;
                    String key2 = "device:" + this.drRouterOld;
                    DeviceInformation deviceInformation1 = this.deviceInformation(key2);
                    if (deviceInformation1 != null) {
                        deviceInformation1.setAlreadyCreated(true);
                        this.setDeviceInformationMapToDelete(key2, deviceInformation1);
                        linkIdKey = "linkId:" + linkId + "-" + deviceInformation1.neighborId();
                        this.addLocalLink(linkIdKey, linkData, linkId, deviceInformation1.neighborId(), true, false);
                        linkIdKey1 = "linkId:" + linkId + "-" + advertisingRouterId;
                        this.addLocalLink(linkIdKey1, linkData, linkId, advertisingRouterId, true, false);
                    } else {
                        DeviceInformation deviceInformationToDelete = this.createDeviceInformation(true, this.drRouterOld, this.drRouterOld, this.drRouterOld, this.drRouterOld, this.drRouterOld, true);
                        this.setDeviceInformationMapToDelete(key2, deviceInformationToDelete);
                        linkIdKey1 = "linkId:" + linkId + "-" + advertisingRouterId;
                        this.addLocalLink(linkIdKey1, linkData, linkId, advertisingRouterId, true, false);
                    }
                }
                this.drRouter = linkId;
                this.drRouterOld = linkId;
                DeviceInformation deviceInformationForDr = this.createDeviceInformation(false, linkId, advertisingRouterId, linkId, linkData, ospfArea.areaId(), true);
                key = "device:" + linkId;
                this.setDeviceInformationMap(key, deviceInformationForDr);
                DeviceInformation deviceInformationForAdvertisingRouter = this.createDeviceInformation(false, linkId, advertisingRouterId, advertisingRouterId, linkData, ospfArea.areaId(), false);
                String key1 = "device:" + advertisingRouterId;
                this.setDeviceInformationMap(key1, deviceInformationForAdvertisingRouter);
                if (this.drRouter.equals((Object)Ip4Address.valueOf((String)"0.0.0.0"))) {
                    System.out.println("Link will not get create since dr is not valid");
                    linkIdKey2 = "linkId:" + linkId + "-" + advertisingRouterId;
                    this.addLocalLink(linkIdKey2, linkData, linkId, advertisingRouterId, true, false);
                    continue;
                }
                linkIdKey2 = "linkId:" + this.drRouter + "-" + advertisingRouterId;
                this.addLocalLink(linkIdKey2, linkData, this.drRouter, advertisingRouterId, true, false);
                continue;
            }
            DeviceInformation deviceInformationDrOther = this.createDeviceInformation(false, linkId, linkId, advertisingRouterId, linkData, ospfArea.areaId(), false);
            key = "device:" + advertisingRouterId;
            this.setDeviceInformationMap(key, deviceInformationDrOther);
            if (this.drRouter.equals((Object)Ip4Address.valueOf((String)"0.0.0.0"))) {
                linkIdKey = "linkId:" + linkId + "-" + advertisingRouterId;
                this.addLocalLink(linkIdKey, linkData, linkId, advertisingRouterId, true, false);
                continue;
            }
            linkIdKey = "linkId:" + this.drRouter + "-" + advertisingRouterId;
            this.addLocalLink(linkIdKey, linkData, this.drRouter, advertisingRouterId, true, false);
        }
    }

    private void createDeviceAndLinkFromNetworkLsa(OspfLsa ospfLsa, OspfArea ospfArea) {
        NetworkLsa networkLsa = (NetworkLsa)ospfLsa;
        Ip4Address advertisingRouterId = networkLsa.networkMask();
        System.out.println("AdvertisingRouterId is : " + advertisingRouterId);
    }

    private void createDeviceAndLinkFromOpaqueLsa(OspfLsa ospfLsa, OspfArea ospfArea) {
        OspfLinkTedImpl ospfLinkTed = new OspfLinkTedImpl();
        OpaqueLsa10 opaqueLsa10 = (OpaqueLsa10)ospfLsa;
        List topLevelTlvList = opaqueLsa10.topLevelValues();
        for (TopLevelTlv topLevelTlv : topLevelTlvList) {
            if (!(topLevelTlv instanceof LinkTlv)) continue;
            LinkTlv linkTlv = (LinkTlv)topLevelTlv;
            List subTypes = linkTlv.subTlvList();
            for (LinkSubType type : subTypes) {
                Ip4Address ip4Address;
                List stringValue;
                Bandwidth bandwidth;
                if (type instanceof UnreservedBandwidth) {
                    UnreservedBandwidth unreservedBandwidth = (UnreservedBandwidth)type;
                    List bandwidthFloatValues = unreservedBandwidth.getUnReservedBandwidthValue();
                    ArrayList<Bandwidth> bandwidthList = new ArrayList<Bandwidth>();
                    for (Object value : bandwidthFloatValues) {
                        Bandwidth bandwidth2 = Bandwidth.bps((double)((Float)value).floatValue());
                        ospfLinkTed.setMaxUnResBandwidth(bandwidth2);
                        bandwidthList.add(bandwidth2);
                    }
                }
                if (type instanceof MaximumBandwidth) {
                    MaximumBandwidth maximumBandwidth = (MaximumBandwidth)type;
                    float maxBandValue = maximumBandwidth.getMaximumBandwidthValue();
                    bandwidth = Bandwidth.bps((double)maxBandValue);
                    ospfLinkTed.setMaximumLink(bandwidth);
                }
                if (type instanceof MaximumReservableBandwidth) {
                    MaximumReservableBandwidth maximumReservableBandwidth = (MaximumReservableBandwidth)type;
                    float maxResBandValue = maximumReservableBandwidth.getMaximumBandwidthValue();
                    bandwidth = Bandwidth.bps((double)maxResBandValue);
                    ospfLinkTed.setMaxReserved(bandwidth);
                }
                if (type instanceof TrafficEngineeringMetric) {
                    TrafficEngineeringMetric trafficEngineeringMetric = (TrafficEngineeringMetric)type;
                    long teMetric = trafficEngineeringMetric.getTrafficEngineeringMetricValue();
                    ospfLinkTed.setTeMetric((int)teMetric);
                }
                if (type instanceof LocalInterfaceIpAddress) {
                    LocalInterfaceIpAddress localInterfaceIpAddress = (LocalInterfaceIpAddress)type;
                    stringValue = localInterfaceIpAddress.getLocalInterfaceIPAddress();
                    ArrayList<Ip4Address> localIp4Address = new ArrayList<Ip4Address>();
                    for (Object value : stringValue) {
                        ip4Address = Ip4Address.valueOf((String)value);
                        localIp4Address.add(ip4Address);
                    }
                    ospfLinkTed.setIpv4LocRouterId(localIp4Address);
                }
                if (!(type instanceof RemoteInterfaceIpAddress)) continue;
                RemoteInterfaceIpAddress remoteInterfaceIpAddress = (RemoteInterfaceIpAddress)type;
                stringValue = remoteInterfaceIpAddress.getRemoteInterfaceAddress();
                ArrayList<Ip4Address> remoteIp4Address = new ArrayList<Ip4Address>();
                for (Object value : stringValue) {
                    ip4Address = Ip4Address.valueOf((String)value);
                    remoteIp4Address.add(ip4Address);
                }
                ospfLinkTed.setIpv4RemRouterId(remoteIp4Address);
            }
        }
        this.ospfLinkTedHashMap.put(this.adRouterId.toString(), ospfLinkTed);
    }

    public void addLocalLink(String advertisingRouter, Ip4Address linkData, Ip4Address linkSrc, Ip4Address linkDest, boolean opaqueEnabled, boolean linkSrcIdNotRouterId) {
        String linkKey = "link:";
        LinkInformationImpl linkInformation = new LinkInformationImpl();
        linkInformation.setLinkId(advertisingRouter);
        linkInformation.setLinkSourceId(linkSrc);
        linkInformation.setLinkDestinationId(linkDest);
        linkInformation.setAlreadyCreated(false);
        linkInformation.setLinkSrcIdNotRouterId(linkSrcIdNotRouterId);
        linkInformation.setInterfaceIp(linkData);
        if (linkDest != null) {
            linkInformation.setLinkSrcIdNotRouterId(false);
        }
        linkKey = linkKey + "-" + linkSrc + "-" + linkDest;
        this.setLinkInformationMap(linkKey, linkInformation);
    }

    public void removeLinks(Ip4Address routerId) {
        Map<String, LinkInformation> linkInformationMaplocal = this.linkInformationMap;
        if (linkInformationMaplocal != null) {
            for (Map.Entry<String, LinkInformation> entry : this.linkInformationMap.entrySet()) {
                boolean check1;
                String key = entry.getKey();
                boolean check = key.contains(routerId.toString());
                LinkInformation linkInformation = this.linkInformationMap.get(key);
                boolean bl = check1 = linkInformation.linkDestinationId() == routerId;
                if (!check && !check1) continue;
                this.toRemove.add(key);
            }
            this.removeLinkFromMap();
        }
    }

    public void removeDevice(Ip4Address routerId) {
        String key = "device:" + routerId;
        this.deviceInformationMap.remove(key);
    }

    private void removeLinkFromMap() {
        for (String key : this.toRemove) {
            this.removeLinkInformationMap(key);
        }
    }

    public void updateLinkInformation(OspfLsa ospfLsa, OspfArea ospfArea) {
        if (ospfLsa.getOspfLsaType().equals((Object)OspfLsaType.ROUTER)) {
            RouterLsa routerLsa = (RouterLsa)ospfLsa;
            routerLsa.lsType();
            List ospfLsaLinkList = routerLsa.routerLink();
            for (OspfLsaLink link : ospfLsaLinkList) {
                if (link.linkType != 1 && link.linkType != 2) continue;
                if (routerLsa.advertisingRouter().equals((Object)ospfArea.routerId()) || link.equals(ospfArea.routerId())) {
                    log.debug("OspfInterface information will not display in web ");
                    continue;
                }
                String key = routerLsa.advertisingRouter() + "-" + link.linkData();
                Set<Object> linkInformations = new HashSet<OspfLsaLink>();
                if (this.deviceAndLinkInformation.containsKey(key)) {
                    linkInformations = this.deviceAndLinkInformation.get(key);
                    linkInformations.add(link);
                    this.deviceAndLinkInformation.put(key, linkInformations);
                    continue;
                }
                linkInformations.add(link);
                this.deviceAndLinkInformation.put(key, linkInformations);
            }
        }
    }

    public List<String> getDeleteRouterInformation(OspfLsa ospfLsa, OspfArea ospfArea) {
        ArrayList<String> removedLinkList = new ArrayList<String>();
        if (ospfLsa.getOspfLsaType().equals((Object)OspfLsaType.ROUTER)) {
            RouterLsa routerLsa = (RouterLsa)ospfLsa;
            List ospfLsaLinkList = routerLsa.routerLink();
            for (OspfLsaLink link : ospfLsaLinkList) {
                if (link.linkType == 1 || link.linkType == 2) {
                    if (routerLsa.advertisingRouter().equals((Object)ospfArea.routerId()) || link.equals(ospfArea.routerId())) {
                        log.debug("OspfInterface information will not display in web ");
                    } else {
                        String key = routerLsa.advertisingRouter() + "-" + link.linkData();
                        Set<OspfLsaLink> linkInformations = this.deviceAndLinkInformation.get(key);
                        if (linkInformations.contains(link)) {
                            linkInformations.remove(link);
                            this.deviceAndLinkInformation.put(key, linkInformations);
                        }
                    }
                }
                Set<String> keys = this.deviceAndLinkInformation.keySet();
                for (String key : keys) {
                    Set<OspfLsaLink> linkInformations = this.deviceAndLinkInformation.get(key);
                    for (OspfLsaLink link1 : linkInformations) {
                        String removedLink = link1.linkId();
                        removedLinkList.add(removedLink);
                    }
                }
            }
        }
        return removedLinkList;
    }
}

