/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.ospf.controller.lsdb;

import com.google.common.base.MoreObjects;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.onosproject.ospf.controller.LsaBin;
import org.onosproject.ospf.controller.LsaWrapper;

public class LsaBinImpl
implements LsaBin {
    private int binNumber;
    private Map<String, LsaWrapper> listOfLsa = new ConcurrentHashMap<String, LsaWrapper>();

    public LsaBinImpl(int binNumber) {
        this.binNumber = binNumber;
    }

    public void addOspfLsa(String lsaKey, LsaWrapper lsaWrapper) {
        if (!this.listOfLsa.containsKey(lsaKey)) {
            this.listOfLsa.put(lsaKey, lsaWrapper);
            lsaWrapper.setBinNumber(this.binNumber);
        }
    }

    public LsaWrapper ospfLsa(String lsaKey) {
        return this.listOfLsa.get(lsaKey);
    }

    public void removeOspfLsa(String lsaKey, LsaWrapper lsaWrapper) {
        if (this.listOfLsa.containsKey(lsaKey)) {
            this.listOfLsa.remove(lsaKey);
        }
    }

    public Map<String, LsaWrapper> listOfLsa() {
        return this.listOfLsa;
    }

    public int binNumber() {
        return this.binNumber;
    }

    public String toString() {
        return MoreObjects.toStringHelper(this.getClass()).omitNullValues().add("binNumber", this.binNumber).add("listOfLsa", this.listOfLsa).toString();
    }
}

