/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.ospf.controller.lsdb;

import java.util.concurrent.BlockingQueue;
import org.jboss.netty.channel.Channel;
import org.onosproject.ospf.controller.LsaWrapper;
import org.onosproject.ospf.controller.OspfArea;
import org.onosproject.ospf.controller.OspfInterface;
import org.onosproject.ospf.controller.OspfLsa;
import org.onosproject.ospf.controller.OspfLsaType;
import org.onosproject.ospf.controller.area.OspfAreaImpl;
import org.onosproject.ospf.controller.area.OspfInterfaceImpl;
import org.onosproject.ospf.controller.lsdb.LsaWrapperImpl;
import org.onosproject.ospf.protocol.lsa.LsaHeader;
import org.onosproject.ospf.protocol.lsa.types.NetworkLsa;
import org.onosproject.ospf.protocol.lsa.types.RouterLsa;
import org.onosproject.ospf.protocol.util.ChecksumCalculator;
import org.onosproject.ospf.protocol.util.OspfInterfaceState;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LsaQueueConsumer
implements Runnable {
    private static final Logger log = LoggerFactory.getLogger(LsaQueueConsumer.class);
    private BlockingQueue queue = null;
    private Channel channel;
    private OspfArea ospfArea;

    public LsaQueueConsumer(BlockingQueue queue, Channel channel, OspfArea ospfArea) {
        this.queue = queue;
        this.channel = channel;
        this.ospfArea = ospfArea;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void run() {
        log.debug("LSAQueueConsumer:run...!!!");
        try {
            block12: while (true) {
                String lsaProcessing;
                if (this.queue.isEmpty()) {
                    continue;
                }
                LsaWrapper wrapper = (LsaWrapper)this.queue.take();
                switch (lsaProcessing = wrapper.lsaProcessing()) {
                    case "verifyChecksum": {
                        log.debug("LSAQueueConsumer: Message - verifyChecksum consumed.");
                        this.processVerifyChecksum(wrapper);
                        continue block12;
                    }
                    case "refreshLsa": {
                        log.debug("LSAQueueConsumer: Message - refreshLsa consumed.");
                        this.processRefreshLsa(wrapper);
                        continue block12;
                    }
                    case "maxAgeLsa": {
                        log.debug("LSAQueueConsumer: Message - maxAgeLsa consumed.");
                        this.processMaxAgeLsa(wrapper);
                        continue block12;
                    }
                }
                log.debug("Unknown command to process the LSA in queue ...!!!");
            }
        }
        catch (Exception e) {
            log.debug("Error::LSAQueueConsumer::{}", (Object)e.getMessage());
            return;
        }
    }

    private void processVerifyChecksum(LsaWrapper wrapper) throws Exception {
        ChecksumCalculator checkSum = new ChecksumCalculator();
        if (!checkSum.isValidLsaCheckSum(wrapper.ospfLsa(), ((LsaWrapperImpl)wrapper).lsaHeader().lsType(), 16, 17)) {
            log.debug("LSAQueueConsumer::Checksum mismatch. Received LSA packet type {} ", (Object)((LsaWrapperImpl)wrapper).lsaHeader().lsType());
        }
    }

    private void processRefreshLsa(LsaWrapper wrapper) throws Exception {
        OspfInterface ospfInterface;
        if (wrapper.isSelfOriginated() && (ospfInterface = wrapper.ospfInterface()) != null) {
            LsaHeader header = ((LsaWrapperImpl)wrapper).lsaHeader();
            header.setAge(wrapper.currentAge());
            if (((OspfInterfaceImpl)ospfInterface).state() == OspfInterfaceState.DR) {
                if (header.lsType() == OspfLsaType.ROUTER.value()) {
                    RouterLsa routerLsa = ((OspfAreaImpl)this.ospfArea).buildRouterLsa(ospfInterface);
                    ((OspfAreaImpl)this.ospfArea).addLsa((OspfLsa)routerLsa, true, ospfInterface);
                    ((OspfAreaImpl)this.ospfArea).addToOtherNeighborLsaTxList((LsaHeader)routerLsa);
                } else if (header.lsType() == OspfLsaType.NETWORK.value() && ospfInterface.listOfNeighbors().size() > 0) {
                    NetworkLsa networkLsa = ((OspfAreaImpl)this.ospfArea).buildNetworkLsa(ospfInterface.ipAddress(), ospfInterface.ipNetworkMask());
                    this.ospfArea.addLsa((OspfLsa)networkLsa, true, ospfInterface);
                    ((OspfAreaImpl)this.ospfArea).addToOtherNeighborLsaTxList((LsaHeader)networkLsa);
                }
            }
            if (((OspfInterfaceImpl)ospfInterface).state() == OspfInterfaceState.BDR || ((OspfInterfaceImpl)ospfInterface).state() == OspfInterfaceState.POINT2POINT || ((OspfInterfaceImpl)ospfInterface).state() == OspfInterfaceState.DROTHER) {
                this.ospfArea.refreshArea(ospfInterface);
            }
            log.debug("LSAQueueConsumer: processRefreshLsa - Flooded SelfOriginated LSA {}", (Object)((LsaWrapperImpl)wrapper).lsaHeader());
        }
    }

    private void processMaxAgeLsa(LsaWrapper wrapper) {
        OspfInterface ospfInterface = wrapper.ospfInterface();
        if (ospfInterface != null) {
            LsaHeader header = (LsaHeader)wrapper.ospfLsa().lsaHeader();
            header.setAge(3600);
            ((LsaWrapperImpl)wrapper).lsaHeader().setAge(3600);
            if (((OspfInterfaceImpl)ospfInterface).state() == OspfInterfaceState.DR || ((OspfInterfaceImpl)ospfInterface).state() == OspfInterfaceState.POINT2POINT) {
                ((OspfAreaImpl)this.ospfArea).addToOtherNeighborLsaTxList(((LsaWrapperImpl)wrapper).lsaHeader());
                ((OspfAreaImpl)this.ospfArea).deleteLsa(((LsaWrapperImpl)wrapper).lsaHeader());
            } else {
                ((OspfAreaImpl)this.ospfArea).deleteLsa(((LsaWrapperImpl)wrapper).lsaHeader());
            }
            log.debug("LSAQueueConsumer: processMaxAgeLsa - Flooded SelfOriginated-Max Age LSA {}", (Object)((LsaWrapperImpl)wrapper).lsaHeader());
        }
    }

    public void setChannel(Channel channel) {
        this.channel = channel;
    }
}

