/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.ospf.controller.lsdb;

import com.google.common.base.MoreObjects;
import com.google.common.base.Objects;
import org.onosproject.ospf.controller.LsaWrapper;
import org.onosproject.ospf.controller.LsdbAge;
import org.onosproject.ospf.controller.OspfInterface;
import org.onosproject.ospf.controller.OspfLsa;
import org.onosproject.ospf.controller.OspfLsaType;
import org.onosproject.ospf.protocol.lsa.LsaHeader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LsaWrapperImpl
implements LsaWrapper {
    private static final Logger log = LoggerFactory.getLogger(LsaWrapperImpl.class);
    private LsaHeader lsaHeader;
    private int lsaAgeReceived;
    private int ageCounterWhenReceived;
    private boolean isSelfOriginated;
    private OspfLsaType lsaType;
    private OspfLsa ospfLsa;
    private int noReTransmissionLists;
    private boolean inAnAgeBin;
    private boolean changedSinceLastFlood;
    private boolean isSequenceRollOver;
    private boolean sentReplyForOlderLsa;
    private boolean checkAge;
    private boolean isAging;
    private String lsaProcessing;
    private int binNumber = -1;
    private OspfInterface ospfInterface;
    private LsdbAge lsdbAge;

    public OspfLsaType lsaType() {
        return this.lsaType;
    }

    public void setLsaType(OspfLsaType lsaType) {
        this.lsaType = lsaType;
    }

    public boolean isSelfOriginated() {
        return this.isSelfOriginated;
    }

    public void setIsSelfOriginated(boolean isSelfOriginated) {
        this.isSelfOriginated = isSelfOriginated;
    }

    public void addLsa(OspfLsaType lsaType, OspfLsa ospfLsa) {
        this.lsaType = lsaType;
        this.lsaHeader = (LsaHeader)ospfLsa.lsaHeader();
        this.ospfLsa = ospfLsa;
    }

    public int lsaAgeReceived() {
        return this.lsaAgeReceived;
    }

    public void setLsaAgeReceived(int lsaAgeReceived) {
        this.lsaAgeReceived = lsaAgeReceived;
    }

    public LsaHeader lsaHeader() {
        this.lsaHeader.setAge(this.currentAge());
        return this.lsaHeader;
    }

    public void setLsaHeader(LsaHeader lsaHeader) {
        this.lsaHeader = lsaHeader;
    }

    public OspfLsa ospfLsa() {
        LsaHeader lsaHeader = (LsaHeader)this.ospfLsa;
        lsaHeader.setAge(this.currentAge());
        return lsaHeader;
    }

    public void setOspfLsa(OspfLsa ospfLsa) {
        this.ospfLsa = ospfLsa;
    }

    public int noReTransmissionLists() {
        return this.noReTransmissionLists;
    }

    public void setNoReTransmissionLists(int noReTransmissionLists) {
        this.noReTransmissionLists = noReTransmissionLists;
    }

    public boolean isInAnAgeBin() {
        return this.inAnAgeBin;
    }

    public void setInAnAgeBin(boolean inAnAgeBin) {
        this.inAnAgeBin = inAnAgeBin;
    }

    public boolean isChangedSinceLastFlood() {
        return this.changedSinceLastFlood;
    }

    public void setChangedSinceLastFlood(boolean changedSinceLastFlood) {
        this.changedSinceLastFlood = changedSinceLastFlood;
    }

    public boolean isSequenceRollOver() {
        return this.isSequenceRollOver;
    }

    public void setIsSequenceRollOver(boolean isSequenceRollOver) {
        this.isSequenceRollOver = isSequenceRollOver;
    }

    public boolean isSentReplyForOlderLsa() {
        return this.sentReplyForOlderLsa;
    }

    public void setSentReplyForOlderLsa(boolean sentReplyForOlderLsa) {
        this.sentReplyForOlderLsa = sentReplyForOlderLsa;
    }

    public boolean isCheckAge() {
        return this.checkAge;
    }

    public void setCheckAge(boolean checkAge) {
        this.checkAge = checkAge;
    }

    public boolean isAging() {
        return this.isAging;
    }

    public void setIsAging(boolean isAging) {
        this.isAging = isAging;
    }

    public LsdbAge getLsdbAge() {
        return this.lsdbAge;
    }

    public void setLsdbAge(LsdbAge lsdbAge) {
        this.lsdbAge = lsdbAge;
    }

    public int currentAge() {
        int currentAge = 0;
        currentAge = this.lsdbAge.getAgeCounter() >= this.ageCounterWhenReceived ? this.lsaAgeReceived + (this.lsdbAge.getAgeCounter() - this.ageCounterWhenReceived) : this.lsaAgeReceived + (3600 + this.lsdbAge.getAgeCounter() - this.ageCounterWhenReceived);
        if (currentAge >= 3600) {
            return 3600;
        }
        return currentAge;
    }

    public int ageCounterWhenReceived() {
        return this.ageCounterWhenReceived;
    }

    public void setAgeCounterWhenReceived(int ageCounterWhenReceived) {
        this.ageCounterWhenReceived = ageCounterWhenReceived;
    }

    public String lsaProcessing() {
        return this.lsaProcessing;
    }

    public void setLsaProcessing(String lsaProcessing) {
        this.lsaProcessing = lsaProcessing;
    }

    public int binNumber() {
        return this.binNumber;
    }

    public void setBinNumber(int binNumber) {
        this.binNumber = binNumber;
    }

    public OspfInterface ospfInterface() {
        return this.ospfInterface;
    }

    public void setOspfInterface(OspfInterface ospfInterface) {
        this.ospfInterface = ospfInterface;
    }

    public String toString() {
        return MoreObjects.toStringHelper(this.getClass()).omitNullValues().add("lsaAgeReceived", this.lsaAgeReceived).add("ageCounterWhenReceived", this.ageCounterWhenReceived).add("isSelfOriginated", this.isSelfOriginated).add("lsaHeader", (Object)this.lsaHeader).add("lsaType", (Object)this.lsaType).add("ospflsa", (Object)this.ospfLsa).add("noReTransmissionLists", this.noReTransmissionLists).add("inAnAgeBin", this.inAnAgeBin).add("changedSinceLasFlood", this.changedSinceLastFlood).add("isSequenceRollOver", this.isSequenceRollOver).add("sentReplyForOlderLSA", this.sentReplyForOlderLsa).add("checkAge", this.checkAge).add("isAging", this.isAging).add("lsaProcessing", (Object)this.lsaProcessing).toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        LsaWrapperImpl that = (LsaWrapperImpl)o;
        return Objects.equal((Object)this.lsaAgeReceived, (Object)that.lsaAgeReceived) && Objects.equal((Object)this.ageCounterWhenReceived, (Object)that.ageCounterWhenReceived) && Objects.equal((Object)this.isSelfOriginated, (Object)that.isSelfOriginated) && Objects.equal((Object)this.lsaHeader, (Object)that.lsaHeader) && Objects.equal((Object)this.ospfLsa, (Object)that.ospfLsa) && Objects.equal((Object)this.noReTransmissionLists, (Object)that.noReTransmissionLists) && Objects.equal((Object)this.inAnAgeBin, (Object)that.inAnAgeBin) && Objects.equal((Object)this.changedSinceLastFlood, (Object)that.changedSinceLastFlood) && Objects.equal((Object)this.isSequenceRollOver, (Object)that.isSequenceRollOver) && Objects.equal((Object)this.sentReplyForOlderLsa, (Object)that.sentReplyForOlderLsa) && Objects.equal((Object)this.checkAge, (Object)that.checkAge) && Objects.equal((Object)this.isAging, (Object)that.isAging) && Objects.equal((Object)this.lsaProcessing, (Object)that.lsaProcessing);
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.lsaAgeReceived, this.lsaAgeReceived, this.ageCounterWhenReceived, this.isSelfOriginated, this.lsaHeader, this.lsaType, this.ospfLsa, this.noReTransmissionLists, this.inAnAgeBin, this.changedSinceLastFlood, this.isSequenceRollOver, this.sentReplyForOlderLsa, this.checkAge, this.isAging, this.lsaProcessing});
    }
}

