/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.ospf.controller.lsdb;

import com.google.common.base.Objects;
import java.util.Map;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.jboss.netty.channel.Channel;
import org.onosproject.ospf.controller.LsaBin;
import org.onosproject.ospf.controller.LsaWrapper;
import org.onosproject.ospf.controller.LsdbAge;
import org.onosproject.ospf.controller.OspfArea;
import org.onosproject.ospf.controller.area.OspfAreaImpl;
import org.onosproject.ospf.controller.lsdb.LsaBinImpl;
import org.onosproject.ospf.controller.lsdb.LsaQueueConsumer;
import org.onosproject.ospf.controller.lsdb.LsaWrapperImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LsdbAgeImpl
implements LsdbAge {
    private static final Logger log = LoggerFactory.getLogger(LsdbAgeImpl.class);
    protected int ageCounter = 0;
    private InternalAgeTimer dbAgeTimer;
    private ScheduledExecutorService exServiceage;
    private Map<Integer, LsaBin> ageBins = new ConcurrentHashMap<Integer, LsaBin>(3600);
    private LsaBin maxAgeBin = new LsaBinImpl(3600);
    private int ageCounterRollOver = 0;
    private Channel channel = null;
    private LsaQueueConsumer queueConsumer = null;
    private BlockingQueue<LsaWrapper> lsaQueue = new ArrayBlockingQueue<LsaWrapper>(1024);
    private OspfArea ospfArea = null;

    public LsdbAgeImpl(OspfArea ospfArea) {
        for (int i = 0; i < 3600; ++i) {
            LsaBinImpl lsaBin = new LsaBinImpl(i);
            this.ageBins.put(i, lsaBin);
        }
        this.ospfArea = ospfArea;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        LsdbAgeImpl that = (LsdbAgeImpl)o;
        return Objects.equal(this.ageBins, that.ageBins) && Objects.equal((Object)this.ageCounter, (Object)that.ageCounter) && Objects.equal((Object)this.ageCounterRollOver, (Object)that.ageCounterRollOver) && Objects.equal(this.lsaQueue, this.lsaQueue);
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.ageBins, this.ageCounter, this.ageCounterRollOver, this.lsaQueue});
    }

    public void addLsaBin(Integer binKey, LsaBin lsaBin) {
        if (!this.ageBins.containsKey(binKey)) {
            this.ageBins.put(binKey, lsaBin);
        }
    }

    public LsaBin getLsaBin(Integer binKey) {
        return this.ageBins.get(binKey);
    }

    public void addLsaToMaxAgeBin(String key, LsaWrapper wrapper) {
        this.maxAgeBin.addOspfLsa(key, wrapper);
    }

    public void removeLsaFromBin(LsaWrapper lsaWrapper) {
        if (this.ageBins.containsKey(lsaWrapper.binNumber())) {
            LsaBin lsaBin = this.ageBins.get(lsaWrapper.binNumber());
            lsaBin.removeOspfLsa(((OspfAreaImpl)this.ospfArea).getLsaKey(((LsaWrapperImpl)lsaWrapper).lsaHeader()), lsaWrapper);
        }
    }

    public void startDbAging() {
        this.startDbAgeTimer();
        this.queueConsumer = new LsaQueueConsumer(this.lsaQueue, this.channel, this.ospfArea);
        new Thread(this.queueConsumer).start();
    }

    public void ageLsaAndFlood() {
        this.checkAges();
        this.refreshLsa();
        this.maxAgeLsa();
        if (this.ageCounter == 3600) {
            this.ageCounter = 0;
            ++this.ageCounterRollOver;
        } else {
            ++this.ageCounter;
        }
    }

    public void maxAgeLsa() {
        if (this.ageCounter == 0) {
            return;
        }
        LsaBin lsaBin = this.ageBins.get(this.ageCounter - 1);
        if (lsaBin == null) {
            return;
        }
        Map lsaBinMap = lsaBin.listOfLsa();
        for (Object key : lsaBinMap.keySet()) {
            LsaWrapper lsa = (LsaWrapper)lsaBinMap.get((String)key);
            if (lsa.currentAge() != 3600) continue;
            lsa.setLsaProcessing("maxAgeLsa");
            log.debug("Lsa picked for maxage flooding. Age Counter: {}, AgeCounterRollover: {}, AgeCounterRollover WhenAddedToDb: {}, LSA Type: {}, LSA Key: {}", new Object[]{this.ageCounter, this.ageCounterRollOver, lsa.currentAge(), lsa.lsaType(), key});
            try {
                this.lsaQueue.put(lsa);
                lsaBin.removeOspfLsa((String)key, lsa);
            }
            catch (InterruptedException e) {
                log.debug("Error::LSDBAge::maxAgeLsa::{}", (Object)e.getMessage());
            }
        }
        Map lsaMaxAgeBinMap = this.maxAgeBin.listOfLsa();
        for (Object key : lsaMaxAgeBinMap.keySet()) {
            LsaWrapper lsa = (LsaWrapper)lsaMaxAgeBinMap.get((String)key);
            lsa.setLsaProcessing("maxAgeLsa");
            log.debug("Lsa picked for maxage flooding. Age Counter: {}, LSA Type: {}, LSA Key: {}", new Object[]{this.ageCounter, lsa.lsaType(), key});
            try {
                this.lsaQueue.put(lsa);
                this.maxAgeBin.removeOspfLsa((String)key, lsa);
            }
            catch (InterruptedException e) {
                log.debug("Error::LSDBAge::maxAgeLsa::{}", (Object)e.getMessage());
            }
        }
    }

    public void refreshLsa() {
        int binNumber = this.ageCounter < 1800 ? this.ageCounter + 1800 : this.ageCounter - 1800;
        LsaBin lsaBin = this.ageBins.get(binNumber);
        if (lsaBin == null) {
            return;
        }
        Map lsaBinMap = lsaBin.listOfLsa();
        for (Object key : lsaBinMap.keySet()) {
            LsaWrapper lsa = (LsaWrapper)lsaBinMap.get((String)key);
            try {
                if (!lsa.isSelfOriginated()) continue;
                log.debug("Lsa picked for refreshLsa. binNumber: {}, LSA Type: {}, LSA Key: {}", new Object[]{binNumber, lsa.lsaType(), key});
                lsa.setLsaProcessing("refreshLsa");
                this.lsaQueue.put(lsa);
                lsaBin.removeOspfLsa((String)key, lsa);
            }
            catch (InterruptedException e) {
                log.debug("Error::LSDBAge::refreshLsa::{}", (Object)e.getMessage());
            }
        }
    }

    public void checkAges() {
        for (int age = 300; age < 3600; age += 300) {
            LsaBin lsaBin = this.ageBins.get(this.age2Bin(age));
            if (lsaBin == null) continue;
            Map lsaBinMap = lsaBin.listOfLsa();
            for (Object key : lsaBinMap.keySet()) {
                LsaWrapper lsa = (LsaWrapper)lsaBinMap.get((String)key);
                lsa.setLsaProcessing("verifyChecksum");
                try {
                    this.lsaQueue.put(lsa);
                }
                catch (InterruptedException e) {
                    log.debug("Error::LSDBAge::checkAges::{}", (Object)e.getMessage());
                }
            }
        }
    }

    private void startDbAgeTimer() {
        log.debug("OSPFNbr::startWaitTimer");
        this.dbAgeTimer = new InternalAgeTimer();
        this.exServiceage = Executors.newSingleThreadScheduledExecutor();
        this.exServiceage.scheduleAtFixedRate(this.dbAgeTimer, 1L, 1L, TimeUnit.SECONDS);
    }

    private void stopDbAgeTimer() {
        log.debug("OSPFNbr::stopWaitTimer ");
        this.exServiceage.shutdown();
    }

    public Channel getChannel() {
        return this.channel;
    }

    public void setChannel(Channel channel) {
        this.channel = channel;
        if (this.queueConsumer != null) {
            this.queueConsumer.setChannel(channel);
        }
    }

    public int getAgeCounter() {
        return this.ageCounter;
    }

    public int getAgeCounterRollOver() {
        return this.ageCounterRollOver;
    }

    public LsaBin getMaxAgeBin() {
        return this.maxAgeBin;
    }

    public int age2Bin(int x) {
        if (x <= this.ageCounter) {
            return this.ageCounter - x;
        }
        return 3599 + (this.ageCounter - x);
    }

    private class InternalAgeTimer
    implements Runnable {
        InternalAgeTimer() {
            log.debug("Starts::LsdbAge::AgeTimer...!!! ");
        }

        @Override
        public void run() {
            LsdbAgeImpl.this.ageLsaAndFlood();
        }
    }
}

