/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.ospf.controller.lsdb;

import com.google.common.base.Objects;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CopyOnWriteArrayList;
import org.onosproject.ospf.controller.LsaBin;
import org.onosproject.ospf.controller.LsaWrapper;
import org.onosproject.ospf.controller.LsdbAge;
import org.onosproject.ospf.controller.OspfArea;
import org.onosproject.ospf.controller.OspfInterface;
import org.onosproject.ospf.controller.OspfLsa;
import org.onosproject.ospf.controller.OspfLsaType;
import org.onosproject.ospf.controller.OspfLsdb;
import org.onosproject.ospf.controller.area.OspfAreaImpl;
import org.onosproject.ospf.controller.lsdb.LsaWrapperImpl;
import org.onosproject.ospf.controller.lsdb.LsdbAgeImpl;
import org.onosproject.ospf.protocol.lsa.LsaHeader;
import org.onosproject.ospf.protocol.lsa.OpaqueLsaHeader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OspfLsdbImpl
implements OspfLsdb {
    private static final Logger log = LoggerFactory.getLogger(OspfLsdbImpl.class);
    private Map routerLsas = new HashMap();
    private Map networkLsas = new HashMap();
    private Map summaryLsas = new HashMap();
    private Map asbrSummaryLSAs = new HashMap();
    private Map opaque9Lsas = new HashMap();
    private Map opaque10Lsas = new HashMap();
    private Map opaque11Lsas = new HashMap();
    private Map externalLsas = new HashMap();
    private long routerLsaSeqNo = -2147483647L;
    private long networkLsaSeqNo = -2147483647L;
    private LsdbAge lsdbAge = null;
    private OspfArea ospfArea = null;

    public OspfLsdbImpl(OspfArea ospfArea) {
        this.ospfArea = ospfArea;
        this.lsdbAge = new LsdbAgeImpl(ospfArea);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        OspfLsdbImpl that = (OspfLsdbImpl)o;
        return Objects.equal((Object)this.routerLsas.size(), (Object)that.routerLsas.size()) && Objects.equal((Object)this.networkLsas.size(), (Object)that.networkLsas.size()) && Objects.equal((Object)this.summaryLsas.size(), (Object)that.summaryLsas.size()) && Objects.equal((Object)this.asbrSummaryLSAs.size(), (Object)that.asbrSummaryLSAs.size()) && Objects.equal((Object)this.lsdbAge, (Object)that.lsdbAge) && Objects.equal((Object)this.routerLsaSeqNo, (Object)that.routerLsaSeqNo) && Objects.equal((Object)this.networkLsaSeqNo, (Object)that.networkLsaSeqNo);
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.routerLsas, this.networkLsas, this.summaryLsas, this.asbrSummaryLSAs, this.lsdbAge, this.routerLsaSeqNo, this.networkLsaSeqNo});
    }

    public void initializeDb() {
        this.lsdbAge.startDbAging();
    }

    public List getAllLsaHeaders(boolean excludeMaxAgeLsa, boolean isOpaqueCapable) {
        CopyOnWriteArrayList summList = new CopyOnWriteArrayList();
        this.addLsaToHeaderList(summList, excludeMaxAgeLsa, this.routerLsas);
        this.addLsaToHeaderList(summList, excludeMaxAgeLsa, this.networkLsas);
        this.addLsaToHeaderList(summList, excludeMaxAgeLsa, this.summaryLsas);
        this.addLsaToHeaderList(summList, excludeMaxAgeLsa, this.asbrSummaryLSAs);
        this.addLsaToHeaderList(summList, excludeMaxAgeLsa, this.externalLsas);
        if (isOpaqueCapable) {
            this.addLsaToHeaderList(summList, excludeMaxAgeLsa, this.opaque9Lsas);
            this.addLsaToHeaderList(summList, excludeMaxAgeLsa, this.opaque10Lsas);
            this.addLsaToHeaderList(summList, excludeMaxAgeLsa, this.opaque11Lsas);
        }
        return summList;
    }

    private void addLsaToHeaderList(List summList, boolean excludeMaxAgeLsa, Map lsaMap) {
        for (LsaWrapper wrapper : lsaMap.values()) {
            if (excludeMaxAgeLsa) {
                if (wrapper.currentAge() == 3600 || this.lsdbAge.getMaxAgeBin().ospfLsa(((OspfAreaImpl)this.ospfArea).getLsaKey(((LsaWrapperImpl)wrapper).lsaHeader())) != null) continue;
                this.addToList(wrapper, summList);
                continue;
            }
            this.addToList(wrapper, summList);
        }
    }

    private void addToList(LsaWrapper wrapper, List summList) {
        LsaHeader header = (LsaHeader)wrapper.ospfLsa();
        header.setAge(wrapper.currentAge());
        summList.add(header);
    }

    public String getLsaKey(LsaHeader lsaHeader) {
        String lsaKey = "";
        switch (lsaHeader.lsType()) {
            case 9: 
            case 10: 
            case 11: {
                OpaqueLsaHeader header = (OpaqueLsaHeader)lsaHeader;
                lsaKey = lsaHeader.lsType() + "-" + header.opaqueType() + header.opaqueId() + "-" + lsaHeader.advertisingRouter();
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                lsaKey = lsaHeader.lsType() + "-" + lsaHeader.linkStateId() + "-" + lsaHeader.advertisingRouter();
                break;
            }
            default: {
                log.debug("Unknown LSA type..!!!");
            }
        }
        return lsaKey;
    }

    public LsaWrapper lsaLookup(LsaHeader lsaHeader) {
        return this.findLsa(lsaHeader.lsType(), this.getLsaKey(lsaHeader));
    }

    public LsaWrapper findLsa(int lsType, String lsaKey) {
        LsaWrapper lsaWrapper = null;
        switch (lsType) {
            case 9: {
                lsaWrapper = (LsaWrapper)this.opaque9Lsas.get(lsaKey);
                break;
            }
            case 10: {
                lsaWrapper = (LsaWrapper)this.opaque10Lsas.get(lsaKey);
                break;
            }
            case 11: {
                lsaWrapper = (LsaWrapper)this.opaque11Lsas.get(lsaKey);
                break;
            }
            case 1: {
                lsaWrapper = (LsaWrapper)this.routerLsas.get(lsaKey);
                break;
            }
            case 2: {
                lsaWrapper = (LsaWrapper)this.networkLsas.get(lsaKey);
                break;
            }
            case 4: {
                lsaWrapper = (LsaWrapper)this.asbrSummaryLSAs.get(lsaKey);
                break;
            }
            case 3: {
                lsaWrapper = (LsaWrapper)this.summaryLsas.get(lsaKey);
                break;
            }
            case 5: {
                lsaWrapper = (LsaWrapper)this.externalLsas.get(lsaKey);
                break;
            }
            default: {
                log.debug("Unknown LSA type..!!!");
            }
        }
        if (lsaWrapper != null) {
            ((LsaWrapperImpl)lsaWrapper).lsaHeader().setAge(lsaWrapper.currentAge());
            ((LsaHeader)lsaWrapper.ospfLsa()).setAge(lsaWrapper.currentAge());
        }
        return lsaWrapper;
    }

    public boolean addLsa(LsaHeader newLsa, boolean isSelfOriginated, OspfInterface ospfInterface) {
        LsaWrapperImpl lsaWrapper = new LsaWrapperImpl();
        lsaWrapper.setLsaType(newLsa.getOspfLsaType());
        lsaWrapper.setOspfLsa((OspfLsa)newLsa);
        lsaWrapper.setLsaHeader(newLsa);
        lsaWrapper.setLsaAgeReceived(newLsa.age());
        lsaWrapper.setAgeCounterWhenReceived(this.lsdbAge.getAgeCounter());
        lsaWrapper.setIsSelfOriginated(isSelfOriginated);
        lsaWrapper.setIsSelfOriginated(isSelfOriginated);
        lsaWrapper.setOspfInterface(ospfInterface);
        lsaWrapper.setLsdbAge(this.lsdbAge);
        this.addLsa(lsaWrapper);
        log.debug("Added LSA In LSDB: {}", (Object)newLsa);
        return true;
    }

    private boolean addLsa(LsaWrapper newLsa) {
        String key = this.getLsaKey(((LsaWrapperImpl)newLsa).lsaHeader());
        this.removeLsaFromBin(this.lsaLookup(((LsaWrapperImpl)newLsa).lsaHeader()));
        switch (((LsaWrapperImpl)newLsa).lsaHeader().lsType()) {
            case 9: {
                this.opaque9Lsas.put(key, newLsa);
                break;
            }
            case 10: {
                this.opaque10Lsas.put(key, newLsa);
                break;
            }
            case 11: {
                this.opaque11Lsas.put(key, newLsa);
                break;
            }
            case 1: {
                this.routerLsas.put(key, newLsa);
                break;
            }
            case 2: {
                this.networkLsas.put(key, newLsa);
                break;
            }
            case 4: {
                this.asbrSummaryLSAs.put(key, newLsa);
                break;
            }
            case 3: {
                this.summaryLsas.put(key, newLsa);
                break;
            }
            case 5: {
                this.externalLsas.put(key, newLsa);
                break;
            }
            default: {
                log.debug("Unknown LSA type to add..!!!");
            }
        }
        Integer binNumber = this.lsdbAge.age2Bin(((LsaWrapperImpl)newLsa).lsaHeader().age());
        LsaBin lsaBin = this.lsdbAge.getLsaBin(binNumber);
        if (lsaBin != null) {
            newLsa.setBinNumber(binNumber.intValue());
            lsaBin.addOspfLsa(key, newLsa);
            this.lsdbAge.addLsaBin(binNumber, lsaBin);
            log.debug("Added Type {} LSA to LSDB and LSABin[{}], Age of LSA {}", new Object[]{newLsa.lsaType(), binNumber, ((LsaWrapperImpl)newLsa).lsaHeader().age()});
        }
        return false;
    }

    public void addLsaToMaxAgeBin(String key, Object wrapper) {
        this.lsdbAge.addLsaToMaxAgeBin(key, (LsaWrapper)wrapper);
    }

    public void removeLsaFromBin(Object lsaWrapper) {
        if (lsaWrapper != null) {
            this.lsdbAge.removeLsaFromBin((LsaWrapper)lsaWrapper);
        }
    }

    public String isNewerOrSameLsa(LsaHeader lsa1, LsaHeader lsa2) {
        if (lsa1.lsSequenceNo() > lsa2.lsSequenceNo()) {
            return "latest";
        }
        if (lsa1.lsSequenceNo() < lsa2.lsSequenceNo()) {
            return "old";
        }
        if (lsa1.lsSequenceNo() == lsa2.lsSequenceNo()) {
            if (lsa1.lsCheckSum() > lsa2.lsCheckSum()) {
                return "latest";
            }
            if (lsa1.lsCheckSum() < lsa2.lsCheckSum()) {
                return "old";
            }
            if (lsa1.lsCheckSum() == lsa2.lsCheckSum()) {
                if (lsa1.age() == lsa2.age()) {
                    return "same";
                }
                if (lsa1.age() == 3600) {
                    return "latest";
                }
                if (lsa2.age() == 3600) {
                    return "old";
                }
                if (900 == lsa1.age() - lsa2.age()) {
                    if (lsa1.age() < lsa2.age()) {
                        return "latest";
                    }
                    return "old";
                }
                return "same";
            }
        }
        return "";
    }

    public long getLsSequenceNumber(OspfLsaType lsaType) {
        switch (lsaType) {
            case ROUTER: {
                return this.routerLsaSeqNo++;
            }
            case NETWORK: {
                return this.networkLsaSeqNo++;
            }
        }
        return -2147483647L;
    }

    public void deleteLsa(LsaHeader lsaHeader) {
        String lsaKey = this.getLsaKey(lsaHeader);
        switch (lsaHeader.lsType()) {
            case 9: {
                this.opaque9Lsas.remove(lsaKey);
                break;
            }
            case 10: {
                this.opaque10Lsas.remove(lsaKey);
                break;
            }
            case 11: {
                this.opaque11Lsas.remove(lsaKey);
                break;
            }
            case 1: {
                this.routerLsas.remove(lsaKey);
                break;
            }
            case 2: {
                this.networkLsas.remove(lsaKey);
                break;
            }
            case 4: {
                this.asbrSummaryLSAs.remove(lsaKey);
                break;
            }
            case 3: {
                this.summaryLsas.remove(lsaKey);
                break;
            }
            case 5: {
                this.externalLsas.remove(lsaKey);
                break;
            }
            default: {
                log.debug("Unknown LSA type to delete..!!!");
            }
        }
    }

    public void setRouterLsaSeqNo(long routerLsaSeqNo) {
        this.routerLsaSeqNo = routerLsaSeqNo;
    }

    public void setNetworkLsaSeqNo(long networkLsaSeqNo) {
        this.networkLsaSeqNo = networkLsaSeqNo;
    }
}

