/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.provider.ospf.topology.impl;

import com.fasterxml.jackson.databind.JsonNode;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.onlab.packet.Ip4Address;
import org.onlab.util.Bandwidth;
import org.onosproject.net.ConnectPoint;
import org.onosproject.net.Device;
import org.onosproject.net.DeviceId;
import org.onosproject.net.Link;
import org.onosproject.net.MastershipRole;
import org.onosproject.net.PortNumber;
import org.onosproject.net.device.DeviceDescription;
import org.onosproject.net.device.DeviceListener;
import org.onosproject.net.device.DeviceProvider;
import org.onosproject.net.device.DeviceProviderRegistry;
import org.onosproject.net.device.DeviceProviderService;
import org.onosproject.net.device.DeviceServiceAdapter;
import org.onosproject.net.device.PortDescription;
import org.onosproject.net.device.PortStatistics;
import org.onosproject.net.link.LinkDescription;
import org.onosproject.net.link.LinkListener;
import org.onosproject.net.link.LinkProvider;
import org.onosproject.net.link.LinkProviderRegistry;
import org.onosproject.net.link.LinkProviderService;
import org.onosproject.net.link.LinkServiceAdapter;
import org.onosproject.net.provider.ProviderId;
import org.onosproject.ospf.controller.OspfController;
import org.onosproject.ospf.controller.OspfDeviceTed;
import org.onosproject.ospf.controller.OspfLinkListener;
import org.onosproject.ospf.controller.OspfLinkTed;
import org.onosproject.ospf.controller.OspfProcess;
import org.onosproject.ospf.controller.OspfRouter;
import org.onosproject.ospf.controller.OspfRouterListener;
import org.onosproject.ospf.controller.impl.OspfDeviceTedImpl;
import org.onosproject.ospf.controller.impl.OspfLinkTedImpl;
import org.onosproject.ospf.controller.impl.OspfRouterImpl;
import org.onosproject.provider.ospf.topology.impl.OspfTopologyProvider;

public class OspfTopologyProviderTest {
    private final OspfTopologyProvider provider = new OspfTopologyProvider();
    private final TestDeviceRegistry nodeRegistry = new TestDeviceRegistry();
    private final TestLinkRegistry linkRegistry = new TestLinkRegistry();
    private final TestController controller = new TestController();
    private final TestLinkService linkService = new TestLinkService();

    @Before
    public void setUp() throws Exception {
        this.provider.deviceProviderRegistry = this.nodeRegistry;
        this.provider.linkProviderRegistry = this.linkRegistry;
        this.provider.controller = this.controller;
        this.provider.linkService = this.linkService;
        this.provider.activate();
        Assert.assertNotNull((String)"provider should be registered", (Object)this.nodeRegistry.provider);
        Assert.assertNotNull((String)"listener should be registered", this.controller.nodeListener);
    }

    @After
    public void tearDown() throws Exception {
        this.provider.deactivate();
        Assert.assertNull((String)"listener should be removed", this.controller.nodeListener);
        this.provider.controller = null;
        this.provider.deviceProviderRegistry = null;
    }

    @Test
    public void triggerProbe() {
        DeviceId deviceId = DeviceId.deviceId((String)"2.2.2.2");
        this.provider.triggerProbe(deviceId);
    }

    @Test
    public void roleChanged() {
        DeviceId deviceId = DeviceId.deviceId((String)"2.2.2.2");
        this.provider.roleChanged(deviceId, MastershipRole.MASTER);
    }

    @Test
    public void changePortState() {
        DeviceId deviceId = DeviceId.deviceId((String)"2.2.2.2");
        this.provider.changePortState(deviceId, PortNumber.portNumber((long)0L), false);
    }

    @Test
    public void isReachable() {
        DeviceId deviceId = DeviceId.deviceId((String)"1.1.1.1");
        this.provider.isReachable(deviceId);
    }

    @Test
    public void ospfTopologyProviderTestAddDevice1() {
        int deviceAddCount = 0;
        OspfRouterImpl ospfRouter = new OspfRouterImpl();
        ospfRouter.setDr(false);
        ospfRouter.setOpaque(false);
        ospfRouter.setNeighborRouterId(Ip4Address.valueOf((String)"2.2.2.2"));
        ospfRouter.setInterfaceId(Ip4Address.valueOf((String)"10.10.10.2"));
        ospfRouter.setAreaIdOfInterface(Ip4Address.valueOf((String)"5.5.5.5"));
        ospfRouter.setRouterIp(Ip4Address.valueOf((String)"1.1.1.1"));
        OspfDeviceTedImpl ospfDeviceTed = new OspfDeviceTedImpl();
        ospfDeviceTed.setAbr(Boolean.valueOf(false));
        ospfDeviceTed.setAsbr(Boolean.valueOf(false));
        ospfRouter.setDeviceTed((OspfDeviceTed)ospfDeviceTed);
        OspfLinkTedImpl ospfLinkTed = new OspfLinkTedImpl();
        ospfLinkTed.setMaximumLink(Bandwidth.bps((long)10L));
        ospfLinkTed.setMaxReserved(Bandwidth.bps((long)20L));
        ospfLinkTed.setTeMetric(Integer.valueOf(10));
        OspfRouterImpl ospfRouter1 = new OspfRouterImpl();
        ospfRouter1.setDr(true);
        ospfRouter1.setOpaque(true);
        ospfRouter1.setNeighborRouterId(Ip4Address.valueOf((String)"2.2.2.2"));
        ospfRouter1.setInterfaceId(Ip4Address.valueOf((String)"10.10.10.2"));
        ospfRouter1.setAreaIdOfInterface(Ip4Address.valueOf((String)"5.5.5.5"));
        ospfRouter1.setRouterIp(Ip4Address.valueOf((String)"1.1.1.1"));
        OspfDeviceTedImpl ospfDeviceTed1 = new OspfDeviceTedImpl();
        ospfDeviceTed1.setAbr(Boolean.valueOf(false));
        ospfDeviceTed1.setAsbr(Boolean.valueOf(false));
        ospfRouter.setDeviceTed((OspfDeviceTed)ospfDeviceTed);
        OspfLinkTedImpl ospfLinkTed1 = new OspfLinkTedImpl();
        ospfLinkTed1.setMaximumLink(Bandwidth.bps((long)10L));
        ospfLinkTed1.setMaxReserved(Bandwidth.bps((long)20L));
        ospfLinkTed1.setTeMetric(Integer.valueOf(10));
        for (OspfRouterListener ospfRouterListener : this.controller.nodeListener) {
            ospfRouterListener.routerAdded((OspfRouter)ospfRouter);
            deviceAddCount = this.nodeRegistry.connected.size();
            Assert.assertTrue((deviceAddCount == 1 ? 1 : 0) != 0);
            ospfRouterListener.routerRemoved((OspfRouter)ospfRouter);
            deviceAddCount = this.nodeRegistry.connected.size();
            Assert.assertTrue((deviceAddCount == 0 ? 1 : 0) != 0);
        }
        for (OspfLinkListener ospfLinkListener : this.controller.linkListener) {
            ospfLinkListener.addLink((OspfRouter)ospfRouter, (OspfLinkTed)ospfLinkTed);
            ospfLinkListener.deleteLink((OspfRouter)ospfRouter, (OspfLinkTed)ospfLinkTed);
        }
    }

    @Test
    public void ospfTopologyProviderTestAddDevice2() {
        int deviceAddCount = 0;
        OspfRouterImpl ospfRouter = new OspfRouterImpl();
        ospfRouter.setDr(true);
        ospfRouter.setOpaque(true);
        ospfRouter.setNeighborRouterId(Ip4Address.valueOf((String)"3.3.3.3"));
        ospfRouter.setInterfaceId(Ip4Address.valueOf((String)"10.10.10.3"));
        ospfRouter.setAreaIdOfInterface(Ip4Address.valueOf((String)"6.6.6.6"));
        ospfRouter.setRouterIp(Ip4Address.valueOf((String)"7.7.7.7"));
        OspfDeviceTedImpl ospfDeviceTed = new OspfDeviceTedImpl();
        ospfDeviceTed.setAbr(Boolean.valueOf(true));
        ospfDeviceTed.setAsbr(Boolean.valueOf(true));
        ospfRouter.setDeviceTed((OspfDeviceTed)ospfDeviceTed);
        OspfLinkTedImpl ospfLinkTed = new OspfLinkTedImpl();
        ospfLinkTed.setMaximumLink(Bandwidth.bps((long)30L));
        ospfLinkTed.setMaxReserved(Bandwidth.bps((long)40L));
        ospfLinkTed.setTeMetric(Integer.valueOf(50));
        for (OspfRouterListener l : this.controller.nodeListener) {
            l.routerAdded((OspfRouter)ospfRouter);
            deviceAddCount = this.nodeRegistry.connected.size();
            Assert.assertTrue((deviceAddCount == 1 ? 1 : 0) != 0);
            l.routerRemoved((OspfRouter)ospfRouter);
            deviceAddCount = this.nodeRegistry.connected.size();
            Assert.assertTrue((deviceAddCount == 0 ? 1 : 0) != 0);
        }
    }

    private class TestController
    implements OspfController {
        protected Set<OspfRouterListener> nodeListener = new CopyOnWriteArraySet<OspfRouterListener>();
        protected Set<OspfLinkListener> linkListener = new CopyOnWriteArraySet<OspfLinkListener>();

        private TestController() {
        }

        public void addRouterListener(OspfRouterListener nodeListener) {
            this.nodeListener.add(nodeListener);
        }

        public void removeRouterListener(OspfRouterListener nodeListener) {
            this.nodeListener = null;
        }

        public void addLinkListener(OspfLinkListener listener) {
            this.linkListener.add(listener);
        }

        public void removeLinkListener(OspfLinkListener listener) {
            this.nodeListener = null;
        }

        public void updateConfig(JsonNode processesNode) {
        }

        public void deleteConfig(List<OspfProcess> processes, String attribute) {
        }

        public Set<OspfRouterListener> listener() {
            return null;
        }

        public Set<OspfLinkListener> linkListener() {
            return null;
        }

        public List<OspfProcess> getAllConfiguredProcesses() {
            return null;
        }
    }

    private class TestLinkRegistry
    implements LinkProviderRegistry {
        LinkProvider provider;
        Set<DeviceId> connected = new HashSet<DeviceId>();

        private TestLinkRegistry() {
        }

        public LinkProviderService register(LinkProvider provider) {
            this.provider = provider;
            return new TestLinkProviderService();
        }

        public void unregister(LinkProvider provider) {
        }

        public Set<ProviderId> getProviders() {
            return null;
        }

        private class TestLinkProviderService
        implements LinkProviderService {
            private TestLinkProviderService() {
            }

            public void linkDetected(LinkDescription linkDescription) {
            }

            public void linkVanished(LinkDescription linkDescription) {
            }

            public void linksVanished(ConnectPoint connectPoint) {
            }

            public void linksVanished(DeviceId deviceId) {
            }

            public LinkProvider provider() {
                return null;
            }
        }
    }

    private class TestLinkService
    extends LinkServiceAdapter {
        private LinkListener listener;

        private TestLinkService() {
        }

        public void addListener(LinkListener listener) {
            this.listener = listener;
        }

        public Iterable<Link> getLinks() {
            return Collections.emptyList();
        }
    }

    private class TestDeviceService
    extends DeviceServiceAdapter {
        private DeviceListener listener;

        private TestDeviceService() {
        }

        public void addListener(DeviceListener listener) {
            this.listener = listener;
        }

        public Iterable<Device> getDevices() {
            return Collections.emptyList();
        }
    }

    private class TestDeviceRegistry
    implements DeviceProviderRegistry {
        DeviceProvider provider;
        Set<DeviceId> connected = new HashSet<DeviceId>();

        private TestDeviceRegistry() {
        }

        public DeviceProviderService register(DeviceProvider provider) {
            this.provider = provider;
            return new TestProviderService();
        }

        public void unregister(DeviceProvider provider) {
        }

        public Set<ProviderId> getProviders() {
            return null;
        }

        private class TestProviderService
        implements DeviceProviderService {
            private TestProviderService() {
            }

            public DeviceProvider provider() {
                return null;
            }

            public void deviceConnected(DeviceId deviceId, DeviceDescription deviceDescription) {
                TestDeviceRegistry.this.connected.add(deviceId);
            }

            public void deviceDisconnected(DeviceId deviceId) {
                TestDeviceRegistry.this.connected.remove(deviceId);
            }

            public void updatePorts(DeviceId deviceId, List<PortDescription> portDescriptions) {
            }

            public void portStatusChanged(DeviceId deviceId, PortDescription portDescription) {
            }

            public void receivedRoleReply(DeviceId deviceId, MastershipRole requested, MastershipRole response) {
            }

            public void updatePortStatistics(DeviceId deviceId, Collection<PortStatistics> portStatistics) {
            }
        }
    }
}

