/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.provider.ospf.topology.impl;

import java.net.URI;
import java.util.LinkedList;
import org.apache.felix.scr.annotations.Activate;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Deactivate;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.ReferenceCardinality;
import org.onlab.packet.ChassisId;
import org.onlab.packet.Ip4Address;
import org.onlab.packet.IpAddress;
import org.onosproject.net.ConnectPoint;
import org.onosproject.net.DefaultAnnotations;
import org.onosproject.net.Device;
import org.onosproject.net.DeviceId;
import org.onosproject.net.ElementId;
import org.onosproject.net.Link;
import org.onosproject.net.MastershipRole;
import org.onosproject.net.PortNumber;
import org.onosproject.net.SparseAnnotations;
import org.onosproject.net.device.DefaultDeviceDescription;
import org.onosproject.net.device.DefaultPortDescription;
import org.onosproject.net.device.DeviceDescription;
import org.onosproject.net.device.DeviceProvider;
import org.onosproject.net.device.DeviceProviderRegistry;
import org.onosproject.net.device.DeviceProviderService;
import org.onosproject.net.link.DefaultLinkDescription;
import org.onosproject.net.link.LinkDescription;
import org.onosproject.net.link.LinkProvider;
import org.onosproject.net.link.LinkProviderRegistry;
import org.onosproject.net.link.LinkProviderService;
import org.onosproject.net.link.LinkService;
import org.onosproject.net.provider.AbstractProvider;
import org.onosproject.net.provider.Provider;
import org.onosproject.net.provider.ProviderId;
import org.onosproject.ospf.controller.OspfController;
import org.onosproject.ospf.controller.OspfLinkListener;
import org.onosproject.ospf.controller.OspfLinkTed;
import org.onosproject.ospf.controller.OspfRouter;
import org.onosproject.ospf.controller.OspfRouterId;
import org.onosproject.ospf.controller.OspfRouterListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(immediate=true)
public class OspfTopologyProvider
extends AbstractProvider
implements DeviceProvider,
LinkProvider {
    public static final long PSEUDO_PORT = -1L;
    private static final Logger log = LoggerFactory.getLogger(OspfTopologyProvider.class);
    private static final String UNKNOWN = "unknown";
    final InternalTopologyProvider listener = new InternalTopologyProvider();
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    protected DeviceProviderRegistry deviceProviderRegistry;
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    protected LinkProviderRegistry linkProviderRegistry;
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    protected LinkService linkService;
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    protected OspfController controller;
    private LinkProviderService linkProviderService;
    private DeviceProviderService deviceProviderService;

    public OspfTopologyProvider() {
        super(new ProviderId("l3", "org.onosproject.provider.ospf"));
    }

    @Activate
    public void activate() {
        this.deviceProviderService = (DeviceProviderService)this.deviceProviderRegistry.register((Provider)this);
        this.linkProviderService = (LinkProviderService)this.linkProviderRegistry.register((Provider)this);
        this.controller.addRouterListener((OspfRouterListener)this.listener);
        this.controller.addLinkListener((OspfLinkListener)this.listener);
        log.debug("IsisDeviceProvider::activate...!!!!");
    }

    @Deactivate
    public void deactivate() {
        log.debug("IsisDeviceProvider::deactivate...!!!!");
        this.deviceProviderRegistry.unregister((Provider)this);
        this.deviceProviderService = null;
        this.linkProviderRegistry.unregister((Provider)this);
        this.linkProviderService = null;
        this.controller.removeRouterListener((OspfRouterListener)this.listener);
        this.controller.removeLinkListener((OspfLinkListener)this.listener);
        log.info("deactivated...!!!");
    }

    public boolean isReachable(DeviceId deviceId) {
        return true;
    }

    public void changePortState(DeviceId deviceId, PortNumber portNumber, boolean enable) {
        log.info("changePortState on device {}", (Object)deviceId);
    }

    public void triggerProbe(DeviceId deviceId) {
        log.info("Triggering probe on device {}", (Object)deviceId);
    }

    public void roleChanged(DeviceId deviceId, MastershipRole newRole) {
        log.info("Accepting mastership role change for device {}", (Object)deviceId);
    }

    private LinkDescription buildLinkDes(OspfRouter ospfRouter, OspfLinkTed ospfLinkTed) {
        long srcAddress = 0L;
        long dstAddress = 0L;
        boolean localPseduo = false;
        srcAddress = Ip4Address.valueOf((String)ospfRouter.routerIp().toString()).toInt();
        dstAddress = Ip4Address.valueOf((String)ospfRouter.neighborRouterId().toString()).toInt();
        DeviceId srcId = DeviceId.deviceId((URI)OspfRouterId.uri((IpAddress)ospfRouter.routerIp()));
        DeviceId dstId = DeviceId.deviceId((URI)OspfRouterId.uri((IpAddress)ospfRouter.neighborRouterId()));
        if (ospfRouter.isDr()) {
            localPseduo = true;
        }
        if (localPseduo && srcAddress == 0L) {
            srcAddress = -1L;
        }
        ConnectPoint src = new ConnectPoint((ElementId)srcId, PortNumber.portNumber((long)srcAddress));
        ConnectPoint dst = new ConnectPoint((ElementId)dstId, PortNumber.portNumber((long)dstAddress));
        return new DefaultLinkDescription(src, dst, Link.Type.DIRECT, false, new SparseAnnotations[0]);
    }

    protected void bindDeviceProviderRegistry(DeviceProviderRegistry deviceProviderRegistry) {
        this.deviceProviderRegistry = deviceProviderRegistry;
    }

    protected void unbindDeviceProviderRegistry(DeviceProviderRegistry deviceProviderRegistry) {
        if (this.deviceProviderRegistry == deviceProviderRegistry) {
            this.deviceProviderRegistry = null;
        }
    }

    protected void bindLinkProviderRegistry(LinkProviderRegistry linkProviderRegistry) {
        this.linkProviderRegistry = linkProviderRegistry;
    }

    protected void unbindLinkProviderRegistry(LinkProviderRegistry linkProviderRegistry) {
        if (this.linkProviderRegistry == linkProviderRegistry) {
            this.linkProviderRegistry = null;
        }
    }

    protected void bindLinkService(LinkService linkService) {
        this.linkService = linkService;
    }

    protected void unbindLinkService(LinkService linkService) {
        if (this.linkService == linkService) {
            this.linkService = null;
        }
    }

    protected void bindController(OspfController ospfController) {
        this.controller = ospfController;
    }

    protected void unbindController(OspfController ospfController) {
        if (this.controller == ospfController) {
            this.controller = null;
        }
    }

    protected class InternalTopologyProvider
    implements OspfRouterListener,
    OspfLinkListener {
        protected InternalTopologyProvider() {
        }

        public void routerAdded(OspfRouter ospfRouter) {
            String routerId = ospfRouter.routerIp().toString();
            log.info("Added device {}", (Object)routerId);
            DeviceId deviceId = DeviceId.deviceId((URI)OspfRouterId.uri((IpAddress)ospfRouter.routerIp()));
            Device.Type deviceType = Device.Type.ROUTER;
            deviceType = ospfRouter.isDr() ? Device.Type.ROUTER : Device.Type.VIRTUAL;
            ChassisId cId = new ChassisId();
            DefaultAnnotations.Builder newBuilder = DefaultAnnotations.builder();
            newBuilder.set("type", "l3");
            newBuilder.set("routerId", routerId);
            DefaultDeviceDescription description = new DefaultDeviceDescription(OspfRouterId.uri((IpAddress)ospfRouter.routerIp()), deviceType, OspfTopologyProvider.UNKNOWN, OspfTopologyProvider.UNKNOWN, OspfTopologyProvider.UNKNOWN, OspfTopologyProvider.UNKNOWN, cId, new SparseAnnotations[]{newBuilder.build()});
            OspfTopologyProvider.this.deviceProviderService.deviceConnected(deviceId, (DeviceDescription)description);
        }

        public void routerRemoved(OspfRouter ospfRouter) {
            String routerId = ospfRouter.routerIp().toString();
            log.info("Delete device {}", (Object)routerId);
            DeviceId deviceId = DeviceId.deviceId((URI)OspfRouterId.uri((IpAddress)ospfRouter.routerIp()));
            if (OspfTopologyProvider.this.deviceProviderService == null) {
                return;
            }
            OspfTopologyProvider.this.deviceProviderService.deviceDisconnected(deviceId);
            log.info("delete device {}", (Object)routerId);
        }

        public void addLink(OspfRouter ospfRouter, OspfLinkTed ospfLinkTed) {
            log.debug("Addlink {}", (Object)ospfRouter.routerIp());
            LinkDescription linkDes = OspfTopologyProvider.this.buildLinkDes(ospfRouter, ospfLinkTed);
            if (OspfTopologyProvider.this.linkService.getLink(linkDes.src(), linkDes.dst()) != null || OspfTopologyProvider.this.linkProviderService == null) {
                return;
            }
            LinkedList<DefaultPortDescription> srcPortDescriptions = new LinkedList<DefaultPortDescription>();
            srcPortDescriptions.add(new DefaultPortDescription(linkDes.src().port(), true, new SparseAnnotations[0]));
            OspfTopologyProvider.this.deviceProviderService.updatePorts(linkDes.src().deviceId(), srcPortDescriptions);
            LinkedList<DefaultPortDescription> dstPortDescriptions = new LinkedList<DefaultPortDescription>();
            dstPortDescriptions.add(new DefaultPortDescription(linkDes.dst().port(), true, new SparseAnnotations[0]));
            OspfTopologyProvider.this.deviceProviderService.updatePorts(linkDes.dst().deviceId(), dstPortDescriptions);
            OspfTopologyProvider.this.linkProviderService.linkDetected(linkDes);
        }

        public void deleteLink(OspfRouter ospfRouter, OspfLinkTed ospfLinkTed) {
            log.debug("Delete link {}", (Object)ospfRouter.routerIp().toString());
            if (OspfTopologyProvider.this.linkProviderService == null) {
                return;
            }
            LinkDescription linkDes = OspfTopologyProvider.this.buildLinkDes(ospfRouter, ospfLinkTed);
            LinkedList<DefaultPortDescription> srcPortDescriptions = new LinkedList<DefaultPortDescription>();
            srcPortDescriptions.add(new DefaultPortDescription(linkDes.src().port(), true, new SparseAnnotations[0]));
            OspfTopologyProvider.this.deviceProviderService.updatePorts(linkDes.src().deviceId(), srcPortDescriptions);
            LinkedList<DefaultPortDescription> dstPortDescriptions = new LinkedList<DefaultPortDescription>();
            dstPortDescriptions.add(new DefaultPortDescription(linkDes.dst().port(), true, new SparseAnnotations[0]));
            OspfTopologyProvider.this.deviceProviderService.updatePorts(linkDes.dst().deviceId(), dstPortDescriptions);
            OspfTopologyProvider.this.linkProviderService.linkVanished(linkDes);
        }

        public void routerChanged(OspfRouter ospfRouter) {
            log.info("Router changed is not supported currently");
        }
    }
}

