/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.ovsdb.controller.impl;

import io.netty.bootstrap.ServerBootstrap;
import io.netty.buffer.PooledByteBufAllocator;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelOption;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.ServerChannel;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.channel.socket.SocketChannel;
import io.netty.channel.socket.nio.NioServerSocketChannel;
import io.netty.handler.codec.string.StringEncoder;
import io.netty.util.CharsetUtil;
import io.netty.util.concurrent.GenericFutureListener;
import java.net.InetSocketAddress;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.onlab.packet.IpAddress;
import org.onosproject.ovsdb.controller.OvsdbNodeId;
import org.onosproject.ovsdb.controller.driver.DefaultOvsdbClient;
import org.onosproject.ovsdb.controller.driver.OvsdbAgent;
import org.onosproject.ovsdb.controller.driver.OvsdbProviderService;
import org.onosproject.ovsdb.controller.impl.ChannelConnectionListener;
import org.onosproject.ovsdb.controller.impl.MessageDecoder;
import org.onosproject.ovsdb.controller.impl.OvsdbJsonRpcHandler;
import org.onosproject.ovsdb.rfc.jsonrpc.Callback;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Controller {
    protected static final Logger log = LoggerFactory.getLogger(Controller.class);
    private int ovsdbPort = 6640;
    private OvsdbAgent agent;
    private Callback monitorCallback;
    private final ExecutorService executorService = Executors.newFixedThreadPool(10);
    private EventLoopGroup bossGroup;
    private EventLoopGroup workerGroup;
    private Class<? extends ServerChannel> serverChannelClass;

    private void initEventLoopGroup() {
        this.bossGroup = new NioEventLoopGroup();
        this.workerGroup = new NioEventLoopGroup();
        this.serverChannelClass = NioServerSocketChannel.class;
    }

    private void startAcceptingConnections() throws InterruptedException {
        ServerBootstrap b = new ServerBootstrap();
        ((ServerBootstrap)b.group(this.bossGroup, this.workerGroup).channel(this.serverChannelClass)).childHandler((ChannelHandler)new OnosCommunicationChannelInitializer());
        b.option(ChannelOption.SO_BACKLOG, (Object)128);
        b.option(ChannelOption.WRITE_BUFFER_HIGH_WATER_MARK, (Object)32768);
        b.option(ChannelOption.WRITE_BUFFER_LOW_WATER_MARK, (Object)8192);
        b.option(ChannelOption.ALLOCATOR, (Object)PooledByteBufAllocator.DEFAULT);
        b.childOption(ChannelOption.SO_KEEPALIVE, (Object)true);
        b.bind(this.ovsdbPort).sync();
    }

    public void run() throws InterruptedException {
        this.initEventLoopGroup();
        this.startAcceptingConnections();
    }

    private void handleNewNodeConnection(final Channel channel) {
        this.executorService.execute(new Runnable(){

            @Override
            public void run() {
                log.info("Handle new node connection");
                IpAddress ipAddress = IpAddress.valueOf((String)((InetSocketAddress)channel.remoteAddress()).getAddress().getHostAddress());
                long port = ((InetSocketAddress)channel.remoteAddress()).getPort();
                log.info("Get connection from ip address {} : {}", (Object)ipAddress.toString(), (Object)port);
                OvsdbNodeId nodeId = new OvsdbNodeId(ipAddress, port);
                OvsdbProviderService ovsdbProviderService = Controller.this.getNodeInstance(nodeId, Controller.this.agent, Controller.this.monitorCallback, channel);
                ovsdbProviderService.setConnection(true);
                OvsdbJsonRpcHandler ovsdbJsonRpcHandler = new OvsdbJsonRpcHandler(nodeId);
                ovsdbJsonRpcHandler.setOvsdbProviderService(ovsdbProviderService);
                channel.pipeline().addLast(new ChannelHandler[]{ovsdbJsonRpcHandler});
                ovsdbProviderService.nodeAdded();
                ChannelFuture closeFuture = channel.closeFuture();
                closeFuture.addListener((GenericFutureListener)new ChannelConnectionListener(ovsdbProviderService));
            }
        });
    }

    protected OvsdbProviderService getNodeInstance(OvsdbNodeId nodeId, OvsdbAgent agent, Callback monitorCallback, Channel channel) {
        DefaultOvsdbClient ovsdbProviderService = new DefaultOvsdbClient(nodeId);
        ovsdbProviderService.setAgent(agent);
        ovsdbProviderService.setCallback(monitorCallback);
        ovsdbProviderService.setChannel(channel);
        return ovsdbProviderService;
    }

    public void start(OvsdbAgent agent, Callback monitorCallback) {
        this.agent = agent;
        this.monitorCallback = monitorCallback;
        try {
            this.run();
        }
        catch (InterruptedException e) {
            log.warn("Interrupted while waiting to start");
            Thread.currentThread().interrupt();
        }
    }

    public void stop() {
        this.workerGroup.shutdownGracefully();
        this.bossGroup.shutdownGracefully();
    }

    private class OnosCommunicationChannelInitializer
    extends ChannelInitializer<SocketChannel> {
        private OnosCommunicationChannelInitializer() {
        }

        protected void initChannel(SocketChannel channel) throws Exception {
            log.info("New channel created");
            channel.pipeline().addLast(new ChannelHandler[]{new StringEncoder(CharsetUtil.UTF_8)});
            channel.pipeline().addLast(new ChannelHandler[]{new MessageDecoder()});
            Controller.this.handleNewNodeConnection((Channel)channel);
        }
    }
}

