/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.ovsdb.controller.impl;

import com.fasterxml.jackson.databind.JsonNode;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.math.BigInteger;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.concurrent.ExecutionException;
import org.apache.felix.scr.annotations.Activate;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Deactivate;
import org.apache.felix.scr.annotations.Service;
import org.onlab.packet.IpAddress;
import org.onlab.packet.MacAddress;
import org.onlab.packet.TpPort;
import org.onosproject.ovsdb.controller.DefaultEventSubject;
import org.onosproject.ovsdb.controller.OvsdbClientService;
import org.onosproject.ovsdb.controller.OvsdbController;
import org.onosproject.ovsdb.controller.OvsdbDatapathId;
import org.onosproject.ovsdb.controller.OvsdbEvent;
import org.onosproject.ovsdb.controller.OvsdbEventListener;
import org.onosproject.ovsdb.controller.OvsdbIfaceId;
import org.onosproject.ovsdb.controller.OvsdbNodeId;
import org.onosproject.ovsdb.controller.OvsdbNodeListener;
import org.onosproject.ovsdb.controller.OvsdbPortName;
import org.onosproject.ovsdb.controller.OvsdbPortNumber;
import org.onosproject.ovsdb.controller.OvsdbPortType;
import org.onosproject.ovsdb.controller.driver.OvsdbAgent;
import org.onosproject.ovsdb.controller.impl.Controller;
import org.onosproject.ovsdb.rfc.jsonrpc.Callback;
import org.onosproject.ovsdb.rfc.message.TableUpdate;
import org.onosproject.ovsdb.rfc.message.TableUpdates;
import org.onosproject.ovsdb.rfc.message.UpdateNotification;
import org.onosproject.ovsdb.rfc.notation.OvsdbMap;
import org.onosproject.ovsdb.rfc.notation.OvsdbSet;
import org.onosproject.ovsdb.rfc.notation.Row;
import org.onosproject.ovsdb.rfc.schema.DatabaseSchema;
import org.onosproject.ovsdb.rfc.table.Bridge;
import org.onosproject.ovsdb.rfc.table.Interface;
import org.onosproject.ovsdb.rfc.table.OvsdbTable;
import org.onosproject.ovsdb.rfc.table.TableGenerator;
import org.onosproject.ovsdb.rfc.utils.FromJsonUtil;
import org.osgi.service.component.ComponentContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(immediate=true)
@Service
public class OvsdbControllerImpl
implements OvsdbController {
    public static final Logger log = LoggerFactory.getLogger(OvsdbControllerImpl.class);
    protected ConcurrentHashMap<OvsdbNodeId, OvsdbClientService> ovsdbClients = new ConcurrentHashMap();
    protected OvsdbAgent agent = new InternalOvsdbNodeAgent();
    protected InternalMonitorCallBack updateCallback = new InternalMonitorCallBack();
    protected Set<OvsdbNodeListener> ovsdbNodeListener = new CopyOnWriteArraySet<OvsdbNodeListener>();
    protected Set<OvsdbEventListener> ovsdbEventListener = new CopyOnWriteArraySet<OvsdbEventListener>();
    protected ConcurrentHashMap<String, OvsdbClientService> requestNotification = new ConcurrentHashMap();
    protected ConcurrentHashMap<String, String> requestDbName = new ConcurrentHashMap();
    private final Controller controller = new Controller();

    @Activate
    public void activate(ComponentContext context) {
        this.controller.start(this.agent, this.updateCallback);
        log.info("Started");
    }

    @Deactivate
    public void deactivate() {
        this.controller.stop();
        log.info("Stoped");
    }

    public void addNodeListener(OvsdbNodeListener listener) {
        if (!this.ovsdbNodeListener.contains(listener)) {
            this.ovsdbNodeListener.add(listener);
        }
    }

    public void removeNodeListener(OvsdbNodeListener listener) {
        this.ovsdbNodeListener.remove(listener);
    }

    public void addOvsdbEventListener(OvsdbEventListener listener) {
        if (!this.ovsdbEventListener.contains(listener)) {
            this.ovsdbEventListener.add(listener);
        }
    }

    public void removeOvsdbEventListener(OvsdbEventListener listener) {
        this.ovsdbEventListener.remove(listener);
    }

    public List<OvsdbNodeId> getNodeIds() {
        return ImmutableList.copyOf((Collection)this.ovsdbClients.keySet());
    }

    public OvsdbClientService getOvsdbClient(OvsdbNodeId nodeId) {
        return this.ovsdbClients.get(nodeId);
    }

    public void connect(IpAddress ip, TpPort port) {
        this.controller.connect(ip, port);
    }

    private void processTableUpdates(OvsdbClientService clientService, TableUpdates updates, String dbName) throws InterruptedException {
        Preconditions.checkNotNull((Object)clientService, (Object)"OvsdbClientService is not null");
        DatabaseSchema dbSchema = clientService.getDatabaseSchema(dbName);
        for (String tableName : updates.result().keySet()) {
            TableUpdate update = (TableUpdate)updates.result().get(tableName);
            for (org.onosproject.ovsdb.rfc.notation.UUID uuid : update.rows().keySet()) {
                log.debug("Begin to process table updates uuid: {}, databaseName: {}, tableName: {}", new Object[]{uuid.value(), dbName, tableName});
                Row newRow = update.getNew(uuid);
                if (newRow != null) {
                    clientService.updateOvsdbStore(dbName, tableName, uuid.value(), newRow);
                    if (!"Interface".equals(tableName)) continue;
                    this.dispatchInterfaceEvent(clientService, newRow, OvsdbEvent.Type.PORT_ADDED, dbSchema);
                    continue;
                }
                if (update.getOld(uuid) == null) continue;
                if ("Interface".equals(tableName)) {
                    Row row = clientService.getRow("Open_vSwitch", tableName, uuid.value());
                    this.dispatchInterfaceEvent(clientService, row, OvsdbEvent.Type.PORT_REMOVED, dbSchema);
                }
                clientService.removeRow(dbName, tableName, uuid.value());
            }
        }
    }

    private void dispatchInterfaceEvent(OvsdbClientService clientService, Row row, OvsdbEvent.Type eventType, DatabaseSchema dbSchema) {
        long dpid = this.getDataPathid(clientService, dbSchema);
        Interface intf = (Interface)TableGenerator.getTable((DatabaseSchema)dbSchema, (Row)row, (OvsdbTable)OvsdbTable.INTERFACE);
        if (intf == null) {
            return;
        }
        String portType = (String)intf.getTypeColumn().data();
        long localPort = this.getOfPort(intf);
        if (localPort < 0L) {
            return;
        }
        String[] macAndIfaceId = this.getMacAndIfaceid(intf);
        if (macAndIfaceId == null) {
            return;
        }
        DefaultEventSubject eventSubject = new DefaultEventSubject(MacAddress.valueOf((String)macAndIfaceId[0]), new HashSet(), new OvsdbPortName(intf.getName()), new OvsdbPortNumber(localPort), new OvsdbDatapathId(Long.toString(dpid)), new OvsdbPortType(portType), new OvsdbIfaceId(macAndIfaceId[1]));
        for (OvsdbEventListener listener : this.ovsdbEventListener) {
            listener.handle(new OvsdbEvent(eventType, (Object)eventSubject));
        }
    }

    private String[] getMacAndIfaceid(Interface intf) {
        OvsdbMap ovsdbMap = (OvsdbMap)intf.getExternalIdsColumn().data();
        Map externalIds = ovsdbMap.map();
        if (externalIds == null) {
            log.warn("The external_ids is null");
            return null;
        }
        String attachedMac = (String)externalIds.get("attached-mac");
        if (attachedMac == null) {
            log.debug("The attachedMac is null");
            return null;
        }
        String ifaceid = (String)externalIds.get("iface-id");
        if (ifaceid == null) {
            log.warn("The ifaceid is null");
            return null;
        }
        return new String[]{attachedMac, ifaceid};
    }

    private long getOfPort(Interface intf) {
        OvsdbSet ofPortSet = (OvsdbSet)intf.getOpenFlowPortColumn().data();
        Set ofPorts = ofPortSet.set();
        if (ofPorts == null || ofPorts.size() <= 0) {
            log.debug("The ofport is null in {}", (Object)intf.getName());
            return -1L;
        }
        Iterator it = ofPorts.iterator();
        return Long.parseLong(((Integer)it.next()).toString());
    }

    private long getDataPathid(OvsdbClientService clientService, DatabaseSchema dbSchema) {
        String bridgeUuid = clientService.getBridgeUuid("br-int");
        if (bridgeUuid == null) {
            log.debug("Unable to spot bridge uuid for {} in {}", (Object)"br-int", (Object)clientService);
            return 0L;
        }
        Row bridgeRow = clientService.getRow("Open_vSwitch", "Bridge", bridgeUuid);
        Bridge bridge = (Bridge)TableGenerator.getTable((DatabaseSchema)dbSchema, (Row)bridgeRow, (OvsdbTable)OvsdbTable.BRIDGE);
        OvsdbSet dpidSet = (OvsdbSet)bridge.getDatapathIdColumn().data();
        Set dpids = dpidSet.set();
        if (dpids == null || dpids.size() == 0) {
            return 0L;
        }
        return this.stringToLong((String)dpids.toArray()[0]);
    }

    private long stringToLong(String values) {
        long value = new BigInteger(values.replaceAll(":", ""), 16).longValue();
        return value;
    }

    private class InternalMonitorCallBack
    implements Callback {
        private InternalMonitorCallBack() {
        }

        public void update(UpdateNotification updateNotification) {
            Object key = updateNotification.jsonValue();
            OvsdbClientService ovsdbClient = OvsdbControllerImpl.this.requestNotification.get(key);
            String dbName = OvsdbControllerImpl.this.requestDbName.get(key);
            JsonNode updatesJson = updateNotification.tbUpdatesJsonNode();
            DatabaseSchema dbSchema = ovsdbClient.getDatabaseSchema(dbName);
            TableUpdates updates = FromJsonUtil.jsonNodeToTableUpdates((JsonNode)updatesJson, (DatabaseSchema)dbSchema);
            try {
                OvsdbControllerImpl.this.processTableUpdates(ovsdbClient, updates, dbName);
            }
            catch (InterruptedException e) {
                log.warn("Interrupted while processing table updates");
                Thread.currentThread().interrupt();
            }
        }

        public void locked(List<String> ids) {
        }

        public void stolen(List<String> ids) {
        }
    }

    private class InternalOvsdbNodeAgent
    implements OvsdbAgent {
        private InternalOvsdbNodeAgent() {
        }

        public void addConnectedNode(OvsdbNodeId nodeId, OvsdbClientService ovsdbClient) {
            if (OvsdbControllerImpl.this.ovsdbClients.get(nodeId) != null) {
                return;
            }
            OvsdbControllerImpl.this.ovsdbClients.put(nodeId, ovsdbClient);
            try {
                List dbNames = (List)ovsdbClient.listDbs().get();
                for (String dbName : dbNames) {
                    DatabaseSchema dbSchema = (DatabaseSchema)ovsdbClient.getOvsdbSchema(dbName).get();
                    log.debug("Begin to monitor tables");
                    String id = UUID.randomUUID().toString();
                    TableUpdates updates = (TableUpdates)ovsdbClient.monitorTables(dbName, id).get();
                    OvsdbControllerImpl.this.requestDbName.put(id, dbName);
                    OvsdbControllerImpl.this.requestNotification.put(id, ovsdbClient);
                    if (updates == null) continue;
                    OvsdbControllerImpl.this.processTableUpdates(ovsdbClient, updates, dbSchema.name());
                }
            }
            catch (InterruptedException e) {
                log.warn("Interrupted while waiting to get message from ovsdb");
                Thread.currentThread().interrupt();
            }
            catch (ExecutionException e) {
                log.error("Exception thrown while to get message from ovsdb");
            }
            log.debug("Add node to north");
            for (OvsdbNodeListener l : OvsdbControllerImpl.this.ovsdbNodeListener) {
                l.nodeAdded(nodeId);
            }
        }

        public void removeConnectedNode(OvsdbNodeId nodeId) {
            OvsdbControllerImpl.this.ovsdbClients.remove(nodeId);
            log.debug("Node connection is removed");
            for (OvsdbNodeListener l : OvsdbControllerImpl.this.ovsdbNodeListener) {
                l.nodeRemoved(nodeId);
            }
        }
    }
}

