/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.ovsdb.controller.impl;

import com.fasterxml.jackson.databind.JsonNode;
import com.google.common.base.Strings;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundHandlerAdapter;
import org.onosproject.ovsdb.controller.OvsdbNodeId;
import org.onosproject.ovsdb.controller.driver.OvsdbProviderService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class OvsdbJsonRpcHandler
extends ChannelInboundHandlerAdapter {
    protected static final Logger log = LoggerFactory.getLogger(OvsdbJsonRpcHandler.class);
    private OvsdbNodeId ovsdbNodeId;
    private OvsdbProviderService ovsdbProviderService;

    public OvsdbJsonRpcHandler(OvsdbNodeId ovsdbNodeId) {
        this.ovsdbNodeId = ovsdbNodeId;
    }

    public OvsdbProviderService getOvsdbProviderService() {
        return this.ovsdbProviderService;
    }

    public void setOvsdbProviderService(OvsdbProviderService ovsdbNodeDriver) {
        this.ovsdbProviderService = ovsdbNodeDriver;
    }

    public OvsdbNodeId getNodeId() {
        return this.ovsdbNodeId;
    }

    public void setNodeId(OvsdbNodeId ovsdbNodeId) {
        this.ovsdbNodeId = ovsdbNodeId;
    }

    private void processOvsdbMessage(JsonNode jsonNode) {
        log.debug("Handle ovsdb message");
        if (jsonNode.has("result")) {
            log.debug("Handle ovsdb result");
            this.ovsdbProviderService.processResult(jsonNode);
        } else if (jsonNode.hasNonNull("method")) {
            log.debug("Handle ovsdb request");
            if (jsonNode.has("id") && !Strings.isNullOrEmpty((String)jsonNode.get("id").asText())) {
                this.ovsdbProviderService.processRequest(jsonNode);
            }
        }
    }

    public void channelRead(ChannelHandlerContext ctx, Object msg) throws Exception {
        log.debug("Receive message from ovsdb");
        if (msg instanceof JsonNode) {
            JsonNode jsonNode = (JsonNode)msg;
            this.processOvsdbMessage(jsonNode);
        }
    }

    public void channelReadComplete(ChannelHandlerContext ctx) throws Exception {
        ctx.flush();
    }

    public void exceptionCaught(ChannelHandlerContext context, Throwable cause) {
        log.error("Exception inside channel handling pipeline.", cause);
        context.close();
    }
}

