/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.provider.pcep.topology.impl;

import com.google.common.base.Preconditions;
import java.net.URI;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.felix.scr.annotations.Activate;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Deactivate;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.ReferenceCardinality;
import org.onlab.packet.ChassisId;
import org.onosproject.cluster.ClusterService;
import org.onosproject.mastership.MastershipAdminService;
import org.onosproject.mastership.MastershipService;
import org.onosproject.net.ConnectPoint;
import org.onosproject.net.DefaultAnnotations;
import org.onosproject.net.Device;
import org.onosproject.net.DeviceId;
import org.onosproject.net.ElementId;
import org.onosproject.net.Link;
import org.onosproject.net.MastershipRole;
import org.onosproject.net.PortNumber;
import org.onosproject.net.SparseAnnotations;
import org.onosproject.net.device.DefaultDeviceDescription;
import org.onosproject.net.device.DefaultPortDescription;
import org.onosproject.net.device.DeviceDescription;
import org.onosproject.net.device.DeviceProvider;
import org.onosproject.net.device.DeviceProviderRegistry;
import org.onosproject.net.device.DeviceProviderService;
import org.onosproject.net.device.DeviceService;
import org.onosproject.net.device.PortDescription;
import org.onosproject.net.link.DefaultLinkDescription;
import org.onosproject.net.link.LinkDescription;
import org.onosproject.net.link.LinkProvider;
import org.onosproject.net.link.LinkProviderRegistry;
import org.onosproject.net.link.LinkProviderService;
import org.onosproject.net.link.LinkService;
import org.onosproject.net.provider.AbstractProvider;
import org.onosproject.net.provider.Provider;
import org.onosproject.net.provider.ProviderId;
import org.onosproject.pcep.api.PcepController;
import org.onosproject.pcep.api.PcepDpid;
import org.onosproject.pcep.api.PcepLink;
import org.onosproject.pcep.api.PcepLinkListener;
import org.onosproject.pcep.api.PcepOperator;
import org.onosproject.pcep.api.PcepSwitch;
import org.onosproject.pcep.api.PcepSwitchListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(immediate=true)
public class PcepTopologyProvider
extends AbstractProvider
implements LinkProvider,
DeviceProvider {
    private static final Logger log = LoggerFactory.getLogger(PcepTopologyProvider.class);
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    protected LinkProviderRegistry linkProviderRegistry;
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    protected DeviceProviderRegistry deviceProviderRegistry;
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    protected PcepController controller;
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    protected DeviceService deviceService;
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    protected LinkService linkService;
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    protected MastershipAdminService mastershipAdminService;
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    protected MastershipService mastershipService;
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    protected ClusterService clusterService;
    private DeviceProviderService deviceProviderService;
    private LinkProviderService linkProviderService;
    HashSet<Long> portSet = new HashSet();
    private InternalLinkProvider listener = new InternalLinkProvider();

    public PcepTopologyProvider() {
        super(new ProviderId("pcep", "org.onosproject.provider.pcep"));
    }

    @Activate
    public void activate() {
        this.linkProviderService = (LinkProviderService)this.linkProviderRegistry.register((Provider)this);
        this.deviceProviderService = (DeviceProviderService)this.deviceProviderRegistry.register((Provider)this);
        this.controller.addListener((PcepSwitchListener)this.listener);
        this.controller.addLinkListener((PcepLinkListener)this.listener);
    }

    @Deactivate
    public void deactivate() {
        this.linkProviderRegistry.unregister((Provider)this);
        this.linkProviderService = null;
        this.controller.removeListener((PcepSwitchListener)this.listener);
        this.controller.removeLinkListener((PcepLinkListener)this.listener);
    }

    private List<PortDescription> buildPortDescriptions(List<Long> ports, PcepLink.PortType portType) {
        ArrayList<PortDescription> portDescs = new ArrayList<PortDescription>();
        for (long port : ports) {
            portDescs.add(this.buildPortDescription(port, portType));
        }
        return portDescs;
    }

    private PortDescription buildPortDescription(long port, PcepLink.PortType portType) {
        PortNumber portNo = PortNumber.portNumber((long)port);
        boolean enabled = true;
        DefaultAnnotations extendedAttributes = DefaultAnnotations.builder().set("portType", String.valueOf(portType)).build();
        return new DefaultPortDescription(portNo, true, new SparseAnnotations[]{extendedAttributes});
    }

    private DefaultAnnotations buildLinkAnnotations(PcepLink linkDesc) {
        DefaultAnnotations extendedAttributes = DefaultAnnotations.builder().set("subType", String.valueOf(linkDesc.linkSubType())).set("workState", linkDesc.linkState()).set("distance", String.valueOf(linkDesc.linkDistance())).set("capType", linkDesc.linkCapacityType().toLowerCase()).set("avail_" + linkDesc.linkCapacityType().toLowerCase(), String.valueOf(linkDesc.linkAvailValue())).set("max_" + linkDesc.linkCapacityType().toLowerCase(), String.valueOf(linkDesc.linkMaxValue())).build();
        return extendedAttributes;
    }

    private LinkDescription buildLinkDescription(PcepLink pceLink) {
        DeviceId srcDeviceID = DeviceId.deviceId((URI)PcepDpid.uri((PcepDpid)pceLink.linkSrcDeviceID()));
        DeviceId dstDeviceID = DeviceId.deviceId((URI)PcepDpid.uri((PcepDpid)pceLink.linkDstDeviceId()));
        if (this.deviceService.getDevice(srcDeviceID) == null || this.deviceService.getDevice(dstDeviceID) == null) {
            log.info("the device of the link is not exited" + srcDeviceID + dstDeviceID);
            return null;
        }
        long srcPort = pceLink.linkSrcPort();
        this.portSet.add(srcPort);
        ArrayList<Long> srcportList = new ArrayList<Long>();
        srcportList.addAll(this.portSet);
        this.deviceProviderService.updatePorts(srcDeviceID, this.buildPortDescriptions(srcportList, pceLink.portType()));
        ConnectPoint src = new ConnectPoint((ElementId)srcDeviceID, PortNumber.portNumber((long)pceLink.linkSrcPort()));
        ConnectPoint dst = new ConnectPoint((ElementId)dstDeviceID, PortNumber.portNumber((long)pceLink.linkDstPort()));
        DefaultAnnotations extendedAttributes = this.buildLinkAnnotations(pceLink);
        DefaultLinkDescription ld = new DefaultLinkDescription(src, dst, Link.Type.OPTICAL, new SparseAnnotations[]{extendedAttributes});
        return ld;
    }

    private void processLinkUpdate(LinkDescription linkDescription) {
        if (this.linkService.getLink(linkDescription.src(), linkDescription.dst()) == null) {
            Set links = this.linkService.getIngressLinks(linkDescription.src());
            for (Link link : links) {
                this.linkProviderService.linkVanished((LinkDescription)link);
                if (this.linkService.getDeviceLinks(link.dst().deviceId()).size() != 0) continue;
                this.deviceProviderService.deviceDisconnected(link.dst().deviceId());
            }
        }
        this.linkProviderService.linkDetected(linkDescription);
    }

    public void triggerProbe(DeviceId deviceId) {
    }

    public void roleChanged(DeviceId deviceId, MastershipRole newRole) {
    }

    public boolean isReachable(DeviceId deviceId) {
        return true;
    }

    protected void bindLinkProviderRegistry(LinkProviderRegistry linkProviderRegistry) {
        this.linkProviderRegistry = linkProviderRegistry;
    }

    protected void unbindLinkProviderRegistry(LinkProviderRegistry linkProviderRegistry) {
        if (this.linkProviderRegistry == linkProviderRegistry) {
            this.linkProviderRegistry = null;
        }
    }

    protected void bindDeviceProviderRegistry(DeviceProviderRegistry deviceProviderRegistry) {
        this.deviceProviderRegistry = deviceProviderRegistry;
    }

    protected void unbindDeviceProviderRegistry(DeviceProviderRegistry deviceProviderRegistry) {
        if (this.deviceProviderRegistry == deviceProviderRegistry) {
            this.deviceProviderRegistry = null;
        }
    }

    protected void bindController(PcepController pcepController) {
        this.controller = pcepController;
    }

    protected void unbindController(PcepController pcepController) {
        if (this.controller == pcepController) {
            this.controller = null;
        }
    }

    protected void bindDeviceService(DeviceService deviceService) {
        this.deviceService = deviceService;
    }

    protected void unbindDeviceService(DeviceService deviceService) {
        if (this.deviceService == deviceService) {
            this.deviceService = null;
        }
    }

    protected void bindLinkService(LinkService linkService) {
        this.linkService = linkService;
    }

    protected void unbindLinkService(LinkService linkService) {
        if (this.linkService == linkService) {
            this.linkService = null;
        }
    }

    protected void bindMastershipAdminService(MastershipAdminService mastershipAdminService) {
        this.mastershipAdminService = mastershipAdminService;
    }

    protected void unbindMastershipAdminService(MastershipAdminService mastershipAdminService) {
        if (this.mastershipAdminService == mastershipAdminService) {
            this.mastershipAdminService = null;
        }
    }

    protected void bindMastershipService(MastershipService mastershipService) {
        this.mastershipService = mastershipService;
    }

    protected void unbindMastershipService(MastershipService mastershipService) {
        if (this.mastershipService == mastershipService) {
            this.mastershipService = null;
        }
    }

    protected void bindClusterService(ClusterService clusterService) {
        this.clusterService = clusterService;
    }

    protected void unbindClusterService(ClusterService clusterService) {
        if (this.clusterService == clusterService) {
            this.clusterService = null;
        }
    }

    private class InternalLinkProvider
    implements PcepSwitchListener,
    PcepLinkListener {
        private InternalLinkProvider() {
        }

        public void switchAdded(PcepDpid dpid) {
            if (PcepTopologyProvider.this.deviceProviderService == null) {
                return;
            }
            DeviceId devicdId = DeviceId.deviceId((URI)PcepDpid.uri((PcepDpid)dpid));
            PcepSwitch sw = PcepTopologyProvider.this.controller.getSwitch(dpid);
            Preconditions.checkNotNull((Object)sw, (Object)"device should not null.");
            ChassisId cId = new ChassisId(dpid.value());
            Device.Type deviceType = null;
            switch (sw.getDeviceType()) {
                case ROADM: {
                    deviceType = Device.Type.ROADM;
                    break;
                }
                case OTN: {
                    deviceType = Device.Type.SWITCH;
                    break;
                }
                case ROUTER: {
                    deviceType = Device.Type.ROUTER;
                    break;
                }
                default: {
                    deviceType = Device.Type.OTHER;
                }
            }
            DefaultDeviceDescription description = new DefaultDeviceDescription(devicdId.uri(), deviceType, sw.manufacturerDescription(), sw.hardwareDescription(), sw.softwareDescription(), sw.serialNumber(), cId, new SparseAnnotations[0]);
            PcepTopologyProvider.this.deviceProviderService.deviceConnected(devicdId, (DeviceDescription)description);
        }

        public void switchRemoved(PcepDpid dpid) {
            if (PcepTopologyProvider.this.deviceProviderService == null || PcepTopologyProvider.this.linkProviderService == null) {
                return;
            }
            PcepTopologyProvider.this.deviceProviderService.deviceDisconnected(DeviceId.deviceId((URI)PcepDpid.uri((PcepDpid)dpid)));
            PcepTopologyProvider.this.linkProviderService.linksVanished(DeviceId.deviceId((URI)PcepDpid.uri((PcepDpid)dpid)));
        }

        public void switchChanged(PcepDpid dpid) {
        }

        public void handlePCEPlink(PcepLink link) {
            PcepOperator.OperationType operType = link.getOperationType();
            LinkDescription ld = PcepTopologyProvider.this.buildLinkDescription(link);
            if (ld == null) {
                log.error("Invalid link info.");
                return;
            }
            switch (operType) {
                case ADD: {
                    PcepTopologyProvider.this.linkProviderService.linkDetected(ld);
                    break;
                }
                case UPDATE: {
                    PcepTopologyProvider.this.processLinkUpdate(ld);
                    break;
                }
                case DELETE: {
                    PcepTopologyProvider.this.linkProviderService.linkVanished(ld);
                    break;
                }
            }
        }
    }
}

