/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.provider.pcep.topology.impl;

import com.google.common.base.Preconditions;
import java.net.URI;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.apache.felix.scr.annotations.Activate;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Deactivate;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.ReferenceCardinality;
import org.onlab.packet.ChassisId;
import org.onosproject.cluster.ClusterService;
import org.onosproject.mastership.MastershipAdminService;
import org.onosproject.mastership.MastershipService;
import org.onosproject.net.ConnectPoint;
import org.onosproject.net.DefaultAnnotations;
import org.onosproject.net.Device;
import org.onosproject.net.DeviceId;
import org.onosproject.net.ElementId;
import org.onosproject.net.Link;
import org.onosproject.net.MastershipRole;
import org.onosproject.net.OchPort;
import org.onosproject.net.OduCltPort;
import org.onosproject.net.OmsPort;
import org.onosproject.net.Port;
import org.onosproject.net.SparseAnnotations;
import org.onosproject.net.device.DefaultDeviceDescription;
import org.onosproject.net.device.DefaultPortDescription;
import org.onosproject.net.device.DeviceDescription;
import org.onosproject.net.device.DeviceProvider;
import org.onosproject.net.device.DeviceProviderRegistry;
import org.onosproject.net.device.DeviceProviderService;
import org.onosproject.net.device.DeviceService;
import org.onosproject.net.device.OchPortDescription;
import org.onosproject.net.device.OduCltPortDescription;
import org.onosproject.net.device.OmsPortDescription;
import org.onosproject.net.device.PortDescription;
import org.onosproject.net.link.DefaultLinkDescription;
import org.onosproject.net.link.LinkDescription;
import org.onosproject.net.link.LinkProvider;
import org.onosproject.net.link.LinkProviderRegistry;
import org.onosproject.net.link.LinkProviderService;
import org.onosproject.net.link.LinkService;
import org.onosproject.net.provider.AbstractProvider;
import org.onosproject.net.provider.Provider;
import org.onosproject.net.provider.ProviderId;
import org.onosproject.pcep.api.PcepController;
import org.onosproject.pcep.api.PcepDpid;
import org.onosproject.pcep.api.PcepLink;
import org.onosproject.pcep.api.PcepLinkListener;
import org.onosproject.pcep.api.PcepOperator;
import org.onosproject.pcep.api.PcepSwitch;
import org.onosproject.pcep.api.PcepSwitchListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(immediate=true)
public class PcepTopologyProvider
extends AbstractProvider
implements LinkProvider,
DeviceProvider {
    private static final Logger log = LoggerFactory.getLogger(PcepTopologyProvider.class);
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    protected LinkProviderRegistry linkProviderRegistry;
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    protected DeviceProviderRegistry deviceProviderRegistry;
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    protected PcepController controller;
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    protected DeviceService deviceService;
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    protected LinkService linkService;
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    protected MastershipAdminService mastershipAdminService;
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    protected MastershipService mastershipService;
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    protected ClusterService clusterService;
    private DeviceProviderService deviceProviderService;
    private LinkProviderService linkProviderService;
    private HashMap<Long, List<PortDescription>> portMap = new HashMap();
    private InternalLinkProvider listener = new InternalLinkProvider();

    public PcepTopologyProvider() {
        super(new ProviderId("pcep", "org.onosproject.provider.pcep"));
    }

    @Activate
    public void activate() {
        this.linkProviderService = (LinkProviderService)this.linkProviderRegistry.register((Provider)this);
        this.deviceProviderService = (DeviceProviderService)this.deviceProviderRegistry.register((Provider)this);
        this.controller.addListener((PcepSwitchListener)this.listener);
        this.controller.addLinkListener((PcepLinkListener)this.listener);
    }

    @Deactivate
    public void deactivate() {
        this.linkProviderRegistry.unregister((Provider)this);
        this.linkProviderService = null;
        this.controller.removeListener((PcepSwitchListener)this.listener);
        this.controller.removeLinkListener((PcepLinkListener)this.listener);
    }

    private List<PortDescription> buildPortDescriptions(PcepDpid dpid, Port port, PcepLink.PortType portType) {
        List<Object> portList = this.portMap.containsKey(dpid.value()) ? this.portMap.get(dpid.value()) : new ArrayList();
        if (port != null && portType != null) {
            portList.add(this.buildPortDescription(port, portType));
        }
        this.portMap.put(dpid.value(), portList);
        return portList;
    }

    private PortDescription buildPortDescription(Port port, PcepLink.PortType portType) {
        DefaultPortDescription portDescription;
        switch (portType) {
            case OCH_PORT: {
                OchPort ochp = (OchPort)port;
                portDescription = new OchPortDescription(ochp.number(), ochp.isEnabled(), ochp.signalType(), ochp.isTunable(), ochp.lambda(), new SparseAnnotations[0]);
                break;
            }
            case ODU_PORT: {
                OduCltPort odup = (OduCltPort)port;
                portDescription = new OduCltPortDescription(odup.number(), odup.isEnabled(), odup.signalType(), new SparseAnnotations[0]);
                break;
            }
            case OMS_PORT: {
                OmsPort op = (OmsPort)port;
                portDescription = new OmsPortDescription(op.number(), op.isEnabled(), op.minFrequency(), op.maxFrequency(), op.grid(), new SparseAnnotations[0]);
                break;
            }
            default: {
                portDescription = new DefaultPortDescription(port.number(), port.isEnabled(), new SparseAnnotations[0]);
            }
        }
        return portDescription;
    }

    private LinkDescription buildLinkDescription(PcepLink pceLink) {
        Preconditions.checkNotNull((Object)pceLink);
        DeviceId srcDeviceID = DeviceId.deviceId((URI)PcepDpid.uri((PcepDpid)pceLink.linkSrcDeviceID()));
        DeviceId dstDeviceID = DeviceId.deviceId((URI)PcepDpid.uri((PcepDpid)pceLink.linkDstDeviceId()));
        this.deviceProviderService.updatePorts(srcDeviceID, this.buildPortDescriptions(pceLink.linkSrcDeviceID(), pceLink.linkSrcPort(), pceLink.portType()));
        this.deviceProviderService.updatePorts(dstDeviceID, this.buildPortDescriptions(pceLink.linkDstDeviceId(), pceLink.linkDstPort(), pceLink.portType()));
        ConnectPoint src = new ConnectPoint((ElementId)srcDeviceID, pceLink.linkSrcPort().number());
        ConnectPoint dst = new ConnectPoint((ElementId)dstDeviceID, pceLink.linkDstPort().number());
        DefaultAnnotations extendedAttributes = DefaultAnnotations.builder().set("subType", String.valueOf(pceLink.linkSubType())).set("workState", pceLink.linkState()).set("distance", String.valueOf(pceLink.linkDistance())).set("capType", pceLink.linkCapacityType().toLowerCase()).set("avail_" + pceLink.linkCapacityType().toLowerCase(), String.valueOf(pceLink.linkAvailValue())).set("max_" + pceLink.linkCapacityType().toLowerCase(), String.valueOf(pceLink.linkMaxValue())).build();
        DefaultLinkDescription ld = new DefaultLinkDescription(src, dst, Link.Type.OPTICAL, new SparseAnnotations[]{extendedAttributes});
        return ld;
    }

    public void triggerProbe(DeviceId deviceId) {
    }

    public void roleChanged(DeviceId deviceId, MastershipRole newRole) {
    }

    public boolean isReachable(DeviceId deviceId) {
        return true;
    }

    protected void bindLinkProviderRegistry(LinkProviderRegistry linkProviderRegistry) {
        this.linkProviderRegistry = linkProviderRegistry;
    }

    protected void unbindLinkProviderRegistry(LinkProviderRegistry linkProviderRegistry) {
        if (this.linkProviderRegistry == linkProviderRegistry) {
            this.linkProviderRegistry = null;
        }
    }

    protected void bindDeviceProviderRegistry(DeviceProviderRegistry deviceProviderRegistry) {
        this.deviceProviderRegistry = deviceProviderRegistry;
    }

    protected void unbindDeviceProviderRegistry(DeviceProviderRegistry deviceProviderRegistry) {
        if (this.deviceProviderRegistry == deviceProviderRegistry) {
            this.deviceProviderRegistry = null;
        }
    }

    protected void bindController(PcepController pcepController) {
        this.controller = pcepController;
    }

    protected void unbindController(PcepController pcepController) {
        if (this.controller == pcepController) {
            this.controller = null;
        }
    }

    protected void bindDeviceService(DeviceService deviceService) {
        this.deviceService = deviceService;
    }

    protected void unbindDeviceService(DeviceService deviceService) {
        if (this.deviceService == deviceService) {
            this.deviceService = null;
        }
    }

    protected void bindLinkService(LinkService linkService) {
        this.linkService = linkService;
    }

    protected void unbindLinkService(LinkService linkService) {
        if (this.linkService == linkService) {
            this.linkService = null;
        }
    }

    protected void bindMastershipAdminService(MastershipAdminService mastershipAdminService) {
        this.mastershipAdminService = mastershipAdminService;
    }

    protected void unbindMastershipAdminService(MastershipAdminService mastershipAdminService) {
        if (this.mastershipAdminService == mastershipAdminService) {
            this.mastershipAdminService = null;
        }
    }

    protected void bindMastershipService(MastershipService mastershipService) {
        this.mastershipService = mastershipService;
    }

    protected void unbindMastershipService(MastershipService mastershipService) {
        if (this.mastershipService == mastershipService) {
            this.mastershipService = null;
        }
    }

    protected void bindClusterService(ClusterService clusterService) {
        this.clusterService = clusterService;
    }

    protected void unbindClusterService(ClusterService clusterService) {
        if (this.clusterService == clusterService) {
            this.clusterService = null;
        }
    }

    private class InternalLinkProvider
    implements PcepSwitchListener,
    PcepLinkListener {
        private InternalLinkProvider() {
        }

        public void switchAdded(PcepDpid dpid) {
            Device.Type deviceType;
            if (PcepTopologyProvider.this.deviceProviderService == null) {
                return;
            }
            DeviceId deviceId = DeviceId.deviceId((URI)PcepDpid.uri((PcepDpid)dpid));
            PcepSwitch sw = PcepTopologyProvider.this.controller.getSwitch(dpid);
            Preconditions.checkNotNull((Object)sw, (Object)"device should not null.");
            ChassisId cId = new ChassisId(dpid.value());
            switch (sw.getDeviceType()) {
                case ROADM: {
                    deviceType = Device.Type.ROADM;
                    break;
                }
                case OTN: {
                    deviceType = Device.Type.SWITCH;
                    break;
                }
                case ROUTER: {
                    deviceType = Device.Type.ROUTER;
                    break;
                }
                default: {
                    deviceType = Device.Type.OTHER;
                }
            }
            DefaultDeviceDescription description = new DefaultDeviceDescription(deviceId.uri(), deviceType, sw.manufacturerDescription(), sw.hardwareDescription(), sw.softwareDescription(), sw.serialNumber(), cId, new SparseAnnotations[0]);
            PcepTopologyProvider.this.deviceProviderService.deviceConnected(deviceId, (DeviceDescription)description);
        }

        public void switchRemoved(PcepDpid dpid) {
            if (PcepTopologyProvider.this.deviceProviderService == null || PcepTopologyProvider.this.linkProviderService == null) {
                return;
            }
            PcepTopologyProvider.this.deviceProviderService.deviceDisconnected(DeviceId.deviceId((URI)PcepDpid.uri((PcepDpid)dpid)));
            PcepTopologyProvider.this.linkProviderService.linksVanished(DeviceId.deviceId((URI)PcepDpid.uri((PcepDpid)dpid)));
        }

        public void switchChanged(PcepDpid dpid) {
        }

        public void handlePceplink(PcepLink link) {
            PcepOperator.OperationType operType = link.getOperationType();
            LinkDescription ld = PcepTopologyProvider.this.buildLinkDescription(link);
            if (ld == null) {
                log.error("Invalid link info.");
                return;
            }
            switch (operType) {
                case ADD: 
                case UPDATE: {
                    PcepTopologyProvider.this.linkProviderService.linkDetected(ld);
                    break;
                }
                case DELETE: {
                    PcepTopologyProvider.this.linkProviderService.linkVanished(ld);
                    break;
                }
            }
        }
    }
}

