/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.provider.pcep.topology.impl;

import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.felix.scr.annotations.Activate;
import org.apache.felix.scr.annotations.Deactivate;
import org.onlab.packet.IpAddress;
import org.onosproject.pcep.controller.ClientCapability;
import org.onosproject.pcep.controller.PccId;
import org.onosproject.pcep.controller.PcepClient;
import org.onosproject.pcep.controller.PcepClientController;
import org.onosproject.pcep.controller.PcepClientListener;
import org.onosproject.pcep.controller.PcepEventListener;
import org.onosproject.pcep.controller.PcepNodeListener;
import org.onosproject.pcep.controller.PcepPacketListener;
import org.onosproject.pcep.controller.driver.PcepAgent;
import org.onosproject.pcepio.protocol.PcepError;
import org.onosproject.pcepio.protocol.PcepErrorInfo;
import org.onosproject.pcepio.protocol.PcepErrorMsg;
import org.onosproject.pcepio.protocol.PcepErrorObject;
import org.onosproject.pcepio.protocol.PcepFactory;
import org.onosproject.pcepio.protocol.PcepMessage;
import org.onosproject.pcepio.protocol.PcepVersion;
import org.onosproject.provider.pcep.topology.impl.PcepClientAdapter;

public class PcepClientControllerAdapter
implements PcepClientController {
    protected ConcurrentHashMap<PccId, PcepClient> connectedClients = new ConcurrentHashMap();
    protected PcepClientAgent agent = new PcepClientAgent();
    protected Set<PcepClientListener> pcepClientListener = new HashSet<PcepClientListener>();
    protected Set<PcepEventListener> pcepEventListener = Sets.newHashSet();
    public Set<PcepNodeListener> pcepNodeListener = Sets.newHashSet();

    @Activate
    public void activate() {
    }

    @Deactivate
    public void deactivate() {
    }

    public Collection<PcepClient> getClients() {
        return this.connectedClients.values();
    }

    public PcepClient getClient(PccId pccId) {
        if (null != this.connectedClients.get(pccId)) {
            return this.connectedClients.get(pccId);
        }
        PcepClientAdapter pc = new PcepClientAdapter();
        if (pccId.ipAddress().equals((Object)IpAddress.valueOf((int)201392387)) || pccId.ipAddress().equals((Object)IpAddress.valueOf((int)-1241362910))) {
            pc.setCapability(new ClientCapability(true, false, false, false, false));
        } else {
            pc.setCapability(new ClientCapability(true, true, true, false, false));
        }
        pc.init(PccId.pccId((IpAddress)pccId.ipAddress()), PcepVersion.PCEP_1);
        this.connectedClients.put(pccId, pc);
        return pc;
    }

    public void addListener(PcepClientListener listener) {
        if (!this.pcepClientListener.contains(listener)) {
            this.pcepClientListener.add(listener);
        }
    }

    public void addNodeListener(PcepNodeListener listener) {
        this.pcepNodeListener.add(listener);
    }

    public void removeNodeListener(PcepNodeListener listener) {
        this.pcepNodeListener.remove(listener);
    }

    public void removeListener(PcepClientListener listener) {
        this.pcepClientListener.remove(listener);
    }

    public void addEventListener(PcepEventListener listener) {
        this.pcepEventListener.add(listener);
    }

    public void removeEventListener(PcepEventListener listener) {
        this.pcepEventListener.remove(listener);
    }

    public void writeMessage(PccId pccId, PcepMessage msg) {
        this.getClient(pccId).sendMessage(msg);
    }

    public void processClientMessage(PccId pccId, PcepMessage msg) {
        PcepClient pc = this.getClient(pccId);
        switch (msg.getType()) {
            case NONE: {
                break;
            }
            case OPEN: {
                break;
            }
            case KEEP_ALIVE: {
                pc.sendMessage(Collections.singletonList(pc.factory().buildKeepaliveMsg().build()));
                break;
            }
            case PATH_COMPUTATION_REQUEST: {
                break;
            }
            case PATH_COMPUTATION_REPLY: {
                break;
            }
            case NOTIFICATION: {
                break;
            }
            case ERROR: {
                break;
            }
            case CLOSE: {
                pc.sendMessage(Collections.singletonList(pc.factory().buildCloseMsg().build()));
                break;
            }
            case INITIATE: {
                if (pc.capability().pcInstantiationCapability()) break;
                pc.sendMessage(Collections.singletonList(this.getErrMsg(pc.factory(), (byte)19, (byte)5)));
                break;
            }
            case REPORT: {
                if (pc.capability().statefulPceCapability()) {
                    for (PcepEventListener l : this.pcepEventListener) {
                        l.handleMessage(pccId, msg);
                    }
                    break;
                }
                pc.sendMessage(Collections.singletonList(this.getErrMsg(pc.factory(), (byte)19, (byte)5)));
                break;
            }
            case UPDATE: {
                if (pc.capability().statefulPceCapability()) break;
                pc.sendMessage(Collections.singletonList(this.getErrMsg(pc.factory(), (byte)19, (byte)5)));
                break;
            }
            case LABEL_UPDATE: {
                if (pc.capability().pceccCapability()) break;
                pc.sendMessage(Collections.singletonList(this.getErrMsg(pc.factory(), (byte)19, (byte)5)));
                break;
            }
            case MAX: {
                break;
            }
            case END: {
                break;
            }
        }
    }

    public void closeConnectedClients() {
        for (PccId id : this.connectedClients.keySet()) {
            PcepClient pc = this.getClient(id);
            pc.disconnectClient();
        }
    }

    private PcepErrorMsg getErrMsg(PcepFactory factory, byte errorType, byte errorValue) {
        LinkedList<PcepError> llPcepErr = new LinkedList<PcepError>();
        LinkedList<PcepErrorObject> llerrObj = new LinkedList<PcepErrorObject>();
        PcepErrorObject errObj = factory.buildPcepErrorObject().setErrorValue(errorValue).setErrorType(errorType).build();
        llerrObj.add(errObj);
        PcepError pcepErr = factory.buildPcepError().setErrorObjList(llerrObj).build();
        llPcepErr.add(pcepErr);
        PcepErrorInfo errInfo = factory.buildPcepErrorInfo().setPcepErrorList(llPcepErr).build();
        PcepErrorMsg errMsg = factory.buildPcepErrorMsg().setPcepErrorInfo(errInfo).build();
        return errMsg;
    }

    public void addPacketListener(PcepPacketListener listener) {
    }

    public void removePacketListener(PcepPacketListener listener) {
    }

    public class PcepClientAgent
    implements PcepAgent {
        public boolean addConnectedClient(PccId pccId, PcepClient pc) {
            if (PcepClientControllerAdapter.this.connectedClients.get(pccId) != null) {
                return false;
            }
            PcepClientControllerAdapter.this.connectedClients.put(pccId, pc);
            for (PcepClientListener l : PcepClientControllerAdapter.this.pcepClientListener) {
                l.clientConnected(pccId);
            }
            return true;
        }

        public boolean validActivation(PccId pccId) {
            return PcepClientControllerAdapter.this.connectedClients.get(pccId) != null;
        }

        public void removeConnectedClient(PccId pccId) {
            PcepClientControllerAdapter.this.connectedClients.remove(pccId);
            for (PcepClientListener l : PcepClientControllerAdapter.this.pcepClientListener) {
                l.clientDisconnected(pccId);
            }
        }

        public void processPcepMessage(PccId pccId, PcepMessage m) {
            PcepClientControllerAdapter.this.processClientMessage(pccId, m);
        }

        public void addNode(PcepClient pc) {
            for (PcepNodeListener l : PcepClientControllerAdapter.this.pcepNodeListener) {
                l.addDevicePcepConfig(pc);
            }
        }

        public void deleteNode(PccId pccId) {
            for (PcepNodeListener l : PcepClientControllerAdapter.this.pcepNodeListener) {
                l.deleteDevicePcepConfig(pccId);
            }
        }

        public boolean analyzeSyncMsgList(PccId pccId) {
            return false;
        }
    }
}

