/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.provider.pcep.topology.impl;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.JsonNodeFactory;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.core.Is;
import org.hamcrest.core.IsNull;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;
import org.onlab.packet.ChassisId;
import org.onlab.packet.IpAddress;
import org.onosproject.net.Annotations;
import org.onosproject.net.ConnectPoint;
import org.onosproject.net.DefaultDevice;
import org.onosproject.net.DefaultLink;
import org.onosproject.net.Device;
import org.onosproject.net.DeviceId;
import org.onosproject.net.Link;
import org.onosproject.net.MastershipRole;
import org.onosproject.net.config.Config;
import org.onosproject.net.config.ConfigApplyDelegate;
import org.onosproject.net.config.ConfigFactory;
import org.onosproject.net.config.NetworkConfigRegistryAdapter;
import org.onosproject.net.device.DeviceDescription;
import org.onosproject.net.device.DeviceProvider;
import org.onosproject.net.device.DeviceProviderRegistry;
import org.onosproject.net.device.DeviceProviderService;
import org.onosproject.net.device.DeviceServiceAdapter;
import org.onosproject.net.device.PortDescription;
import org.onosproject.net.device.PortStatistics;
import org.onosproject.net.link.LinkDescription;
import org.onosproject.net.link.LinkProvider;
import org.onosproject.net.link.LinkProviderRegistry;
import org.onosproject.net.link.LinkProviderService;
import org.onosproject.net.provider.ProviderId;
import org.onosproject.pcep.api.DeviceCapability;
import org.onosproject.pcep.controller.ClientCapability;
import org.onosproject.pcep.controller.PccId;
import org.onosproject.pcep.controller.PcepClient;
import org.onosproject.pcep.controller.PcepNodeListener;
import org.onosproject.provider.pcep.topology.impl.PcepClientControllerAdapter;
import org.onosproject.provider.pcep.topology.impl.PcepControllerAdapter;
import org.onosproject.provider.pcep.topology.impl.PcepTopologyProvider;

public class PcepTopologyProviderTest {
    private static final String UNKNOWN = new String("unknown");
    public static ProviderId providerId = new ProviderId("l3", "foo");
    private final PcepClientControllerAdapter clientController = new PcepClientControllerAdapter();
    private final PcepTopologyProvider provider = new PcepTopologyProvider();
    private final MockDeviceRegistry nodeRegistry = new MockDeviceRegistry();
    private final PcepControllerAdapter controller = new PcepControllerAdapter();
    private final MockLinkRegistry linkRegistry = new MockLinkRegistry();
    private final MockDeviceService deviceService = new MockDeviceService();
    private final MockNetConfigRegistryAdapter netConfigRegistry = new MockNetConfigRegistryAdapter();
    private Map<DeviceId, Device> deviceMap = new HashMap<DeviceId, Device>();

    @Before
    public void startUp() {
        this.provider.pcepClientController = this.clientController;
        this.provider.deviceProviderRegistry = this.nodeRegistry;
        this.provider.linkProviderRegistry = this.linkRegistry;
        this.provider.controller = this.controller;
        this.provider.deviceService = this.deviceService;
        this.provider.netConfigRegistry = this.netConfigRegistry;
        this.provider.netConfigService = this.netConfigRegistry;
        this.provider.activate();
    }

    @After
    public void tearDown() {
        this.provider.deactivate();
        this.provider.deviceProviderRegistry = null;
        this.provider.pcepClientController = null;
        this.provider.linkProviderRegistry = null;
        this.provider.controller = null;
        this.provider.deviceService = null;
        this.provider.netConfigRegistry = null;
        this.provider.netConfigService = null;
    }

    @Test
    public void testPcepTopologyProviderTestAddDevice1() {
        PcepClient pc = this.clientController.getClient(PccId.pccId((IpAddress)IpAddress.valueOf((String)"1.1.1.1")));
        for (PcepNodeListener l : this.clientController.pcepNodeListener) {
            pc.setCapability(new ClientCapability(true, true, false, true, true));
            l.addDevicePcepConfig(pc);
            DeviceId pccDeviceId = DeviceId.deviceId((String)String.valueOf(pc.getPccId().ipAddress()));
            DeviceCapability deviceCap = this.netConfigRegistry.getConfig(pccDeviceId, DeviceCapability.class);
            MatcherAssert.assertThat((Object)deviceCap.srCap(), (Matcher)Is.is((Object)true));
            MatcherAssert.assertThat((Object)deviceCap.labelStackCap(), (Matcher)Is.is((Object)true));
            MatcherAssert.assertThat((Object)deviceCap.localLabelCap(), (Matcher)Is.is((Object)true));
            l.deleteDevicePcepConfig(pc.getPccId());
            deviceCap = this.netConfigRegistry.getConfig(pccDeviceId, DeviceCapability.class);
            MatcherAssert.assertThat((Object)deviceCap, (Matcher)Is.is((Matcher)IsNull.nullValue()));
        }
    }

    @Test
    public void testPcepTopologyProviderTestAddDevice2() {
        PcepClient pc = this.clientController.getClient(PccId.pccId((IpAddress)IpAddress.valueOf((String)"1.1.1.1")));
        for (PcepNodeListener l : this.clientController.pcepNodeListener) {
            pc.setCapability(new ClientCapability(true, true, false, false, true));
            l.addDevicePcepConfig(pc);
            DeviceId pccDeviceId = DeviceId.deviceId((String)String.valueOf(pc.getPccId().ipAddress()));
            DeviceCapability deviceCap = this.netConfigRegistry.getConfig(pccDeviceId, DeviceCapability.class);
            MatcherAssert.assertThat((Object)deviceCap.srCap(), (Matcher)Is.is((Object)true));
            MatcherAssert.assertThat((Object)deviceCap.labelStackCap(), (Matcher)Is.is((Object)false));
            MatcherAssert.assertThat((Object)deviceCap.localLabelCap(), (Matcher)Is.is((Object)true));
            l.deleteDevicePcepConfig(pc.getPccId());
            deviceCap = this.netConfigRegistry.getConfig(pccDeviceId, DeviceCapability.class);
            MatcherAssert.assertThat((Object)deviceCap, (Matcher)Is.is((Matcher)IsNull.nullValue()));
        }
    }

    private class MockNetConfigRegistryAdapter
    extends NetworkConfigRegistryAdapter {
        private ConfigFactory cfgFactory;
        private Map<DeviceId, DeviceCapability> classConfig = new HashMap<DeviceId, DeviceCapability>();

        private MockNetConfigRegistryAdapter() {
        }

        public void registerConfigFactory(ConfigFactory configFactory) {
            this.cfgFactory = configFactory;
        }

        public void unregisterConfigFactory(ConfigFactory configFactory) {
            this.cfgFactory = null;
        }

        public <S, C extends Config<S>> C addConfig(S subject, Class<C> configClass) {
            if (configClass == DeviceCapability.class) {
                DeviceCapability devCap = new DeviceCapability();
                this.classConfig.put((DeviceId)subject, devCap);
                ObjectNode node = new ObjectNode((JsonNodeFactory)new MockJsonNode());
                ObjectMapper mapper = new ObjectMapper();
                InternalApplyDelegate delegate = new InternalApplyDelegate();
                devCap.init((Object)((DeviceId)subject), null, (JsonNode)node, mapper, (ConfigApplyDelegate)delegate);
                return (C)devCap;
            }
            return null;
        }

        public <S, C extends Config<S>> void removeConfig(S subject, Class<C> configClass) {
            this.classConfig.remove(subject);
        }

        public <S, C extends Config<S>> C getConfig(S subject, Class<C> configClass) {
            if (configClass == DeviceCapability.class) {
                return (C)((Config)this.classConfig.get(subject));
            }
            return null;
        }

        private class InternalApplyDelegate
        implements ConfigApplyDelegate {
            private InternalApplyDelegate() {
            }

            public void onApply(Config config) {
            }
        }

        private class MockJsonNode
        extends JsonNodeFactory {
            private MockJsonNode() {
            }
        }
    }

    private class MockDeviceService
    extends DeviceServiceAdapter {
        private MockDeviceService() {
        }

        public Device getDevice(DeviceId deviceId) {
            return (Device)PcepTopologyProviderTest.this.deviceMap.get(deviceId);
        }
    }

    private class MockDeviceRegistry
    implements DeviceProviderRegistry {
        DeviceProvider provider;
        Set<DeviceId> connected = new HashSet<DeviceId>();

        private MockDeviceRegistry() {
        }

        public DeviceProviderService register(DeviceProvider provider) {
            this.provider = provider;
            return new MockProviderService();
        }

        public void unregister(DeviceProvider provider) {
        }

        public Set<ProviderId> getProviders() {
            return null;
        }

        private class MockProviderService
        implements DeviceProviderService {
            private MockProviderService() {
            }

            public DeviceProvider provider() {
                return null;
            }

            public void deviceConnected(DeviceId deviceId, DeviceDescription deviceDescription) {
                MockDeviceRegistry.this.connected.add(deviceId);
                DefaultDevice device = new DefaultDevice(ProviderId.NONE, deviceId, Device.Type.ROUTER, UNKNOWN, UNKNOWN, UNKNOWN, UNKNOWN, new ChassisId(), new Annotations[]{deviceDescription.annotations()});
                PcepTopologyProviderTest.this.deviceMap.put(deviceId, device);
            }

            public void deviceDisconnected(DeviceId deviceId) {
                MockDeviceRegistry.this.connected.remove(deviceId);
                PcepTopologyProviderTest.this.deviceMap.remove(deviceId);
            }

            public void updatePorts(DeviceId deviceId, List<PortDescription> portDescriptions) {
            }

            public void portStatusChanged(DeviceId deviceId, PortDescription portDescription) {
            }

            public void receivedRoleReply(DeviceId deviceId, MastershipRole requested, MastershipRole response) {
            }

            public void updatePortStatistics(DeviceId deviceId, Collection<PortStatistics> portStatistics) {
            }
        }
    }

    private class MockLinkRegistry
    implements LinkProviderRegistry {
        LinkProvider linkProvider;
        Set<Link> links = new HashSet<Link>();

        private MockLinkRegistry() {
        }

        public LinkProviderService register(LinkProvider provider) {
            this.linkProvider = provider;
            return new MockProviderService();
        }

        public void unregister(LinkProvider provider) {
        }

        public Set<ProviderId> getProviders() {
            return null;
        }

        private class MockProviderService
        implements LinkProviderService {
            private MockProviderService() {
            }

            public void linkDetected(LinkDescription linkDescription) {
                MockLinkRegistry.this.links.add((Link)DefaultLink.builder().src(linkDescription.src()).dst(linkDescription.dst()).state(Link.State.ACTIVE).type(linkDescription.type()).providerId(ProviderId.NONE).build());
            }

            public void linkVanished(LinkDescription linkDescription) {
                MockLinkRegistry.this.links.remove(DefaultLink.builder().src(linkDescription.src()).dst(linkDescription.dst()).state(Link.State.ACTIVE).type(linkDescription.type()).providerId(ProviderId.NONE).build());
            }

            public void linksVanished(ConnectPoint connectPoint) {
            }

            public void linksVanished(DeviceId deviceId) {
            }

            public LinkProvider provider() {
                return null;
            }
        }
    }
}

