/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.provider.pcep.tunnel.impl;

import com.google.common.base.Preconditions;
import java.net.URI;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import org.apache.felix.scr.annotations.Activate;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Deactivate;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.ReferenceCardinality;
import org.apache.felix.scr.annotations.Service;
import org.onosproject.core.DefaultGroupId;
import org.onosproject.incubator.net.tunnel.DefaultOpticalTunnelEndPoint;
import org.onosproject.incubator.net.tunnel.DefaultTunnelDescription;
import org.onosproject.incubator.net.tunnel.OpticalLogicId;
import org.onosproject.incubator.net.tunnel.OpticalTunnelEndPoint;
import org.onosproject.incubator.net.tunnel.Tunnel;
import org.onosproject.incubator.net.tunnel.TunnelDescription;
import org.onosproject.incubator.net.tunnel.TunnelEndPoint;
import org.onosproject.incubator.net.tunnel.TunnelId;
import org.onosproject.incubator.net.tunnel.TunnelName;
import org.onosproject.incubator.net.tunnel.TunnelProvider;
import org.onosproject.incubator.net.tunnel.TunnelProviderRegistry;
import org.onosproject.incubator.net.tunnel.TunnelProviderService;
import org.onosproject.net.Annotations;
import org.onosproject.net.ConnectPoint;
import org.onosproject.net.DefaultAnnotations;
import org.onosproject.net.DefaultLink;
import org.onosproject.net.DefaultPath;
import org.onosproject.net.DeviceId;
import org.onosproject.net.ElementId;
import org.onosproject.net.Link;
import org.onosproject.net.Path;
import org.onosproject.net.PortNumber;
import org.onosproject.net.SparseAnnotations;
import org.onosproject.net.provider.AbstractProvider;
import org.onosproject.net.provider.Provider;
import org.onosproject.net.provider.ProviderId;
import org.onosproject.pcep.api.PcepController;
import org.onosproject.pcep.api.PcepDpid;
import org.onosproject.pcep.api.PcepHopNodeDescription;
import org.onosproject.pcep.api.PcepOperator;
import org.onosproject.pcep.api.PcepTunnel;
import org.onosproject.pcep.api.PcepTunnelListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(immediate=true)
@Service
public class PcepTunnelProvider
extends AbstractProvider
implements TunnelProvider {
    private static final Logger log = LoggerFactory.getLogger(PcepTunnelProvider.class);
    private static final long MAX_BANDWIDTH = 99999744L;
    private static final long MIN_BANDWIDTH = 64L;
    private static final String BANDWIDTH_UINT = "kbps";
    static final String PROVIDER_ID = "org.onosproject.provider.tunnel.default";
    private static final String TUNNLE_NOT_NULL = "Create failed,The given port may be wrong or has been occupied.";
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    protected TunnelProviderRegistry tunnelProviderRegistry;
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    protected PcepController controller;
    TunnelProviderService service;
    HashMap<String, TunnelId> tunnelMap = new HashMap();
    private InnerTunnerProvider listener = new InnerTunnerProvider();

    public PcepTunnelProvider() {
        super(new ProviderId("default", PROVIDER_ID));
    }

    @Activate
    public void activate() {
        this.service = (TunnelProviderService)this.tunnelProviderRegistry.register((Provider)this);
        this.controller.addTunnelListener((PcepTunnelListener)this.listener);
        log.info("Started");
    }

    @Deactivate
    public void deactivate() {
        this.tunnelProviderRegistry.unregister((Provider)this);
        this.controller.removeTunnelListener((PcepTunnelListener)this.listener);
        log.info("Stopped");
    }

    public void setupTunnel(Tunnel tunnel, Path path) {
    }

    public void setupTunnel(ElementId srcElement, Tunnel tunnel, Path path) {
    }

    public void releaseTunnel(Tunnel tunnel) {
    }

    public void releaseTunnel(ElementId srcElement, Tunnel tunnel) {
    }

    public void updateTunnel(Tunnel tunnel, Path path) {
    }

    public void updateTunnel(ElementId srcElement, Tunnel tunnel, Path path) {
    }

    public TunnelId tunnelAdded(TunnelDescription tunnel) {
        long bandwidth = Long.parseLong(tunnel.annotations().value("bandwidth"));
        if (bandwidth < 64L || bandwidth > 99999744L) {
            this.error("Update failed, invalid bandwidth.");
            return null;
        }
        OpticalTunnelEndPoint src = (OpticalTunnelEndPoint)tunnel.src();
        OpticalTunnelEndPoint dst = (OpticalTunnelEndPoint)tunnel.dst();
        DeviceId srcId = (DeviceId)src.elementId().get();
        DeviceId dstId = (DeviceId)dst.elementId().get();
        long srcPort = ((PortNumber)src.portNumber().get()).toLong();
        long dstPort = ((PortNumber)dst.portNumber().get()).toLong();
        if (tunnel.type() != Tunnel.Type.VLAN) {
            this.error("Illegal tunnel type. Only support VLAN tunnel creation.");
            return null;
        }
        PcepTunnel pcepTunnel = this.controller.applyTunnel(srcId, dstId, srcPort, dstPort, bandwidth, tunnel.tunnelName().value());
        Preconditions.checkNotNull((Object)pcepTunnel, (Object)TUNNLE_NOT_NULL);
        TunnelDescription tunnelAdded = this.buildOpticalTunnel(pcepTunnel, null);
        TunnelId tunnelId = this.service.tunnelAdded(tunnelAdded);
        this.tunnelMap.put(String.valueOf(pcepTunnel.id()), tunnelId);
        return tunnelId;
    }

    public void tunnelRemoved(TunnelDescription tunnel) {
        Tunnel tunnelOld = this.tunnelQueryById(tunnel.id());
        Preconditions.checkNotNull((Object)tunnelOld, (Object)"The tunnel id is not exsited.");
        if (tunnelOld.type() != Tunnel.Type.VLAN) {
            this.error("Illegal tunnel type. Only support VLAN tunnel deletion.");
            return;
        }
        String pcepTunnelId = this.getPCEPTunnelKey(tunnel.id());
        Preconditions.checkNotNull((Object)pcepTunnelId, (Object)"The tunnel id is not exsited.");
        if (!this.controller.deleteTunnel(pcepTunnelId).booleanValue()) {
            this.error("Delete tunnel failed, Maybe some devices have been disconnected.");
            return;
        }
        this.tunnelMap.remove(pcepTunnelId);
        this.service.tunnelRemoved(tunnel);
    }

    public void tunnelUpdated(TunnelDescription tunnel) {
        Tunnel tunnelOld = this.tunnelQueryById(tunnel.id());
        if (tunnelOld.type() != Tunnel.Type.VLAN) {
            this.error("Illegal tunnel type. Only support VLAN tunnel update.");
            return;
        }
        long bandwidth = Long.parseLong(tunnel.annotations().value("bandwidth"));
        if (bandwidth < 64L || bandwidth > 99999744L) {
            this.error("Update failed, invalid bandwidth.");
            return;
        }
        String pcepTunnelId = this.getPCEPTunnelKey(tunnel.id());
        Preconditions.checkNotNull((Object)pcepTunnelId, (Object)"Invalid tunnel id");
        if (!this.controller.updateTunnelBandwidth(pcepTunnelId, bandwidth).booleanValue()) {
            this.error("Update failed,maybe invalid bandwidth.");
            return;
        }
        this.service.tunnelUpdated(tunnel);
    }

    private void error(String info) {
        System.err.println(info);
    }

    private ConnectPoint connectPoint(PcepDpid id, long port) {
        return new ConnectPoint((ElementId)DeviceId.deviceId((URI)PcepDpid.uri((PcepDpid)id)), PortNumber.portNumber((long)port));
    }

    private Link link(PcepDpid src, long sp, PcepDpid dst, long dp) {
        return new DefaultLink(this.id(), this.connectPoint(src, sp), this.connectPoint(dst, dp), Link.Type.TUNNEL, new Annotations[0]);
    }

    private Path createPath(List<PcepHopNodeDescription> hopList, PcepTunnel.PATHTYPE pathtype, PcepTunnel.PathState pathState) {
        if (hopList == null || hopList.size() == 0) {
            return null;
        }
        ArrayList<Link> links = new ArrayList<Link>();
        for (int i = 1; i < hopList.size() - 1; i += 2) {
            links.add(this.link(hopList.get(i).getDeviceId(), hopList.get(i).getPortNum(), hopList.get(i + 1).getDeviceId(), hopList.get(i + 1).getPortNum()));
        }
        int hopNum = hopList.size() - 2;
        DefaultAnnotations extendAnnotations = DefaultAnnotations.builder().set("pathNum", String.valueOf(hopNum)).set("pathState", String.valueOf(pathState)).set("pathType", String.valueOf(pathtype)).build();
        return new DefaultPath(this.id(), links, (double)hopNum, new Annotations[]{extendAnnotations});
    }

    public String pathToString(List<Link> links) {
        StringBuilder builder = new StringBuilder();
        builder.append("{");
        for (Link link : links) {
            builder.append("(Device:" + link.src().deviceId() + "  Port:" + link.src().port().toLong());
            builder.append(" Device:" + link.dst().deviceId() + "  Port:" + link.dst().port().toLong());
            builder.append(")");
        }
        builder.append("}");
        return builder.toString();
    }

    private TunnelDescription buildOpticalTunnel(PcepTunnel pcepTunnel, TunnelId tunnelId) {
        DefaultOpticalTunnelEndPoint srcPoint = null;
        DefaultOpticalTunnelEndPoint dstPoint = null;
        Tunnel.Type tunnelType = null;
        TunnelName name = TunnelName.tunnelName((String)pcepTunnel.name());
        Path path = this.createPath(pcepTunnel.getHopList(), pcepTunnel.getPathType(), pcepTunnel.getPathState());
        OpticalTunnelEndPoint.Type endPointType = null;
        switch (pcepTunnel.type()) {
            case OCH: {
                tunnelType = Tunnel.Type.OCH;
                endPointType = OpticalTunnelEndPoint.Type.LAMBDA;
                break;
            }
            case OTN: {
                tunnelType = Tunnel.Type.ODUK;
                endPointType = OpticalTunnelEndPoint.Type.TIMESLOT;
                break;
            }
            case UNI: {
                tunnelType = Tunnel.Type.VLAN;
                endPointType = null;
                break;
            }
        }
        DeviceId srcDid = DeviceId.deviceId((URI)PcepDpid.uri((PcepDpid)pcepTunnel.srcDeviceID()));
        DeviceId dstDid = DeviceId.deviceId((URI)PcepDpid.uri((PcepDpid)pcepTunnel.dstDeviceId()));
        PortNumber srcPort = PortNumber.portNumber((long)pcepTunnel.srcPort());
        PortNumber dstPort = PortNumber.portNumber((long)pcepTunnel.dstPort());
        srcPoint = new DefaultOpticalTunnelEndPoint(this.id(), Optional.of(srcDid), Optional.of(srcPort), null, endPointType, OpticalLogicId.logicId((long)0L), true, new Annotations[0]);
        dstPoint = new DefaultOpticalTunnelEndPoint(this.id(), Optional.of(dstDid), Optional.of(dstPort), null, endPointType, OpticalLogicId.logicId((long)0L), true, new Annotations[0]);
        DefaultAnnotations annotations = DefaultAnnotations.builder().set("SLA", String.valueOf(pcepTunnel.getSla())).set("bandwidth", String.valueOf(pcepTunnel.bandWidth()) + BANDWIDTH_UINT).set("index", String.valueOf(pcepTunnel.id())).build();
        if (pcepTunnel.underlayTunnelId() != 0L) {
            DefaultAnnotations extendAnnotations = DefaultAnnotations.builder().set("underLayTunnelIndex", String.valueOf(pcepTunnel.underlayTunnelId())).build();
            annotations = DefaultAnnotations.merge((DefaultAnnotations)annotations, (SparseAnnotations)extendAnnotations);
        }
        DefaultTunnelDescription tunnel = new DefaultTunnelDescription(tunnelId, (TunnelEndPoint)srcPoint, (TunnelEndPoint)dstPoint, tunnelType, new DefaultGroupId(0), this.id(), name, path, new SparseAnnotations[]{annotations});
        return tunnel;
    }

    private TunnelId getTunnelId(String tunnelKey) {
        for (String key : this.tunnelMap.keySet()) {
            if (!key.equals(tunnelKey)) continue;
            return this.tunnelMap.get(key);
        }
        return null;
    }

    private String getPCEPTunnelKey(TunnelId tunnelId) {
        for (String key : this.tunnelMap.keySet()) {
            if (this.tunnelMap.get(key).id() != tunnelId.id()) continue;
            return key;
        }
        return null;
    }

    public Tunnel tunnelQueryById(TunnelId tunnelId) {
        return this.service.tunnelQueryById(tunnelId);
    }

    protected void bindTunnelProviderRegistry(TunnelProviderRegistry tunnelProviderRegistry) {
        this.tunnelProviderRegistry = tunnelProviderRegistry;
    }

    protected void unbindTunnelProviderRegistry(TunnelProviderRegistry tunnelProviderRegistry) {
        if (this.tunnelProviderRegistry == tunnelProviderRegistry) {
            this.tunnelProviderRegistry = null;
        }
    }

    protected void bindController(PcepController pcepController) {
        this.controller = pcepController;
    }

    protected void unbindController(PcepController pcepController) {
        if (this.controller == pcepController) {
            this.controller = null;
        }
    }

    private class InnerTunnerProvider
    implements PcepTunnelListener {
        private InnerTunnerProvider() {
        }

        public void handlePCEPTunnel(PcepTunnel pcepTunnel) {
            TunnelDescription tunnel = null;
            String tunnelKey = String.valueOf(pcepTunnel.getInstance()) + String.valueOf(pcepTunnel.id());
            if (tunnelKey == null || "".equals(tunnelKey)) {
                log.error("Invalid PCEP tunnel");
                return;
            }
            TunnelId tunnelId = PcepTunnelProvider.this.getTunnelId(tunnelKey);
            tunnel = PcepTunnelProvider.this.buildOpticalTunnel(pcepTunnel, tunnelId);
            PcepOperator.OperationType operType = pcepTunnel.getOperationType();
            switch (operType) {
                case ADD: {
                    tunnelId = PcepTunnelProvider.this.service.tunnelAdded(tunnel);
                    PcepTunnelProvider.this.tunnelMap.put(tunnelKey, tunnelId);
                    break;
                }
                case UPDATE: {
                    PcepTunnelProvider.this.service.tunnelUpdated(tunnel);
                    break;
                }
                case DELETE: {
                    PcepTunnelProvider.this.service.tunnelRemoved(tunnel);
                    PcepTunnelProvider.this.tunnelMap.remove(tunnelKey);
                    break;
                }
                default: {
                    log.error("Invalid tunnel operation");
                }
            }
        }
    }
}

