/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.provider.pcep.tunnel.impl;

import java.util.HashMap;
import java.util.Map;
import org.apache.commons.collections.map.MultiKeyMap;
import org.onosproject.incubator.net.tunnel.TunnelId;
import org.onosproject.incubator.net.tunnel.TunnelProviderService;
import org.onosproject.provider.pcep.tunnel.impl.PcepTunnelData;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PcepTunnelApiMapper {
    protected static final Logger log = LoggerFactory.getLogger(PcepTunnelApiMapper.class);
    static final String PROVIDER_ID = "org.onosproject.provider.tunnel.pcep";
    private Map<Integer, PcepTunnelData> tunnelRequestQueue;
    private Map<TunnelId, PcepTunnelData> coreTunnelRequestQueue;
    private Map<Integer, PcepTunnelData> tunnelDB;
    private Map<TunnelId, Integer> tunnelIdMap;
    private MultiKeyMap pccTunnelDB = new MultiKeyMap();
    TunnelProviderService tunnelApiMapperservice;

    public PcepTunnelApiMapper() {
        this.tunnelRequestQueue = new HashMap<Integer, PcepTunnelData>();
        this.coreTunnelRequestQueue = new HashMap<TunnelId, PcepTunnelData>();
        this.tunnelDB = new HashMap<Integer, PcepTunnelData>();
        this.tunnelIdMap = new HashMap<TunnelId, Integer>();
    }

    public void addToTunnelRequestQueue(int srpId, PcepTunnelData pcepTunnelData) {
        this.tunnelRequestQueue.put(new Integer(srpId), pcepTunnelData);
        log.debug("Tunnel Added to TunnelRequestQueue");
    }

    public void addToTunnelIdMap(PcepTunnelData pcepTunnelData) {
        int value = pcepTunnelData.statefulIpv4IndentifierTlv().getTunnelId() & 0xFFFF;
        this.tunnelIdMap.put(pcepTunnelData.tunnel().tunnelId(), new Integer(value));
        log.debug("Tunnel ID Added to tunnelIdMap");
    }

    public void addToCoreTunnelRequestQueue(PcepTunnelData pcepTunnelData) {
        this.coreTunnelRequestQueue.put(pcepTunnelData.tunnel().tunnelId(), pcepTunnelData);
        log.debug("Tunnel Added to CoreTunnelRequestQueue");
    }

    public void removeFromCoreTunnelRequestQueue(TunnelId tunnelId) {
        this.coreTunnelRequestQueue.remove(tunnelId);
        log.debug("Tunnnel create response sent to core and removed from CoreTunnelRequestQueue");
    }

    public void handleCreateTunnelRequestQueue(int srpId, PcepTunnelData pcepTunnelData) {
        int value = this.tunnelIdMap.get(pcepTunnelData.tunnel().tunnelId());
        this.tunnelDB.put(new Integer(value), pcepTunnelData);
        this.tunnelRequestQueue.remove(new Integer(srpId), pcepTunnelData);
        log.debug("Tunnel Added to TunnelDBQueue and removed from TunnelRequestQueue. tunnel id {}" + new Integer(value).toString());
    }

    public void handleUpdateTunnelRequestQueue(int srpId, PcepTunnelData pcepTunnelData) {
        if (pcepTunnelData.rptFlag()) {
            pcepTunnelData.setRptFlag(false);
            int value = this.tunnelIdMap.get(pcepTunnelData.tunnel().tunnelId());
            this.tunnelDB.put(new Integer(value), pcepTunnelData);
            this.tunnelRequestQueue.remove(new Integer(srpId), pcepTunnelData);
            log.debug("Tunnel Added to TunnelDBQueue and removed from TunnelRequestQueue. tunnel id {}", (Object)new Integer(value).toString());
        } else {
            pcepTunnelData.setRptFlag(true);
            this.tunnelRequestQueue.put(new Integer(srpId), pcepTunnelData);
            log.debug("Tunnel updated in TunnelRequestQueue");
        }
    }

    public void handleRemoveFromTunnelRequestQueue(int srpId, PcepTunnelData pcepTunnelData) {
        int value = this.tunnelIdMap.get(pcepTunnelData.tunnel().tunnelId());
        this.tunnelIdMap.remove(pcepTunnelData.tunnel().tunnelId());
        this.tunnelDB.remove(new Integer(value));
        this.tunnelRequestQueue.remove(srpId);
        log.debug("Tunnel removed from  TunnelDBQueue and TunnelRequestQueue");
    }

    public PcepTunnelData getDataFromTunnelRequestQueue(int srpId) {
        return this.tunnelRequestQueue.get(new Integer(srpId));
    }

    public PcepTunnelData getDataFromTunnelDBQueue(TunnelId tunnelId) {
        int value = this.tunnelIdMap.get(tunnelId);
        return this.tunnelDB.get(new Integer(value));
    }

    public boolean checkFromTunnelRequestQueue(int srpId) {
        boolean retValue = this.tunnelRequestQueue.containsKey(srpId);
        return retValue;
    }

    public boolean checkFromTunnelDBQueue(TunnelId tunnelId) {
        int value = this.tunnelIdMap.get(tunnelId);
        boolean retValue = this.tunnelDB.containsKey(new Integer(value));
        return retValue;
    }

    public void addPccTunnelDB(PcepTunnelData pcepTunnelData) {
        this.pccTunnelDB.put((Object)((long)pcepTunnelData.statefulIpv4IndentifierTlv().getTunnelId() & 0xFFFFL), (Object)pcepTunnelData.statefulIpv4IndentifierTlv().getIpv4IngressAddress(), (Object)pcepTunnelData);
    }
}

