/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.provider.pcep.tunnel.impl;

import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.collect.Maps;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Dictionary;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Optional;
import org.apache.felix.scr.annotations.Activate;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Deactivate;
import org.apache.felix.scr.annotations.Property;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.ReferenceCardinality;
import org.apache.felix.scr.annotations.Service;
import org.onlab.packet.IpAddress;
import org.onlab.util.Tools;
import org.onosproject.cfg.ComponentConfigService;
import org.onosproject.core.DefaultGroupId;
import org.onosproject.incubator.net.tunnel.DefaultOpticalTunnelEndPoint;
import org.onosproject.incubator.net.tunnel.DefaultTunnel;
import org.onosproject.incubator.net.tunnel.DefaultTunnelDescription;
import org.onosproject.incubator.net.tunnel.DefaultTunnelStatistics;
import org.onosproject.incubator.net.tunnel.IpTunnelEndPoint;
import org.onosproject.incubator.net.tunnel.OpticalLogicId;
import org.onosproject.incubator.net.tunnel.OpticalTunnelEndPoint;
import org.onosproject.incubator.net.tunnel.Tunnel;
import org.onosproject.incubator.net.tunnel.TunnelDescription;
import org.onosproject.incubator.net.tunnel.TunnelEndPoint;
import org.onosproject.incubator.net.tunnel.TunnelId;
import org.onosproject.incubator.net.tunnel.TunnelName;
import org.onosproject.incubator.net.tunnel.TunnelProvider;
import org.onosproject.incubator.net.tunnel.TunnelProviderRegistry;
import org.onosproject.incubator.net.tunnel.TunnelProviderService;
import org.onosproject.incubator.net.tunnel.TunnelService;
import org.onosproject.incubator.net.tunnel.TunnelStatistics;
import org.onosproject.net.Annotations;
import org.onosproject.net.ConnectPoint;
import org.onosproject.net.DefaultAnnotations;
import org.onosproject.net.DefaultLink;
import org.onosproject.net.DefaultPath;
import org.onosproject.net.DeviceId;
import org.onosproject.net.ElementId;
import org.onosproject.net.IpElementId;
import org.onosproject.net.Link;
import org.onosproject.net.Path;
import org.onosproject.net.PortNumber;
import org.onosproject.net.SparseAnnotations;
import org.onosproject.net.provider.AbstractProvider;
import org.onosproject.net.provider.Provider;
import org.onosproject.net.provider.ProviderId;
import org.onosproject.pcep.api.PcepController;
import org.onosproject.pcep.api.PcepDpid;
import org.onosproject.pcep.api.PcepHopNodeDescription;
import org.onosproject.pcep.api.PcepOperator;
import org.onosproject.pcep.api.PcepTunnel;
import org.onosproject.pcep.api.PcepTunnelListener;
import org.onosproject.pcep.api.PcepTunnelStatistics;
import org.onosproject.pcep.controller.PccId;
import org.onosproject.pcep.controller.PcepClient;
import org.onosproject.pcep.controller.PcepClientController;
import org.onosproject.pcep.controller.PcepClientListener;
import org.onosproject.pcep.controller.PcepEventListener;
import org.onosproject.pcepio.exceptions.PcepParseException;
import org.onosproject.pcepio.protocol.PcInitiatedLspRequest;
import org.onosproject.pcepio.protocol.PcepAttribute;
import org.onosproject.pcepio.protocol.PcepBandwidthObject;
import org.onosproject.pcepio.protocol.PcepEndPointsObject;
import org.onosproject.pcepio.protocol.PcepEroObject;
import org.onosproject.pcepio.protocol.PcepInitiateMsg;
import org.onosproject.pcepio.protocol.PcepLspObject;
import org.onosproject.pcepio.protocol.PcepMessage;
import org.onosproject.pcepio.protocol.PcepMsgPath;
import org.onosproject.pcepio.protocol.PcepReportMsg;
import org.onosproject.pcepio.protocol.PcepRroObject;
import org.onosproject.pcepio.protocol.PcepSrpObject;
import org.onosproject.pcepio.protocol.PcepStateReport;
import org.onosproject.pcepio.protocol.PcepUpdateMsg;
import org.onosproject.pcepio.protocol.PcepUpdateRequest;
import org.onosproject.pcepio.types.IPv4SubObject;
import org.onosproject.pcepio.types.PcepValueType;
import org.onosproject.pcepio.types.StatefulIPv4LspIdentidiersTlv;
import org.onosproject.pcepio.types.SymbolicPathNameTlv;
import org.onosproject.provider.pcep.tunnel.impl.PcepTunnelApiMapper;
import org.onosproject.provider.pcep.tunnel.impl.PcepTunnelData;
import org.onosproject.provider.pcep.tunnel.impl.RequestType;
import org.onosproject.provider.pcep.tunnel.impl.SrpIdGenerators;
import org.onosproject.provider.pcep.tunnel.impl.TunnelStatsCollector;
import org.osgi.service.component.ComponentContext;
import org.osgi.service.component.annotations.Modified;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(immediate=true)
@Service
public class PcepTunnelProvider
extends AbstractProvider
implements TunnelProvider {
    private static final Logger log = LoggerFactory.getLogger(PcepTunnelProvider.class);
    private static final long MAX_BANDWIDTH = 99999744L;
    private static final long MIN_BANDWIDTH = 64L;
    private static final String BANDWIDTH_UINT = "kbps";
    static final String PROVIDER_ID = "org.onosproject.provider.tunnel.pcep";
    static final int POLL_INTERVAL = 10;
    @Property(name="tunnelStatsPollFrequency", intValue={10}, label="Frequency (in seconds) for polling tunnel statistics")
    private int tunnelStatsPollFrequency = 10;
    private static final String TUNNLE_NOT_NULL = "Create failed,The given port may be wrong or has been occupied.";
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    protected TunnelProviderRegistry tunnelProviderRegistry;
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    protected PcepController controller;
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    protected PcepClientController pcepClientController;
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    protected TunnelService tunnelService;
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    protected ComponentConfigService cfgService;
    TunnelProviderService service;
    HashMap<String, TunnelId> tunnelMap = new HashMap();
    HashMap<TunnelId, TunnelStatistics> tunnelStatisticsMap = new HashMap();
    private HashMap<Long, TunnelStatsCollector> collectors = Maps.newHashMap();
    private InnerTunnelProvider listener = new InnerTunnelProvider();
    protected PcepTunnelApiMapper pcepTunnelAPIMapper = new PcepTunnelApiMapper();
    private static final int DEFAULT_BANDWIDTH_VALUE = 10;

    public PcepTunnelProvider() {
        super(new ProviderId("pcep", PROVIDER_ID));
    }

    @Activate
    public void activate() {
        this.cfgService.registerProperties(((Object)((Object)this)).getClass());
        this.service = (TunnelProviderService)this.tunnelProviderRegistry.register((Provider)this);
        this.controller.addTunnelListener((PcepTunnelListener)this.listener);
        this.pcepClientController.addListener((PcepClientListener)this.listener);
        this.pcepClientController.addEventListener((PcepEventListener)this.listener);
        this.tunnelService.queryAllTunnels().forEach(tunnel -> {
            String pcepTunnelId = this.getPCEPTunnelKey(tunnel.tunnelId());
            TunnelStatsCollector tsc = new TunnelStatsCollector(pcepTunnelId, this.tunnelStatsPollFrequency);
            tsc.start();
            this.collectors.put(tunnel.tunnelId().id(), tsc);
        });
        log.info("Started");
    }

    @Deactivate
    public void deactivate() {
        this.tunnelProviderRegistry.unregister((Provider)this);
        this.controller.removeTunnelListener((PcepTunnelListener)this.listener);
        this.collectors.values().forEach(TunnelStatsCollector::stop);
        this.pcepClientController.removeListener((PcepClientListener)this.listener);
        log.info("Stopped");
    }

    @Modified
    public void modified(ComponentContext context) {
        int newTunnelStatsPollFrequency;
        Dictionary properties = context.getProperties();
        try {
            String s = Tools.get((Dictionary)properties, (String)"tunnelStatsPollFrequency");
            newTunnelStatsPollFrequency = Strings.isNullOrEmpty((String)s) ? this.tunnelStatsPollFrequency : Integer.parseInt(s.trim());
        }
        catch (ClassCastException | NumberFormatException e) {
            newTunnelStatsPollFrequency = this.tunnelStatsPollFrequency;
        }
        if (newTunnelStatsPollFrequency != this.tunnelStatsPollFrequency) {
            this.tunnelStatsPollFrequency = newTunnelStatsPollFrequency;
            this.collectors.values().forEach(tsc -> tsc.adjustPollInterval(this.tunnelStatsPollFrequency));
            log.info("New setting: tunnelStatsPollFrequency={}", (Object)this.tunnelStatsPollFrequency);
        }
    }

    public void setupTunnel(Tunnel tunnel, Path path) {
        if (tunnel.type() != Tunnel.Type.MPLS) {
            log.error("Tunnel Type MPLS is only supported");
            return;
        }
        if (!(tunnel.src() instanceof IpTunnelEndPoint) || !(tunnel.dst() instanceof IpTunnelEndPoint)) {
            log.error("Tunnel source or destination is not valid");
            return;
        }
        PcepClient pc = this.pcepClientController.getClient(PccId.pccId((IpAddress)((IpTunnelEndPoint)tunnel.src()).ip()));
        if (!(pc instanceof PcepClient)) {
            log.error("There is no PCC connected with ip addresss {}" + ((IpTunnelEndPoint)tunnel.src()).ip().toString());
            return;
        }
        this.pcepSetupTunnel(tunnel, path, pc);
    }

    public void setupTunnel(ElementId srcElement, Tunnel tunnel, Path path) {
        if (tunnel.type() != Tunnel.Type.MPLS) {
            log.error("Tunnel Type MPLS is only supported");
            return;
        }
        if (!(srcElement instanceof IpElementId)) {
            log.error("Element id is not valid");
            return;
        }
        if (!(tunnel.src() instanceof IpTunnelEndPoint) || !(tunnel.dst() instanceof IpTunnelEndPoint)) {
            log.error("Tunnel source or destination is not valid");
            return;
        }
        PcepClient pc = this.pcepClientController.getClient(PccId.pccId((IpAddress)((IpElementId)srcElement).ipAddress()));
        if (!(pc instanceof PcepClient)) {
            log.error("There is no PCC connected with ip addresss {}" + ((IpElementId)srcElement).ipAddress().toString());
            return;
        }
        this.pcepSetupTunnel(tunnel, path, pc);
    }

    public void releaseTunnel(Tunnel tunnel) {
        if (tunnel.type() != Tunnel.Type.MPLS) {
            log.error("Tunnel Type MPLS is only supported");
            return;
        }
        if (!(tunnel.src() instanceof IpTunnelEndPoint) || !(tunnel.dst() instanceof IpTunnelEndPoint)) {
            log.error("Tunnel source or destination is not valid");
            return;
        }
        PcepClient pc = this.pcepClientController.getClient(PccId.pccId((IpAddress)((IpTunnelEndPoint)tunnel.src()).ip()));
        if (!(pc instanceof PcepClient)) {
            log.error("There is no PCC connected with ip addresss {}" + ((IpTunnelEndPoint)tunnel.src()).ip().toString());
            return;
        }
        this.pcepReleaseTunnel(tunnel, pc);
    }

    public void releaseTunnel(ElementId srcElement, Tunnel tunnel) {
        if (tunnel.type() != Tunnel.Type.MPLS) {
            log.error("Tunnel Type MPLS is only supported");
            return;
        }
        if (!(srcElement instanceof IpElementId)) {
            log.error("Element id is not valid");
            return;
        }
        if (!(tunnel.src() instanceof IpTunnelEndPoint) || !(tunnel.dst() instanceof IpTunnelEndPoint)) {
            log.error("Tunnel source or destination is not valid");
            return;
        }
        PcepClient pc = this.pcepClientController.getClient(PccId.pccId((IpAddress)((IpElementId)srcElement).ipAddress()));
        if (!(pc instanceof PcepClient)) {
            log.error("There is no PCC connected with ip addresss {}" + ((IpElementId)srcElement).ipAddress().toString());
            return;
        }
        this.pcepReleaseTunnel(tunnel, pc);
    }

    public void updateTunnel(Tunnel tunnel, Path path) {
        if (tunnel.type() != Tunnel.Type.MPLS) {
            log.error("Tunnel Type MPLS is only supported");
            return;
        }
        if (!(tunnel.src() instanceof IpTunnelEndPoint) || !(tunnel.dst() instanceof IpTunnelEndPoint)) {
            log.error("Tunnel source or destination is not valid");
            return;
        }
        PcepClient pc = this.pcepClientController.getClient(PccId.pccId((IpAddress)((IpTunnelEndPoint)tunnel.src()).ip()));
        if (!(pc instanceof PcepClient)) {
            log.error("There is no PCC connected with ip addresss {}" + ((IpTunnelEndPoint)tunnel.src()).ip().toString());
            return;
        }
        this.pcepUpdateTunnel(tunnel, path, pc);
    }

    public void updateTunnel(ElementId srcElement, Tunnel tunnel, Path path) {
        if (tunnel.type() != Tunnel.Type.MPLS) {
            log.error("Tunnel Type MPLS is only supported");
            return;
        }
        if (!(srcElement instanceof IpElementId)) {
            log.error("Element id is not valid");
            return;
        }
        if (!(tunnel.src() instanceof IpTunnelEndPoint) || !(tunnel.dst() instanceof IpTunnelEndPoint)) {
            log.error("Tunnel source or destination is not valid");
            return;
        }
        PcepClient pc = this.pcepClientController.getClient(PccId.pccId((IpAddress)((IpElementId)srcElement).ipAddress()));
        if (!(pc instanceof PcepClient)) {
            log.error("There is no PCC connected with ip addresss {}" + ((IpElementId)srcElement).ipAddress().toString());
            return;
        }
        this.pcepUpdateTunnel(tunnel, path, pc);
    }

    public TunnelId tunnelAdded(TunnelDescription tunnel) {
        if (tunnel.type() == Tunnel.Type.MPLS) {
            this.pcepTunnelAPIMapper.removeFromCoreTunnelRequestQueue(tunnel.id());
            return this.service.tunnelAdded(tunnel);
        }
        long bandwidth = Long.parseLong(tunnel.annotations().value("bandwidth"));
        if (bandwidth < 64L || bandwidth > 99999744L) {
            this.error("Update failed, invalid bandwidth.");
            return null;
        }
        OpticalTunnelEndPoint src = (OpticalTunnelEndPoint)tunnel.src();
        OpticalTunnelEndPoint dst = (OpticalTunnelEndPoint)tunnel.dst();
        DeviceId srcId = (DeviceId)src.elementId().get();
        DeviceId dstId = (DeviceId)dst.elementId().get();
        long srcPort = ((PortNumber)src.portNumber().get()).toLong();
        long dstPort = ((PortNumber)dst.portNumber().get()).toLong();
        if (tunnel.type() != Tunnel.Type.VLAN) {
            this.error("Illegal tunnel type. Only support VLAN tunnel creation.");
            return null;
        }
        PcepTunnel pcepTunnel = this.controller.applyTunnel(srcId, dstId, srcPort, dstPort, bandwidth, tunnel.tunnelName().value());
        Preconditions.checkNotNull((Object)pcepTunnel, (Object)TUNNLE_NOT_NULL);
        TunnelDescription tunnelAdded = this.buildOpticalTunnel(pcepTunnel, null);
        TunnelId tunnelId = this.service.tunnelAdded(tunnelAdded);
        this.tunnelMap.put(String.valueOf(pcepTunnel.id()), tunnelId);
        return tunnelId;
    }

    public void tunnelRemoved(TunnelDescription tunnel) {
        if (tunnel.type() == Tunnel.Type.MPLS) {
            this.pcepTunnelAPIMapper.removeFromCoreTunnelRequestQueue(tunnel.id());
            this.service.tunnelRemoved(tunnel);
        }
        Tunnel tunnelOld = this.tunnelQueryById(tunnel.id());
        Preconditions.checkNotNull((Object)tunnelOld, (Object)"The tunnel id is not exsited.");
        if (tunnelOld.type() != Tunnel.Type.VLAN) {
            this.error("Illegal tunnel type. Only support VLAN tunnel deletion.");
            return;
        }
        String pcepTunnelId = this.getPCEPTunnelKey(tunnel.id());
        Preconditions.checkNotNull((Object)pcepTunnelId, (Object)"The tunnel id is not exsited.");
        if (!this.controller.deleteTunnel(pcepTunnelId).booleanValue()) {
            this.error("Delete tunnel failed, Maybe some devices have been disconnected.");
            return;
        }
        this.tunnelMap.remove(pcepTunnelId);
        this.service.tunnelRemoved(tunnel);
    }

    public void tunnelUpdated(TunnelDescription tunnel) {
        Tunnel tunnelOld;
        if (tunnel.type() == Tunnel.Type.MPLS) {
            this.pcepTunnelAPIMapper.removeFromCoreTunnelRequestQueue(tunnel.id());
            this.service.tunnelUpdated(tunnel);
        }
        if ((tunnelOld = this.tunnelQueryById(tunnel.id())).type() != Tunnel.Type.VLAN) {
            this.error("Illegal tunnel type. Only support VLAN tunnel update.");
            return;
        }
        long bandwidth = Long.parseLong(tunnel.annotations().value("bandwidth"));
        if (bandwidth < 64L || bandwidth > 99999744L) {
            this.error("Update failed, invalid bandwidth.");
            return;
        }
        String pcepTunnelId = this.getPCEPTunnelKey(tunnel.id());
        Preconditions.checkNotNull((Object)pcepTunnelId, (Object)"Invalid tunnel id");
        if (!this.controller.updateTunnelBandwidth(pcepTunnelId, bandwidth).booleanValue()) {
            this.error("Update failed,maybe invalid bandwidth.");
            return;
        }
        this.service.tunnelUpdated(tunnel);
    }

    private void error(String info) {
        System.err.println(info);
    }

    private ConnectPoint connectPoint(PcepDpid id, long port) {
        return new ConnectPoint((ElementId)DeviceId.deviceId((URI)PcepDpid.uri((PcepDpid)id)), PortNumber.portNumber((long)port));
    }

    private Link link(PcepDpid src, long sp, PcepDpid dst, long dp) {
        return new DefaultLink(this.id(), this.connectPoint(src, sp), this.connectPoint(dst, dp), Link.Type.TUNNEL, new Annotations[0]);
    }

    private Path createPath(List<PcepHopNodeDescription> hopList, PcepTunnel.PATHTYPE pathtype, PcepTunnel.PathState pathState) {
        if (hopList == null || hopList.size() == 0) {
            return null;
        }
        ArrayList<Link> links = new ArrayList<Link>();
        for (int i = 1; i < hopList.size() - 1; i += 2) {
            links.add(this.link(hopList.get(i).getDeviceId(), hopList.get(i).getPortNum(), hopList.get(i + 1).getDeviceId(), hopList.get(i + 1).getPortNum()));
        }
        int hopNum = hopList.size() - 2;
        DefaultAnnotations extendAnnotations = DefaultAnnotations.builder().set("pathNum", String.valueOf(hopNum)).set("pathState", String.valueOf(pathState)).set("pathType", String.valueOf(pathtype)).build();
        return new DefaultPath(this.id(), links, (double)hopNum, new Annotations[]{extendAnnotations});
    }

    public String pathToString(List<Link> links) {
        StringBuilder builder = new StringBuilder();
        builder.append("{");
        for (Link link : links) {
            builder.append("(Device:" + link.src().deviceId() + "  Port:" + link.src().port().toLong());
            builder.append(" Device:" + link.dst().deviceId() + "  Port:" + link.dst().port().toLong());
            builder.append(")");
        }
        builder.append("}");
        return builder.toString();
    }

    private TunnelDescription buildOpticalTunnel(PcepTunnel pcepTunnel, TunnelId tunnelId) {
        DefaultOpticalTunnelEndPoint srcPoint = null;
        DefaultOpticalTunnelEndPoint dstPoint = null;
        Tunnel.Type tunnelType = null;
        TunnelName name = TunnelName.tunnelName((String)pcepTunnel.name());
        Path path = this.createPath(pcepTunnel.getHopList(), pcepTunnel.getPathType(), pcepTunnel.getPathState());
        OpticalTunnelEndPoint.Type endPointType = null;
        switch (pcepTunnel.type()) {
            case OCH: {
                tunnelType = Tunnel.Type.OCH;
                endPointType = OpticalTunnelEndPoint.Type.LAMBDA;
                break;
            }
            case OTN: {
                tunnelType = Tunnel.Type.ODUK;
                endPointType = OpticalTunnelEndPoint.Type.TIMESLOT;
                break;
            }
            case UNI: {
                tunnelType = Tunnel.Type.VLAN;
                endPointType = null;
                break;
            }
        }
        DeviceId srcDid = DeviceId.deviceId((URI)PcepDpid.uri((PcepDpid)pcepTunnel.srcDeviceID()));
        DeviceId dstDid = DeviceId.deviceId((URI)PcepDpid.uri((PcepDpid)pcepTunnel.dstDeviceId()));
        PortNumber srcPort = PortNumber.portNumber((long)pcepTunnel.srcPort());
        PortNumber dstPort = PortNumber.portNumber((long)pcepTunnel.dstPort());
        srcPoint = new DefaultOpticalTunnelEndPoint(this.id(), Optional.of(srcDid), Optional.of(srcPort), null, endPointType, OpticalLogicId.logicId((long)0L), true, new Annotations[0]);
        dstPoint = new DefaultOpticalTunnelEndPoint(this.id(), Optional.of(dstDid), Optional.of(dstPort), null, endPointType, OpticalLogicId.logicId((long)0L), true, new Annotations[0]);
        DefaultAnnotations annotations = DefaultAnnotations.builder().set("SLA", String.valueOf(pcepTunnel.getSla())).set("bandwidth", String.valueOf(pcepTunnel.bandWidth()) + BANDWIDTH_UINT).set("index", String.valueOf(pcepTunnel.id())).build();
        if (pcepTunnel.underlayTunnelId() != 0L) {
            DefaultAnnotations extendAnnotations = DefaultAnnotations.builder().set("underLayTunnelIndex", String.valueOf(pcepTunnel.underlayTunnelId())).build();
            annotations = DefaultAnnotations.merge((DefaultAnnotations)annotations, (SparseAnnotations)extendAnnotations);
        }
        DefaultTunnelDescription tunnel = new DefaultTunnelDescription(tunnelId, (TunnelEndPoint)srcPoint, (TunnelEndPoint)dstPoint, tunnelType, new DefaultGroupId(0), this.id(), name, path, new SparseAnnotations[]{annotations});
        return tunnel;
    }

    private TunnelId getTunnelId(String tunnelKey) {
        for (String key : this.tunnelMap.keySet()) {
            if (!key.equals(tunnelKey)) continue;
            return this.tunnelMap.get(key);
        }
        return null;
    }

    private String getPCEPTunnelKey(TunnelId tunnelId) {
        for (String key : this.tunnelMap.keySet()) {
            if (this.tunnelMap.get(key).id() != tunnelId.id()) continue;
            return key;
        }
        return null;
    }

    private TunnelStatistics buildTunnelStatistics(PcepTunnelStatistics statistics) {
        DefaultTunnelStatistics.Builder builder = new DefaultTunnelStatistics.Builder();
        DefaultTunnelStatistics tunnelStatistics = builder.setBwUtilization(statistics.bandwidthUtilization()).setPacketLossRatio(statistics.packetLossRate()).setFlowDelay(statistics.flowDelay()).setAlarms(statistics.alarms()).build();
        return tunnelStatistics;
    }

    private LinkedList<PcepValueType> createPcepPath(Path path) {
        LinkedList<PcepValueType> llSubObjects = new LinkedList<PcepValueType>();
        List listLink = path.links();
        ConnectPoint source = null;
        ConnectPoint destination = null;
        IpAddress ipDstAddress = null;
        IpAddress ipSrcAddress = null;
        IPv4SubObject subObj = null;
        for (Link link : listLink) {
            source = link.src();
            if (!source.equals(destination)) {
                ipSrcAddress = source.ipElementId().ipAddress();
                subObj = new IPv4SubObject(ipSrcAddress.getIp4Address().toInt());
                llSubObjects.add((PcepValueType)subObj);
            }
            destination = link.dst();
            ipDstAddress = destination.ipElementId().ipAddress();
            subObj = new IPv4SubObject(ipDstAddress.getIp4Address().toInt());
            llSubObjects.add((PcepValueType)subObj);
        }
        return llSubObjects;
    }

    LinkedList<PcInitiatedLspRequest> createPcInitiatedLspReqList(Tunnel tunnel, Path path, PcepClient pc, int srpId) throws PcepParseException {
        LinkedList<PcepValueType> llSubObjects = this.createPcepPath(path);
        if (llSubObjects == null || llSubObjects.size() == 0) {
            log.error("There is no link information to create tunnel");
            return null;
        }
        PcepSrpObject srpobj = pc.factory().buildSrpObject().setSrpID(srpId).setRFlag(false).build();
        LinkedList<StatefulIPv4LspIdentidiersTlv> llOptionalTlv = new LinkedList<StatefulIPv4LspIdentidiersTlv>();
        LinkedList<PcInitiatedLspRequest> llPcInitiatedLspRequestList = new LinkedList<PcInitiatedLspRequest>();
        StatefulIPv4LspIdentidiersTlv tlv = new StatefulIPv4LspIdentidiersTlv(((IpTunnelEndPoint)tunnel.src()).ip().getIp4Address().toInt(), 0, 0, 0, ((IpTunnelEndPoint)tunnel.dst()).ip().getIp4Address().toInt());
        llOptionalTlv.add(tlv);
        tlv = new SymbolicPathNameTlv(tunnel.tunnelName().value().getBytes());
        llOptionalTlv.add(tlv);
        PcepLspObject lspobj = pc.factory().buildLspObject().setAFlag(true).setOFlag((byte)0).setPlspId(0).setOptionalTlv(llOptionalTlv).build();
        PcepEndPointsObject endpointsobj = pc.factory().buildEndPointsObject().setSourceIpAddress(((IpTunnelEndPoint)tunnel.src()).ip().getIp4Address().toInt()).setDestIpAddress(((IpTunnelEndPoint)tunnel.dst()).ip().getIp4Address().toInt()).setPFlag(true).build();
        PcepEroObject eroobj = pc.factory().buildEroObject().setSubObjects(llSubObjects).build();
        int iBandwidth = 10;
        if (tunnel.annotations().value("bandwidth") != null) {
            iBandwidth = Integer.parseInt(tunnel.annotations().value("bandwidth"));
        }
        PcepBandwidthObject bandwidthObject = pc.factory().buildBandwidthObject().setBandwidth(iBandwidth).build();
        PcepAttribute pcepAttribute = pc.factory().buildPcepAttribute().setBandwidthObject(bandwidthObject).build();
        PcInitiatedLspRequest initiateLspRequest = pc.factory().buildPcInitiatedLspRequest().setSrpObject(srpobj).setLspObject(lspobj).setEndPointsObject(endpointsobj).setEroObject(eroobj).setPcepAttribute(pcepAttribute).build();
        llPcInitiatedLspRequestList.add(initiateLspRequest);
        return llPcInitiatedLspRequestList;
    }

    private void pcepSetupTunnel(Tunnel tunnel, Path path, PcepClient pc) {
        try {
            int srpId = SrpIdGenerators.create();
            PcepTunnelData pcepTunnelData = new PcepTunnelData(tunnel, path, RequestType.CREATE);
            this.pcepTunnelAPIMapper.addToCoreTunnelRequestQueue(pcepTunnelData);
            LinkedList<PcInitiatedLspRequest> llPcInitiatedLspRequestList = this.createPcInitiatedLspReqList(tunnel, path, pc, srpId);
            if (llPcInitiatedLspRequestList == null || llPcInitiatedLspRequestList.size() == 0) {
                log.error("Failed to create PcInitiatedLspRequestList");
                return;
            }
            PcepInitiateMsg pcInitiateMsg = pc.factory().buildPcepInitiateMsg().setPcInitiatedLspRequestList(llPcInitiatedLspRequestList).build();
            pc.sendMessage(Collections.singletonList(pcInitiateMsg));
            this.pcepTunnelAPIMapper.addToTunnelRequestQueue(srpId, pcepTunnelData);
        }
        catch (PcepParseException e) {
            log.error("PcepParseException occurred while processing setup tunnel {}", (Object)e.getMessage());
        }
    }

    private void pcepReleaseTunnel(Tunnel tunnel, PcepClient pc) {
        try {
            PcepTunnelData pcepTunnelData = new PcepTunnelData(tunnel, RequestType.DELETE);
            this.pcepTunnelAPIMapper.addToCoreTunnelRequestQueue(pcepTunnelData);
            int srpId = SrpIdGenerators.create();
            TunnelId tunnelId = tunnel.tunnelId();
            int plspId = 0;
            StatefulIPv4LspIdentidiersTlv statefulIpv4IndentifierTlv = null;
            if (!this.pcepTunnelAPIMapper.checkFromTunnelDBQueue(tunnelId)) {
                log.error("Tunnel doesnot exists. Tunnel id {}" + tunnelId.toString());
                return;
            }
            PcepTunnelData pcepTunnelDbData = this.pcepTunnelAPIMapper.getDataFromTunnelDBQueue(tunnelId);
            plspId = pcepTunnelDbData.plspId();
            statefulIpv4IndentifierTlv = pcepTunnelDbData.statefulIpv4IndentifierTlv();
            PcepSrpObject srpobj = pc.factory().buildSrpObject().setSrpID(srpId).setRFlag(true).build();
            LinkedList<StatefulIPv4LspIdentidiersTlv> llOptionalTlv = new LinkedList<StatefulIPv4LspIdentidiersTlv>();
            LinkedList<PcInitiatedLspRequest> llPcInitiatedLspRequestList = new LinkedList<PcInitiatedLspRequest>();
            StatefulIPv4LspIdentidiersTlv tlv = statefulIpv4IndentifierTlv != null ? statefulIpv4IndentifierTlv : new StatefulIPv4LspIdentidiersTlv(((IpTunnelEndPoint)tunnel.src()).ip().getIp4Address().toInt(), 0, 0, 0, ((IpTunnelEndPoint)tunnel.dst()).ip().getIp4Address().toInt());
            llOptionalTlv.add(tlv);
            tlv = new SymbolicPathNameTlv(tunnel.tunnelName().value().getBytes());
            llOptionalTlv.add(tlv);
            PcepLspObject lspobj = pc.factory().buildLspObject().setRFlag(false).setPlspId(plspId).setOptionalTlv(llOptionalTlv).build();
            PcInitiatedLspRequest releaseLspRequest = pc.factory().buildPcInitiatedLspRequest().setSrpObject(srpobj).setLspObject(lspobj).build();
            llPcInitiatedLspRequestList.add(releaseLspRequest);
            PcepInitiateMsg pcInitiateMsg = pc.factory().buildPcepInitiateMsg().setPcInitiatedLspRequestList(llPcInitiatedLspRequestList).build();
            pc.sendMessage(Collections.singletonList(pcInitiateMsg));
            this.pcepTunnelAPIMapper.addToTunnelRequestQueue(srpId, pcepTunnelData);
        }
        catch (PcepParseException e) {
            log.error("PcepParseException occurred while processing release tunnel {}", (Object)e.getMessage());
        }
    }

    private void pcepUpdateTunnel(Tunnel tunnel, Path path, PcepClient pc) {
        try {
            PcepTunnelData pcepTunnelData = new PcepTunnelData(tunnel, path, RequestType.UPDATE);
            this.pcepTunnelAPIMapper.addToCoreTunnelRequestQueue(pcepTunnelData);
            int srpId = SrpIdGenerators.create();
            TunnelId tunnelId = tunnel.tunnelId();
            int plspId = 0;
            LinkedList<PcepValueType> llSubObjects = this.createPcepPath(path);
            LinkedList<StatefulIPv4LspIdentidiersTlv> llOptionalTlv = new LinkedList<StatefulIPv4LspIdentidiersTlv>();
            LinkedList<PcepUpdateRequest> llUpdateRequestList = new LinkedList<PcepUpdateRequest>();
            PcepSrpObject srpobj = pc.factory().buildSrpObject().setSrpID(srpId).setRFlag(false).build();
            if (!this.pcepTunnelAPIMapper.checkFromTunnelDBQueue(tunnelId)) {
                log.error("Tunnel doesnot exists in DB");
                return;
            }
            PcepTunnelData pcepTunnelDBData = this.pcepTunnelAPIMapper.getDataFromTunnelDBQueue(tunnelId);
            plspId = pcepTunnelDBData.plspId();
            StatefulIPv4LspIdentidiersTlv tlv = new StatefulIPv4LspIdentidiersTlv(((IpTunnelEndPoint)tunnel.src()).ip().getIp4Address().toInt(), 0, 0, 0, ((IpTunnelEndPoint)tunnel.dst()).ip().getIp4Address().toInt());
            llOptionalTlv.add(tlv);
            if (tunnel.tunnelName().value() != null) {
                tlv = new SymbolicPathNameTlv(tunnel.tunnelName().value().getBytes());
                llOptionalTlv.add(tlv);
            }
            PcepLspObject lspobj = pc.factory().buildLspObject().setAFlag(true).setPlspId(plspId).setOptionalTlv(llOptionalTlv).build();
            PcepEroObject eroobj = pc.factory().buildEroObject().setSubObjects(llSubObjects).build();
            int iBandwidth = 10;
            if (tunnel.annotations().value("bandwidth") != null) {
                iBandwidth = Integer.parseInt(tunnel.annotations().value("bandwidth"));
            }
            PcepBandwidthObject bandwidthObject = pc.factory().buildBandwidthObject().setBandwidth(iBandwidth).build();
            PcepAttribute pcepAttribute = pc.factory().buildPcepAttribute().setBandwidthObject(bandwidthObject).build();
            PcepMsgPath msgPath = pc.factory().buildPcepMsgPath().setEroObject(eroobj).setPcepAttribute(pcepAttribute).build();
            PcepUpdateRequest updateRequest = pc.factory().buildPcepUpdateRequest().setSrpObject(srpobj).setLspObject(lspobj).setMsgPath(msgPath).build();
            llUpdateRequestList.add(updateRequest);
            PcepUpdateMsg pcUpdateMsg = pc.factory().buildUpdateMsg().setUpdateRequestList(llUpdateRequestList).build();
            pc.sendMessage(Collections.singletonList(pcUpdateMsg));
            this.pcepTunnelAPIMapper.addToTunnelRequestQueue(srpId, pcepTunnelData);
        }
        catch (PcepParseException e) {
            log.error("PcepParseException occurred while processing release tunnel {}", (Object)e.getMessage());
        }
    }

    public Tunnel tunnelQueryById(TunnelId tunnelId) {
        return this.service.tunnelQueryById(tunnelId);
    }

    protected void bindTunnelProviderRegistry(TunnelProviderRegistry tunnelProviderRegistry) {
        this.tunnelProviderRegistry = tunnelProviderRegistry;
    }

    protected void unbindTunnelProviderRegistry(TunnelProviderRegistry tunnelProviderRegistry) {
        if (this.tunnelProviderRegistry == tunnelProviderRegistry) {
            this.tunnelProviderRegistry = null;
        }
    }

    protected void bindController(PcepController pcepController) {
        this.controller = pcepController;
    }

    protected void unbindController(PcepController pcepController) {
        if (this.controller == pcepController) {
            this.controller = null;
        }
    }

    protected void bindPcepClientController(PcepClientController pcepClientController) {
        this.pcepClientController = pcepClientController;
    }

    protected void unbindPcepClientController(PcepClientController pcepClientController) {
        if (this.pcepClientController == pcepClientController) {
            this.pcepClientController = null;
        }
    }

    protected void bindTunnelService(TunnelService tunnelService) {
        this.tunnelService = tunnelService;
    }

    protected void unbindTunnelService(TunnelService tunnelService) {
        if (this.tunnelService == tunnelService) {
            this.tunnelService = null;
        }
    }

    protected void bindCfgService(ComponentConfigService componentConfigService) {
        this.cfgService = componentConfigService;
    }

    protected void unbindCfgService(ComponentConfigService componentConfigService) {
        if (this.cfgService == componentConfigService) {
            this.cfgService = null;
        }
    }

    private class InnerTunnelProvider
    implements PcepTunnelListener,
    PcepEventListener,
    PcepClientListener {
        private InnerTunnelProvider() {
        }

        public void handlePCEPTunnel(PcepTunnel pcepTunnel) {
            TunnelDescription tunnel = null;
            String tunnelKey = String.valueOf(pcepTunnel.getInstance()) + String.valueOf(pcepTunnel.id());
            if (tunnelKey == null || "".equals(tunnelKey)) {
                log.error("Invalid PCEP tunnel");
                return;
            }
            TunnelId tunnelId = PcepTunnelProvider.this.getTunnelId(tunnelKey);
            tunnel = PcepTunnelProvider.this.buildOpticalTunnel(pcepTunnel, tunnelId);
            PcepOperator.OperationType operType = pcepTunnel.getOperationType();
            switch (operType) {
                case ADD: {
                    tunnelId = PcepTunnelProvider.this.service.tunnelAdded(tunnel);
                    PcepTunnelProvider.this.tunnelMap.put(tunnelKey, tunnelId);
                    break;
                }
                case UPDATE: {
                    PcepTunnelProvider.this.service.tunnelUpdated(tunnel);
                    break;
                }
                case DELETE: {
                    PcepTunnelProvider.this.service.tunnelRemoved(tunnel);
                    PcepTunnelProvider.this.tunnelMap.remove(tunnelKey);
                    break;
                }
                default: {
                    log.error("Invalid tunnel operation");
                }
            }
        }

        public void handleMessage(PccId pccId, PcepMessage msg) {
            try {
                log.debug("tunnel provider handle message {}", (Object)msg.getType().toString());
                switch (msg.getType()) {
                    case REPORT: {
                        int srpId = 0;
                        LinkedList llStateReportList = null;
                        llStateReportList = ((PcepReportMsg)msg).getStateReportList();
                        ListIterator listIterator = llStateReportList.listIterator();
                        PcepSrpObject srpObj = null;
                        PcepLspObject lspObj = null;
                        while (listIterator.hasNext()) {
                            PcepStateReport stateRpt = (PcepStateReport)listIterator.next();
                            srpObj = stateRpt.getSrpObject();
                            lspObj = stateRpt.getLspObject();
                            if (srpObj instanceof PcepSrpObject) {
                                srpId = srpObj.getSrpID();
                            }
                            log.debug("Plsp ID in handle message " + lspObj.getPlspId());
                            log.debug("SRP ID in handle message " + srpId);
                            if (!PcepTunnelProvider.this.pcepTunnelAPIMapper.checkFromTunnelRequestQueue(srpId)) {
                                if (lspObj.getSFlag()) {
                                    this.handleSyncReport(stateRpt);
                                    continue;
                                }
                                if (PcepTunnelProvider.this.pcepClientController.getClient(pccId).isSyncComplete()) continue;
                                PcepTunnelProvider.this.pcepClientController.getClient(pccId).setIsSyncComplete(true);
                                continue;
                            }
                            this.handleReportMessage(srpId, lspObj);
                        }
                        break;
                    }
                    default: {
                        log.debug("Received unsupported message type {}", (Object)msg.getType().toString());
                        break;
                    }
                }
            }
            catch (Exception e) {
                log.error("Exception occured while processing report message {}", (Object)e.getMessage());
            }
        }

        private void handleReportMessage(int srpId, PcepLspObject lspObj) {
            ProviderId providerId = new ProviderId("pcep", PcepTunnelProvider.PROVIDER_ID);
            PcepTunnelData pcepTunnelData = PcepTunnelProvider.this.pcepTunnelAPIMapper.getDataFromTunnelRequestQueue(srpId);
            SparseAnnotations annotations = (SparseAnnotations)pcepTunnelData.tunnel().annotations();
            pcepTunnelData.setPlspId(lspObj.getPlspId());
            pcepTunnelData.setLspAFlag(lspObj.getAFlag());
            pcepTunnelData.setLspOFlag(lspObj.getOFlag());
            pcepTunnelData.setLspDFlag(lspObj.getDFlag());
            StatefulIPv4LspIdentidiersTlv ipv4LspTlv = null;
            ListIterator listTlvIterator = lspObj.getOptionalTlv().listIterator();
            while (listTlvIterator.hasNext()) {
                PcepValueType tlv = (PcepValueType)listTlvIterator.next();
                if (tlv.getType() != 18) continue;
                ipv4LspTlv = (StatefulIPv4LspIdentidiersTlv)tlv;
                break;
            }
            if (ipv4LspTlv != null) {
                pcepTunnelData.setStatefulIpv4IndentifierTlv(ipv4LspTlv);
            }
            Path path = pcepTunnelData.path();
            Tunnel tunnel = pcepTunnelData.tunnel();
            DefaultTunnelDescription td = new DefaultTunnelDescription(tunnel.tunnelId(), tunnel.src(), tunnel.dst(), tunnel.type(), tunnel.groupId(), providerId, tunnel.tunnelName(), path, new SparseAnnotations[]{annotations});
            if (RequestType.CREATE == pcepTunnelData.requestType()) {
                log.debug("Report received for create request");
                PcepTunnelProvider.this.pcepTunnelAPIMapper.handleCreateTunnelRequestQueue(srpId, pcepTunnelData);
                if (0 == lspObj.getOFlag()) {
                    log.warn("The tunnel is in down state");
                }
                PcepTunnelProvider.this.tunnelAdded((TunnelDescription)td);
            }
            if (RequestType.DELETE == pcepTunnelData.requestType()) {
                log.debug("Report received for delete request");
                PcepTunnelProvider.this.pcepTunnelAPIMapper.handleRemoveFromTunnelRequestQueue(srpId, pcepTunnelData);
                PcepTunnelProvider.this.tunnelRemoved((TunnelDescription)td);
            }
            if (RequestType.UPDATE == pcepTunnelData.requestType()) {
                log.debug("Report received for update request");
                pcepTunnelData.setRptFlag(true);
                PcepTunnelProvider.this.pcepTunnelAPIMapper.addToTunnelIdMap(pcepTunnelData);
                PcepTunnelProvider.this.pcepTunnelAPIMapper.handleUpdateTunnelRequestQueue(srpId, pcepTunnelData);
                if (0 == lspObj.getOFlag()) {
                    log.warn("The tunnel is in down state");
                }
                if (!PcepTunnelProvider.this.pcepTunnelAPIMapper.checkFromTunnelRequestQueue(srpId)) {
                    PcepTunnelProvider.this.tunnelUpdated((TunnelDescription)td);
                }
            }
        }

        private void handleSyncReport(PcepStateReport stateRpt) {
            PcepLspObject lspObj = stateRpt.getLspObject();
            PcepStateReport.PcepMsgPath msgPath = stateRpt.getMsgPath();
            Preconditions.checkNotNull((Object)msgPath);
            PcepRroObject rroObj = msgPath.getRroObject();
            if (rroObj == null) {
                log.debug("RRO object is null in sate report");
                return;
            }
            int bandwidth = 0;
            log.debug("Handle Sync report received from PCC.");
            if (0 == lspObj.getOFlag()) {
                log.warn("The PCC reported tunnel is in down state");
            }
            log.debug("Sync report received");
            if (msgPath.getBandwidthObject() != null) {
                bandwidth = msgPath.getBandwidthObject().getBandwidth();
            }
            this.buildAndStorePcepTunnelData(lspObj, rroObj, bandwidth);
        }

        private Path buildPathFromRroObj(PcepRroObject rroObj, ProviderId providerId) {
            Preconditions.checkNotNull((Object)rroObj);
            ArrayList<DefaultLink> links = new ArrayList<DefaultLink>();
            LinkedList llSubObj = rroObj.getSubObjects();
            if (0 == llSubObj.size()) {
                log.error("RRO in report message does not have hop information");
            }
            ListIterator tlvIterator = llSubObj.listIterator();
            ConnectPoint src = null;
            ConnectPoint dst = null;
            boolean isSrcSet = false;
            while (tlvIterator.hasNext()) {
                PcepValueType subObj = (PcepValueType)tlvIterator.next();
                switch (subObj.getType()) {
                    case 1: {
                        IPv4SubObject ipv4SubObj = (IPv4SubObject)subObj;
                        if (!isSrcSet) {
                            IpAddress srcIp = IpAddress.valueOf((int)ipv4SubObj.getIpAddress());
                            src = new ConnectPoint((ElementId)IpElementId.ipElement((IpAddress)srcIp), PortNumber.portNumber((long)0L));
                            isSrcSet = true;
                            break;
                        }
                        IpAddress dstIp = IpAddress.valueOf((int)ipv4SubObj.getIpAddress());
                        dst = new ConnectPoint((ElementId)IpElementId.ipElement((IpAddress)dstIp), PortNumber.portNumber((long)0L));
                        DefaultLink link = new DefaultLink(providerId, src, dst, Link.Type.DIRECT, new Annotations[]{DefaultAnnotations.EMPTY});
                        links.add(link);
                        src = dst;
                        break;
                    }
                }
            }
            return new DefaultPath(providerId, links, 0.0, new Annotations[]{DefaultAnnotations.EMPTY});
        }

        private void buildAndStorePcepTunnelData(PcepLspObject lspObj, PcepRroObject rroObj, int bandwidth) {
            ProviderId providerId = new ProviderId("pcep", PcepTunnelProvider.PROVIDER_ID);
            StatefulIPv4LspIdentidiersTlv lspIdenTlv = null;
            SymbolicPathNameTlv pathNameTlv = null;
            LinkedList llOptionalTlv = lspObj.getOptionalTlv();
            ListIterator listIterator = llOptionalTlv.listIterator();
            while (listIterator.hasNext()) {
                PcepValueType tlv = (PcepValueType)listIterator.next();
                switch (tlv.getType()) {
                    case 18: {
                        lspIdenTlv = (StatefulIPv4LspIdentidiersTlv)tlv;
                        break;
                    }
                    case 17: {
                        pathNameTlv = (SymbolicPathNameTlv)tlv;
                        break;
                    }
                }
            }
            IpTunnelEndPoint tunnelEndPointSrc = IpTunnelEndPoint.ipTunnelPoint((IpAddress)IpAddress.valueOf((int)lspIdenTlv.getIpv4IngressAddress()));
            IpTunnelEndPoint tunnelEndPointDst = IpTunnelEndPoint.ipTunnelPoint((IpAddress)IpAddress.valueOf((int)lspIdenTlv.getIpv4EgressAddress()));
            Path path = this.buildPathFromRroObj(rroObj, providerId);
            DefaultAnnotations annotations = DefaultAnnotations.builder().set("bandwidth", new Integer(bandwidth).toString()).build();
            DefaultTunnelDescription td = new DefaultTunnelDescription(null, (TunnelEndPoint)tunnelEndPointSrc, (TunnelEndPoint)tunnelEndPointDst, Tunnel.Type.MPLS, new DefaultGroupId(0), providerId, TunnelName.tunnelName((String)pathNameTlv.toString()), path, new SparseAnnotations[]{annotations});
            TunnelId tId = PcepTunnelProvider.this.tunnelAdded((TunnelDescription)td);
            DefaultTunnel tunnel = new DefaultTunnel(providerId, (TunnelEndPoint)tunnelEndPointSrc, (TunnelEndPoint)tunnelEndPointDst, Tunnel.Type.MPLS, new DefaultGroupId(0), tId, TunnelName.tunnelName((String)pathNameTlv.toString()), path, new Annotations[]{annotations});
            PcepTunnelData pcepTunnelData = new PcepTunnelData((Tunnel)tunnel, path, RequestType.LSP_STATE_RPT);
            pcepTunnelData.setStatefulIpv4IndentifierTlv(lspIdenTlv);
            PcepTunnelProvider.this.pcepTunnelAPIMapper.addPccTunnelDB(pcepTunnelData);
            PcepTunnelProvider.this.pcepTunnelAPIMapper.addToTunnelIdMap(pcepTunnelData);
        }

        public void clientConnected(PccId pccId) {
        }

        public void clientDisconnected(PccId pccId) {
        }

        public void handlePcepTunnelStatistics(PcepTunnelStatistics pcepTunnelStatistics) {
            TunnelId id = PcepTunnelProvider.this.getTunnelId(String.valueOf(pcepTunnelStatistics.id()));
            TunnelStatistics tunnelStatistics = PcepTunnelProvider.this.buildTunnelStatistics(pcepTunnelStatistics);
            PcepTunnelProvider.this.tunnelStatisticsMap.put(id, tunnelStatistics);
        }
    }
}

