/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.provider.pcep.tunnel.impl;

import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.felix.scr.annotations.Activate;
import org.apache.felix.scr.annotations.Deactivate;
import org.onlab.packet.IpAddress;
import org.onosproject.pcep.controller.PccId;
import org.onosproject.pcep.controller.PcepClient;
import org.onosproject.pcep.controller.PcepClientController;
import org.onosproject.pcep.controller.PcepClientListener;
import org.onosproject.pcep.controller.PcepEventListener;
import org.onosproject.pcep.controller.driver.PcepAgent;
import org.onosproject.pcepio.protocol.PcepMessage;
import org.onosproject.pcepio.protocol.PcepVersion;
import org.onosproject.provider.pcep.tunnel.impl.PcepClientAdapter;

public class PcepClientControllerAdapter
implements PcepClientController {
    protected ConcurrentHashMap<PccId, PcepClient> connectedClients = new ConcurrentHashMap();
    protected PcepClientAgent agent = new PcepClientAgent();
    protected Set<PcepClientListener> pcepClientListener = new HashSet<PcepClientListener>();
    protected Set<PcepEventListener> pcepEventListener = Sets.newHashSet();

    @Activate
    public void activate() {
    }

    @Deactivate
    public void deactivate() {
    }

    public Collection<PcepClient> getClients() {
        return this.connectedClients.values();
    }

    public PcepClient getClient(PccId pccId) {
        PcepClientAdapter pc = new PcepClientAdapter();
        pc.init(PccId.pccId((IpAddress)IpAddress.valueOf((int)-1409286143)), PcepVersion.PCEP_1);
        return pc;
    }

    public void addListener(PcepClientListener listener) {
        if (!this.pcepClientListener.contains(listener)) {
            this.pcepClientListener.add(listener);
        }
    }

    public void removeListener(PcepClientListener listener) {
        this.pcepClientListener.remove(listener);
    }

    public void addEventListener(PcepEventListener listener) {
        this.pcepEventListener.add(listener);
    }

    public void removeEventListener(PcepEventListener listener) {
        this.pcepEventListener.remove(listener);
    }

    public void writeMessage(PccId pccId, PcepMessage msg) {
        this.getClient(pccId).sendMessage(msg);
    }

    public void processClientMessage(PccId pccId, PcepMessage msg) {
        PcepClient pc = this.getClient(pccId);
        switch (msg.getType()) {
            case NONE: {
                break;
            }
            case OPEN: {
                break;
            }
            case KEEP_ALIVE: {
                pc.sendMessage(Collections.singletonList(pc.factory().buildKeepaliveMsg().build()));
                break;
            }
            case PATH_COMPUTATION_REQUEST: {
                break;
            }
            case PATH_COMPUTATION_REPLY: {
                break;
            }
            case NOTIFICATION: {
                break;
            }
            case ERROR: {
                break;
            }
            case CLOSE: {
                pc.sendMessage(Collections.singletonList(pc.factory().buildCloseMsg().build()));
                break;
            }
            case REPORT: {
                for (PcepEventListener l : this.pcepEventListener) {
                    l.handleMessage(pccId, msg);
                }
                break;
            }
            case UPDATE: {
                for (PcepEventListener l : this.pcepEventListener) {
                    l.handleMessage(pccId, msg);
                }
                break;
            }
            case INITIATE: {
                for (PcepEventListener l : this.pcepEventListener) {
                    l.handleMessage(pccId, msg);
                }
                break;
            }
            case LABEL_UPDATE: {
                break;
            }
            case MAX: {
                break;
            }
            case END: {
                break;
            }
        }
    }

    public void closeConnectedClients() {
        for (PccId id : this.connectedClients.keySet()) {
            PcepClient pc = this.getClient(id);
            pc.disconnectClient();
        }
    }

    public class PcepClientAgent
    implements PcepAgent {
        public boolean addConnectedClient(PccId pccId, PcepClient pc) {
            if (PcepClientControllerAdapter.this.connectedClients.get(pccId) != null) {
                return false;
            }
            PcepClientControllerAdapter.this.connectedClients.put(pccId, pc);
            for (PcepClientListener l : PcepClientControllerAdapter.this.pcepClientListener) {
                l.clientConnected(pccId);
            }
            return true;
        }

        public boolean validActivation(PccId pccId) {
            return PcepClientControllerAdapter.this.connectedClients.get(pccId) != null;
        }

        public void removeConnectedClient(PccId pccId) {
            PcepClientControllerAdapter.this.connectedClients.remove(pccId);
            for (PcepClientListener l : PcepClientControllerAdapter.this.pcepClientListener) {
                l.clientDisconnected(pccId);
            }
        }

        public void processPcepMessage(PccId pccId, PcepMessage m) {
            PcepClientControllerAdapter.this.processClientMessage(pccId, m);
        }
    }
}

