/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.provider.pcep.tunnel.impl;

import java.io.IOException;
import java.util.ArrayList;
import org.junit.After;
import org.junit.Test;
import org.onlab.packet.IpAddress;
import org.onosproject.cfg.ComponentConfigAdapter;
import org.onosproject.core.DefaultGroupId;
import org.onosproject.incubator.net.tunnel.DefaultTunnel;
import org.onosproject.incubator.net.tunnel.IpTunnelEndPoint;
import org.onosproject.incubator.net.tunnel.Tunnel;
import org.onosproject.incubator.net.tunnel.TunnelEndPoint;
import org.onosproject.incubator.net.tunnel.TunnelId;
import org.onosproject.incubator.net.tunnel.TunnelName;
import org.onosproject.net.Annotations;
import org.onosproject.net.ConnectPoint;
import org.onosproject.net.DefaultAnnotations;
import org.onosproject.net.DefaultLink;
import org.onosproject.net.DefaultPath;
import org.onosproject.net.ElementId;
import org.onosproject.net.IpElementId;
import org.onosproject.net.Link;
import org.onosproject.net.Path;
import org.onosproject.net.PortNumber;
import org.onosproject.net.provider.ProviderId;
import org.onosproject.provider.pcep.tunnel.impl.PcepClientControllerAdapter;
import org.onosproject.provider.pcep.tunnel.impl.PcepControllerAdapter;
import org.onosproject.provider.pcep.tunnel.impl.PcepTunnelProvider;
import org.onosproject.provider.pcep.tunnel.impl.TunnelProviderRegistryAdapter;
import org.onosproject.provider.pcep.tunnel.impl.TunnelServiceAdapter;

public class PcepSetupTunnelProviderTest {
    static final String PROVIDER_ID = "org.onosproject.provider.tunnel.pcep";
    PcepTunnelProvider tunnelProvider = new PcepTunnelProvider();
    private final TunnelProviderRegistryAdapter registry = new TunnelProviderRegistryAdapter();
    private final PcepClientControllerAdapter controller = new PcepClientControllerAdapter();
    private final PcepControllerAdapter ctl = new PcepControllerAdapter();
    private final TunnelServiceAdapter tunnelService = new TunnelServiceAdapter();

    @Test
    public void testCasePcepSetupTunnel() {
        this.tunnelProvider.tunnelProviderRegistry = this.registry;
        this.tunnelProvider.pcepClientController = this.controller;
        this.tunnelProvider.controller = this.ctl;
        this.tunnelProvider.cfgService = new ComponentConfigAdapter();
        this.tunnelProvider.tunnelService = this.tunnelService;
        this.tunnelProvider.activate();
        ProviderId pid = new ProviderId("pcep", PROVIDER_ID);
        ArrayList<DefaultLink> links = new ArrayList<DefaultLink>();
        IpAddress srcIp = IpAddress.valueOf((int)0xC010101);
        IpElementId srcElementId = IpElementId.ipElement((IpAddress)srcIp);
        IpAddress dstIp = IpAddress.valueOf((int)201392386);
        IpElementId dstElementId = IpElementId.ipElement((IpAddress)dstIp);
        IpTunnelEndPoint ipTunnelEndPointSrc = IpTunnelEndPoint.ipTunnelPoint((IpAddress)srcIp);
        IpTunnelEndPoint ipTunnelEndPointDst = IpTunnelEndPoint.ipTunnelPoint((IpAddress)dstIp);
        ConnectPoint src = new ConnectPoint((ElementId)srcElementId, PortNumber.portNumber((long)10023L));
        ConnectPoint dst = new ConnectPoint((ElementId)dstElementId, PortNumber.portNumber((long)10023L));
        DefaultLink link = DefaultLink.builder().providerId(pid).src(src).dst(dst).type(Link.Type.DIRECT).build();
        links.add(link);
        DefaultPath path = new DefaultPath(pid, links, 10.0, new Annotations[]{DefaultAnnotations.EMPTY});
        DefaultTunnel tunnel = new DefaultTunnel(pid, (TunnelEndPoint)ipTunnelEndPointSrc, (TunnelEndPoint)ipTunnelEndPointDst, Tunnel.Type.MPLS, new DefaultGroupId(0), TunnelId.valueOf((long)1L), TunnelName.tunnelName((String)"T123"), (Path)path, new Annotations[]{DefaultAnnotations.EMPTY});
        this.tunnelProvider.setupTunnel((Tunnel)tunnel, (Path)path);
    }

    @After
    public void tearDown() throws IOException {
        this.tunnelProvider.deactivate();
        this.tunnelProvider.controller = null;
        this.tunnelProvider.pcepClientController = null;
        this.tunnelProvider.tunnelProviderRegistry = null;
    }
}

