/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.provider.pcep.tunnel.impl;

import com.google.common.collect.FluentIterable;
import com.google.common.collect.ImmutableSet;
import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.core.Is;
import org.jboss.netty.buffer.ChannelBuffer;
import org.jboss.netty.buffer.ChannelBuffers;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;
import org.onlab.packet.ChassisId;
import org.onlab.packet.IpAddress;
import org.onosproject.cfg.ComponentConfigAdapter;
import org.onosproject.core.ApplicationId;
import org.onosproject.incubator.net.tunnel.DefaultTunnel;
import org.onosproject.incubator.net.tunnel.IpTunnelEndPoint;
import org.onosproject.incubator.net.tunnel.Tunnel;
import org.onosproject.incubator.net.tunnel.TunnelAdminService;
import org.onosproject.incubator.net.tunnel.TunnelDescription;
import org.onosproject.incubator.net.tunnel.TunnelEndPoint;
import org.onosproject.incubator.net.tunnel.TunnelId;
import org.onosproject.incubator.net.tunnel.TunnelName;
import org.onosproject.incubator.net.tunnel.TunnelProvider;
import org.onosproject.incubator.net.tunnel.TunnelProviderService;
import org.onosproject.mastership.MastershipServiceAdapter;
import org.onosproject.net.Annotations;
import org.onosproject.net.ConnectPoint;
import org.onosproject.net.DefaultAnnotations;
import org.onosproject.net.DefaultDevice;
import org.onosproject.net.DefaultLink;
import org.onosproject.net.Device;
import org.onosproject.net.DeviceId;
import org.onosproject.net.ElementId;
import org.onosproject.net.Link;
import org.onosproject.net.MastershipRole;
import org.onosproject.net.Path;
import org.onosproject.net.PortNumber;
import org.onosproject.net.device.DeviceServiceAdapter;
import org.onosproject.net.link.LinkServiceAdapter;
import org.onosproject.net.provider.ProviderId;
import org.onosproject.pcep.controller.ClientCapability;
import org.onosproject.pcep.controller.LspKey;
import org.onosproject.pcep.controller.LspType;
import org.onosproject.pcep.controller.PccId;
import org.onosproject.pcep.controller.PcepSyncStatus;
import org.onosproject.pcepio.exceptions.PcepOutOfBoundMessageException;
import org.onosproject.pcepio.exceptions.PcepParseException;
import org.onosproject.pcepio.protocol.PcepFactories;
import org.onosproject.pcepio.protocol.PcepMessage;
import org.onosproject.pcepio.protocol.PcepMessageReader;
import org.onosproject.pcepio.protocol.PcepVersion;
import org.onosproject.provider.pcep.tunnel.impl.PcepClientAdapter;
import org.onosproject.provider.pcep.tunnel.impl.PcepClientControllerAdapter;
import org.onosproject.provider.pcep.tunnel.impl.PcepControllerAdapter;
import org.onosproject.provider.pcep.tunnel.impl.PcepTunnelApiMapper;
import org.onosproject.provider.pcep.tunnel.impl.PcepTunnelProvider;
import org.onosproject.provider.pcep.tunnel.impl.TunnelProviderRegistryAdapter;
import org.onosproject.provider.pcep.tunnel.impl.TunnelServiceAdapter;

public class PcepTunnelAddedTest {
    public static final String PROVIDER_ID = "org.onosproject.provider.tunnel.pcep";
    public static final String UNKOWN = "UNKOWN";
    PcepTunnelProvider tunnelProvider = new PcepTunnelProvider();
    private final MockTunnelProviderRegistryAdapter registry = new MockTunnelProviderRegistryAdapter();
    private final PcepClientControllerAdapter controller = new PcepClientControllerAdapter();
    private final PcepControllerAdapter ctl = new PcepControllerAdapter();
    private final PcepTunnelApiMapper pcepTunnelAPIMapper = new PcepTunnelApiMapper();
    private final MockTunnelServiceAdapter tunnelService = new MockTunnelServiceAdapter();
    public final MockDeviceService deviceService = new MockDeviceService();
    private final MockMasterShipService masterShipService = new MockMasterShipService();
    private final MockLinkService linkService = new MockLinkService();
    private final MockTunnelAdminService tunnelAdminService = new MockTunnelAdminService();

    @Before
    public void preSetup() {
        this.tunnelProvider.tunnelProviderRegistry = this.registry;
        this.tunnelProvider.pcepClientController = this.controller;
        this.tunnelProvider.controller = this.ctl;
        this.tunnelProvider.deviceService = this.deviceService;
        this.tunnelProvider.mastershipService = this.masterShipService;
        this.tunnelProvider.pcepTunnelApiMapper = this.pcepTunnelAPIMapper;
        this.tunnelProvider.cfgService = new ComponentConfigAdapter();
        this.tunnelProvider.tunnelService = this.tunnelService;
        this.tunnelProvider.tunnelAdminService = this.tunnelAdminService;
        this.tunnelProvider.service = this.registry.register((TunnelProvider)this.tunnelProvider);
        this.tunnelProvider.linkService = this.linkService;
        this.tunnelProvider.activate();
    }

    @Test
    public void tunnelProviderAddedTest1() throws PcepParseException, PcepOutOfBoundMessageException {
        byte[] reportMsg = new byte[]{32, 10, 0, -124, 33, 16, 0, 20, 0, 0, 0, 0, 0, 0, 0, 1, 0, 28, 0, 4, 0, 0, 0, 2, 32, 16, 0, 36, 0, 0, 16, 3, 0, 17, 0, 2, 84, 49, 0, 0, 0, 18, 0, 16, 1, 1, 1, 1, 0, 1, 0, 1, 1, 1, 1, 1, 5, 5, 5, 5, 7, 16, 0, 20, 1, 8, 1, 1, 1, 1, 4, 0, 1, 8, 5, 5, 5, 5, 4, 0, 8, 16, 0, 52, 1, 8, 17, 1, 1, 1, 4, 0, 1, 8, 17, 1, 1, 2, 4, 0, 1, 8, 6, 6, 6, 6, 4, 0, 1, 8, 18, 1, 1, 2, 4, 0, 1, 8, 18, 1, 1, 1, 4, 0, 1, 8, 5, 5, 5, 5, 4, 0};
        ChannelBuffer buffer = ChannelBuffers.dynamicBuffer();
        buffer.writeBytes(reportMsg);
        PcepMessageReader reader = PcepFactories.getGenericReader();
        PcepMessage message = (PcepMessage)reader.readFrom(buffer);
        DefaultAnnotations.Builder newBuilder = DefaultAnnotations.builder();
        newBuilder.set("lsrId", "1.1.1.1");
        newBuilder.set("type", "L3");
        DefaultDevice device = new DefaultDevice(ProviderId.NONE, DeviceId.deviceId((String)"1.1.1.1"), Device.Type.ROUTER, UNKOWN, UNKOWN, UNKOWN, UNKOWN, new ChassisId(), new Annotations[]{newBuilder.build()});
        this.deviceService.addDevice((Device)device);
        this.controller.getClient(PccId.pccId((IpAddress)IpAddress.valueOf((String)"1.1.1.1"))).setCapability(new ClientCapability(true, true, true, true, true));
        this.masterShipService.setMaster(true);
        DefaultLink link = DefaultLink.builder().src(new ConnectPoint((ElementId)device.id(), PortNumber.portNumber((long)0x1010101L))).dst(new ConnectPoint((ElementId)device.id(), PortNumber.portNumber((long)0x5050505L))).state(Link.State.ACTIVE).type(Link.Type.DIRECT).providerId(ProviderId.NONE).build();
        this.linkService.addLink((Link)link);
        this.controller.processClientMessage(PccId.pccId((IpAddress)IpAddress.valueOf((String)"1.1.1.1")), message);
        MatcherAssert.assertThat((Object)this.registry.tunnelIdCounter, (Matcher)Is.is((Object)1L));
    }

    @Test
    public void tunnelProviderAddedTest2() throws PcepParseException, PcepOutOfBoundMessageException {
        byte[] reportMsg = new byte[]{32, 10, 0, 80, 33, 16, 0, 20, 0, 0, 0, 0, 0, 0, 0, 0, 0, 28, 0, 4, 0, 0, 0, 2, 32, 16, 0, 36, 0, 0, 16, 25, 0, 17, 0, 2, 84, 49, 0, 0, 0, 18, 0, 16, 78, 31, 4, 0, 0, 1, 0, 1, 78, 31, 4, 0, 78, 32, 4, 0, 7, 16, 0, 20, 1, 8, -74, 2, 78, 31, 4, 0, 1, 8, -74, 2, 78, 32, 4, 0};
        ChannelBuffer buffer = ChannelBuffers.dynamicBuffer();
        buffer.writeBytes(reportMsg);
        PcepMessageReader reader = PcepFactories.getGenericReader();
        PcepMessage message = (PcepMessage)reader.readFrom(buffer);
        IpTunnelEndPoint tunnelEndPointSrc = IpTunnelEndPoint.ipTunnelPoint((IpAddress)IpAddress.valueOf((int)1310655488));
        IpTunnelEndPoint tunnelEndPointDst = IpTunnelEndPoint.ipTunnelPoint((IpAddress)IpAddress.valueOf((int)1310721024));
        DefaultAnnotations annotations = DefaultAnnotations.builder().set("bandwidth", new Integer(1).toString()).set("lspSigType", LspType.WITHOUT_SIGNALLING_AND_WITHOUT_SR.name()).set("PccTunnelId", String.valueOf(1)).set("PLspId", String.valueOf(1)).set("localLspId", String.valueOf(1)).set("delegate", String.valueOf("true")).build();
        DefaultTunnel tunnel = new DefaultTunnel(null, (TunnelEndPoint)tunnelEndPointSrc, (TunnelEndPoint)tunnelEndPointDst, Tunnel.Type.MPLS, Tunnel.State.INIT, null, null, TunnelName.tunnelName((String)"T123"), null, new Annotations[]{annotations});
        this.tunnelService.setupTunnel(null, null, (Tunnel)tunnel, null);
        PccId pccId = PccId.pccId((IpAddress)IpAddress.valueOf((int)1310655488));
        PcepClientAdapter pc = new PcepClientAdapter();
        pc.init(pccId, PcepVersion.PCEP_1);
        this.masterShipService.setMaster(true);
        this.controller.getClient(pccId).setLspAndDelegationInfo(new LspKey(1, 1), true);
        this.controller.getClient(pccId).setCapability(new ClientCapability(true, true, true, true, true));
        this.controller.getClient(pccId).setLspDbSyncStatus(PcepSyncStatus.SYNCED);
        this.controller.processClientMessage(pccId, message);
        MatcherAssert.assertThat((Object)this.tunnelService.queryAllTunnels().size(), (Matcher)Is.is((Object)1));
    }

    @Test
    public void tunnelProviderAddedTest3() throws PcepParseException, PcepOutOfBoundMessageException {
        byte[] reportMsg = new byte[]{32, 10, 0, -124, 33, 16, 0, 20, 0, 0, 0, 0, 0, 0, 0, 0, 0, 28, 0, 4, 0, 0, 0, 2, 32, 16, 0, 36, 0, 0, 16, 27, 0, 17, 0, 2, 84, 49, 0, 0, 0, 18, 0, 16, 1, 1, 1, 1, 0, 1, 0, 1, 1, 1, 1, 1, 5, 5, 5, 5, 7, 16, 0, 20, 1, 8, 1, 1, 1, 1, 4, 0, 1, 8, 5, 5, 5, 5, 4, 0, 8, 16, 0, 52, 1, 8, 17, 1, 1, 1, 4, 0, 1, 8, 17, 1, 1, 2, 4, 0, 1, 8, 6, 6, 6, 6, 4, 0, 1, 8, 18, 1, 1, 2, 4, 0, 1, 8, 18, 1, 1, 1, 4, 0, 1, 8, 5, 5, 5, 5, 4, 0};
        ChannelBuffer buffer = ChannelBuffers.dynamicBuffer();
        buffer.writeBytes(reportMsg);
        PcepMessageReader reader = PcepFactories.getGenericReader();
        PcepMessage message = (PcepMessage)reader.readFrom(buffer);
        DefaultAnnotations.Builder newBuilder = DefaultAnnotations.builder();
        newBuilder.set("lsrId", "1.1.1.1");
        newBuilder.set("type", "L3");
        DefaultDevice device = new DefaultDevice(ProviderId.NONE, DeviceId.deviceId((String)"1.1.1.1"), Device.Type.ROUTER, UNKOWN, UNKOWN, UNKOWN, UNKOWN, new ChassisId(), new Annotations[]{newBuilder.build()});
        this.deviceService.addDevice((Device)device);
        PccId pccId = PccId.pccId((IpAddress)IpAddress.valueOf((String)"1.1.1.1"));
        this.controller.getClient(pccId).setLspDbSyncStatus(PcepSyncStatus.SYNCED);
        this.controller.getClient(pccId).setCapability(new ClientCapability(true, true, true, true, true));
        DefaultLink link = DefaultLink.builder().src(new ConnectPoint((ElementId)device.id(), PortNumber.portNumber((long)0x1010101L))).dst(new ConnectPoint((ElementId)device.id(), PortNumber.portNumber((long)0x5050505L))).state(Link.State.ACTIVE).type(Link.Type.DIRECT).providerId(ProviderId.NONE).build();
        this.linkService.addLink((Link)link);
        PcepClientAdapter pc = new PcepClientAdapter();
        pc.init(pccId, PcepVersion.PCEP_1);
        this.controller.getClient(pccId).setLspAndDelegationInfo(new LspKey(1, 1), true);
        this.masterShipService.setMaster(true);
        this.controller.processClientMessage(pccId, message);
        MatcherAssert.assertThat((Object)this.registry.tunnelIdCounter, (Matcher)Is.is((Object)1L));
    }

    @Test
    public void tunnelProviderAddedTest4() throws PcepParseException, PcepOutOfBoundMessageException, InterruptedException {
        byte[] reportMsg = new byte[]{32, 10, 0, -124, 33, 16, 0, 20, 0, 0, 0, 0, 0, 0, 0, 1, 0, 28, 0, 4, 0, 0, 0, 2, 32, 16, 0, 36, 0, 0, 16, 2, 0, 17, 0, 2, 84, 49, 0, 0, 0, 18, 0, 16, 1, 1, 1, 1, 0, 1, 0, 1, 1, 1, 1, 1, 5, 5, 5, 5, 7, 16, 0, 20, 1, 8, 1, 1, 1, 1, 4, 0, 1, 8, 5, 5, 5, 5, 4, 0, 8, 16, 0, 52, 1, 8, 17, 1, 1, 1, 4, 0, 1, 8, 17, 1, 1, 2, 4, 0, 1, 8, 6, 6, 6, 6, 4, 0, 1, 8, 18, 1, 1, 2, 4, 0, 1, 8, 18, 1, 1, 1, 4, 0, 1, 8, 5, 5, 5, 5, 4, 0};
        ChannelBuffer buffer = ChannelBuffers.dynamicBuffer();
        buffer.writeBytes(reportMsg);
        PcepMessageReader reader = PcepFactories.getGenericReader();
        PcepMessage message = (PcepMessage)reader.readFrom(buffer);
        this.masterShipService.setMaster(true);
        DefaultAnnotations.Builder newBuilder = DefaultAnnotations.builder();
        newBuilder.set("lsrId", "1.1.1.1");
        newBuilder.set("type", "L3");
        DefaultDevice device = new DefaultDevice(ProviderId.NONE, DeviceId.deviceId((String)"1.1.1.1"), Device.Type.ROUTER, UNKOWN, UNKOWN, UNKOWN, UNKOWN, new ChassisId(), new Annotations[]{newBuilder.build()});
        this.deviceService.addDevice((Device)device);
        this.controller.getClient(PccId.pccId((IpAddress)IpAddress.valueOf((String)"1.1.1.1"))).setCapability(new ClientCapability(true, true, true, true, true));
        DefaultLink link = DefaultLink.builder().src(new ConnectPoint((ElementId)device.id(), PortNumber.portNumber((long)0x1010101L))).dst(new ConnectPoint((ElementId)device.id(), PortNumber.portNumber((long)0x5050505L))).state(Link.State.ACTIVE).type(Link.Type.DIRECT).providerId(ProviderId.NONE).build();
        this.linkService.addLink((Link)link);
        this.controller.processClientMessage(PccId.pccId((IpAddress)IpAddress.valueOf((String)"1.1.1.1")), message);
        MatcherAssert.assertThat((Object)((Tunnel)this.tunnelService.tunnelIdAsKeyStore.values().iterator().next()).annotations().value("delegate"), (Matcher)Is.is((Object)"false"));
        this.masterShipService.setMaster(false);
        reportMsg = new byte[]{32, 10, 0, -124, 33, 16, 0, 20, 0, 0, 0, 0, 0, 0, 0, 1, 0, 28, 0, 4, 0, 0, 0, 2, 32, 16, 0, 36, 0, 0, 16, 3, 0, 17, 0, 2, 84, 49, 0, 0, 0, 18, 0, 16, 1, 1, 1, 1, 0, 1, 0, 1, 1, 1, 1, 1, 5, 5, 5, 5, 7, 16, 0, 20, 1, 8, 1, 1, 1, 1, 4, 0, 1, 8, 5, 5, 5, 5, 4, 0, 8, 16, 0, 52, 1, 8, 17, 1, 1, 1, 4, 0, 1, 8, 17, 1, 1, 2, 4, 0, 1, 8, 6, 6, 6, 6, 4, 0, 1, 8, 18, 1, 1, 2, 4, 0, 1, 8, 18, 1, 1, 1, 4, 0, 1, 8, 5, 5, 5, 5, 4, 0};
        buffer = ChannelBuffers.dynamicBuffer();
        buffer.writeBytes(reportMsg);
        reader = PcepFactories.getGenericReader();
        message = (PcepMessage)reader.readFrom(buffer);
        this.controller.processClientMessage(PccId.pccId((IpAddress)IpAddress.valueOf((String)"1.1.1.1")), message);
        TimeUnit.MILLISECONDS.sleep(4000L);
        MatcherAssert.assertThat((Object)this.registry.tunnelIdCounter, (Matcher)Is.is((Object)1L));
        MatcherAssert.assertThat((Object)((Tunnel)this.tunnelService.tunnelIdAsKeyStore.values().iterator().next()).annotations().value("delegate"), (Matcher)Is.is((Object)"true"));
    }

    @Test
    public void tunnelProviderAddedTest5() throws PcepParseException, PcepOutOfBoundMessageException {
        byte[] reportMsg = new byte[]{32, 10, 0, -124, 33, 16, 0, 20, 0, 0, 0, 0, 0, 0, 0, 0, 0, 28, 0, 4, 0, 0, 0, 2, 32, 16, 0, 36, 0, 0, 16, 25, 0, 17, 0, 2, 84, 49, 0, 0, 0, 18, 0, 16, 1, 1, 1, 1, 0, 1, 0, 1, 1, 1, 1, 1, 5, 5, 5, 5, 7, 16, 0, 20, 1, 8, 1, 1, 1, 1, 4, 0, 1, 8, 5, 5, 5, 5, 4, 0, 8, 16, 0, 52, 1, 8, 17, 1, 1, 1, 4, 0, 1, 8, 17, 1, 1, 2, 4, 0, 1, 8, 6, 6, 6, 6, 4, 0, 1, 8, 18, 1, 1, 2, 4, 0, 1, 8, 18, 1, 1, 1, 4, 0, 1, 8, 5, 5, 5, 5, 4, 0};
        ChannelBuffer buffer = ChannelBuffers.dynamicBuffer();
        buffer.writeBytes(reportMsg);
        PcepMessageReader reader = PcepFactories.getGenericReader();
        PcepMessage message = (PcepMessage)reader.readFrom(buffer);
        DefaultAnnotations.Builder newBuilder = DefaultAnnotations.builder();
        newBuilder.set("lsrId", "1.1.1.1");
        newBuilder.set("type", "L3");
        DefaultDevice device = new DefaultDevice(ProviderId.NONE, DeviceId.deviceId((String)"1.1.1.1"), Device.Type.ROUTER, UNKOWN, UNKOWN, UNKOWN, UNKOWN, new ChassisId(), new Annotations[]{newBuilder.build()});
        this.deviceService.addDevice((Device)device);
        PccId pccId = PccId.pccId((IpAddress)IpAddress.valueOf((String)"1.1.1.1"));
        this.controller.getClient(pccId).setLspDbSyncStatus(PcepSyncStatus.SYNCED);
        this.controller.getClient(pccId).setCapability(new ClientCapability(true, true, true, true, true));
        PcepClientAdapter pc = new PcepClientAdapter();
        pc.init(pccId, PcepVersion.PCEP_1);
        this.controller.getClient(pccId).setLspAndDelegationInfo(new LspKey(1, 1), true);
        this.masterShipService.setMaster(true);
        this.controller.processClientMessage(pccId, message);
        MatcherAssert.assertThat((Object)this.registry.tunnelIdCounter, (Matcher)Is.is((Object)0L));
    }

    @After
    public void tearDown() throws IOException {
        this.tunnelProvider.deactivate();
        this.tunnelProvider.controller = null;
        this.tunnelProvider.pcepClientController = null;
        this.tunnelProvider.tunnelProviderRegistry = null;
        this.tunnelProvider.pcepTunnelApiMapper = null;
        this.tunnelProvider.cfgService = null;
        this.tunnelProvider.tunnelService = null;
        this.tunnelProvider.tunnelAdminService = null;
        this.tunnelProvider.deviceService = null;
        this.tunnelProvider.mastershipService = null;
        this.tunnelProvider.linkService = null;
        this.tunnelProvider.service = null;
    }

    private class MockTunnelServiceAdapter
    extends TunnelServiceAdapter {
        private HashMap<TunnelId, Tunnel> tunnelIdAsKeyStore = new HashMap();
        private int tunnelIdCounter = 0;

        private MockTunnelServiceAdapter() {
        }

        @Override
        public TunnelId setupTunnel(ApplicationId producerId, ElementId srcElementId, Tunnel tunnel, Path path) {
            TunnelId tunnelId = TunnelId.valueOf((String)String.valueOf(++this.tunnelIdCounter));
            this.tunnelIdAsKeyStore.put(tunnelId, tunnel);
            return tunnelId;
        }

        @Override
        public Collection<Tunnel> queryTunnel(TunnelEndPoint src, TunnelEndPoint dst) {
            HashSet<Tunnel> result = new HashSet<Tunnel>();
            Tunnel tunnel = null;
            for (TunnelId tunnelId : this.tunnelIdAsKeyStore.keySet()) {
                tunnel = this.tunnelIdAsKeyStore.get(tunnelId);
                if (null == tunnel || !src.equals(tunnel.src()) || !dst.equals(tunnel.dst())) continue;
                result.add(tunnel);
            }
            return result.isEmpty() ? Collections.emptySet() : ImmutableSet.copyOf(result);
        }

        @Override
        public Collection<Tunnel> queryAllTunnels() {
            HashSet<Tunnel> result = new HashSet<Tunnel>();
            for (TunnelId tunnelId : this.tunnelIdAsKeyStore.keySet()) {
                result.add(this.tunnelIdAsKeyStore.get(tunnelId));
            }
            return result.isEmpty() ? Collections.emptySet() : ImmutableSet.copyOf(result);
        }
    }

    private class MockTunnelProviderRegistryAdapter
    extends TunnelProviderRegistryAdapter {
        public long tunnelIdCounter;

        private MockTunnelProviderRegistryAdapter() {
        }

        @Override
        public TunnelProviderService register(TunnelProvider provider) {
            this.provider = provider;
            return new TestProviderService();
        }

        private class TestProviderService
        implements TunnelProviderService {
            private TestProviderService() {
            }

            public TunnelProvider provider() {
                return null;
            }

            public TunnelId tunnelAdded(TunnelDescription tunnel) {
                TunnelId id = TunnelId.valueOf((String)String.valueOf(++MockTunnelProviderRegistryAdapter.this.tunnelIdCounter));
                DefaultTunnel storedTunnel = new DefaultTunnel(ProviderId.NONE, tunnel.src(), tunnel.dst(), tunnel.type(), tunnel.groupId(), id, tunnel.tunnelName(), tunnel.path(), tunnel.resource(), new Annotations[]{tunnel.annotations()});
                PcepTunnelAddedTest.this.tunnelService.tunnelIdAsKeyStore.put(id, storedTunnel);
                return id;
            }

            public TunnelId tunnelAdded(TunnelDescription tunnel, Tunnel.State state) {
                TunnelId id = TunnelId.valueOf((String)String.valueOf(++MockTunnelProviderRegistryAdapter.this.tunnelIdCounter));
                DefaultTunnel storedTunnel = new DefaultTunnel(ProviderId.NONE, tunnel.src(), tunnel.dst(), tunnel.type(), tunnel.groupId(), id, tunnel.tunnelName(), tunnel.path(), tunnel.resource(), new Annotations[]{tunnel.annotations()});
                PcepTunnelAddedTest.this.tunnelService.tunnelIdAsKeyStore.put(id, storedTunnel);
                return id;
            }

            public void tunnelRemoved(TunnelDescription tunnel) {
            }

            public void tunnelUpdated(TunnelDescription tunnel) {
            }

            public void tunnelUpdated(TunnelDescription tunnel, Tunnel.State state) {
            }

            public Tunnel tunnelQueryById(TunnelId tunnelId) {
                return null;
            }
        }
    }

    private class MockDeviceService
    extends DeviceServiceAdapter {
        List<Device> devices = new LinkedList<Device>();

        private MockDeviceService() {
        }

        private void addDevice(Device dev) {
            this.devices.add(dev);
        }

        public Iterable<Device> getAvailableDevices() {
            return this.devices;
        }
    }

    private class MockMasterShipService
    extends MastershipServiceAdapter {
        boolean set;

        private MockMasterShipService() {
        }

        private void setMaster(boolean isMaster) {
            this.set = isMaster;
        }

        public MastershipRole getLocalRole(DeviceId deviceId) {
            return this.set ? MastershipRole.MASTER : MastershipRole.STANDBY;
        }

        public boolean isLocalMaster(DeviceId deviceId) {
            return this.getLocalRole(deviceId) == MastershipRole.MASTER;
        }
    }

    private class MockTunnelAdminService
    implements TunnelAdminService {
        private MockTunnelAdminService() {
        }

        public void removeTunnel(TunnelId tunnelId) {
        }

        public void removeTunnels(TunnelEndPoint src, TunnelEndPoint dst, ProviderId producerName) {
        }

        public void removeTunnels(TunnelEndPoint src, TunnelEndPoint dst, Tunnel.Type type, ProviderId producerName) {
        }

        public void updateTunnel(Tunnel tunnel, Path path) {
            if (PcepTunnelAddedTest.this.tunnelService.tunnelIdAsKeyStore.containsKey(tunnel.tunnelId())) {
                PcepTunnelAddedTest.this.tunnelService.tunnelIdAsKeyStore.replace(tunnel.tunnelId(), tunnel);
            }
        }
    }

    private class MockLinkService
    extends LinkServiceAdapter {
        LinkedList<Link> links = new LinkedList();

        private MockLinkService() {
        }

        void addLink(Link link) {
            this.links.add(link);
        }

        public Iterable<Link> getActiveLinks() {
            return FluentIterable.from(this.links).filter(input -> input.state() == Link.State.ACTIVE);
        }
    }
}

