/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.pcepio;

import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.hamcrest.core.Is;
import org.jboss.netty.buffer.ChannelBuffer;
import org.jboss.netty.buffer.ChannelBuffers;
import org.junit.Test;
import org.onosproject.pcepio.exceptions.PcepParseException;
import org.onosproject.pcepio.protocol.PcepFactories;
import org.onosproject.pcepio.protocol.PcepMessage;
import org.onosproject.pcepio.protocol.PcepMessageReader;
import org.onosproject.pcepio.protocol.PcepTEReportMsg;

public class PcepTEReportMsgTest {
    @Test
    public void teReportMessageTest1() throws PcepParseException {
        byte[] teReportMsg = new byte[]{32, 14, 0, 40, 14, 16, 0, 36, 1, 0, 0, 3, 0, 0, 0, 16, 0, 14, 0, 8, 0, 0, 0, 0, 0, 0, 0, 1, 6, 101, 0, 8, 0, 100, 0, 4, 0, 0, 0, 17};
        ChannelBuffer buffer = ChannelBuffers.dynamicBuffer();
        buffer.writeBytes(teReportMsg);
        PcepMessageReader reader = PcepFactories.getGenericReader();
        PcepMessage message = null;
        message = (PcepMessage)reader.readFrom(buffer);
        byte[] testReportMsg = new byte[]{0};
        MatcherAssert.assertThat((Object)message, (Matcher)Matchers.instanceOf(PcepTEReportMsg.class));
        ChannelBuffer buf = ChannelBuffers.dynamicBuffer();
        message.writeTo(buf);
        int readLen = buf.writerIndex();
        testReportMsg = new byte[readLen];
        buf.readBytes(testReportMsg, 0, readLen);
        MatcherAssert.assertThat((Object)testReportMsg, (Matcher)Is.is((Object)teReportMsg));
    }

    @Test
    public void teReportMessageTest2() throws PcepParseException {
        byte[] teReportMsg = new byte[]{32, 14, 0, 40, 14, 16, 0, 36, 1, 0, 0, 3, 0, 0, 0, 16, 0, 14, 0, 8, 0, 0, 0, 0, 0, 0, 0, 1, 6, 101, 0, 8, 0, 100, 0, 4, 0, 0, 0, 17};
        ChannelBuffer buffer = ChannelBuffers.dynamicBuffer();
        buffer.writeBytes(teReportMsg);
        PcepMessageReader reader = PcepFactories.getGenericReader();
        PcepMessage message = null;
        message = (PcepMessage)reader.readFrom(buffer);
        byte[] testReportMsg = new byte[]{0};
        MatcherAssert.assertThat((Object)message, (Matcher)Matchers.instanceOf(PcepTEReportMsg.class));
        ChannelBuffer buf = ChannelBuffers.dynamicBuffer();
        message.writeTo(buf);
        int readLen = buf.writerIndex();
        testReportMsg = new byte[readLen];
        buf.readBytes(testReportMsg, 0, readLen);
        MatcherAssert.assertThat((Object)testReportMsg, (Matcher)Is.is((Object)teReportMsg));
    }

    @Test
    public void teReportMessageTest3() throws PcepParseException {
        byte[] teReportMsg = new byte[]{32, 14, 0, 28, 14, 16, 0, 24, 1, 0, 0, 3, 0, 0, 0, 16, 0, 14, 0, 8, 0, 0, 0, 0, 0, 0, 0, 1};
        ChannelBuffer buffer = ChannelBuffers.dynamicBuffer();
        buffer.writeBytes(teReportMsg);
        PcepMessageReader reader = PcepFactories.getGenericReader();
        PcepMessage message = null;
        message = (PcepMessage)reader.readFrom(buffer);
        byte[] testReportMsg = new byte[]{0};
        MatcherAssert.assertThat((Object)message, (Matcher)Matchers.instanceOf(PcepTEReportMsg.class));
        ChannelBuffer buf = ChannelBuffers.dynamicBuffer();
        message.writeTo(buf);
        int readLen = buf.writerIndex();
        testReportMsg = new byte[readLen];
        buf.readBytes(testReportMsg, 0, readLen);
        MatcherAssert.assertThat((Object)testReportMsg, (Matcher)Is.is((Object)teReportMsg));
    }

    @Test
    public void teReportMessageTest4() throws PcepParseException {
        byte[] teReportMsg = new byte[]{32, 14, 0, 68, 14, 16, 0, 64, 1, 0, 0, 3, 0, 0, 0, 16, 0, 14, 0, 8, 0, 0, 0, 0, 0, 0, 0, 1, 6, 101, 0, 36, 0, 100, 0, 4, 0, 0, 0, 17, 0, 17, 0, 4, 0, 0, 0, 17, 2, 88, 0, 4, 0, 0, 0, 17, 3, -24, 0, 8, 0, 0, 0, 17, 0, 0, 0, 17};
        ChannelBuffer buffer = ChannelBuffers.dynamicBuffer();
        buffer.writeBytes(teReportMsg);
        PcepMessageReader reader = PcepFactories.getGenericReader();
        PcepMessage message = null;
        message = (PcepMessage)reader.readFrom(buffer);
        byte[] testReportMsg = new byte[]{0};
        MatcherAssert.assertThat((Object)message, (Matcher)Matchers.instanceOf(PcepTEReportMsg.class));
        ChannelBuffer buf = ChannelBuffers.dynamicBuffer();
        message.writeTo(buf);
        int readLen = buf.writerIndex();
        testReportMsg = new byte[readLen];
        buf.readBytes(testReportMsg, 0, readLen);
        MatcherAssert.assertThat((Object)testReportMsg, (Matcher)Is.is((Object)teReportMsg));
    }

    @Test
    public void teReportMessageTest5() throws PcepParseException {
        byte[] teReportMsg = new byte[]{32, 14, 0, 60, 14, 16, 0, 56, 1, 0, 0, 3, 0, 0, 0, 16, 0, 14, 0, 8, 0, 0, 0, 0, 0, 0, 0, 1, 6, 101, 0, 28, 0, 17, 0, 4, 0, 0, 0, 17, 2, 88, 0, 4, 0, 0, 0, 17, 3, -24, 0, 8, 0, 0, 0, 17, 0, 0, 0, 17};
        ChannelBuffer buffer = ChannelBuffers.dynamicBuffer();
        buffer.writeBytes(teReportMsg);
        PcepMessageReader reader = PcepFactories.getGenericReader();
        PcepMessage message = null;
        message = (PcepMessage)reader.readFrom(buffer);
        byte[] testReportMsg = new byte[]{0};
        MatcherAssert.assertThat((Object)message, (Matcher)Matchers.instanceOf(PcepTEReportMsg.class));
        ChannelBuffer buf = ChannelBuffers.dynamicBuffer();
        message.writeTo(buf);
        int readLen = buf.writerIndex();
        testReportMsg = new byte[readLen];
        buf.readBytes(testReportMsg, 0, readLen);
        MatcherAssert.assertThat((Object)testReportMsg, (Matcher)Is.is((Object)teReportMsg));
    }

    @Test
    public void teReportMessageTest6() throws PcepParseException {
        byte[] teReportMsg = new byte[]{32, 14, 0, 52, 14, 16, 0, 48, 1, 0, 0, 3, 0, 0, 0, 16, 0, 14, 0, 8, 0, 0, 0, 0, 0, 0, 0, 1, 6, 101, 0, 20, 2, 88, 0, 4, 0, 0, 0, 17, 3, -24, 0, 8, 0, 0, 0, 17, 0, 0, 0, 17};
        ChannelBuffer buffer = ChannelBuffers.dynamicBuffer();
        buffer.writeBytes(teReportMsg);
        PcepMessageReader reader = PcepFactories.getGenericReader();
        PcepMessage message = null;
        message = (PcepMessage)reader.readFrom(buffer);
        byte[] testReportMsg = new byte[]{0};
        MatcherAssert.assertThat((Object)message, (Matcher)Matchers.instanceOf(PcepTEReportMsg.class));
        ChannelBuffer buf = ChannelBuffers.dynamicBuffer();
        message.writeTo(buf);
        int readLen = buf.writerIndex();
        testReportMsg = new byte[readLen];
        buf.readBytes(testReportMsg, 0, readLen);
        MatcherAssert.assertThat((Object)testReportMsg, (Matcher)Is.is((Object)teReportMsg));
    }

    @Test
    public void teReportMessageTest7() throws PcepParseException {
        byte[] teReportMsg = new byte[]{32, 14, 0, 44, 14, 16, 0, 40, 1, 0, 0, 3, 0, 0, 0, 16, 0, 14, 0, 8, 0, 0, 0, 0, 0, 0, 0, 1, 6, 101, 0, 12, 3, -24, 0, 8, 0, 0, 0, 17, 0, 0, 0, 17};
        ChannelBuffer buffer = ChannelBuffers.dynamicBuffer();
        buffer.writeBytes(teReportMsg);
        PcepMessageReader reader = PcepFactories.getGenericReader();
        PcepMessage message = null;
        message = (PcepMessage)reader.readFrom(buffer);
        byte[] testReportMsg = new byte[]{0};
        MatcherAssert.assertThat((Object)message, (Matcher)Matchers.instanceOf(PcepTEReportMsg.class));
        ChannelBuffer buf = ChannelBuffers.dynamicBuffer();
        message.writeTo(buf);
        int readLen = buf.writerIndex();
        testReportMsg = new byte[readLen];
        buf.readBytes(testReportMsg, 0, readLen);
        MatcherAssert.assertThat((Object)testReportMsg, (Matcher)Is.is((Object)teReportMsg));
    }

    @Test
    public void teReportMessageTest8() throws PcepParseException {
        byte[] teReportMsg = new byte[]{32, 14, 0, 32, 14, 16, 0, 28, 1, 0, 0, 3, 0, 0, 0, 16, 0, 14, 0, 8, 0, 0, 0, 0, 0, 0, 0, 1, 6, 101, 0, 0};
        ChannelBuffer buffer = ChannelBuffers.dynamicBuffer();
        buffer.writeBytes(teReportMsg);
        PcepMessageReader reader = PcepFactories.getGenericReader();
        PcepMessage message = null;
        message = (PcepMessage)reader.readFrom(buffer);
        byte[] testReportMsg = new byte[]{0};
        MatcherAssert.assertThat((Object)message, (Matcher)Matchers.instanceOf(PcepTEReportMsg.class));
        ChannelBuffer buf = ChannelBuffers.dynamicBuffer();
        message.writeTo(buf);
        int readLen = buf.writerIndex();
        testReportMsg = new byte[readLen];
        buf.readBytes(testReportMsg, 0, readLen);
        MatcherAssert.assertThat((Object)testReportMsg, (Matcher)Is.is((Object)teReportMsg));
    }

    @Test
    public void teReportMessageTest9() throws PcepParseException {
        byte[] teReportMsg = new byte[]{32, 14, 0, 108, 14, 16, 0, 104, 1, 0, 0, 3, 0, 0, 0, 16, 0, 14, 0, 8, 0, 0, 0, 0, 0, 0, 0, 1, 6, 101, 0, 36, 0, 100, 0, 4, 0, 0, 0, 17, 0, 17, 0, 4, 0, 0, 0, 17, 2, 88, 0, 4, 0, 0, 0, 17, 3, -24, 0, 8, 0, 0, 0, 17, 0, 0, 0, 17, 3, -21, 0, 36, 0, 100, 0, 4, 0, 0, 0, 17, 0, 17, 0, 4, 0, 0, 0, 17, 2, 88, 0, 4, 0, 0, 0, 17, 3, -24, 0, 8, 0, 0, 0, 17, 0, 0, 0, 17};
        ChannelBuffer buffer = ChannelBuffers.dynamicBuffer();
        buffer.writeBytes(teReportMsg);
        PcepMessageReader reader = PcepFactories.getGenericReader();
        PcepMessage message = null;
        message = (PcepMessage)reader.readFrom(buffer);
        byte[] testReportMsg = new byte[]{0};
        MatcherAssert.assertThat((Object)message, (Matcher)Matchers.instanceOf(PcepTEReportMsg.class));
        ChannelBuffer buf = ChannelBuffers.dynamicBuffer();
        message.writeTo(buf);
        int readLen = buf.writerIndex();
        testReportMsg = new byte[readLen];
        buf.readBytes(testReportMsg, 0, readLen);
        MatcherAssert.assertThat((Object)testReportMsg, (Matcher)Is.is((Object)teReportMsg));
    }

    @Test
    public void teReportMessageTest10() throws PcepParseException {
        byte[] teReportMsg = new byte[]{32, 14, 0, 100, 14, 16, 0, 96, 1, 0, 0, 3, 0, 0, 0, 16, 0, 14, 0, 8, 0, 0, 0, 0, 0, 0, 0, 1, 6, 101, 0, 36, 0, 100, 0, 4, 0, 0, 0, 17, 0, 17, 0, 4, 0, 0, 0, 17, 2, 88, 0, 4, 0, 0, 0, 17, 3, -24, 0, 8, 0, 0, 0, 17, 0, 0, 0, 17, 3, -21, 0, 28, 0, 17, 0, 4, 0, 0, 0, 17, 2, 88, 0, 4, 0, 0, 0, 17, 3, -24, 0, 8, 0, 0, 0, 17, 0, 0, 0, 17};
        ChannelBuffer buffer = ChannelBuffers.dynamicBuffer();
        buffer.writeBytes(teReportMsg);
        PcepMessageReader reader = PcepFactories.getGenericReader();
        PcepMessage message = null;
        message = (PcepMessage)reader.readFrom(buffer);
        byte[] testReportMsg = new byte[]{0};
        MatcherAssert.assertThat((Object)message, (Matcher)Matchers.instanceOf(PcepTEReportMsg.class));
        ChannelBuffer buf = ChannelBuffers.dynamicBuffer();
        message.writeTo(buf);
        int readLen = buf.writerIndex();
        testReportMsg = new byte[readLen];
        buf.readBytes(testReportMsg, 0, readLen);
        MatcherAssert.assertThat((Object)testReportMsg, (Matcher)Is.is((Object)teReportMsg));
    }

    @Test
    public void teReportMessageTest11() throws PcepParseException {
        byte[] teReportMsg = new byte[]{32, 14, 0, 92, 14, 16, 0, 88, 1, 0, 0, 3, 0, 0, 0, 16, 0, 14, 0, 8, 0, 0, 0, 0, 0, 0, 0, 1, 6, 101, 0, 36, 0, 100, 0, 4, 0, 0, 0, 17, 0, 17, 0, 4, 0, 0, 0, 17, 2, 88, 0, 4, 0, 0, 0, 17, 3, -24, 0, 8, 0, 0, 0, 17, 0, 0, 0, 17, 3, -21, 0, 20, 2, 88, 0, 4, 0, 0, 0, 17, 3, -24, 0, 8, 0, 0, 0, 17, 0, 0, 0, 17};
        ChannelBuffer buffer = ChannelBuffers.dynamicBuffer();
        buffer.writeBytes(teReportMsg);
        PcepMessageReader reader = PcepFactories.getGenericReader();
        PcepMessage message = null;
        message = (PcepMessage)reader.readFrom(buffer);
        byte[] testReportMsg = new byte[]{0};
        MatcherAssert.assertThat((Object)message, (Matcher)Matchers.instanceOf(PcepTEReportMsg.class));
        ChannelBuffer buf = ChannelBuffers.dynamicBuffer();
        message.writeTo(buf);
        int readLen = buf.writerIndex();
        testReportMsg = new byte[readLen];
        buf.readBytes(testReportMsg, 0, readLen);
        MatcherAssert.assertThat((Object)testReportMsg, (Matcher)Is.is((Object)teReportMsg));
    }

    @Test
    public void teReportMessageTest12() throws PcepParseException {
        byte[] teReportMsg = new byte[]{32, 14, 0, 84, 14, 16, 0, 80, 1, 0, 0, 3, 0, 0, 0, 16, 0, 14, 0, 8, 0, 0, 0, 0, 0, 0, 0, 1, 6, 101, 0, 36, 0, 100, 0, 4, 0, 0, 0, 17, 0, 17, 0, 4, 0, 0, 0, 17, 2, 88, 0, 4, 0, 0, 0, 17, 3, -24, 0, 8, 0, 0, 0, 17, 0, 0, 0, 17, 3, -21, 0, 12, 3, -24, 0, 8, 0, 0, 0, 17, 0, 0, 0, 17};
        ChannelBuffer buffer = ChannelBuffers.dynamicBuffer();
        buffer.writeBytes(teReportMsg);
        PcepMessageReader reader = PcepFactories.getGenericReader();
        PcepMessage message = null;
        message = (PcepMessage)reader.readFrom(buffer);
        byte[] testReportMsg = new byte[]{0};
        MatcherAssert.assertThat((Object)message, (Matcher)Matchers.instanceOf(PcepTEReportMsg.class));
        ChannelBuffer buf = ChannelBuffers.dynamicBuffer();
        message.writeTo(buf);
        int readLen = buf.writerIndex();
        testReportMsg = new byte[readLen];
        buf.readBytes(testReportMsg, 0, readLen);
        MatcherAssert.assertThat((Object)testReportMsg, (Matcher)Is.is((Object)teReportMsg));
    }

    @Test
    public void teReportMessageTest13() throws PcepParseException {
        byte[] teReportMsg = new byte[]{32, 14, 0, 72, 14, 16, 0, 68, 1, 0, 0, 3, 0, 0, 0, 16, 0, 14, 0, 8, 0, 0, 0, 0, 0, 0, 0, 1, 6, 101, 0, 36, 0, 100, 0, 4, 0, 0, 0, 17, 0, 17, 0, 4, 0, 0, 0, 17, 2, 88, 0, 4, 0, 0, 0, 17, 3, -24, 0, 8, 0, 0, 0, 17, 0, 0, 0, 17, 3, -21, 0, 0};
        ChannelBuffer buffer = ChannelBuffers.dynamicBuffer();
        buffer.writeBytes(teReportMsg);
        PcepMessageReader reader = PcepFactories.getGenericReader();
        PcepMessage message = null;
        message = (PcepMessage)reader.readFrom(buffer);
        byte[] testReportMsg = new byte[]{0};
        MatcherAssert.assertThat((Object)message, (Matcher)Matchers.instanceOf(PcepTEReportMsg.class));
        ChannelBuffer buf = ChannelBuffers.dynamicBuffer();
        message.writeTo(buf);
        int readLen = buf.writerIndex();
        testReportMsg = new byte[readLen];
        buf.readBytes(testReportMsg, 0, readLen);
        MatcherAssert.assertThat((Object)testReportMsg, (Matcher)Is.is((Object)teReportMsg));
    }

    @Test
    public void teReportMessageTest14() throws PcepParseException {
        byte[] teReportMsg = new byte[]{32, 14, 0, -116, 14, 16, 0, -120, 1, 0, 0, 3, 0, 0, 0, 16, 0, 14, 0, 8, 0, 0, 0, 0, 0, 0, 0, 1, 6, 101, 0, 36, 0, 100, 0, 4, 0, 0, 0, 17, 0, 17, 0, 4, 0, 0, 0, 17, 2, 88, 0, 4, 0, 0, 0, 17, 3, -24, 0, 8, 0, 0, 0, 17, 0, 0, 0, 17, 3, -21, 0, 36, 0, 100, 0, 4, 0, 0, 0, 17, 0, 17, 0, 4, 0, 0, 0, 17, 2, 88, 0, 4, 0, 0, 0, 17, 3, -24, 0, 8, 0, 0, 0, 17, 0, 0, 0, 17, 4, 46, 0, 28, 0, 4, 0, 8, 1, 17, 0, 9, 1, 33, 0, 9, 0, 6, 0, 4, 1, 1, 1, 1, 0, 8, 0, 4, 1, 17, 1, 16};
        ChannelBuffer buffer = ChannelBuffers.dynamicBuffer();
        buffer.writeBytes(teReportMsg);
        PcepMessageReader reader = PcepFactories.getGenericReader();
        PcepMessage message = null;
        message = (PcepMessage)reader.readFrom(buffer);
        byte[] testReportMsg = new byte[]{0};
        MatcherAssert.assertThat((Object)message, (Matcher)Matchers.instanceOf(PcepTEReportMsg.class));
        ChannelBuffer buf = ChannelBuffers.dynamicBuffer();
        message.writeTo(buf);
        int readLen = buf.writerIndex();
        testReportMsg = new byte[readLen];
        buf.readBytes(testReportMsg, 0, readLen);
        MatcherAssert.assertThat((Object)testReportMsg, (Matcher)Is.is((Object)teReportMsg));
    }

    @Test
    public void teReportMessageTest15() throws PcepParseException {
        byte[] teReportMsg = new byte[]{32, 14, 0, -128, 14, 16, 0, 124, 1, 0, 0, 3, 0, 0, 0, 16, 0, 14, 0, 8, 0, 0, 0, 0, 0, 0, 0, 1, 6, 101, 0, 36, 0, 100, 0, 4, 0, 0, 0, 17, 0, 17, 0, 4, 0, 0, 0, 17, 2, 88, 0, 4, 0, 0, 0, 17, 3, -24, 0, 8, 0, 0, 0, 17, 0, 0, 0, 17, 3, -21, 0, 36, 0, 100, 0, 4, 0, 0, 0, 17, 0, 17, 0, 4, 0, 0, 0, 17, 2, 88, 0, 4, 0, 0, 0, 17, 3, -24, 0, 8, 0, 0, 0, 17, 0, 0, 0, 17, 4, 46, 0, 16, 0, 6, 0, 4, 1, 1, 1, 1, 0, 8, 0, 4, 1, 17, 1, 16};
        ChannelBuffer buffer = ChannelBuffers.dynamicBuffer();
        buffer.writeBytes(teReportMsg);
        PcepMessageReader reader = PcepFactories.getGenericReader();
        PcepMessage message = null;
        message = (PcepMessage)reader.readFrom(buffer);
        byte[] testReportMsg = new byte[]{0};
        MatcherAssert.assertThat((Object)message, (Matcher)Matchers.instanceOf(PcepTEReportMsg.class));
        ChannelBuffer buf = ChannelBuffers.dynamicBuffer();
        message.writeTo(buf);
        int readLen = buf.writerIndex();
        testReportMsg = new byte[readLen];
        buf.readBytes(testReportMsg, 0, readLen);
        MatcherAssert.assertThat((Object)testReportMsg, (Matcher)Is.is((Object)teReportMsg));
    }

    @Test
    public void teReportMessageTest16() throws PcepParseException {
        byte[] teReportMsg = new byte[]{32, 14, 0, 120, 14, 16, 0, 116, 1, 0, 0, 3, 0, 0, 0, 16, 0, 14, 0, 8, 0, 0, 0, 0, 0, 0, 0, 1, 6, 101, 0, 36, 0, 100, 0, 4, 0, 0, 0, 17, 0, 17, 0, 4, 0, 0, 0, 17, 2, 88, 0, 4, 0, 0, 0, 17, 3, -24, 0, 8, 0, 0, 0, 17, 0, 0, 0, 17, 3, -21, 0, 36, 0, 100, 0, 4, 0, 0, 0, 17, 0, 17, 0, 4, 0, 0, 0, 17, 2, 88, 0, 4, 0, 0, 0, 17, 3, -24, 0, 8, 0, 0, 0, 17, 0, 0, 0, 17, 4, 46, 0, 8, 0, 8, 0, 4, 1, 17, 1, 16};
        ChannelBuffer buffer = ChannelBuffers.dynamicBuffer();
        buffer.writeBytes(teReportMsg);
        PcepMessageReader reader = PcepFactories.getGenericReader();
        PcepMessage message = null;
        message = (PcepMessage)reader.readFrom(buffer);
        byte[] testReportMsg = new byte[]{0};
        MatcherAssert.assertThat((Object)message, (Matcher)Matchers.instanceOf(PcepTEReportMsg.class));
        ChannelBuffer buf = ChannelBuffers.dynamicBuffer();
        message.writeTo(buf);
        int readLen = buf.writerIndex();
        testReportMsg = new byte[readLen];
        buf.readBytes(testReportMsg, 0, readLen);
        MatcherAssert.assertThat((Object)testReportMsg, (Matcher)Is.is((Object)teReportMsg));
    }

    @Test
    public void teReportMessageTest17() throws PcepParseException {
        byte[] teReportMsg = new byte[]{32, 14, 0, 112, 14, 16, 0, 108, 1, 0, 0, 3, 0, 0, 0, 16, 0, 14, 0, 8, 0, 0, 0, 0, 0, 0, 0, 1, 6, 101, 0, 36, 0, 100, 0, 4, 0, 0, 0, 17, 0, 17, 0, 4, 0, 0, 0, 17, 2, 88, 0, 4, 0, 0, 0, 17, 3, -24, 0, 8, 0, 0, 0, 17, 0, 0, 0, 17, 3, -21, 0, 36, 0, 100, 0, 4, 0, 0, 0, 17, 0, 17, 0, 4, 0, 0, 0, 17, 2, 88, 0, 4, 0, 0, 0, 17, 3, -24, 0, 8, 0, 0, 0, 17, 0, 0, 0, 17, 4, 46, 0, 0};
        ChannelBuffer buffer = ChannelBuffers.dynamicBuffer();
        buffer.writeBytes(teReportMsg);
        PcepMessageReader reader = PcepFactories.getGenericReader();
        PcepMessage message = null;
        message = (PcepMessage)reader.readFrom(buffer);
        byte[] testReportMsg = new byte[]{0};
        MatcherAssert.assertThat((Object)message, (Matcher)Matchers.instanceOf(PcepTEReportMsg.class));
        ChannelBuffer buf = ChannelBuffers.dynamicBuffer();
        message.writeTo(buf);
        int readLen = buf.writerIndex();
        testReportMsg = new byte[readLen];
        buf.readBytes(testReportMsg, 0, readLen);
        MatcherAssert.assertThat((Object)testReportMsg, (Matcher)Is.is((Object)teReportMsg));
    }

    @Test
    public void teReportMessageTest18() throws PcepParseException {
        byte[] teReportMsg = new byte[]{32, 14, 0, -64, 14, 16, 0, -68, 1, 0, 0, 3, 0, 0, 0, 16, 0, 14, 0, 8, 0, 0, 0, 0, 0, 0, 0, 1, 6, 101, 0, 36, 0, 100, 0, 4, 0, 0, 0, 17, 0, 17, 0, 4, 0, 0, 0, 17, 2, 88, 0, 4, 0, 0, 0, 17, 3, -24, 0, 8, 0, 0, 0, 17, 0, 0, 0, 17, 3, -21, 0, 36, 0, 100, 0, 4, 0, 0, 0, 17, 0, 17, 0, 4, 0, 0, 0, 17, 2, 88, 0, 4, 0, 0, 0, 17, 3, -24, 0, 8, 0, 0, 0, 17, 0, 0, 0, 17, 4, 46, 0, 28, 0, 4, 0, 8, 1, 17, 0, 9, 1, 33, 0, 9, 0, 6, 0, 4, 1, 1, 1, 1, 0, 8, 0, 4, 1, 17, 1, 16, 4, -13, 0, 48, 0, 14, 0, 1, -112, 0, 0, 0, 3, -23, 0, 4, 1, 17, 1, 16, 3, -17, 0, 8, 8, 0, 1, 9, 8, 0, 1, 9, 0, 107, 0, 8, 32, 1, 34, 1, 32, 1, 34, 1, 0, -122, 0, 4, 0, 1, 1, 2};
        ChannelBuffer buffer = ChannelBuffers.dynamicBuffer();
        buffer.writeBytes(teReportMsg);
        PcepMessageReader reader = PcepFactories.getGenericReader();
        PcepMessage message = null;
        message = (PcepMessage)reader.readFrom(buffer);
        byte[] testReportMsg = new byte[]{0};
        MatcherAssert.assertThat((Object)message, (Matcher)Matchers.instanceOf(PcepTEReportMsg.class));
        ChannelBuffer buf = ChannelBuffers.dynamicBuffer();
        message.writeTo(buf);
        int readLen = buf.writerIndex();
        testReportMsg = new byte[readLen];
        buf.readBytes(testReportMsg, 0, readLen);
        MatcherAssert.assertThat((Object)testReportMsg, (Matcher)Is.is((Object)teReportMsg));
    }

    @Test
    public void teReportMessageTest19() throws PcepParseException {
        byte[] teReportMsg = new byte[]{32, 14, 0, -64, 14, 16, 0, -68, 1, 0, 0, 3, 0, 0, 0, 16, 0, 14, 0, 8, 0, 0, 0, 0, 0, 0, 0, 1, 6, 101, 0, 36, 0, 100, 0, 4, 0, 0, 0, 17, 0, 17, 0, 4, 0, 0, 0, 17, 2, 88, 0, 4, 0, 0, 0, 17, 3, -24, 0, 8, 0, 0, 0, 17, 0, 0, 0, 17, 3, -21, 0, 36, 0, 100, 0, 4, 0, 0, 0, 17, 0, 17, 0, 4, 0, 0, 0, 17, 2, 88, 0, 4, 0, 0, 0, 17, 3, -24, 0, 8, 0, 0, 0, 17, 0, 0, 0, 17, 4, 46, 0, 28, 0, 4, 0, 8, 1, 17, 0, 9, 1, 33, 0, 9, 0, 6, 0, 4, 1, 1, 1, 1, 0, 8, 0, 4, 1, 17, 1, 16, 4, -13, 0, 48, 0, 14, 0, 1, -112, 0, 0, 0, 3, -23, 0, 4, 1, 17, 1, 16, 3, -17, 0, 8, 8, 0, 1, 9, 8, 0, 1, 9, 0, 107, 0, 8, 32, 1, 34, 1, 32, 1, 34, 1, 0, -122, 0, 4, 0, 1, 1, 2};
        ChannelBuffer buffer = ChannelBuffers.dynamicBuffer();
        buffer.writeBytes(teReportMsg);
        PcepMessageReader reader = PcepFactories.getGenericReader();
        PcepMessage message = null;
        message = (PcepMessage)reader.readFrom(buffer);
        byte[] testReportMsg = new byte[]{0};
        MatcherAssert.assertThat((Object)message, (Matcher)Matchers.instanceOf(PcepTEReportMsg.class));
        ChannelBuffer buf = ChannelBuffers.dynamicBuffer();
        message.writeTo(buf);
        int readLen = buf.writerIndex();
        testReportMsg = new byte[readLen];
        buf.readBytes(testReportMsg, 0, readLen);
        MatcherAssert.assertThat((Object)testReportMsg, (Matcher)Is.is((Object)teReportMsg));
    }

    @Test
    public void teReportMessageTest20() throws PcepParseException {
        byte[] teReportMsg = new byte[]{32, 14, 0, -72, 14, 16, 0, -76, 1, 0, 0, 3, 0, 0, 0, 16, 0, 14, 0, 8, 0, 0, 0, 0, 0, 0, 0, 1, 6, 101, 0, 36, 0, 100, 0, 4, 0, 0, 0, 17, 0, 17, 0, 4, 0, 0, 0, 17, 2, 88, 0, 4, 0, 0, 0, 17, 3, -24, 0, 8, 0, 0, 0, 17, 0, 0, 0, 17, 3, -21, 0, 36, 0, 100, 0, 4, 0, 0, 0, 17, 0, 17, 0, 4, 0, 0, 0, 17, 2, 88, 0, 4, 0, 0, 0, 17, 3, -24, 0, 8, 0, 0, 0, 17, 0, 0, 0, 17, 4, 46, 0, 28, 0, 4, 0, 8, 1, 17, 0, 9, 1, 33, 0, 9, 0, 6, 0, 4, 1, 1, 1, 1, 0, 8, 0, 4, 1, 17, 1, 16, 4, -13, 0, 40, 3, -23, 0, 4, 1, 17, 1, 16, 3, -17, 0, 8, 8, 0, 1, 9, 8, 0, 1, 9, 0, 107, 0, 8, 32, 1, 34, 1, 32, 1, 34, 1, 0, -122, 0, 4, 0, 1, 1, 2};
        ChannelBuffer buffer = ChannelBuffers.dynamicBuffer();
        buffer.writeBytes(teReportMsg);
        PcepMessageReader reader = PcepFactories.getGenericReader();
        PcepMessage message = null;
        message = (PcepMessage)reader.readFrom(buffer);
        byte[] testReportMsg = new byte[]{0};
        MatcherAssert.assertThat((Object)message, (Matcher)Matchers.instanceOf(PcepTEReportMsg.class));
        ChannelBuffer buf = ChannelBuffers.dynamicBuffer();
        message.writeTo(buf);
        int readLen = buf.writerIndex();
        testReportMsg = new byte[readLen];
        buf.readBytes(testReportMsg, 0, readLen);
        MatcherAssert.assertThat((Object)testReportMsg, (Matcher)Is.is((Object)teReportMsg));
    }

    @Test
    public void teReportMessageTest21() throws PcepParseException {
        byte[] teReportMsg = new byte[]{32, 14, 0, -84, 14, 16, 0, -88, 1, 0, 0, 3, 0, 0, 0, 16, 0, 14, 0, 8, 0, 0, 0, 0, 0, 0, 0, 1, 6, 101, 0, 36, 0, 100, 0, 4, 0, 0, 0, 17, 0, 17, 0, 4, 0, 0, 0, 17, 2, 88, 0, 4, 0, 0, 0, 17, 3, -24, 0, 8, 0, 0, 0, 17, 0, 0, 0, 17, 3, -21, 0, 36, 0, 100, 0, 4, 0, 0, 0, 17, 0, 17, 0, 4, 0, 0, 0, 17, 2, 88, 0, 4, 0, 0, 0, 17, 3, -24, 0, 8, 0, 0, 0, 17, 0, 0, 0, 17, 4, 46, 0, 28, 0, 4, 0, 8, 1, 17, 0, 9, 1, 33, 0, 9, 0, 6, 0, 4, 1, 1, 1, 1, 0, 8, 0, 4, 1, 17, 1, 16, 4, -13, 0, 28, 3, -23, 0, 4, 1, 17, 1, 16, 0, 107, 0, 8, 32, 1, 34, 1, 32, 1, 34, 1, 0, -122, 0, 4, 0, 1, 1, 2};
        ChannelBuffer buffer = ChannelBuffers.dynamicBuffer();
        buffer.writeBytes(teReportMsg);
        PcepMessageReader reader = PcepFactories.getGenericReader();
        PcepMessage message = null;
        message = (PcepMessage)reader.readFrom(buffer);
        byte[] testReportMsg = new byte[]{0};
        MatcherAssert.assertThat((Object)message, (Matcher)Matchers.instanceOf(PcepTEReportMsg.class));
        ChannelBuffer buf = ChannelBuffers.dynamicBuffer();
        message.writeTo(buf);
        int readLen = buf.writerIndex();
        testReportMsg = new byte[readLen];
        buf.readBytes(testReportMsg, 0, readLen);
        MatcherAssert.assertThat((Object)testReportMsg, (Matcher)Is.is((Object)teReportMsg));
    }

    @Test
    public void teReportMessageTest22() throws PcepParseException {
        byte[] teReportMsg = new byte[]{32, 14, 1, 32, 14, 16, 1, 28, 1, 0, 0, 3, 0, 0, 0, 16, 0, 14, 0, 8, 0, 0, 0, 0, 0, 0, 0, 1, 6, 101, 0, 36, 0, 100, 0, 4, 0, 0, 0, 17, 0, 17, 0, 4, 0, 0, 0, 17, 2, 88, 0, 4, 0, 0, 0, 17, 3, -24, 0, 8, 0, 0, 0, 17, 0, 0, 0, 17, 3, -21, 0, 36, 0, 100, 0, 4, 0, 0, 0, 17, 0, 17, 0, 4, 0, 0, 0, 17, 2, 88, 0, 4, 0, 0, 0, 17, 3, -24, 0, 8, 0, 0, 0, 17, 0, 0, 0, 17, 4, 46, 0, 28, 0, 4, 0, 8, 1, 17, 0, 9, 1, 33, 0, 9, 0, 6, 0, 4, 1, 1, 1, 1, 0, 8, 0, 4, 1, 17, 1, 16, 4, -13, 0, 40, 3, -23, 0, 4, 1, 17, 1, 16, 3, -17, 0, 8, 8, 0, 1, 9, 8, 0, 1, 9, 0, 107, 0, 8, 32, 1, 34, 1, 32, 1, 34, 1, 0, -122, 0, 4, 0, 1, 1, 2, 7, 105, 0, 100, 5, 60, 0, 4, 0, 7, 8, 0, 0, 3, 0, 4, 0, 9, 8, 0, 0, 9, 0, 4, 0, 9, 0, 0, 0, 10, 0, 4, 0, 16, 0, 0, 0, 11, 0, 4, 0, 0, -112, 0, 52, 88, 0, 4, 0, -103, 9, 0, 0, 20, 0, 2, 9, 0, 0, 0, 4, 70, 0, 1, -128, 0, 0, 0, 4, 71, 0, 3, 9, -119, 7, 0, 4, 72, 0, 8, 4, 71, 0, 3, 4, 71, 0, 3, 4, 73, 0, 4, 4, 71, 0, 3, 4, 74, 0, 4, 4, 71, 0, 3};
        ChannelBuffer buffer = ChannelBuffers.dynamicBuffer();
        buffer.writeBytes(teReportMsg);
        PcepMessageReader reader = PcepFactories.getGenericReader();
        PcepMessage message = null;
        message = (PcepMessage)reader.readFrom(buffer);
        byte[] testReportMsg = new byte[]{0};
        MatcherAssert.assertThat((Object)message, (Matcher)Matchers.instanceOf(PcepTEReportMsg.class));
        ChannelBuffer buf = ChannelBuffers.dynamicBuffer();
        message.writeTo(buf);
        int readLen = buf.writerIndex();
        testReportMsg = new byte[readLen];
        buf.readBytes(testReportMsg, 0, readLen);
        MatcherAssert.assertThat((Object)testReportMsg, (Matcher)Is.is((Object)teReportMsg));
    }

    @Test
    public void teReportMessageTest23() throws PcepParseException {
        byte[] teReportMsg = new byte[]{32, 14, 1, 24, 14, 16, 1, 20, 1, 0, 0, 3, 0, 0, 0, 16, 0, 14, 0, 8, 0, 0, 0, 0, 0, 0, 0, 1, 6, 101, 0, 36, 0, 100, 0, 4, 0, 0, 0, 17, 0, 17, 0, 4, 0, 0, 0, 17, 2, 88, 0, 4, 0, 0, 0, 17, 3, -24, 0, 8, 0, 0, 0, 17, 0, 0, 0, 17, 3, -21, 0, 36, 0, 100, 0, 4, 0, 0, 0, 17, 0, 17, 0, 4, 0, 0, 0, 17, 2, 88, 0, 4, 0, 0, 0, 17, 3, -24, 0, 8, 0, 0, 0, 17, 0, 0, 0, 17, 4, 46, 0, 28, 0, 4, 0, 8, 1, 17, 0, 9, 1, 33, 0, 9, 0, 6, 0, 4, 1, 1, 1, 1, 0, 8, 0, 4, 1, 17, 1, 16, 4, -13, 0, 40, 3, -23, 0, 4, 1, 17, 1, 16, 3, -17, 0, 8, 8, 0, 1, 9, 8, 0, 1, 9, 0, 107, 0, 8, 32, 1, 34, 1, 32, 1, 34, 1, 0, -122, 0, 4, 0, 1, 1, 2, 7, 105, 0, 92, 5, 60, 0, 4, 0, 7, 8, 0, 0, 3, 0, 4, 0, 9, 8, 0, 0, 9, 0, 4, 0, 9, 0, 0, 0, 10, 0, 4, 0, 16, 0, 0, 0, 11, 0, 4, 0, 0, -112, 0, 52, 88, 0, 4, 0, -103, 9, 0, 0, 20, 0, 2, 9, 0, 0, 0, 4, 70, 0, 1, -128, 0, 0, 0, 4, 71, 0, 3, 9, -119, 7, 0, 4, 72, 0, 8, 4, 71, 0, 3, 4, 71, 0, 3, 4, 73, 0, 4, 4, 71, 0, 3};
        ChannelBuffer buffer = ChannelBuffers.dynamicBuffer();
        buffer.writeBytes(teReportMsg);
        PcepMessageReader reader = PcepFactories.getGenericReader();
        PcepMessage message = null;
        message = (PcepMessage)reader.readFrom(buffer);
        byte[] testReportMsg = new byte[]{0};
        MatcherAssert.assertThat((Object)message, (Matcher)Matchers.instanceOf(PcepTEReportMsg.class));
        ChannelBuffer buf = ChannelBuffers.dynamicBuffer();
        message.writeTo(buf);
        int readLen = buf.writerIndex();
        testReportMsg = new byte[readLen];
        buf.readBytes(testReportMsg, 0, readLen);
        MatcherAssert.assertThat((Object)testReportMsg, (Matcher)Is.is((Object)teReportMsg));
    }

    @Test
    public void teReportMessageTest24() throws PcepParseException {
        byte[] teReportMsg = new byte[]{32, 14, 1, 16, 14, 16, 1, 12, 1, 0, 0, 3, 0, 0, 0, 16, 0, 14, 0, 8, 0, 0, 0, 0, 0, 0, 0, 1, 6, 101, 0, 36, 0, 100, 0, 4, 0, 0, 0, 17, 0, 17, 0, 4, 0, 0, 0, 17, 2, 88, 0, 4, 0, 0, 0, 17, 3, -24, 0, 8, 0, 0, 0, 17, 0, 0, 0, 17, 3, -21, 0, 36, 0, 100, 0, 4, 0, 0, 0, 17, 0, 17, 0, 4, 0, 0, 0, 17, 2, 88, 0, 4, 0, 0, 0, 17, 3, -24, 0, 8, 0, 0, 0, 17, 0, 0, 0, 17, 4, 46, 0, 28, 0, 4, 0, 8, 1, 17, 0, 9, 1, 33, 0, 9, 0, 6, 0, 4, 1, 1, 1, 1, 0, 8, 0, 4, 1, 17, 1, 16, 4, -13, 0, 40, 3, -23, 0, 4, 1, 17, 1, 16, 3, -17, 0, 8, 8, 0, 1, 9, 8, 0, 1, 9, 0, 107, 0, 8, 32, 1, 34, 1, 32, 1, 34, 1, 0, -122, 0, 4, 0, 1, 1, 2, 7, 105, 0, 84, 5, 60, 0, 4, 0, 7, 8, 0, 0, 3, 0, 4, 0, 9, 8, 0, 0, 9, 0, 4, 0, 9, 0, 0, 0, 10, 0, 4, 0, 16, 0, 0, 0, 11, 0, 4, 0, 0, -112, 0, 52, 88, 0, 4, 0, -103, 9, 0, 0, 20, 0, 2, 9, 0, 0, 0, 4, 70, 0, 1, -128, 0, 0, 0, 4, 71, 0, 3, 9, -119, 7, 0, 4, 72, 0, 8, 4, 71, 0, 3, 4, 71, 0, 3};
        ChannelBuffer buffer = ChannelBuffers.dynamicBuffer();
        buffer.writeBytes(teReportMsg);
        PcepMessageReader reader = PcepFactories.getGenericReader();
        PcepMessage message = null;
        message = (PcepMessage)reader.readFrom(buffer);
        byte[] testReportMsg = new byte[]{0};
        MatcherAssert.assertThat((Object)message, (Matcher)Matchers.instanceOf(PcepTEReportMsg.class));
        ChannelBuffer buf = ChannelBuffers.dynamicBuffer();
        message.writeTo(buf);
        int readLen = buf.writerIndex();
        testReportMsg = new byte[readLen];
        buf.readBytes(testReportMsg, 0, readLen);
        MatcherAssert.assertThat((Object)testReportMsg, (Matcher)Is.is((Object)teReportMsg));
    }

    @Test
    public void teReportMessageTest25() throws PcepParseException {
        byte[] teReportMsg = new byte[]{32, 14, 1, 4, 14, 16, 1, 0, 1, 0, 0, 3, 0, 0, 0, 16, 0, 14, 0, 8, 0, 0, 0, 0, 0, 0, 0, 1, 6, 101, 0, 36, 0, 100, 0, 4, 0, 0, 0, 17, 0, 17, 0, 4, 0, 0, 0, 17, 2, 88, 0, 4, 0, 0, 0, 17, 3, -24, 0, 8, 0, 0, 0, 17, 0, 0, 0, 17, 3, -21, 0, 36, 0, 100, 0, 4, 0, 0, 0, 17, 0, 17, 0, 4, 0, 0, 0, 17, 2, 88, 0, 4, 0, 0, 0, 17, 3, -24, 0, 8, 0, 0, 0, 17, 0, 0, 0, 17, 4, 46, 0, 28, 0, 4, 0, 8, 1, 17, 0, 9, 1, 33, 0, 9, 0, 6, 0, 4, 1, 1, 1, 1, 0, 8, 0, 4, 1, 17, 1, 16, 4, -13, 0, 40, 3, -23, 0, 4, 1, 17, 1, 16, 3, -17, 0, 8, 8, 0, 1, 9, 8, 0, 1, 9, 0, 107, 0, 8, 32, 1, 34, 1, 32, 1, 34, 1, 0, -122, 0, 4, 0, 1, 1, 2, 7, 105, 0, 72, 5, 60, 0, 4, 0, 7, 8, 0, 0, 3, 0, 4, 0, 9, 8, 0, 0, 9, 0, 4, 0, 9, 0, 0, 0, 10, 0, 4, 0, 16, 0, 0, 0, 11, 0, 4, 0, 0, -112, 0, 52, 88, 0, 4, 0, -103, 9, 0, 0, 20, 0, 2, 9, 0, 0, 0, 4, 70, 0, 1, -128, 0, 0, 0, 4, 71, 0, 3, 9, -119, 7, 0};
        ChannelBuffer buffer = ChannelBuffers.dynamicBuffer();
        buffer.writeBytes(teReportMsg);
        PcepMessageReader reader = PcepFactories.getGenericReader();
        PcepMessage message = null;
        message = (PcepMessage)reader.readFrom(buffer);
        byte[] testReportMsg = new byte[]{0};
        MatcherAssert.assertThat((Object)message, (Matcher)Matchers.instanceOf(PcepTEReportMsg.class));
        ChannelBuffer buf = ChannelBuffers.dynamicBuffer();
        message.writeTo(buf);
        int readLen = buf.writerIndex();
        testReportMsg = new byte[readLen];
        buf.readBytes(testReportMsg, 0, readLen);
        MatcherAssert.assertThat((Object)testReportMsg, (Matcher)Is.is((Object)teReportMsg));
    }
}

