/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.pcepio.protocol.ver1;

import com.google.common.base.MoreObjects;
import java.util.LinkedList;
import java.util.ListIterator;
import org.jboss.netty.buffer.ChannelBuffer;
import org.onosproject.pcepio.exceptions.PcepParseException;
import org.onosproject.pcepio.protocol.PcepError;
import org.onosproject.pcepio.protocol.PcepErrorInfo;
import org.onosproject.pcepio.protocol.PcepErrorObject;
import org.onosproject.pcepio.protocol.PcepRPObject;
import org.onosproject.pcepio.protocol.PcepTEObject;
import org.onosproject.pcepio.protocol.ver1.PcepErrorVer1;
import org.onosproject.pcepio.types.PcepObjectHeader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PcepErrorInfoVer1
implements PcepErrorInfo {
    protected static final Logger log = LoggerFactory.getLogger(PcepErrorInfoVer1.class);
    private LinkedList<PcepError> errList;

    public PcepErrorInfoVer1(LinkedList<PcepRPObject> llRPObjList, LinkedList<PcepTEObject> llTEObjList, LinkedList<PcepErrorObject> llErrObjList) {
        this.errList = new LinkedList();
        if (llErrObjList != null && !llErrObjList.isEmpty()) {
            this.errList.add(new PcepErrorVer1(llRPObjList, llTEObjList, llErrObjList));
        }
    }

    public PcepErrorInfoVer1(LinkedList<PcepError> errll) {
        this.errList = errll;
    }

    @Override
    public boolean isErrorInfoPresent() {
        return !this.errList.isEmpty();
    }

    @Override
    public void read(ChannelBuffer cb) throws PcepParseException {
        while (0 < cb.readableBytes()) {
            cb.markReaderIndex();
            PcepObjectHeader tempObjHeader = PcepObjectHeader.read(cb);
            cb.resetReaderIndex();
            byte yObjClass = tempObjHeader.getObjClass();
            if (yObjClass != 2 && yObjClass != 101 && yObjClass != 13) {
                throw new PcepParseException("Unknown Object is present in PCEP-ERROR. Object Class: " + yObjClass);
            }
            this.errList.add(PcepErrorVer1.read(cb));
        }
    }

    @Override
    public void write(ChannelBuffer cb) throws PcepParseException {
        ListIterator listIterator = this.errList.listIterator();
        while (listIterator.hasNext()) {
            LinkedList<PcepTEObject> llTEObjList;
            PcepError pcepError = (PcepError)listIterator.next();
            LinkedList<PcepRPObject> llRPObjList = pcepError.getRPObjList();
            if (llRPObjList != null) {
                ListIterator rpListIterator = llRPObjList.listIterator();
                while (rpListIterator.hasNext()) {
                    ((PcepRPObject)rpListIterator.next()).write(cb);
                }
            }
            if ((llTEObjList = pcepError.getTEObjList()) != null) {
                ListIterator teListIterator = llTEObjList.listIterator();
                while (teListIterator.hasNext()) {
                    ((PcepTEObject)teListIterator.next()).write(cb);
                }
            }
            boolean bIsErrorObjListFound = false;
            LinkedList<PcepErrorObject> llErrObjList = pcepError.getErrorObjList();
            if (llErrObjList != null) {
                ListIterator errObjListIterator = llErrObjList.listIterator();
                while (errObjListIterator.hasNext()) {
                    ((PcepErrorObject)errObjListIterator.next()).write(cb);
                    bIsErrorObjListFound = true;
                }
            }
            if (bIsErrorObjListFound) continue;
            throw new PcepParseException("<error-obj-list> is mandatory.");
        }
    }

    @Override
    public LinkedList<Integer> getErrorType() {
        LinkedList<Integer> errorType = new LinkedList<Integer>();
        ListIterator listIterator = this.errList.listIterator();
        while (listIterator.hasNext()) {
            PcepError pcepError = (PcepError)listIterator.next();
            LinkedList<PcepErrorObject> llErrObjList = pcepError.getErrorObjList();
            if (llErrObjList == null) continue;
            ListIterator errObjListIterator = llErrObjList.listIterator();
            while (errObjListIterator.hasNext()) {
                PcepErrorObject errObj = (PcepErrorObject)errObjListIterator.next();
                int error = errObj.getErrorType();
                errorType.add(error);
            }
        }
        return errorType;
    }

    @Override
    public LinkedList<Integer> getErrorValue() {
        LinkedList<Integer> errorValue = new LinkedList<Integer>();
        ListIterator listIterator = this.errList.listIterator();
        while (listIterator.hasNext()) {
            PcepError pcepError = (PcepError)listIterator.next();
            LinkedList<PcepErrorObject> llErrObjList = pcepError.getErrorObjList();
            if (llErrObjList == null) continue;
            ListIterator errObjListIterator = llErrObjList.listIterator();
            while (errObjListIterator.hasNext()) {
                PcepErrorObject errObj = (PcepErrorObject)errObjListIterator.next();
                byte error = errObj.getErrorValue();
                errorValue.add(Integer.valueOf(error));
            }
        }
        return errorValue;
    }

    public String toString() {
        return MoreObjects.toStringHelper(this.getClass()).add("ErrorList", this.errList).toString();
    }

    public static class Builder
    implements PcepErrorInfo.Builder {
        private LinkedList<PcepError> errll;

        @Override
        public PcepErrorInfo build() {
            return new PcepErrorInfoVer1(this.errll);
        }

        @Override
        public LinkedList<PcepError> getPcepErrorList() {
            return this.errll;
        }

        @Override
        public Builder setPcepErrorList(LinkedList<PcepError> errll) {
            this.errll = errll;
            return this;
        }
    }
}

