/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.pcepio.protocol.ver1;

import com.google.common.base.MoreObjects;
import java.util.LinkedList;
import java.util.ListIterator;
import org.jboss.netty.buffer.ChannelBuffer;
import org.onosproject.pcepio.exceptions.PcepParseException;
import org.onosproject.pcepio.protocol.PcepError;
import org.onosproject.pcepio.protocol.PcepErrorObject;
import org.onosproject.pcepio.protocol.PcepRPObject;
import org.onosproject.pcepio.protocol.PcepTEObject;
import org.onosproject.pcepio.protocol.ver1.PcepErrorObjectVer1;
import org.onosproject.pcepio.protocol.ver1.PcepRPObjectVer1;
import org.onosproject.pcepio.protocol.ver1.PcepTEObjectVer1;
import org.onosproject.pcepio.types.PcepObjectHeader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PcepErrorVer1
implements PcepError {
    protected static final Logger log = LoggerFactory.getLogger(PcepErrorVer1.class);
    private boolean isErroInfoSet;
    private LinkedList<PcepErrorObject> llErrObjList;
    private LinkedList<PcepRPObject> llRPObjList;
    private LinkedList<PcepTEObject> llTEObjList;
    private boolean isTEObjListSet;
    public static final int OBJECT_HEADER_LENGTH = 4;

    public PcepErrorVer1() {
        this.llRPObjList = null;
        this.llTEObjList = null;
        this.llErrObjList = null;
    }

    public PcepErrorVer1(LinkedList<PcepRPObject> llRPObjList, LinkedList<PcepTEObject> llTEObjList, LinkedList<PcepErrorObject> llErrObjListObjList) {
        this.llRPObjList = llRPObjList;
        this.llTEObjList = llTEObjList;
        this.llErrObjList = llErrObjListObjList;
    }

    public PcepErrorVer1(LinkedList<PcepErrorObject> llErrObjList) {
        this.llRPObjList = null;
        this.llTEObjList = null;
        this.llErrObjList = llErrObjList;
    }

    @Override
    public LinkedList<PcepRPObject> getRPObjList() {
        return this.llRPObjList;
    }

    @Override
    public LinkedList<PcepTEObject> getTEObjList() {
        return this.llTEObjList;
    }

    @Override
    public LinkedList<PcepErrorObject> getErrorObjList() {
        return this.llErrObjList;
    }

    public void parseRPList(ChannelBuffer cb) throws PcepParseException {
        this.llRPObjList = new LinkedList();
        if (cb.readableBytes() < 4) {
            log.debug("Unable to find RP Object");
            return;
        }
        cb.markReaderIndex();
        PcepObjectHeader tempObjHeader = PcepObjectHeader.read(cb);
        cb.resetReaderIndex();
        byte yObjClass = tempObjHeader.getObjClass();
        byte yObjType = tempObjHeader.getObjType();
        while (yObjClass == 2 && yObjType == 1) {
            PcepRPObject rpObj = PcepRPObjectVer1.read(cb);
            this.llRPObjList.add(rpObj);
            if (cb.readableBytes() <= 4) break;
            cb.markReaderIndex();
            tempObjHeader = PcepObjectHeader.read(cb);
            cb.resetReaderIndex();
            yObjClass = tempObjHeader.getObjClass();
            yObjType = tempObjHeader.getObjType();
        }
    }

    public void parseTEList(ChannelBuffer cb) throws PcepParseException {
        this.llTEObjList = new LinkedList();
        if (cb.readableBytes() < 4) {
            log.debug("Unable to find TE Object");
            return;
        }
        cb.markReaderIndex();
        PcepObjectHeader tempObjHeader = PcepObjectHeader.read(cb);
        cb.resetReaderIndex();
        byte yObjClass = tempObjHeader.getObjClass();
        byte yObjType = tempObjHeader.getObjType();
        while (yObjClass == 101 && (yObjType == 1 || yObjType == 2)) {
            PcepTEObject teObj = PcepTEObjectVer1.read(cb);
            this.llTEObjList.add(teObj);
            if (cb.readableBytes() <= 4) break;
            cb.markReaderIndex();
            tempObjHeader = PcepObjectHeader.read(cb);
            cb.resetReaderIndex();
            yObjClass = tempObjHeader.getObjClass();
            yObjType = tempObjHeader.getObjType();
        }
    }

    public void parseErrObjList(ChannelBuffer cb) throws PcepParseException {
        boolean bIsErrorObjFound = false;
        this.llErrObjList = new LinkedList();
        if (cb.readableBytes() < 4) {
            throw new PcepParseException("Unable to find PCEP-ERROR Object");
        }
        cb.markReaderIndex();
        PcepObjectHeader tempObjHeader = PcepObjectHeader.read(cb);
        cb.resetReaderIndex();
        byte yObjClass = tempObjHeader.getObjClass();
        byte yObjType = tempObjHeader.getObjType();
        while (yObjClass == 13 && yObjType == 1) {
            PcepErrorObject errorObject = PcepErrorObjectVer1.read(cb);
            this.llErrObjList.add(errorObject);
            bIsErrorObjFound = true;
            if (cb.readableBytes() <= 4) break;
            cb.markReaderIndex();
            tempObjHeader = PcepObjectHeader.read(cb);
            cb.resetReaderIndex();
            yObjClass = tempObjHeader.getObjClass();
            yObjType = tempObjHeader.getObjType();
        }
        if (!bIsErrorObjFound) {
            throw new PcepParseException("At least one PCEP-ERROR Object should be present.");
        }
    }

    public static PcepErrorVer1 read(ChannelBuffer cb) throws PcepParseException {
        if (cb.readableBytes() < 4) {
            throw new PcepParseException("Unknown Object");
        }
        PcepErrorVer1 pcepError = new PcepErrorVer1();
        cb.markReaderIndex();
        PcepObjectHeader tempObjHeader = PcepObjectHeader.read(cb);
        cb.resetReaderIndex();
        byte yObjClass = tempObjHeader.getObjClass();
        if (yObjClass == 2) {
            log.debug("RP_LIST");
            pcepError.parseRPList(cb);
            yObjClass = PcepErrorVer1.checkNextObject(cb);
        } else if (yObjClass == 101) {
            log.debug("TE_LIST");
            pcepError.parseTEList(cb);
            yObjClass = PcepErrorVer1.checkNextObject(cb);
        }
        if (yObjClass == 13) {
            log.debug("PCEP-ERROR obj list");
            pcepError.parseErrObjList(cb);
            yObjClass = PcepErrorVer1.checkNextObject(cb);
        }
        return pcepError;
    }

    private static byte checkNextObject(ChannelBuffer cb) {
        if (cb.readableBytes() < 4) {
            return 0;
        }
        cb.markReaderIndex();
        PcepObjectHeader tempObjHeader = PcepObjectHeader.read(cb);
        cb.resetReaderIndex();
        return tempObjHeader.getObjClass();
    }

    @Override
    public int write(ChannelBuffer cb) throws PcepParseException {
        int iLenStartIndex = cb.writerIndex();
        if (this.isErroInfoSet) {
            ListIterator rpObjlistIterator = this.llRPObjList.listIterator();
            while (rpObjlistIterator.hasNext()) {
                ((PcepRPObject)rpObjlistIterator.next()).write(cb);
            }
        }
        if (this.isTEObjListSet) {
            ListIterator teObjlistIterator = this.llTEObjList.listIterator();
            while (teObjlistIterator.hasNext()) {
                ((PcepTEObject)teObjlistIterator.next()).write(cb);
            }
        }
        ListIterator errlistIterator = this.llErrObjList.listIterator();
        while (errlistIterator.hasNext()) {
            ((PcepErrorObject)errlistIterator.next()).write(cb);
        }
        return cb.writerIndex() - iLenStartIndex;
    }

    @Override
    public void setRPObjList(LinkedList<PcepRPObject> llRPObjList) {
        this.llRPObjList = llRPObjList;
    }

    @Override
    public void setTEObjList(LinkedList<PcepTEObject> llTEObjList) {
        this.llTEObjList = llTEObjList;
    }

    @Override
    public void setErrorObjList(LinkedList<PcepErrorObject> llErrObjList) {
        this.llErrObjList = llErrObjList;
    }

    public String toString() {
        return MoreObjects.toStringHelper(this.getClass()).omitNullValues().add("RpObjectList", this.llRPObjList).add("TeObjectList", this.llTEObjList).add("ErrorObjectList", this.llErrObjList).toString();
    }

    public static class Builder
    implements PcepError.Builder {
        private LinkedList<PcepRPObject> llRPObjList;
        private LinkedList<PcepTEObject> llTEObjList;
        private LinkedList<PcepErrorObject> llErrObjList;

        @Override
        public PcepError build() {
            return new PcepErrorVer1(this.llRPObjList, this.llTEObjList, this.llErrObjList);
        }

        @Override
        public LinkedList<PcepRPObject> getRPObjList() {
            return this.llRPObjList;
        }

        @Override
        public Builder setRPObjList(LinkedList<PcepRPObject> llRPObjList) {
            this.llRPObjList = llRPObjList;
            return this;
        }

        @Override
        public LinkedList<PcepTEObject> getTEObjList() {
            return this.llTEObjList;
        }

        @Override
        public Builder setTEObjList(LinkedList<PcepTEObject> llTEObjList) {
            this.llTEObjList = llTEObjList;
            return this;
        }

        @Override
        public LinkedList<PcepErrorObject> getErrorObjList() {
            return this.llErrObjList;
        }

        @Override
        public Builder setErrorObjList(LinkedList<PcepErrorObject> llErrObjList) {
            this.llErrObjList = llErrObjList;
            return this;
        }
    }
}

