/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.pcepio.protocol.ver1;

import com.google.common.base.MoreObjects;
import org.jboss.netty.buffer.ChannelBuffer;
import org.onosproject.pcepio.exceptions.PcepParseException;
import org.onosproject.pcepio.protocol.PcepFecObjectIPv6;
import org.onosproject.pcepio.protocol.PcepVersion;
import org.onosproject.pcepio.types.PcepObjectHeader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PcepFecObjectIPv6Ver1
implements PcepFecObjectIPv6 {
    protected static final Logger log = LoggerFactory.getLogger(PcepFecObjectIPv6Ver1.class);
    public static final byte FEC_OBJ_TYPE = 2;
    public static final byte FEC_OBJ_CLASS = 63;
    public static final byte FEC_OBJECT_VERSION = 1;
    public static final short FEC_OBJ_MINIMUM_LENGTH = 20;
    public static final int MINIMUM_COMMON_HEADER_LENGTH = 4;
    public static final int IPV6_ADDRESS_LENGTH = 16;
    static final PcepObjectHeader DEFAULT_FEC_OBJECT_HEADER = new PcepObjectHeader(63, 2, false, false, 20);
    private PcepObjectHeader fecObjHeader;
    private byte[] nodeID = new byte[16];

    public PcepFecObjectIPv6Ver1(PcepObjectHeader fecObjHeader, byte[] nodeID) {
        this.fecObjHeader = fecObjHeader;
        this.nodeID = nodeID;
    }

    public void setFecIpv6ObjHeader(PcepObjectHeader obj) {
        this.fecObjHeader = obj;
    }

    @Override
    public void setNodeID(byte[] nodeID) {
        this.nodeID = nodeID;
    }

    public PcepObjectHeader getFecIpv6ObjHeader() {
        return this.fecObjHeader;
    }

    @Override
    public byte[] getNodeID() {
        return this.nodeID;
    }

    public static PcepFecObjectIPv6 read(ChannelBuffer cb) throws PcepParseException {
        byte[] nodeID = new byte[16];
        PcepObjectHeader fecObjHeader = PcepObjectHeader.read(cb);
        cb.readBytes(nodeID, 0, 16);
        return new PcepFecObjectIPv6Ver1(fecObjHeader, nodeID);
    }

    @Override
    public int write(ChannelBuffer cb) throws PcepParseException {
        int objStartIndex = cb.writerIndex();
        int objLenIndex = this.fecObjHeader.write(cb);
        cb.writeBytes(this.nodeID);
        cb.setShort(objLenIndex, (int)((short)(cb.writerIndex() - objStartIndex)));
        return cb.writerIndex();
    }

    @Override
    public PcepVersion getVersion() {
        return PcepVersion.PCEP_1;
    }

    @Override
    public int getType() {
        return 2;
    }

    public String toString() {
        return MoreObjects.toStringHelper(this.getClass()).add("fecObjHeader", (Object)this.fecObjHeader).add("NodeID: ", (Object)this.nodeID).toString();
    }

    public static class Builder
    implements PcepFecObjectIPv6.Builder {
        private boolean bIsHeaderSet = false;
        private boolean bIsNodeIdset = false;
        private PcepObjectHeader fecObjHeader;
        private byte[] nodeID = new byte[16];
        private boolean bIsPFlagSet = false;
        private boolean bPFlag;
        private boolean bIsIFlagSet = false;
        private boolean bIFlag;

        @Override
        public PcepFecObjectIPv6 build() throws PcepParseException {
            PcepObjectHeader fecObjHeader;
            PcepObjectHeader pcepObjectHeader = fecObjHeader = this.bIsHeaderSet ? this.fecObjHeader : DEFAULT_FEC_OBJECT_HEADER;
            if (!this.bIsNodeIdset) {
                throw new PcepParseException(" NodeID not set while building PcepFecObjectIPv6 object.");
            }
            if (this.bIsPFlagSet) {
                fecObjHeader.setPFlag(this.bPFlag);
            }
            if (this.bIsIFlagSet) {
                fecObjHeader.setIFlag(this.bIFlag);
            }
            return new PcepFecObjectIPv6Ver1(fecObjHeader, this.nodeID);
        }

        @Override
        public Builder setPFlag(boolean value) {
            this.bPFlag = value;
            this.bIsPFlagSet = true;
            return this;
        }

        @Override
        public Builder setIFlag(boolean value) {
            this.bIFlag = value;
            this.bIsIFlagSet = true;
            return this;
        }

        @Override
        public PcepObjectHeader getFecIpv6ObjHeader() {
            return this.fecObjHeader;
        }

        @Override
        public Builder setFecIpv6ObjHeader(PcepObjectHeader obj) {
            this.fecObjHeader = obj;
            this.bIsHeaderSet = true;
            return this;
        }

        @Override
        public byte[] getNodeID() {
            return this.nodeID;
        }

        @Override
        public Builder setNodeID(byte[] value) {
            this.nodeID = value;
            this.bIsNodeIdset = true;
            return this;
        }
    }
}

