/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.pcepio.protocol.ver1;

import com.google.common.base.MoreObjects;
import org.jboss.netty.buffer.ChannelBuffer;
import org.onosproject.pcepio.exceptions.PcepParseException;
import org.onosproject.pcepio.protocol.PcepInterLayerObject;
import org.onosproject.pcepio.types.PcepObjectHeader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PcepInterLayerObjectVer1
implements PcepInterLayerObject {
    protected static final Logger log = LoggerFactory.getLogger(PcepInterLayerObjectVer1.class);
    public static final byte INTER_LAYER_OBJ_TYPE = 1;
    public static final byte INTER_LAYER_OBJ_CLASS = 18;
    public static final byte INTER_LAYER_OBJECT_VERSION = 1;
    public static final short INTER_LAYER_OBJ_MINIMUM_LENGTH = 8;
    public static final boolean DEFAULT_IFLAG = false;
    public static final boolean DEFAULT_NFLAG = false;
    public static final int OBJECT_HEADER_LENGTH = 4;
    public static final int NFLAG_SHIFT_VALUE = 2;
    public static final int IFLAG_SHIFT_VALUE = 1;
    static final PcepObjectHeader DEFAULT_INTER_LAYER_OBJECT_HEADER = new PcepObjectHeader(18, 1, false, false, 8);
    private PcepObjectHeader interLayerObjHeader;
    private boolean bNFlag;
    private boolean bIFlag;

    public PcepInterLayerObjectVer1(PcepObjectHeader interLayerObjHeader, boolean bNFlag, boolean bIFlag) {
        this.interLayerObjHeader = interLayerObjHeader;
        this.bNFlag = bNFlag;
        this.bIFlag = bIFlag;
    }

    public void setInterLayerObjHeader(PcepObjectHeader obj) {
        this.interLayerObjHeader = obj;
    }

    @Override
    public void setbNFlag(boolean bNFlag) {
        this.bNFlag = bNFlag;
    }

    @Override
    public void setbIFlag(boolean bIFlag) {
        this.bIFlag = bIFlag;
    }

    public PcepObjectHeader getInterLayerObjHeader() {
        return this.interLayerObjHeader;
    }

    @Override
    public boolean getbNFlag() {
        return this.bNFlag;
    }

    @Override
    public boolean getbIFlag() {
        return this.bIFlag;
    }

    public static PcepInterLayerObject read(ChannelBuffer cb) throws PcepParseException {
        PcepObjectHeader interLayerObjHeader = PcepObjectHeader.read(cb);
        ChannelBuffer tempCb = cb.readBytes(interLayerObjHeader.getObjLen() - 4);
        int iTemp = tempCb.readInt();
        boolean bIFlag = (iTemp & 1) == 1;
        boolean bNFlag = (iTemp & 2) == 2;
        return new PcepInterLayerObjectVer1(interLayerObjHeader, bNFlag, bIFlag);
    }

    @Override
    public int write(ChannelBuffer cb) throws PcepParseException {
        int objStartIndex = cb.writerIndex();
        int objLenIndex = this.interLayerObjHeader.write(cb);
        if (objLenIndex <= 0) {
            throw new PcepParseException(" ObjectLength Index is " + objLenIndex);
        }
        int iTemp = 0;
        if (this.bIFlag) {
            iTemp |= 1;
        }
        if (this.bNFlag) {
            iTemp |= 2;
        }
        cb.writeInt(iTemp);
        int length = cb.writerIndex() - objStartIndex;
        this.interLayerObjHeader.setObjLen((short)length);
        cb.setShort(objLenIndex, (int)((short)length));
        objLenIndex = cb.writerIndex();
        return objLenIndex;
    }

    public String toString() {
        return MoreObjects.toStringHelper(this.getClass()).add("IFlag", this.bIFlag).add("NFlag", this.bNFlag).toString();
    }

    public static class Builder
    implements PcepInterLayerObject.Builder {
        private boolean bIsHeaderSet = false;
        private boolean bIsNFlagset = false;
        private boolean bIsIFlagset = false;
        private PcepObjectHeader interLayerObjHeader;
        private boolean bNFlag;
        private boolean bIFlag;
        private boolean bIsPFlagSet = false;
        private boolean bPFalg;
        private boolean bIsIFlagSet = false;
        private boolean iFlag;

        @Override
        public PcepInterLayerObject build() {
            boolean bIFlag;
            PcepObjectHeader interLayerObjHeader = this.bIsHeaderSet ? this.interLayerObjHeader : DEFAULT_INTER_LAYER_OBJECT_HEADER;
            boolean bNFlag = this.bIsNFlagset ? this.bNFlag : false;
            boolean bl = bIFlag = this.bIsIFlagset ? this.bIFlag : false;
            if (this.bIsPFlagSet) {
                interLayerObjHeader.setPFlag(this.bPFalg);
            }
            if (this.bIsIFlagSet) {
                interLayerObjHeader.setIFlag(this.iFlag);
            }
            return new PcepInterLayerObjectVer1(interLayerObjHeader, bNFlag, bIFlag);
        }

        @Override
        public PcepObjectHeader getInterLayerObjHeader() {
            return this.interLayerObjHeader;
        }

        @Override
        public Builder setInterLayerObjHeader(PcepObjectHeader obj) {
            this.interLayerObjHeader = obj;
            this.bIsHeaderSet = true;
            return this;
        }

        @Override
        public boolean getbNFlag() {
            return this.bNFlag;
        }

        @Override
        public Builder setbNFlag(boolean value) {
            this.bNFlag = value;
            this.bIsNFlagset = true;
            return this;
        }

        @Override
        public boolean getbIFlag() {
            return this.bIFlag;
        }

        @Override
        public Builder setbIFlag(boolean value) {
            this.bIFlag = value;
            this.bIsIFlagset = true;
            return this;
        }

        @Override
        public Builder setPFlag(boolean value) {
            this.bPFalg = value;
            this.bIsPFlagSet = true;
            return this;
        }

        @Override
        public Builder setIFlag(boolean value) {
            this.iFlag = value;
            this.bIsIFlagSet = true;
            return this;
        }
    }
}

