/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.pcepio.protocol.ver1;

import com.google.common.base.MoreObjects;
import java.util.LinkedList;
import java.util.ListIterator;
import org.jboss.netty.buffer.ChannelBuffer;
import org.onosproject.pcepio.exceptions.PcepParseException;
import org.onosproject.pcepio.protocol.PcepLspObject;
import org.onosproject.pcepio.types.PcepObjectHeader;
import org.onosproject.pcepio.types.PcepValueType;
import org.onosproject.pcepio.types.StatefulIPv4LspIdentidiersTlv;
import org.onosproject.pcepio.types.StatefulLspDbVerTlv;
import org.onosproject.pcepio.types.StatefulLspErrorCodeTlv;
import org.onosproject.pcepio.types.StatefulRsvpErrorSpecTlv;
import org.onosproject.pcepio.types.SymbolicPathNameTlv;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PcepLspObjectVer1
implements PcepLspObject {
    protected static final Logger log = LoggerFactory.getLogger(PcepLspObjectVer1.class);
    public static final byte LSP_OBJ_TYPE = 1;
    public static final byte LSP_OBJ_CLASS = 32;
    public static final byte LSP_OBJECT_VERSION = 1;
    public static final short LSP_OBJ_MINIMUM_LENGTH = 16;
    public static final int DEFAULT_PLSPID = 0;
    public static final byte DEFAULT_OFLAG = 1;
    public static final boolean DEFAULT_AFLAG = false;
    public static final boolean DEFAULT_RFLAG = false;
    public static final boolean DEFAULT_SFLAG = false;
    public static final boolean DEFAULT_DFLAG = false;
    public static final int OBJECT_HEADER_LENGTH = 4;
    public static final int PLSPID_SHIFT_VALUE = 12;
    public static final int OFLAG_SHIFT_VALUE = 4;
    public static final int AFLAG_SHIFT_VALUE = 3;
    public static final int RFLAG_SHIFT_VALUE = 2;
    public static final int SFLAG_SHIFT_VALUE = 1;
    public static final int PLSPID_TEMP_SHIFT_VALUE = -4096;
    public static final int OFLAG_TEMP_SHIFT_VALUE = 112;
    public static final int AFLAG_TEMP_SHIFT_VALUE = 8;
    public static final int RFLAG_TEMP_SHIFT_VALUE = 4;
    public static final int SFLAG_TEMP_SHIFT_VALUE = 2;
    public static final int DFLAG_TEMP_SHIFT_VALUE = 1;
    public static final int BIT_SET = 1;
    public static final int BIT_RESET = 0;
    public static final int MINIMUM_COMMON_HEADER_LENGTH = 4;
    static final PcepObjectHeader DEFAULT_LSP_OBJECT_HEADER = new PcepObjectHeader(32, 1, false, false, 16);
    private PcepObjectHeader lspObjHeader;
    private int iPlspId;
    private byte yOFlag;
    private boolean bAFlag;
    private boolean bRFlag;
    private boolean bSFlag;
    private boolean bDFlag;
    private LinkedList<PcepValueType> llOptionalTlv;

    public PcepLspObjectVer1(PcepObjectHeader lspObjHeader, int iPlspId, byte yOFlag, boolean bAFlag, boolean bRFlag, boolean bSFlag, boolean bDFlag, LinkedList<PcepValueType> llOptionalTlv) {
        this.lspObjHeader = lspObjHeader;
        this.iPlspId = iPlspId;
        this.yOFlag = yOFlag;
        this.bAFlag = bAFlag;
        this.bRFlag = bRFlag;
        this.bSFlag = bSFlag;
        this.bDFlag = bDFlag;
        this.llOptionalTlv = llOptionalTlv;
    }

    public void setLspObjHeader(PcepObjectHeader obj) {
        this.lspObjHeader = obj;
    }

    @Override
    public void setPlspId(int iPlspId) {
        this.iPlspId = iPlspId;
    }

    @Override
    public void setOFlag(byte yOFlag) {
        this.yOFlag = yOFlag;
    }

    @Override
    public void setAFlag(boolean bAFlag) {
        this.bAFlag = bAFlag;
    }

    @Override
    public void setRFlag(boolean bRFlag) {
        this.bRFlag = bRFlag;
    }

    @Override
    public void setSFlag(boolean bSFlag) {
        this.bSFlag = bSFlag;
    }

    @Override
    public void setDFlag(boolean bDFlag) {
        this.bDFlag = bDFlag;
    }

    public PcepObjectHeader getLspObjHeader() {
        return this.lspObjHeader;
    }

    @Override
    public int getPlspId() {
        return this.iPlspId;
    }

    @Override
    public byte getOFlag() {
        return this.yOFlag;
    }

    @Override
    public boolean getAFlag() {
        return this.bAFlag;
    }

    @Override
    public boolean getRFlag() {
        return this.bRFlag;
    }

    @Override
    public boolean getSFlag() {
        return this.bSFlag;
    }

    @Override
    public boolean getDFlag() {
        return this.bDFlag;
    }

    @Override
    public LinkedList<PcepValueType> getOptionalTlv() {
        return this.llOptionalTlv;
    }

    @Override
    public void setOptionalTlv(LinkedList<PcepValueType> llOptionalTlv) {
        this.llOptionalTlv = llOptionalTlv;
    }

    public static PcepLspObject read(ChannelBuffer cb) throws PcepParseException {
        LinkedList<PcepValueType> llOptionalTlv = new LinkedList();
        PcepObjectHeader lspObjHeader = PcepObjectHeader.read(cb);
        if (lspObjHeader.getObjClass() != 32) {
            throw new PcepParseException(6, 8);
        }
        ChannelBuffer tempCb = cb.readBytes(lspObjHeader.getObjLen() - 4);
        Integer iTemp = tempCb.readInt();
        int iPlspId = (iTemp & 0xFFFFF000) >> 12;
        Integer iX = (iTemp & 0x70) >> 4;
        byte yOFlag = iX.byteValue();
        iX = (iTemp & 8) >> 3;
        boolean bAFlag = iX > 0;
        iX = (iTemp & 4) >> 2;
        boolean bRFlag = iX > 0;
        iX = (iTemp & 2) >> 1;
        boolean bSFlag = iX > 0;
        iX = iTemp & 1;
        boolean bDFlag = iX > 0;
        llOptionalTlv = PcepLspObjectVer1.parseOptionalTlv(tempCb);
        return new PcepLspObjectVer1(lspObjHeader, iPlspId, yOFlag, bAFlag, bRFlag, bSFlag, bDFlag, llOptionalTlv);
    }

    @Override
    public int write(ChannelBuffer cb) throws PcepParseException {
        int objStartIndex = cb.writerIndex();
        int objLenIndex = this.lspObjHeader.write(cb);
        if (objLenIndex <= 0) {
            throw new PcepParseException("Failed to write lsp object header. Index " + objLenIndex);
        }
        int iTemp = this.iPlspId << 12;
        iTemp = this.bAFlag ? iTemp | 8 : (iTemp |= this.yOFlag << 4);
        int bFlag = this.bRFlag ? 1 : 0;
        iTemp |= bFlag << 2;
        bFlag = this.bSFlag ? 1 : 0;
        iTemp |= bFlag << 1;
        bFlag = this.bDFlag ? 1 : 0;
        cb.writeInt(iTemp |= bFlag);
        this.packOptionalTlv(cb);
        int length = cb.writerIndex() - objStartIndex;
        this.lspObjHeader.setObjLen((short)length);
        cb.setShort(objLenIndex, (int)((short)length));
        return length;
    }

    protected static LinkedList<PcepValueType> parseOptionalTlv(ChannelBuffer cb) throws PcepParseException {
        LinkedList<PcepValueType> llOutOptionalTlv = new LinkedList<PcepValueType>();
        while (4 <= cb.readableBytes()) {
            PcepValueType tlv;
            short hType = cb.readShort();
            short hLength = cb.readShort();
            int iValue = 0;
            switch (hType) {
                case 18: {
                    tlv = StatefulIPv4LspIdentidiersTlv.read(cb);
                    break;
                }
                case 20: {
                    iValue = cb.readInt();
                    tlv = new StatefulLspErrorCodeTlv(iValue);
                    break;
                }
                case 21: {
                    tlv = StatefulRsvpErrorSpecTlv.read(cb);
                    break;
                }
                case 17: {
                    tlv = SymbolicPathNameTlv.read(cb, hLength);
                    break;
                }
                case 23: {
                    tlv = StatefulLspDbVerTlv.read(cb);
                    break;
                }
                default: {
                    throw new PcepParseException("Received unsupported TLV type :" + hType);
                }
            }
            int pad = hLength % 4;
            if (0 < pad && (pad = 4 - pad) <= cb.readableBytes()) {
                cb.skipBytes(pad);
            }
            llOutOptionalTlv.add(tlv);
        }
        if (0 < cb.readableBytes()) {
            throw new PcepParseException("Optional Tlv parsing error. Extra bytes received.");
        }
        return llOutOptionalTlv;
    }

    protected int packOptionalTlv(ChannelBuffer cb) {
        ListIterator listIterator = this.llOptionalTlv.listIterator();
        int startIndex = cb.writerIndex();
        while (listIterator.hasNext()) {
            PcepValueType tlv = (PcepValueType)listIterator.next();
            if (tlv == null) {
                log.debug("tlv is null from OptionalTlv list");
                continue;
            }
            tlv.write(cb);
            int pad = tlv.getLength() % 4;
            if (0 == pad) continue;
            pad = 4 - pad;
            for (int i = 0; i < pad; ++i) {
                cb.writeByte(0);
            }
        }
        return cb.writerIndex() - startIndex;
    }

    public String toString() {
        return MoreObjects.toStringHelper(this.getClass()).add("PlspIDValue", this.iPlspId).add("OFlag", (int)this.yOFlag).add("AFlag", this.bAFlag).add("RFlag", this.bRFlag).add("SFlag", this.bSFlag).add("DFlag", this.bDFlag).add("OptionalTlvList", this.llOptionalTlv).toString();
    }

    public static class Builder
    implements PcepLspObject.Builder {
        private boolean bIsHeaderSet = false;
        private boolean bIsPlspIdSet = false;
        private boolean bIsOFlagSet = false;
        private boolean bIsRFlagSet = false;
        private boolean bIsAFlagSet = false;
        private boolean bIsDFlagSet = false;
        private boolean bIsSFlagSet = false;
        private PcepObjectHeader lspObjHeader;
        private byte yOFlag;
        private boolean bAFlag;
        private boolean bDFlag;
        private boolean bSFlag;
        private boolean bRFlag;
        LinkedList<PcepValueType> llOptionalTlv = null;
        private int plspId;
        private boolean bIsPFlagSet = false;
        private boolean bPFlag;
        private boolean bIsIFlagSet = false;
        private boolean bIFlag;

        @Override
        public PcepLspObject build() {
            boolean bDFlag;
            PcepObjectHeader lspObjHeader = this.bIsHeaderSet ? this.lspObjHeader : DEFAULT_LSP_OBJECT_HEADER;
            int plspId = this.bIsPlspIdSet ? this.plspId : 0;
            byte yOFlag = this.bIsOFlagSet ? this.yOFlag : (byte)1;
            boolean bAFlag = this.bIsAFlagSet ? this.bAFlag : false;
            boolean bRFlag = this.bIsRFlagSet ? this.bRFlag : false;
            boolean bSFlag = this.bIsSFlagSet ? this.bSFlag : false;
            boolean bl = bDFlag = this.bIsDFlagSet ? this.bDFlag : false;
            if (this.bIsPFlagSet) {
                lspObjHeader.setPFlag(this.bPFlag);
            }
            if (this.bIsIFlagSet) {
                lspObjHeader.setIFlag(this.bIFlag);
            }
            return new PcepLspObjectVer1(lspObjHeader, plspId, yOFlag, bAFlag, bRFlag, bSFlag, bDFlag, this.llOptionalTlv);
        }

        @Override
        public PcepObjectHeader getLspObjHeader() {
            return this.lspObjHeader;
        }

        @Override
        public Builder setLspObjHeader(PcepObjectHeader obj) {
            this.lspObjHeader = obj;
            this.bIsHeaderSet = true;
            return this;
        }

        @Override
        public int getPlspId() {
            return this.plspId;
        }

        @Override
        public Builder setPlspId(int value) {
            this.plspId = value;
            this.bIsPlspIdSet = true;
            return this;
        }

        @Override
        public byte getOFlag() {
            return this.yOFlag;
        }

        @Override
        public Builder setOFlag(byte value) {
            this.yOFlag = value;
            this.bIsOFlagSet = true;
            return this;
        }

        @Override
        public boolean getAFlag() {
            return this.bAFlag;
        }

        @Override
        public Builder setAFlag(boolean value) {
            this.bAFlag = value;
            this.bIsAFlagSet = true;
            return this;
        }

        @Override
        public boolean getRFlag() {
            return this.bRFlag;
        }

        @Override
        public Builder setRFlag(boolean value) {
            this.bRFlag = value;
            this.bIsRFlagSet = true;
            return this;
        }

        @Override
        public boolean getSFlag() {
            return this.bSFlag;
        }

        @Override
        public Builder setSFlag(boolean value) {
            this.bSFlag = value;
            this.bIsSFlagSet = true;
            return this;
        }

        @Override
        public boolean getDFlag() {
            return this.bDFlag;
        }

        @Override
        public Builder setDFlag(boolean value) {
            this.bDFlag = value;
            this.bIsDFlagSet = true;
            return this;
        }

        @Override
        public Builder setOptionalTlv(LinkedList<PcepValueType> llOptionalTlv) {
            this.llOptionalTlv = llOptionalTlv;
            return this;
        }

        @Override
        public LinkedList<PcepValueType> getOptionalTlv() {
            return this.llOptionalTlv;
        }

        @Override
        public Builder setPFlag(boolean value) {
            this.bPFlag = value;
            this.bIsPFlagSet = true;
            return this;
        }

        @Override
        public Builder setIFlag(boolean value) {
            this.bIFlag = value;
            this.bIsIFlagSet = true;
            return this;
        }
    }
}

