/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.pcepio.protocol.ver1;

import com.google.common.base.MoreObjects;
import org.jboss.netty.buffer.ChannelBuffer;
import org.onosproject.pcepio.exceptions.PcepParseException;
import org.onosproject.pcepio.protocol.PcepAttribute;
import org.onosproject.pcepio.protocol.PcepEroObject;
import org.onosproject.pcepio.protocol.PcepMsgPath;
import org.onosproject.pcepio.protocol.ver1.PcepAttributeVer1;
import org.onosproject.pcepio.protocol.ver1.PcepEroObjectVer1;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PcepMsgPathVer1
implements PcepMsgPath {
    protected static final Logger log = LoggerFactory.getLogger(PcepMsgPathVer1.class);
    private PcepEroObject eroObj;
    private boolean isEroObjectSet;
    private PcepAttribute attrList;
    private boolean isAttributeListSet;

    public PcepMsgPathVer1() {
        this.eroObj = null;
        this.attrList = null;
        this.isEroObjectSet = false;
        this.isAttributeListSet = false;
    }

    @Override
    public PcepEroObject getEroObject() {
        return this.eroObj;
    }

    @Override
    public PcepAttribute getPcepAttribute() {
        return this.attrList;
    }

    @Override
    public void setEroObject(PcepEroObject eroObj) {
        this.eroObj = eroObj;
    }

    @Override
    public void setPcepAttribute(PcepAttribute attrList) {
        this.attrList = attrList;
    }

    public PcepMsgPathVer1(PcepEroObject eroObj, PcepAttribute attrList) {
        this.eroObj = eroObj;
        this.isEroObjectSet = true;
        this.attrList = attrList;
        this.isAttributeListSet = attrList != null;
    }

    @Override
    public PcepMsgPath read(ChannelBuffer cb) throws PcepParseException {
        PcepEroObject eroObj = PcepEroObjectVer1.read(cb);
        PcepAttribute attrList = PcepAttributeVer1.read(cb);
        return new PcepMsgPathVer1(eroObj, attrList);
    }

    @Override
    public int write(ChannelBuffer cb) throws PcepParseException {
        int iLenStartIndex = cb.writerIndex();
        if (this.isEroObjectSet) {
            this.eroObj.write(cb);
        }
        if (this.isAttributeListSet) {
            this.attrList.write(cb);
        }
        return cb.writerIndex() - iLenStartIndex;
    }

    public String toString() {
        return MoreObjects.toStringHelper(this.getClass()).add("EroObject", (Object)this.eroObj).add("AttributeList", (Object)this.attrList).toString();
    }

    public static class Builder
    implements PcepMsgPath.Builder {
        private boolean bIsEROObjectSet = false;
        private boolean bIsPcepAttributeSet = false;
        private PcepEroObject eroObject;
        private PcepAttribute pcepAttribute;

        @Override
        public PcepMsgPath build() throws PcepParseException {
            PcepEroObject eroObject = null;
            PcepAttribute pcepAttribute = null;
            if (!this.bIsEROObjectSet) {
                throw new PcepParseException("ERO Object NOT Set while building PcepMsgPath.");
            }
            eroObject = this.eroObject;
            if (!this.bIsPcepAttributeSet) {
                throw new PcepParseException("Pcep Attributes NOT Set while building PcepMsgPath.");
            }
            pcepAttribute = this.pcepAttribute;
            return new PcepMsgPathVer1(eroObject, pcepAttribute);
        }

        @Override
        public PcepEroObject getEroObject() {
            return this.eroObject;
        }

        @Override
        public PcepAttribute getPcepAttribute() {
            return this.pcepAttribute;
        }

        @Override
        public Builder setEroObject(PcepEroObject eroObject) {
            this.eroObject = eroObject;
            this.bIsEROObjectSet = true;
            return this;
        }

        @Override
        public Builder setPcepAttribute(PcepAttribute pcepAttribute) {
            this.pcepAttribute = pcepAttribute;
            this.bIsPcepAttributeSet = true;
            return this;
        }
    }
}

