/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.pcepio.protocol.ver1;

import com.google.common.base.MoreObjects;
import java.util.LinkedList;
import java.util.ListIterator;
import org.jboss.netty.buffer.ChannelBuffer;
import org.onosproject.pcepio.exceptions.PcepParseException;
import org.onosproject.pcepio.protocol.PcepTEObject;
import org.onosproject.pcepio.types.LocalTENodeDescriptorsTlv;
import org.onosproject.pcepio.types.PcepObjectHeader;
import org.onosproject.pcepio.types.PcepValueType;
import org.onosproject.pcepio.types.RemoteTENodeDescriptorsTlv;
import org.onosproject.pcepio.types.RoutingUniverseTlv;
import org.onosproject.pcepio.types.TELinkAttributesTlv;
import org.onosproject.pcepio.types.TELinkDescriptorsTlv;
import org.onosproject.pcepio.types.TENodeAttributesTlv;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PcepTEObjectVer1
implements PcepTEObject {
    protected static final Logger log = LoggerFactory.getLogger(PcepTEObjectVer1.class);
    public static final byte TE_OBJ_TYPE_NODE_VALUE = 1;
    public static final byte TE_OBJ_TYPE_LINK_VALUE = 2;
    public static final byte TE_OBJ_CLASS = 101;
    public static final byte TE_OBJECT_VERSION = 1;
    public static final short TE_OBJ_MINIMUM_LENGTH = 12;
    public static final byte DEFAULT_PROTOCOL_ID = 1;
    public static final boolean DEFAULT_R_FLAG = false;
    public static final boolean DEFAULT_S_FLAG = false;
    public static final int DEFAULT_TE_ID = 0;
    public static final int OBJECT_HEADER_LENGTH = 4;
    public static final int RIGHT_SHIFT_ONE = 1;
    public static final int RIGHT_FIRST_FLAG = 1;
    public static final int FLAG_SET_R_FLAG = 2;
    public static final int FLAG_SET_S_FLAG = 1;
    public static final int MINIMUM_COMMON_HEADER_LENGTH = 4;
    public static final int MINIMUM_TLV_HEADER_LENGTH = 4;
    public static final PcepObjectHeader DEFAULT_TE_OBJECT_HEADER = new PcepObjectHeader(101, 1, false, false, 12);
    private PcepObjectHeader teObjHeader;
    private byte yProtocolId;
    private boolean bRFlag;
    private boolean bSFlag;
    private int iTEId;
    private LinkedList<PcepValueType> llOptionalTlv;

    public PcepTEObjectVer1(PcepObjectHeader teObjHeader, byte yProtocolId, boolean bRFlag, boolean bSFlag, int iTEId, LinkedList<PcepValueType> llOptionalTlv) {
        this.teObjHeader = teObjHeader;
        this.yProtocolId = yProtocolId;
        this.bRFlag = bRFlag;
        this.bSFlag = bSFlag;
        this.iTEId = iTEId;
        this.llOptionalTlv = llOptionalTlv;
    }

    @Override
    public PcepObjectHeader getTEObjHeader() {
        return this.teObjHeader;
    }

    @Override
    public void setTEObjHeader(PcepObjectHeader obj) {
        this.teObjHeader = obj;
    }

    @Override
    public byte getProtocolId() {
        return this.yProtocolId;
    }

    @Override
    public void setProtocolId(byte yProtId) {
        this.yProtocolId = yProtId;
    }

    @Override
    public boolean getRFlag() {
        return this.bRFlag;
    }

    @Override
    public void setRFlag(boolean bRFlag) {
        this.bRFlag = bRFlag;
    }

    @Override
    public boolean getSFlag() {
        return this.bSFlag;
    }

    @Override
    public void setSFlag(boolean bSFlag) {
        this.bSFlag = bSFlag;
    }

    @Override
    public int getTEId() {
        return this.iTEId;
    }

    @Override
    public void setTEId(int iTEId) {
        this.iTEId = iTEId;
    }

    @Override
    public LinkedList<PcepValueType> getOptionalTlv() {
        return this.llOptionalTlv;
    }

    @Override
    public void setOptionalTlv(LinkedList<PcepValueType> llOptionalTlv) {
        this.llOptionalTlv = llOptionalTlv;
    }

    public static PcepTEObject read(ChannelBuffer cb) throws PcepParseException {
        log.debug("read");
        PcepObjectHeader teObjHeader = PcepObjectHeader.read(cb);
        ChannelBuffer tempCb = cb.readBytes(teObjHeader.getObjLen() - 4);
        byte yProtocolId = tempCb.readByte();
        tempCb.readShort();
        Integer iTemp = tempCb.readByte();
        boolean bSFlag = (iTemp & 1) == 1;
        boolean bRFlag = (iTemp & 2) == 2;
        int iTEId = tempCb.readInt();
        LinkedList<PcepValueType> llOptionalTlv = PcepTEObjectVer1.parseOptionalTlv(tempCb);
        return new PcepTEObjectVer1(teObjHeader, yProtocolId, bRFlag, bSFlag, iTEId, llOptionalTlv);
    }

    @Override
    public int write(ChannelBuffer cb) throws PcepParseException {
        int objStartIndex = cb.writerIndex();
        int objLenIndex = this.teObjHeader.write(cb);
        if (objLenIndex <= 0) {
            throw new PcepParseException("ObjectLength Index is " + objLenIndex);
        }
        cb.writeByte((int)this.yProtocolId);
        cb.writeShort(0);
        int bTemp = 0;
        if (this.bSFlag) {
            bTemp = 1;
        }
        if (this.bRFlag) {
            bTemp = (byte)(bTemp | 2);
        }
        cb.writeByte(bTemp);
        cb.writeInt(this.iTEId);
        this.packOptionalTlv(cb);
        int length = cb.writerIndex() - objStartIndex;
        this.teObjHeader.setObjLen((short)length);
        cb.setShort(objLenIndex, (int)((short)length));
        return cb.writerIndex();
    }

    protected static LinkedList<PcepValueType> parseOptionalTlv(ChannelBuffer cb) throws PcepParseException {
        LinkedList<PcepValueType> llOutOptionalTlv = new LinkedList<PcepValueType>();
        while (4 <= cb.readableBytes()) {
            PcepValueType tlv;
            short hType = cb.readShort();
            short hLength = cb.readShort();
            long lValue = 0L;
            switch (hType) {
                case 14: {
                    lValue = cb.readLong();
                    tlv = new RoutingUniverseTlv(lValue);
                    break;
                }
                case 1637: {
                    tlv = LocalTENodeDescriptorsTlv.read(cb, hLength);
                    break;
                }
                case 1003: {
                    tlv = RemoteTENodeDescriptorsTlv.read(cb, hLength);
                    break;
                }
                case 1070: {
                    tlv = TELinkDescriptorsTlv.read(cb, hLength);
                    break;
                }
                case 1267: {
                    tlv = TENodeAttributesTlv.read(cb, hLength);
                    break;
                }
                case 1897: {
                    tlv = TELinkAttributesTlv.read(cb, hLength);
                    break;
                }
                default: {
                    throw new PcepParseException("Unsupported TLV type :" + hType);
                }
            }
            int pad = hLength % 4;
            if (0 < pad && (pad = 4 - pad) <= cb.readableBytes()) {
                cb.skipBytes(pad);
            }
            llOutOptionalTlv.add(tlv);
        }
        if (0 < cb.readableBytes()) {
            throw new PcepParseException("Optional Tlv parsing error. Extra bytes received.");
        }
        return llOutOptionalTlv;
    }

    protected int packOptionalTlv(ChannelBuffer cb) {
        ListIterator listIterator = this.llOptionalTlv.listIterator();
        while (listIterator.hasNext()) {
            PcepValueType tlv = (PcepValueType)listIterator.next();
            if (tlv == null) {
                log.debug("TLV is null from OptionalTlv list");
                continue;
            }
            tlv.write(cb);
            int pad = tlv.getLength() % 4;
            if (0 == pad) continue;
            pad = 4 - pad;
            for (int i = 0; i < pad; ++i) {
                cb.writeByte(0);
            }
        }
        return cb.writerIndex();
    }

    public String toString() {
        return MoreObjects.toStringHelper(this.getClass()).add("ObjectHeader", (Object)this.teObjHeader).add("ProtocolId", (int)this.yProtocolId).add("RFlag", this.bRFlag ? 1 : 0).add("SFlag", this.bSFlag ? 1 : 0).add("TeId", this.iTEId).add("OptionalTlv", this.llOptionalTlv).toString();
    }

    public static class Builder
    implements PcepTEObject.Builder {
        private boolean bIsHeaderSet = false;
        private boolean bIsProtocolIdSet = false;
        private boolean bIsRFlagSet = false;
        private boolean bIsSFlagSet = false;
        private boolean bIsTEIdSet = false;
        private PcepObjectHeader teObjHeader;
        private byte yProtocolId;
        private boolean bRFlag;
        private boolean bSFlag;
        private int iTEId;
        private LinkedList<PcepValueType> llOptionalTlv = new LinkedList();
        private boolean bIsPFlagSet = false;
        private boolean bPFlag;
        private boolean bIsIFlagSet = false;
        private boolean bIFlag;

        @Override
        public PcepTEObject build() {
            int iTEId;
            PcepObjectHeader teObjHeader = this.bIsHeaderSet ? this.teObjHeader : DEFAULT_TE_OBJECT_HEADER;
            byte yProtocolId = this.bIsProtocolIdSet ? this.yProtocolId : (byte)1;
            boolean bRFlag = this.bIsRFlagSet ? this.bRFlag : false;
            boolean bSFlag = this.bIsSFlagSet ? this.bSFlag : false;
            int n = iTEId = this.bIsTEIdSet ? this.iTEId : 0;
            if (this.bIsPFlagSet) {
                teObjHeader.setPFlag(this.bPFlag);
            }
            if (this.bIsIFlagSet) {
                teObjHeader.setIFlag(this.bIFlag);
            }
            return new PcepTEObjectVer1(teObjHeader, yProtocolId, bRFlag, bSFlag, iTEId, this.llOptionalTlv);
        }

        @Override
        public PcepObjectHeader getTEObjHeader() {
            return this.teObjHeader;
        }

        @Override
        public Builder setTEObjHeader(PcepObjectHeader obj) {
            this.teObjHeader = obj;
            this.bIsHeaderSet = true;
            return this;
        }

        @Override
        public byte getProtocolId() {
            return this.yProtocolId;
        }

        @Override
        public Builder setProtocolId(byte yProtId) {
            this.yProtocolId = yProtId;
            this.bIsProtocolIdSet = true;
            return this;
        }

        @Override
        public boolean getRFlag() {
            return this.bRFlag;
        }

        @Override
        public Builder setRFlag(boolean bRFlag) {
            this.bRFlag = bRFlag;
            this.bIsRFlagSet = true;
            return this;
        }

        @Override
        public boolean getSFlag() {
            return this.bSFlag;
        }

        @Override
        public Builder setSFlag(boolean bSFlag) {
            this.bSFlag = bSFlag;
            this.bIsSFlagSet = true;
            return this;
        }

        @Override
        public int getTEId() {
            return this.iTEId;
        }

        @Override
        public Builder setTEId(int iTEId) {
            this.iTEId = iTEId;
            this.bIsTEIdSet = true;
            return this;
        }

        @Override
        public LinkedList<PcepValueType> getOptionalTlv() {
            return this.llOptionalTlv;
        }

        @Override
        public Builder setOptionalTlv(LinkedList<PcepValueType> llOptionalTlv) {
            this.llOptionalTlv = llOptionalTlv;
            return this;
        }

        @Override
        public Builder setPFlag(boolean value) {
            this.bPFlag = value;
            this.bIsPFlagSet = true;
            return this;
        }

        @Override
        public Builder setIFlag(boolean value) {
            this.bIFlag = value;
            this.bIsIFlagSet = true;
            return this;
        }
    }
}

