/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.pcepio.protocol.ver1;

import com.google.common.base.MoreObjects;
import java.util.LinkedList;
import java.util.ListIterator;
import org.jboss.netty.buffer.ChannelBuffer;
import org.onosproject.pcepio.exceptions.PcepParseException;
import org.onosproject.pcepio.protocol.PcepMessageReader;
import org.onosproject.pcepio.protocol.PcepMessageWriter;
import org.onosproject.pcepio.protocol.PcepTEObject;
import org.onosproject.pcepio.protocol.PcepTEReportMsg;
import org.onosproject.pcepio.protocol.PcepType;
import org.onosproject.pcepio.protocol.PcepVersion;
import org.onosproject.pcepio.protocol.ver1.PcepTEObjectVer1;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class PcepTEReportMsgVer1
implements PcepTEReportMsg {
    private static final Logger log = LoggerFactory.getLogger(PcepTEReportMsgVer1.class);
    public static final int PACKET_MINIMUM_LENGTH = 16;
    public static final PcepType MSG_TYPE = PcepType.TE_REPORT;
    private LinkedList<PcepTEObject> teReportList;
    public static final Reader READER = new Reader();
    static final Writer WRITER = new Writer();

    PcepTEReportMsgVer1(LinkedList<PcepTEObject> teReportList) {
        this.teReportList = teReportList;
    }

    @Override
    public void writeTo(ChannelBuffer bb) throws PcepParseException {
        WRITER.write(bb, this);
    }

    @Override
    public PcepVersion getVersion() {
        return PcepVersion.PCEP_1;
    }

    @Override
    public PcepType getType() {
        return MSG_TYPE;
    }

    @Override
    public LinkedList<PcepTEObject> getTEReportList() {
        return this.teReportList;
    }

    @Override
    public void setTEReportList(LinkedList<PcepTEObject> ll) {
        this.teReportList = ll;
    }

    public String toString() {
        return MoreObjects.toStringHelper(this.getClass()).add("TeReportList", this.teReportList).toString();
    }

    static class Writer
    implements PcepMessageWriter<PcepTEReportMsgVer1> {
        Writer() {
        }

        @Override
        public void write(ChannelBuffer bb, PcepTEReportMsgVer1 message) throws PcepParseException {
            int startIndex = bb.writerIndex();
            bb.writeByte(32);
            bb.writeByte((int)MSG_TYPE.getType());
            int msgLenIndex = bb.writerIndex();
            bb.writeShort(0);
            ListIterator listIterator = message.teReportList.listIterator();
            while (listIterator.hasNext()) {
                PcepTEObject teObj = (PcepTEObject)listIterator.next();
                teObj.write(bb);
            }
            int length = bb.writerIndex() - startIndex;
            bb.setShort(msgLenIndex, (int)((short)length));
        }
    }

    static class Builder
    implements PcepTEReportMsg.Builder {
        LinkedList<PcepTEObject> teReportList;

        Builder() {
        }

        @Override
        public PcepVersion getVersion() {
            return PcepVersion.PCEP_1;
        }

        @Override
        public PcepType getType() {
            return PcepType.TE_REPORT;
        }

        @Override
        public PcepTEReportMsg build() {
            return new PcepTEReportMsgVer1(this.teReportList);
        }

        @Override
        public LinkedList<PcepTEObject> getTEReportList() {
            return this.teReportList;
        }

        @Override
        public Builder setTEReportList(LinkedList<PcepTEObject> ll) {
            this.teReportList = ll;
            return this;
        }
    }

    static class Reader
    implements PcepMessageReader<PcepTEReportMsg> {
        LinkedList<PcepTEObject> teReportList;

        Reader() {
        }

        @Override
        public PcepTEReportMsg readFrom(ChannelBuffer cb) throws PcepParseException {
            if (cb.readableBytes() < 16) {
                return null;
            }
            this.teReportList = new LinkedList();
            byte version = cb.readByte();
            if ((version = (byte)(version >> 5)) != 1) {
                throw new PcepParseException("Wrong version. Expected=PcepVersion.PCEP_1(1), got=" + version);
            }
            byte type = cb.readByte();
            if (type != MSG_TYPE.getType()) {
                throw new PcepParseException("Wrong type. Expected=PcepType.TE_REPORT(14), got=" + type);
            }
            short length = cb.readShort();
            if (length < 16) {
                throw new PcepParseException("Wrong length. Expected to be >= 16, is: " + length);
            }
            this.parseTEReportList(cb);
            return new PcepTEReportMsgVer1(this.teReportList);
        }

        public void parseTEReportList(ChannelBuffer cb) throws PcepParseException {
            while (0 < cb.readableBytes()) {
                if (this.teReportList.add(PcepTEObjectVer1.read(cb))) continue;
                throw new PcepParseException("Failed to add TE object to TE report list");
            }
        }
    }
}

