/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.pcepio.types;

import com.google.common.base.MoreObjects;
import java.util.Objects;
import org.jboss.netty.buffer.ChannelBuffer;
import org.onosproject.pcepio.protocol.PcepVersion;
import org.onosproject.pcepio.types.PcepValueType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AdministrativeGroupTlv
implements PcepValueType {
    protected static final Logger log = LoggerFactory.getLogger(AdministrativeGroupTlv.class);
    public static final short TYPE = 3;
    public static final short LENGTH = 4;
    private final int rawValue;

    public AdministrativeGroupTlv(int rawValue) {
        this.rawValue = rawValue;
    }

    public static AdministrativeGroupTlv of(int raw) {
        return new AdministrativeGroupTlv(raw);
    }

    public int getInt() {
        return this.rawValue;
    }

    @Override
    public PcepVersion getVersion() {
        return PcepVersion.PCEP_1;
    }

    @Override
    public short getType() {
        return 3;
    }

    @Override
    public short getLength() {
        return 4;
    }

    public int hashCode() {
        return Objects.hash(this.rawValue);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof AdministrativeGroupTlv) {
            AdministrativeGroupTlv other = (AdministrativeGroupTlv)obj;
            return Objects.equals(this.rawValue, other.rawValue);
        }
        return false;
    }

    @Override
    public int write(ChannelBuffer c) {
        int iLenStartIndex = c.writerIndex();
        c.writeShort(3);
        c.writeShort(4);
        c.writeInt(this.rawValue);
        return c.writerIndex() - iLenStartIndex;
    }

    public static AdministrativeGroupTlv read(ChannelBuffer c) {
        return AdministrativeGroupTlv.of(c.readInt());
    }

    public String toString() {
        return MoreObjects.toStringHelper(this.getClass()).add("Type", 3).add("Length", 4).add("Value", this.rawValue).toString();
    }
}

