/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.pcepio.types;

import com.google.common.base.MoreObjects;
import java.util.Objects;
import org.jboss.netty.buffer.ChannelBuffer;
import org.onosproject.pcepio.protocol.PcepVersion;
import org.onosproject.pcepio.types.PcepValueType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IGPMetricTlv
implements PcepValueType {
    protected static final Logger log = LoggerFactory.getLogger(IGPMetricTlv.class);
    public static final short TYPE = 1095;
    private short hLength;
    private final byte[] rawValue;

    public IGPMetricTlv(byte[] rawValue, short hLength) {
        this.rawValue = rawValue;
        this.hLength = hLength;
    }

    public static IGPMetricTlv of(byte[] raw, short hLength) {
        return new IGPMetricTlv(raw, hLength);
    }

    public byte[] getValue() {
        return this.rawValue;
    }

    @Override
    public PcepVersion getVersion() {
        return PcepVersion.PCEP_1;
    }

    @Override
    public short getType() {
        return 1095;
    }

    @Override
    public short getLength() {
        return this.hLength;
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.rawValue});
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof IGPMetricTlv) {
            IGPMetricTlv other = (IGPMetricTlv)obj;
            return Objects.equals(this.rawValue, other.rawValue);
        }
        return false;
    }

    @Override
    public int write(ChannelBuffer c) {
        int iLenStartIndex = c.writerIndex();
        c.writeShort(1095);
        c.writeShort((int)this.hLength);
        c.writeBytes(this.rawValue);
        return c.writerIndex() - iLenStartIndex;
    }

    public static PcepValueType read(ChannelBuffer c, short hLength) {
        byte[] iIGPMetric = new byte[hLength];
        c.readBytes(iIGPMetric, 0, (int)hLength);
        return new IGPMetricTlv(iIGPMetric, hLength);
    }

    public String toString() {
        MoreObjects.ToStringHelper toStrHelper = MoreObjects.toStringHelper(this.getClass());
        toStrHelper.add("Type", 1095);
        toStrHelper.add("Length", (int)this.hLength);
        StringBuffer result = new StringBuffer();
        for (byte b : this.rawValue) {
            result.append(String.format("%02X ", b));
        }
        toStrHelper.add("Value", (Object)result);
        return toStrHelper.toString();
    }
}

