/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.pcepio.types;

import com.google.common.base.MoreObjects;
import java.util.Objects;
import org.jboss.netty.buffer.ChannelBuffer;
import org.onosproject.pcepio.protocol.PcepVersion;
import org.onosproject.pcepio.types.PcepValueType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ISISAreaIdentifierTlv
implements PcepValueType {
    protected static final Logger log = LoggerFactory.getLogger(ISISAreaIdentifierTlv.class);
    public static final short TYPE = 107;
    private short hLength;
    private final byte[] rawValue;

    public ISISAreaIdentifierTlv(byte[] rawValue, short hLength) {
        log.debug("ISISAreaIdentifierTlv");
        this.rawValue = rawValue;
        this.hLength = 0 == hLength ? (short)rawValue.length : hLength;
    }

    public static ISISAreaIdentifierTlv of(byte[] raw, short hLength) {
        return new ISISAreaIdentifierTlv(raw, hLength);
    }

    public byte[] getValue() {
        return this.rawValue;
    }

    @Override
    public PcepVersion getVersion() {
        return PcepVersion.PCEP_1;
    }

    @Override
    public short getType() {
        return 107;
    }

    @Override
    public short getLength() {
        return this.hLength;
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.rawValue});
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof ISISAreaIdentifierTlv) {
            ISISAreaIdentifierTlv other = (ISISAreaIdentifierTlv)obj;
            return Objects.equals(this.hLength, other.hLength) && Objects.equals(this.rawValue, other.rawValue);
        }
        return false;
    }

    @Override
    public int write(ChannelBuffer c) {
        int iLenStartIndex = c.writerIndex();
        c.writeShort(107);
        c.writeShort((int)this.hLength);
        c.writeBytes(this.rawValue);
        return c.writerIndex() - iLenStartIndex;
    }

    public static PcepValueType read(ChannelBuffer c, short hLength) {
        byte[] iISISAreaIdentifier = new byte[hLength];
        c.readBytes(iISISAreaIdentifier, 0, (int)hLength);
        return new ISISAreaIdentifierTlv(iISISAreaIdentifier, hLength);
    }

    public String toString() {
        MoreObjects.ToStringHelper toStrHelper = MoreObjects.toStringHelper(this.getClass());
        toStrHelper.add("Type", 107);
        toStrHelper.add("Length", (int)this.hLength);
        StringBuffer result = new StringBuffer();
        for (byte b : this.rawValue) {
            result.append(String.format("%02X ", b));
        }
        toStrHelper.add("Value", (Object)result);
        return toStrHelper.toString();
    }
}

