/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.pcepio.types;

import com.google.common.base.MoreObjects;
import java.util.Objects;
import org.jboss.netty.buffer.ChannelBuffer;
import org.onosproject.pcepio.protocol.PcepVersion;
import org.onosproject.pcepio.types.PcepValueType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LinkLocalRemoteIdentifiersTlv
implements PcepValueType {
    protected static final Logger log = LoggerFactory.getLogger(LinkLocalRemoteIdentifiersTlv.class);
    public static final short TYPE = 4;
    public static final short LENGTH = 8;
    private final int iLinkLocalIdentifier;
    private final int iLinkRemoteIdentifier;

    public LinkLocalRemoteIdentifiersTlv(int iLinkLocalIdentifier, int iLinkRemoteIdentifier) {
        this.iLinkLocalIdentifier = iLinkLocalIdentifier;
        this.iLinkRemoteIdentifier = iLinkRemoteIdentifier;
    }

    public static LinkLocalRemoteIdentifiersTlv of(int iLinkLocalIdentifier, int iLinkRemoteIdentifier) {
        return new LinkLocalRemoteIdentifiersTlv(iLinkLocalIdentifier, iLinkRemoteIdentifier);
    }

    public int getLinkLocalIdentifier() {
        return this.iLinkLocalIdentifier;
    }

    public int getLinkRemoteIdentifier() {
        return this.iLinkRemoteIdentifier;
    }

    @Override
    public PcepVersion getVersion() {
        return PcepVersion.PCEP_1;
    }

    @Override
    public short getLength() {
        return 8;
    }

    @Override
    public short getType() {
        return 4;
    }

    public int hashCode() {
        return Objects.hash(this.iLinkLocalIdentifier, this.iLinkRemoteIdentifier);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof LinkLocalRemoteIdentifiersTlv) {
            LinkLocalRemoteIdentifiersTlv other = (LinkLocalRemoteIdentifiersTlv)obj;
            return Objects.equals(this.iLinkLocalIdentifier, other.iLinkLocalIdentifier) && Objects.equals(this.iLinkRemoteIdentifier, other.iLinkRemoteIdentifier);
        }
        return false;
    }

    @Override
    public int write(ChannelBuffer c) {
        int iStartIndex = c.writerIndex();
        c.writeShort(4);
        c.writeShort(8);
        c.writeInt(this.iLinkLocalIdentifier);
        c.writeInt(this.iLinkRemoteIdentifier);
        return c.writerIndex() - iStartIndex;
    }

    public static PcepValueType read(ChannelBuffer c) {
        int iLinkLocalIdentifier = c.readInt();
        int iLinkRemoteIdentifier = c.readInt();
        return new LinkLocalRemoteIdentifiersTlv(iLinkLocalIdentifier, iLinkRemoteIdentifier);
    }

    public String toString() {
        return MoreObjects.toStringHelper(this.getClass()).add("Type", 4).add("Length", 8).add("LinkLocalIdentifier", this.iLinkLocalIdentifier).add("LinkRemoteIdentifier", this.iLinkRemoteIdentifier).toString();
    }
}

