/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.pcepio.types;

import com.google.common.base.MoreObjects;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.ListIterator;
import java.util.Objects;
import org.jboss.netty.buffer.ChannelBuffer;
import org.onosproject.pcepio.exceptions.PcepParseException;
import org.onosproject.pcepio.protocol.PcepVersion;
import org.onosproject.pcepio.types.AutonomousSystemTlv;
import org.onosproject.pcepio.types.BGPLSidentifierTlv;
import org.onosproject.pcepio.types.OSPFareaIDsubTlv;
import org.onosproject.pcepio.types.PcepValueType;
import org.onosproject.pcepio.types.RouterIDSubTlv;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LocalTENodeDescriptorsTlv
implements PcepValueType {
    protected static final Logger log = LoggerFactory.getLogger(LocalTENodeDescriptorsTlv.class);
    public static final short TYPE = 1637;
    public short hLength;
    public static final int TLV_HEADER_LENGTH = 4;
    private LinkedList<PcepValueType> llNodeDescriptorSubTLVs;

    public LocalTENodeDescriptorsTlv(LinkedList<PcepValueType> llNodeDescriptorSubTLVs) {
        this.llNodeDescriptorSubTLVs = llNodeDescriptorSubTLVs;
    }

    public static LocalTENodeDescriptorsTlv of(LinkedList<PcepValueType> llNodeDescriptorSubTLVs) {
        return new LocalTENodeDescriptorsTlv(llNodeDescriptorSubTLVs);
    }

    public LinkedList<PcepValueType> getllNodeDescriptorSubTLVs() {
        return this.llNodeDescriptorSubTLVs;
    }

    @Override
    public PcepVersion getVersion() {
        return PcepVersion.PCEP_1;
    }

    @Override
    public short getType() {
        return 1637;
    }

    @Override
    public short getLength() {
        return this.hLength;
    }

    public int hashCode() {
        return Objects.hash(this.llNodeDescriptorSubTLVs.hashCode());
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof LocalTENodeDescriptorsTlv) {
            int countObjSubTlv = 0;
            int countOtherSubTlv = 0;
            boolean isCommonSubTlv = true;
            LocalTENodeDescriptorsTlv other = (LocalTENodeDescriptorsTlv)obj;
            Iterator objListIterator = ((LocalTENodeDescriptorsTlv)obj).llNodeDescriptorSubTLVs.iterator();
            countObjSubTlv = ((LocalTENodeDescriptorsTlv)obj).llNodeDescriptorSubTLVs.size();
            if (countObjSubTlv != (countOtherSubTlv = other.llNodeDescriptorSubTLVs.size())) {
                return false;
            }
            while (objListIterator.hasNext() && isCommonSubTlv) {
                PcepValueType subTlv = (PcepValueType)objListIterator.next();
                isCommonSubTlv = Objects.equals(this.llNodeDescriptorSubTLVs.contains(subTlv), other.llNodeDescriptorSubTLVs.contains(subTlv));
            }
            return isCommonSubTlv;
        }
        return false;
    }

    @Override
    public int write(ChannelBuffer c) {
        int tlvStartIndex = c.writerIndex();
        c.writeShort(1637);
        int tlvLenIndex = c.writerIndex();
        this.hLength = 0;
        c.writeShort(0);
        ListIterator listIterator = this.llNodeDescriptorSubTLVs.listIterator();
        while (listIterator.hasNext()) {
            PcepValueType tlv = (PcepValueType)listIterator.next();
            if (tlv == null) {
                log.debug("TLV is null from subTlv list");
                continue;
            }
            tlv.write(c);
            int pad = tlv.getLength() % 4;
            if (0 == pad) continue;
            pad = 4 - pad;
            for (int i = 0; i < pad; ++i) {
                c.writeByte(0);
            }
        }
        this.hLength = (short)(c.writerIndex() - tlvStartIndex);
        c.setShort(tlvLenIndex, this.hLength - 4);
        return c.writerIndex() - tlvStartIndex;
    }

    public static PcepValueType read(ChannelBuffer c, short hLength) throws PcepParseException {
        LinkedList<PcepValueType> llNodeDescriptorSubTLVs = new LinkedList<PcepValueType>();
        ChannelBuffer tempCb = c.readBytes((int)hLength);
        while (4 <= tempCb.readableBytes()) {
            PcepValueType tlv;
            short hType = tempCb.readShort();
            int iValue = 0;
            short length = tempCb.readShort();
            switch (hType) {
                case 100: {
                    iValue = tempCb.readInt();
                    tlv = new AutonomousSystemTlv(iValue);
                    break;
                }
                case 17: {
                    iValue = tempCb.readInt();
                    tlv = new BGPLSidentifierTlv(iValue);
                    break;
                }
                case 600: {
                    iValue = tempCb.readInt();
                    tlv = new OSPFareaIDsubTlv(iValue);
                    break;
                }
                case 1000: {
                    tlv = RouterIDSubTlv.read(tempCb, length);
                    break;
                }
                default: {
                    throw new PcepParseException("Unsupported Sub TLV type :" + hType);
                }
            }
            int pad = length % 4;
            if (0 < pad && (pad = 4 - pad) <= tempCb.readableBytes()) {
                tempCb.skipBytes(pad);
            }
            llNodeDescriptorSubTLVs.add(tlv);
        }
        if (0 < tempCb.readableBytes()) {
            throw new PcepParseException("Sub Tlv parsing error. Extra bytes received.");
        }
        return new LocalTENodeDescriptorsTlv(llNodeDescriptorSubTLVs);
    }

    public String toString() {
        return MoreObjects.toStringHelper(this.getClass()).add("Type", 1637).add("Length", (int)this.hLength).add("NodeDescriptorSubTLVs", this.llNodeDescriptorSubTLVs).toString();
    }
}

