/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.pcepio.types;

import com.google.common.base.MoreObjects;
import java.util.Objects;
import org.jboss.netty.buffer.ChannelBuffer;
import org.onosproject.pcepio.protocol.PcepVersion;
import org.onosproject.pcepio.types.PcepValueType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PceccCapabilityTlv
implements PcepValueType {
    protected static final Logger log = LoggerFactory.getLogger(PceccCapabilityTlv.class);
    public static final short TYPE = 32;
    public static final short LENGTH = 4;
    public static final int SET = 1;
    public static final byte LFLAG_CHECK = 1;
    public static final byte GFLAG_CHECK = 2;
    private final boolean bGFlag;
    private final boolean bLFlag;
    private final int rawValue;
    private final boolean isRawValueSet;

    public PceccCapabilityTlv(int rawValue) {
        this.rawValue = rawValue;
        this.isRawValueSet = true;
        this.bLFlag = (rawValue & 1) == 1;
        this.bGFlag = (rawValue & 2) == 2;
    }

    public PceccCapabilityTlv(boolean bGFlag, boolean bLFlag) {
        this.bGFlag = bGFlag;
        this.bLFlag = bLFlag;
        this.rawValue = 0;
        this.isRawValueSet = false;
    }

    public static PceccCapabilityTlv of(int raw) {
        return new PceccCapabilityTlv(raw);
    }

    @Override
    public PcepVersion getVersion() {
        return PcepVersion.PCEP_1;
    }

    public boolean getGFlag() {
        return this.bGFlag;
    }

    public boolean getLFlag() {
        return this.bLFlag;
    }

    public int getInt() {
        return this.rawValue;
    }

    @Override
    public short getType() {
        return 32;
    }

    @Override
    public short getLength() {
        return 4;
    }

    public int hashCode() {
        if (this.isRawValueSet) {
            return Objects.hash(this.rawValue);
        }
        return Objects.hash(this.bLFlag, this.bGFlag);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof PceccCapabilityTlv) {
            PceccCapabilityTlv other = (PceccCapabilityTlv)obj;
            if (this.isRawValueSet) {
                return Objects.equals(this.rawValue, other.rawValue);
            }
            return Objects.equals(this.bGFlag, other.bGFlag) && Objects.equals(this.bLFlag, other.bLFlag);
        }
        return false;
    }

    @Override
    public int write(ChannelBuffer c) {
        int iLenStartIndex = c.writerIndex();
        int temp = 0;
        c.writeShort(32);
        c.writeShort(4);
        if (this.isRawValueSet) {
            c.writeInt(this.rawValue);
        } else {
            if (this.bGFlag) {
                temp |= 2;
            }
            if (this.bLFlag) {
                temp |= 1;
            }
            c.writeInt(temp);
        }
        return c.writerIndex() - iLenStartIndex;
    }

    public static PceccCapabilityTlv read(ChannelBuffer c) {
        return PceccCapabilityTlv.of(c.readInt());
    }

    public String toString() {
        return MoreObjects.toStringHelper(this.getClass()).add("Type", 32).add("Length", 4).add("Value", this.rawValue).toString();
    }
}

