/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.pcepio.types;

import com.google.common.base.MoreObjects;
import java.util.Objects;
import org.jboss.netty.buffer.ChannelBuffer;
import org.onosproject.pcepio.protocol.PcepNai;

public class PcepNaiIpv6Adjacency
implements PcepNai {
    public static final byte ST_TYPE = 4;
    public static final byte IPV6_LEN = 16;
    private final byte[] localIpv6Addr;
    private final byte[] remoteIpv6Addr;

    public PcepNaiIpv6Adjacency(byte[] localIpv6, byte[] remoteIpv6) {
        this.localIpv6Addr = localIpv6;
        this.remoteIpv6Addr = remoteIpv6;
    }

    @Override
    public byte getType() {
        return 4;
    }

    @Override
    public int write(ChannelBuffer bb) {
        int iLenStartIndex = bb.writerIndex();
        bb.writeBytes(this.localIpv6Addr);
        bb.writeBytes(this.remoteIpv6Addr);
        return bb.writerIndex() - iLenStartIndex;
    }

    public static PcepNaiIpv6Adjacency read(ChannelBuffer bb) {
        byte[] localIpv6 = new byte[16];
        bb.readBytes(localIpv6, 0, 16);
        byte[] remoteIpv6 = new byte[16];
        bb.readBytes(remoteIpv6, 0, 16);
        return new PcepNaiIpv6Adjacency(localIpv6, remoteIpv6);
    }

    public int hashCode() {
        return Objects.hash(this.localIpv6Addr, this.remoteIpv6Addr);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof PcepNaiIpv6Adjacency) {
            PcepNaiIpv6Adjacency other = (PcepNaiIpv6Adjacency)obj;
            return Objects.equals(this.localIpv6Addr, other.localIpv6Addr) && Objects.equals(this.remoteIpv6Addr, other.remoteIpv6Addr);
        }
        return false;
    }

    public static PcepNaiIpv6Adjacency of(byte[] localIpv6Addr, byte[] remoteIpv6Addr) {
        return new PcepNaiIpv6Adjacency(localIpv6Addr, remoteIpv6Addr);
    }

    public String toString() {
        return MoreObjects.toStringHelper(this.getClass()).add("localIPV6Address", (Object)this.localIpv6Addr).add("remoteIPV6Address", (Object)this.remoteIpv6Addr).toString();
    }
}

