/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.pcepio.types;

import com.google.common.base.MoreObjects;
import org.jboss.netty.buffer.ChannelBuffer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PcepObjectHeader {
    protected static final Logger log = LoggerFactory.getLogger(PcepObjectHeader.class);
    public static final boolean REQ_OBJ_MUST_PROCESS = true;
    public static final boolean REQ_OBJ_OPTIONAL_PROCESS = false;
    public static final boolean RSP_OBJ_IGNORED = true;
    public static final boolean RSP_OBJ_PROCESSED = false;
    public static final int OBJECT_TYPE_SHIFT_VALUE = 4;
    public static final byte PFLAG_SET = 2;
    public static final byte IFLAG_SET = 1;
    public static final int SET = 1;
    private byte objClass;
    private byte objType;
    private boolean bPFlag;
    private boolean bIFlag;
    private short objLen;

    public PcepObjectHeader(byte objClass, byte objType, boolean bPFlag, boolean bIFlag, short objLen) {
        this.objClass = objClass;
        this.objType = objType;
        this.bPFlag = bPFlag;
        this.bIFlag = bIFlag;
        this.objLen = objLen;
    }

    public void setObjClass(byte value) {
        this.objClass = value;
    }

    public void setObjType(byte value) {
        this.objType = value;
    }

    public void setPFlag(boolean value) {
        this.bPFlag = value;
    }

    public void setIFlag(boolean value) {
        this.bIFlag = value;
    }

    public void setObjLen(short value) {
        this.objLen = value;
    }

    public boolean getPFlag() {
        return this.bPFlag;
    }

    public boolean getIFlag() {
        return this.bIFlag;
    }

    public short getObjLen() {
        return this.objLen;
    }

    public byte getObjClass() {
        return this.objClass;
    }

    public byte getObjType() {
        return this.objType;
    }

    public int write(ChannelBuffer cb) {
        cb.writeByte((int)this.objClass);
        byte temp = (byte)(this.objType << 4);
        if (this.bPFlag) {
            temp = (byte)(temp | 2);
        }
        if (this.bIFlag) {
            temp = (byte)(temp | 1);
        }
        cb.writeByte((int)temp);
        int objLenIndex = cb.writerIndex();
        cb.writeShort(0);
        return objLenIndex;
    }

    public static PcepObjectHeader read(ChannelBuffer cb) {
        byte objClass = cb.readByte();
        byte temp = cb.readByte();
        boolean bIFlag = (temp & 1) == 1;
        boolean bPFlag = (temp & 2) == 2;
        byte objType = (byte)(temp >> 4);
        short objLen = cb.readShort();
        return new PcepObjectHeader(objClass, objType, bPFlag, bIFlag, objLen);
    }

    public String toString() {
        return MoreObjects.toStringHelper(this.getClass()).add("ObjectClass", (int)this.objClass).add("ObjectType", (int)this.objType).add("ObjectLength", (int)this.objLen).add("PFlag", this.bPFlag ? 1 : 0).add("IFlag", this.bIFlag ? 1 : 0).toString();
    }
}

