/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.pcepio.types;

import com.google.common.base.MoreObjects;
import java.util.Objects;
import org.jboss.netty.buffer.ChannelBuffer;
import org.onosproject.pcepio.protocol.PcepVersion;
import org.onosproject.pcepio.types.PcepValueType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SharedRiskLinkGroupTlv
implements PcepValueType {
    protected static final Logger log = LoggerFactory.getLogger(SharedRiskLinkGroupTlv.class);
    public static final short TYPE = 1096;
    private final short hLength;
    private final int[] srlgValue;

    public SharedRiskLinkGroupTlv(int[] srlgValue, short hLength) {
        this.srlgValue = srlgValue;
        this.hLength = 0 == hLength ? (short)(srlgValue.length * 4) : hLength;
    }

    public static SharedRiskLinkGroupTlv of(int[] raw, short hLength) {
        return new SharedRiskLinkGroupTlv(raw, hLength);
    }

    public int[] getValue() {
        return this.srlgValue;
    }

    @Override
    public PcepVersion getVersion() {
        return PcepVersion.PCEP_1;
    }

    @Override
    public short getType() {
        return 1096;
    }

    @Override
    public short getLength() {
        return this.hLength;
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.srlgValue});
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof SharedRiskLinkGroupTlv) {
            SharedRiskLinkGroupTlv other = (SharedRiskLinkGroupTlv)obj;
            return Objects.equals(this.srlgValue, other.srlgValue);
        }
        return false;
    }

    @Override
    public int write(ChannelBuffer c) {
        int iLenStartIndex = c.writerIndex();
        c.writeShort(1096);
        c.writeShort((int)this.hLength);
        for (int b : this.srlgValue) {
            c.writeInt(b);
        }
        return c.writerIndex() - iLenStartIndex;
    }

    public static PcepValueType read(ChannelBuffer c, short hLength) {
        int iLength = hLength / 4;
        int[] iSharedRiskLinkGroup = new int[iLength];
        for (int i = 0; i < iLength; ++i) {
            iSharedRiskLinkGroup[i] = c.readInt();
        }
        return new SharedRiskLinkGroupTlv(iSharedRiskLinkGroup, hLength);
    }

    public String toString() {
        MoreObjects.ToStringHelper toStrHelper = MoreObjects.toStringHelper(this.getClass());
        toStrHelper.add("Type", 1096);
        toStrHelper.add("Length", (int)this.hLength);
        StringBuffer result = new StringBuffer();
        for (int b : this.srlgValue) {
            result.append(String.format("%02X ", b));
        }
        toStrHelper.add("Value", (Object)result);
        return toStrHelper.toString();
    }
}

