/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.pcepio.types;

import com.google.common.base.MoreObjects;
import java.util.Objects;
import org.jboss.netty.buffer.ChannelBuffer;
import org.onosproject.pcepio.protocol.PcepVersion;
import org.onosproject.pcepio.types.PcepValueType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SymbolicPathNameTlv
implements PcepValueType {
    protected static final Logger log = LoggerFactory.getLogger(SymbolicPathNameTlv.class);
    public static final short TYPE = 17;
    private short hLength;
    private final byte[] rawValue;

    public SymbolicPathNameTlv(byte[] rawValue) {
        this.rawValue = rawValue;
        this.hLength = (short)rawValue.length;
    }

    public SymbolicPathNameTlv(byte[] rawValue, short hLength) {
        this.rawValue = rawValue;
        this.hLength = 0 == hLength ? (short)rawValue.length : hLength;
    }

    public static SymbolicPathNameTlv of(byte[] raw, short hLength) {
        return new SymbolicPathNameTlv(raw, hLength);
    }

    public byte[] getValue() {
        return this.rawValue;
    }

    @Override
    public PcepVersion getVersion() {
        return PcepVersion.PCEP_1;
    }

    @Override
    public short getType() {
        return 17;
    }

    @Override
    public short getLength() {
        return this.hLength;
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.rawValue});
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof SymbolicPathNameTlv) {
            SymbolicPathNameTlv other = (SymbolicPathNameTlv)obj;
            return Objects.equals(this.rawValue, other.rawValue);
        }
        return false;
    }

    @Override
    public int write(ChannelBuffer c) {
        int iLenStartIndex = c.writerIndex();
        c.writeShort(17);
        c.writeShort((int)this.hLength);
        c.writeBytes(this.rawValue);
        return c.writerIndex() - iLenStartIndex;
    }

    public static SymbolicPathNameTlv read(ChannelBuffer c, short hLength) {
        byte[] symbolicPathName = new byte[hLength];
        c.readBytes(symbolicPathName, 0, (int)hLength);
        return new SymbolicPathNameTlv(symbolicPathName, hLength);
    }

    public String toString() {
        return MoreObjects.toStringHelper(this.getClass()).add("SymbolicPathName ", (Object)this.rawValue).toString();
    }
}

