/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.pcepio.types;

import com.google.common.base.MoreObjects;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.ListIterator;
import java.util.Objects;
import org.jboss.netty.buffer.ChannelBuffer;
import org.onosproject.pcepio.exceptions.PcepParseException;
import org.onosproject.pcepio.protocol.PcepVersion;
import org.onosproject.pcepio.types.AdministrativeGroupTlv;
import org.onosproject.pcepio.types.IGPMetricTlv;
import org.onosproject.pcepio.types.IPv4TERouterIdOfLocalNodeTlv;
import org.onosproject.pcepio.types.IPv4TERouterIdOfRemoteNodeTlv;
import org.onosproject.pcepio.types.IPv6TERouterIdofLocalNodeTlv;
import org.onosproject.pcepio.types.IPv6TERouterIdofRemoteNodeTlv;
import org.onosproject.pcepio.types.LinkLocalRemoteIdentifiersTlv;
import org.onosproject.pcepio.types.LinkNameTlv;
import org.onosproject.pcepio.types.LinkProtectionTypeTlv;
import org.onosproject.pcepio.types.MPLSProtocolMaskTlv;
import org.onosproject.pcepio.types.MaximumLinkBandwidthTlv;
import org.onosproject.pcepio.types.MaximumReservableLinkBandwidthTlv;
import org.onosproject.pcepio.types.OpaqueLinkAttributeTlv;
import org.onosproject.pcepio.types.PcepValueType;
import org.onosproject.pcepio.types.SharedRiskLinkGroupTlv;
import org.onosproject.pcepio.types.TEDefaultMetricTlv;
import org.onosproject.pcepio.types.UnreservedBandwidthTlv;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TELinkAttributesTlv
implements PcepValueType {
    protected static final Logger log = LoggerFactory.getLogger(TELinkAttributesTlv.class);
    public static final short TYPE = 1897;
    public short hLength;
    public static final int TLV_HEADER_LENGTH = 4;
    private LinkedList<PcepValueType> llLinkAttributesSubTLVs;

    public TELinkAttributesTlv(LinkedList<PcepValueType> llLinkAttributesSubTLVs) {
        this.llLinkAttributesSubTLVs = llLinkAttributesSubTLVs;
    }

    public static TELinkAttributesTlv of(LinkedList<PcepValueType> llLinkAttributesSubTLVs) {
        return new TELinkAttributesTlv(llLinkAttributesSubTLVs);
    }

    public LinkedList<PcepValueType> getllLinkAttributesSubTLVs() {
        return this.llLinkAttributesSubTLVs;
    }

    @Override
    public PcepVersion getVersion() {
        return PcepVersion.PCEP_1;
    }

    @Override
    public short getType() {
        return 1897;
    }

    @Override
    public short getLength() {
        return this.hLength;
    }

    public int hashCode() {
        return Objects.hash(this.llLinkAttributesSubTLVs.hashCode());
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof TELinkAttributesTlv) {
            int countObjSubTlv = 0;
            int countOtherSubTlv = 0;
            boolean isCommonSubTlv = true;
            TELinkAttributesTlv other = (TELinkAttributesTlv)obj;
            Iterator objListIterator = ((TELinkAttributesTlv)obj).llLinkAttributesSubTLVs.iterator();
            countObjSubTlv = ((TELinkAttributesTlv)obj).llLinkAttributesSubTLVs.size();
            if (countObjSubTlv != (countOtherSubTlv = other.llLinkAttributesSubTLVs.size())) {
                return false;
            }
            while (objListIterator.hasNext() && isCommonSubTlv) {
                PcepValueType subTlv = (PcepValueType)objListIterator.next();
                isCommonSubTlv = Objects.equals(this.llLinkAttributesSubTLVs.contains(subTlv), other.llLinkAttributesSubTLVs.contains(subTlv));
            }
            return isCommonSubTlv;
        }
        return false;
    }

    @Override
    public int write(ChannelBuffer c) {
        int tlvStartIndex = c.writerIndex();
        c.writeShort(1897);
        int tlvLenIndex = c.writerIndex();
        this.hLength = 0;
        c.writeShort((int)this.hLength);
        ListIterator listIterator = this.llLinkAttributesSubTLVs.listIterator();
        while (listIterator.hasNext()) {
            PcepValueType tlv = (PcepValueType)listIterator.next();
            if (tlv == null) {
                log.debug("TLV is null from subTlv list");
                continue;
            }
            tlv.write(c);
            int pad = tlv.getLength() % 4;
            if (0 == pad) continue;
            pad = 4 - pad;
            for (int i = 0; i < pad; ++i) {
                c.writeByte(0);
            }
        }
        this.hLength = (short)(c.writerIndex() - tlvStartIndex);
        c.setShort(tlvLenIndex, this.hLength - 4);
        return c.writerIndex() - tlvStartIndex;
    }

    public static PcepValueType read(ChannelBuffer c, short hLength) throws PcepParseException {
        LinkedList<PcepValueType> llLinkAttributesSubTLVs = new LinkedList<PcepValueType>();
        ChannelBuffer tempCb = c.readBytes((int)hLength);
        while (4 <= tempCb.readableBytes()) {
            PcepValueType tlv;
            short hType = tempCb.readShort();
            int iValue = 0;
            short length = tempCb.readShort();
            switch (hType) {
                case 134: {
                    iValue = tempCb.readInt();
                    tlv = new IPv4TERouterIdOfLocalNodeTlv(iValue);
                    break;
                }
                case 140: {
                    byte[] ipv6LValue = new byte[18];
                    tempCb.readBytes(ipv6LValue, 0, 18);
                    tlv = new IPv6TERouterIdofLocalNodeTlv(ipv6LValue);
                    break;
                }
                case 1340: {
                    iValue = tempCb.readInt();
                    tlv = new IPv4TERouterIdOfRemoteNodeTlv(iValue);
                    break;
                }
                case 1400: {
                    byte[] ipv6RValue = new byte[18];
                    tempCb.readBytes(ipv6RValue, 0, 18);
                    tlv = new IPv6TERouterIdofRemoteNodeTlv(ipv6RValue);
                    break;
                }
                case 4: {
                    tlv = LinkLocalRemoteIdentifiersTlv.read(tempCb);
                    break;
                }
                case 3: {
                    iValue = tempCb.readInt();
                    tlv = new AdministrativeGroupTlv(iValue);
                    break;
                }
                case 9: {
                    iValue = tempCb.readInt();
                    tlv = new MaximumLinkBandwidthTlv(iValue);
                    break;
                }
                case 10: {
                    iValue = tempCb.readInt();
                    tlv = new MaximumReservableLinkBandwidthTlv(iValue);
                    break;
                }
                case 11: {
                    iValue = tempCb.readInt();
                    tlv = new UnreservedBandwidthTlv(iValue);
                    break;
                }
                case 13400: {
                    iValue = tempCb.readInt();
                    tlv = new TEDefaultMetricTlv(iValue);
                    break;
                }
                case 20: {
                    tlv = LinkProtectionTypeTlv.read(tempCb);
                    break;
                }
                case 1094: {
                    byte cValue = tempCb.readByte();
                    tlv = new MPLSProtocolMaskTlv(cValue);
                    break;
                }
                case 1095: {
                    tlv = IGPMetricTlv.read(tempCb, length);
                    break;
                }
                case 1096: {
                    tlv = SharedRiskLinkGroupTlv.read(tempCb, length);
                    break;
                }
                case 1097: {
                    tlv = OpaqueLinkAttributeTlv.read(tempCb, length);
                    break;
                }
                case 1098: {
                    tlv = LinkNameTlv.read(tempCb, length);
                    break;
                }
                default: {
                    throw new PcepParseException("Unsupported Sub TLV type :" + hType);
                }
            }
            int pad = length % 4;
            if (0 < pad && (pad = 4 - pad) <= tempCb.readableBytes()) {
                tempCb.skipBytes(pad);
            }
            llLinkAttributesSubTLVs.add(tlv);
        }
        if (0 < tempCb.readableBytes()) {
            throw new PcepParseException("Sub Tlv parsing error. Extra bytes received.");
        }
        return new TELinkAttributesTlv(llLinkAttributesSubTLVs);
    }

    public String toString() {
        return MoreObjects.toStringHelper(this.getClass()).add("Type", 1897).add("Length", (int)this.hLength).add("LinkAttributesSubTLVs", this.llLinkAttributesSubTLVs).toString();
    }
}

