/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.pcepio.types;

import com.google.common.base.MoreObjects;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.ListIterator;
import java.util.Objects;
import org.jboss.netty.buffer.ChannelBuffer;
import org.onosproject.pcepio.exceptions.PcepParseException;
import org.onosproject.pcepio.protocol.PcepVersion;
import org.onosproject.pcepio.types.IPv4TERouterIdOfLocalNodeTlv;
import org.onosproject.pcepio.types.IPv6TERouterIdofLocalNodeTlv;
import org.onosproject.pcepio.types.ISISAreaIdentifierTlv;
import org.onosproject.pcepio.types.NodeFlagBitsTlv;
import org.onosproject.pcepio.types.NodeNameTlv;
import org.onosproject.pcepio.types.OpaqueNodeAttributeTlv;
import org.onosproject.pcepio.types.PcepValueType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TENodeAttributesTlv
implements PcepValueType {
    protected static final Logger log = LoggerFactory.getLogger(TENodeAttributesTlv.class);
    public static final short TYPE = 1267;
    public short hLength;
    public static final int TLV_HEADER_LENGTH = 4;
    private LinkedList<PcepValueType> llNodeAttributesSubTLVs;

    public TENodeAttributesTlv(LinkedList<PcepValueType> llNodeAttributesSubTLVs) {
        this.llNodeAttributesSubTLVs = llNodeAttributesSubTLVs;
    }

    public static TENodeAttributesTlv of(LinkedList<PcepValueType> llNodeAttributesSubTLVs) {
        return new TENodeAttributesTlv(llNodeAttributesSubTLVs);
    }

    public LinkedList<PcepValueType> getllNodeAttributesSubTLVs() {
        return this.llNodeAttributesSubTLVs;
    }

    @Override
    public PcepVersion getVersion() {
        return PcepVersion.PCEP_1;
    }

    @Override
    public short getType() {
        return 1267;
    }

    @Override
    public short getLength() {
        return this.hLength;
    }

    public int hashCode() {
        return Objects.hash(this.llNodeAttributesSubTLVs.hashCode());
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof TENodeAttributesTlv) {
            int countObjSubTlv = 0;
            int countOtherSubTlv = 0;
            boolean isCommonSubTlv = true;
            TENodeAttributesTlv other = (TENodeAttributesTlv)obj;
            Iterator objListIterator = ((TENodeAttributesTlv)obj).llNodeAttributesSubTLVs.iterator();
            countObjSubTlv = ((TENodeAttributesTlv)obj).llNodeAttributesSubTLVs.size();
            if (countObjSubTlv != (countOtherSubTlv = other.llNodeAttributesSubTLVs.size())) {
                return false;
            }
            while (objListIterator.hasNext() && isCommonSubTlv) {
                PcepValueType subTlv = (PcepValueType)objListIterator.next();
                isCommonSubTlv = Objects.equals(this.llNodeAttributesSubTLVs.contains(subTlv), other.llNodeAttributesSubTLVs.contains(subTlv));
            }
            return isCommonSubTlv;
        }
        return false;
    }

    @Override
    public int write(ChannelBuffer c) {
        int tlvStartIndex = c.writerIndex();
        c.writeShort(1267);
        int tlvLenIndex = c.writerIndex();
        this.hLength = 0;
        c.writeShort((int)this.hLength);
        ListIterator listIterator = this.llNodeAttributesSubTLVs.listIterator();
        while (listIterator.hasNext()) {
            PcepValueType tlv = (PcepValueType)listIterator.next();
            tlv.write(c);
            int pad = tlv.getLength() % 4;
            if (0 == pad) continue;
            pad = 4 - pad;
            for (int i = 0; i < pad; ++i) {
                c.writeByte(0);
            }
        }
        this.hLength = (short)(c.writerIndex() - tlvStartIndex);
        c.setShort(tlvLenIndex, this.hLength - 4);
        return c.writerIndex() - tlvStartIndex;
    }

    public static PcepValueType read(ChannelBuffer c, short hLength) throws PcepParseException {
        LinkedList<PcepValueType> llNodeAttributesSubTLVs = new LinkedList<PcepValueType>();
        ChannelBuffer tempCb = c.readBytes((int)hLength);
        while (4 <= tempCb.readableBytes()) {
            PcepValueType tlv;
            short hType = tempCb.readShort();
            int iValue = 0;
            short length = tempCb.readShort();
            switch (hType) {
                case 14: {
                    byte cValue = tempCb.readByte();
                    tlv = new NodeFlagBitsTlv(cValue);
                    break;
                }
                case 1001: {
                    tlv = OpaqueNodeAttributeTlv.read(tempCb, length);
                    break;
                }
                case 1007: {
                    tlv = NodeNameTlv.read(tempCb, length);
                    break;
                }
                case 107: {
                    tlv = ISISAreaIdentifierTlv.read(tempCb, length);
                    break;
                }
                case 134: {
                    iValue = tempCb.readInt();
                    tlv = new IPv4TERouterIdOfLocalNodeTlv(iValue);
                    break;
                }
                case 140: {
                    byte[] ipv6Value = new byte[18];
                    tempCb.readBytes(ipv6Value, 0, 18);
                    tlv = new IPv6TERouterIdofLocalNodeTlv(ipv6Value);
                    break;
                }
                default: {
                    throw new PcepParseException("Unsupported Sub TLV type :" + hType);
                }
            }
            int pad = length % 4;
            if (0 < pad && (pad = 4 - pad) <= tempCb.readableBytes()) {
                tempCb.skipBytes(pad);
            }
            llNodeAttributesSubTLVs.add(tlv);
        }
        if (0 < tempCb.readableBytes()) {
            throw new PcepParseException("Sub Tlv parsing error. Extra bytes received.");
        }
        return new TENodeAttributesTlv(llNodeAttributesSubTLVs);
    }

    public String toString() {
        return MoreObjects.toStringHelper(this.getClass()).add("Type", 1267).add("Length", (int)this.hLength).add("NodeAttributesSubTLVs", this.llNodeAttributesSubTLVs).toString();
    }
}

