/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.pcepio.types;

import com.google.common.base.MoreObjects;
import java.util.Objects;
import org.jboss.netty.buffer.ChannelBuffer;
import org.onosproject.pcepio.protocol.PcepVersion;
import org.onosproject.pcepio.types.PcepValueType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TedCapabilityTlv
implements PcepValueType {
    protected static final Logger log = LoggerFactory.getLogger(TedCapabilityTlv.class);
    public static final short TYPE = 132;
    public static final short LENGTH = 4;
    public static final int SET = 1;
    public static final byte RFLAG_CHECK = 1;
    private final boolean bRFlag;
    private final int rawValue;
    private final boolean isRawValueSet;

    public TedCapabilityTlv(int rawValue) {
        this.rawValue = rawValue;
        this.isRawValueSet = true;
        int temp = rawValue;
        this.bRFlag = (temp &= 1) == 1;
    }

    public TedCapabilityTlv(boolean bRFlag) {
        this.bRFlag = bRFlag;
        this.rawValue = 0;
        this.isRawValueSet = false;
    }

    public boolean getbRFlag() {
        return this.bRFlag;
    }

    public static TedCapabilityTlv of(int raw) {
        return new TedCapabilityTlv(raw);
    }

    @Override
    public PcepVersion getVersion() {
        return PcepVersion.PCEP_1;
    }

    public int getInt() {
        return this.rawValue;
    }

    @Override
    public short getType() {
        return 132;
    }

    @Override
    public short getLength() {
        return 4;
    }

    public int hashCode() {
        if (this.isRawValueSet) {
            return Objects.hash(this.rawValue);
        }
        return Objects.hash(this.bRFlag);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof TedCapabilityTlv) {
            TedCapabilityTlv other = (TedCapabilityTlv)obj;
            if (this.isRawValueSet) {
                return Objects.equals(this.rawValue, other.rawValue);
            }
            return Objects.equals(this.bRFlag, other.bRFlag);
        }
        return false;
    }

    @Override
    public int write(ChannelBuffer c) {
        int iStartIndex = c.writerIndex();
        int temp = 0;
        c.writeShort(132);
        c.writeShort(4);
        if (this.isRawValueSet) {
            c.writeInt(this.rawValue);
        } else {
            if (this.bRFlag) {
                temp |= 1;
            }
            c.writeInt(temp);
        }
        return c.writerIndex() - iStartIndex;
    }

    public static TedCapabilityTlv read(ChannelBuffer c) {
        return TedCapabilityTlv.of(c.readInt());
    }

    public String toString() {
        return MoreObjects.toStringHelper(this.getClass()).add("Type", 132).add("Length", 4).add("Value", this.rawValue).toString();
    }
}

