/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.pcepio.protocol;

import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.hamcrest.core.Is;
import org.jboss.netty.buffer.ChannelBuffer;
import org.jboss.netty.buffer.ChannelBuffers;
import org.junit.Test;
import org.onosproject.pcepio.exceptions.PcepParseException;
import org.onosproject.pcepio.protocol.PcepFactories;
import org.onosproject.pcepio.protocol.PcepMessage;
import org.onosproject.pcepio.protocol.PcepMessageReader;
import org.onosproject.pcepio.protocol.PcepUpdateMsg;

public class PcepUpdateMsgTest {
    @Test
    public void pcepUpdateMsgTest1() throws PcepParseException {
        byte[] updateMsg = new byte[]{32, 11, 0, 48, 33, 16, 0, 12, 0, 0, 0, 0, 0, 0, 0, 3, 32, 16, 0, 28, 0, 0, 16, 3, 0, 18, 0, 16, -74, 2, 78, 31, 0, 1, -128, 1, -74, 2, 78, 31, -74, 2, 78, 32, 7, 16, 0, 4};
        byte[] testupdateMsg = new byte[]{0};
        ChannelBuffer buffer = ChannelBuffers.dynamicBuffer();
        buffer.writeBytes(updateMsg);
        PcepMessageReader reader = PcepFactories.getGenericReader();
        PcepMessage message = null;
        message = (PcepMessage)reader.readFrom(buffer);
        MatcherAssert.assertThat((Object)message, (Matcher)Matchers.instanceOf(PcepUpdateMsg.class));
        ChannelBuffer buf = ChannelBuffers.dynamicBuffer();
        message.writeTo(buf);
        testupdateMsg = buf.array();
        int readLen = buf.writerIndex() - 0;
        testupdateMsg = new byte[readLen];
        buf.readBytes(testupdateMsg, 0, readLen);
        MatcherAssert.assertThat((Object)testupdateMsg, (Matcher)Is.is((Object)updateMsg));
    }

    @Test
    public void pcepUpdateMsgTest2() throws PcepParseException {
        byte[] updateMsg = new byte[]{32, 11, 0, -108, 33, 16, 0, 20, 0, 0, 0, 0, 0, 0, 0, 3, 0, 17, 0, 2, 84, 49, 0, 0, 32, 16, 0, 44, 0, 0, 16, 3, 0, 18, 0, 16, -74, 2, 78, 31, 0, 1, -128, 1, -74, 2, 78, 31, -74, 2, 78, 32, 0, 17, 0, 2, 84, 49, 0, 0, 0, 20, 0, 4, 0, 0, 0, 8, 7, 16, 0, 36, 1, 8, 17, 1, 1, 1, 4, 0, 1, 8, 17, 1, 1, 2, 4, 0, 1, 8, 18, 1, 1, 2, 4, 0, 1, 8, 18, 1, 1, 1, 4, 0, 9, 16, 0, 20, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 7, 7, 0, 0, 6, 16, 0, 12, 0, 0, 0, 2, 0, 0, 0, 1, 6, 16, 0, 12, 0, 0, 1, 3, 0, 0, 0, 32};
        byte[] testupdateMsg = new byte[]{0};
        ChannelBuffer buffer = ChannelBuffers.dynamicBuffer();
        buffer.writeBytes(updateMsg);
        PcepMessageReader reader = PcepFactories.getGenericReader();
        PcepMessage message = null;
        message = (PcepMessage)reader.readFrom(buffer);
        MatcherAssert.assertThat((Object)message, (Matcher)Matchers.instanceOf(PcepUpdateMsg.class));
        ChannelBuffer buf = ChannelBuffers.dynamicBuffer();
        message.writeTo(buf);
        testupdateMsg = buf.array();
        int readLen = buf.writerIndex() - 0;
        testupdateMsg = new byte[readLen];
        buf.readBytes(testupdateMsg, 0, readLen);
        MatcherAssert.assertThat((Object)testupdateMsg, (Matcher)Is.is((Object)updateMsg));
    }

    @Test
    public void pcepUpdateMsgTest3() throws PcepParseException {
        byte[] updateMsg = new byte[]{32, 11, 0, 56, 33, 16, 0, 20, 0, 0, 0, 0, 0, 0, 0, 3, 0, 17, 0, 2, 84, 49, 0, 0, 32, 16, 0, 28, 0, 0, 16, 3, 0, 18, 0, 16, -74, 2, 78, 31, 0, 1, -128, 1, -74, 2, 78, 31, -74, 2, 78, 32, 7, 16, 0, 4};
        byte[] testupdateMsg = new byte[]{0};
        ChannelBuffer buffer = ChannelBuffers.dynamicBuffer();
        buffer.writeBytes(updateMsg);
        PcepMessageReader reader = PcepFactories.getGenericReader();
        PcepMessage message = null;
        message = (PcepMessage)reader.readFrom(buffer);
        MatcherAssert.assertThat((Object)message, (Matcher)Matchers.instanceOf(PcepUpdateMsg.class));
        ChannelBuffer buf = ChannelBuffers.dynamicBuffer();
        message.writeTo(buf);
        testupdateMsg = buf.array();
        int readLen = buf.writerIndex() - 0;
        testupdateMsg = new byte[readLen];
        buf.readBytes(testupdateMsg, 0, readLen);
        MatcherAssert.assertThat((Object)testupdateMsg, (Matcher)Is.is((Object)updateMsg));
    }

    @Test
    public void pcepUpdateMsgTest4() throws PcepParseException {
        byte[] updateMsg = new byte[]{32, 11, 0, 64, 33, 16, 0, 20, 0, 0, 0, 0, 0, 0, 0, 3, 0, 17, 0, 2, 84, 49, 0, 0, 32, 16, 0, 36, 0, 0, 16, 3, 0, 18, 0, 16, -74, 2, 78, 31, 0, 1, -128, 1, -74, 2, 78, 31, -74, 2, 78, 32, 0, 17, 0, 2, 84, 49, 0, 0, 7, 16, 0, 4};
        byte[] testupdateMsg = new byte[]{0};
        ChannelBuffer buffer = ChannelBuffers.dynamicBuffer();
        buffer.writeBytes(updateMsg);
        PcepMessageReader reader = PcepFactories.getGenericReader();
        PcepMessage message = null;
        message = (PcepMessage)reader.readFrom(buffer);
        MatcherAssert.assertThat((Object)message, (Matcher)Matchers.instanceOf(PcepUpdateMsg.class));
        ChannelBuffer buf = ChannelBuffers.dynamicBuffer();
        message.writeTo(buf);
        testupdateMsg = buf.array();
        int readLen = buf.writerIndex() - 0;
        testupdateMsg = new byte[readLen];
        buf.readBytes(testupdateMsg, 0, readLen);
        MatcherAssert.assertThat((Object)testupdateMsg, (Matcher)Is.is((Object)updateMsg));
    }

    @Test
    public void pcepUpdateMsgTest5() throws PcepParseException {
        byte[] updateMsg = new byte[]{32, 11, 0, 64, 33, 16, 0, 20, 0, 0, 0, 0, 0, 0, 0, 3, 0, 17, 0, 2, 84, 49, 0, 0, 32, 16, 0, 36, 0, 0, 16, 3, 0, 18, 0, 16, -74, 2, 78, 31, 0, 1, -128, 1, -74, 2, 78, 31, -74, 2, 78, 32, 0, 17, 0, 2, 84, 49, 0, 0, 7, 16, 0, 4};
        byte[] testupdateMsg = new byte[]{0};
        ChannelBuffer buffer = ChannelBuffers.dynamicBuffer();
        buffer.writeBytes(updateMsg);
        PcepMessageReader reader = PcepFactories.getGenericReader();
        PcepMessage message = null;
        message = (PcepMessage)reader.readFrom(buffer);
        MatcherAssert.assertThat((Object)message, (Matcher)Matchers.instanceOf(PcepUpdateMsg.class));
        ChannelBuffer buf = ChannelBuffers.dynamicBuffer();
        message.writeTo(buf);
        testupdateMsg = buf.array();
        int readLen = buf.writerIndex() - 0;
        testupdateMsg = new byte[readLen];
        buf.readBytes(testupdateMsg, 0, readLen);
        MatcherAssert.assertThat((Object)testupdateMsg, (Matcher)Is.is((Object)updateMsg));
    }

    @Test
    public void pcepUpdateMsgTest6() throws PcepParseException {
        byte[] updateMsg = new byte[]{32, 11, 0, 72, 33, 16, 0, 20, 0, 0, 0, 0, 0, 0, 0, 3, 0, 17, 0, 2, 84, 49, 0, 0, 32, 16, 0, 44, 0, 0, 16, 3, 0, 18, 0, 16, -74, 2, 78, 31, 0, 1, -128, 1, -74, 2, 78, 31, -74, 2, 78, 32, 0, 17, 0, 2, 84, 49, 0, 0, 0, 20, 0, 4, 0, 0, 0, 8, 7, 16, 0, 4};
        byte[] testupdateMsg = new byte[]{0};
        ChannelBuffer buffer = ChannelBuffers.dynamicBuffer();
        buffer.writeBytes(updateMsg);
        PcepMessageReader reader = PcepFactories.getGenericReader();
        PcepMessage message = null;
        message = (PcepMessage)reader.readFrom(buffer);
        MatcherAssert.assertThat((Object)message, (Matcher)Matchers.instanceOf(PcepUpdateMsg.class));
        ChannelBuffer buf = ChannelBuffers.dynamicBuffer();
        message.writeTo(buf);
        testupdateMsg = buf.array();
        int readLen = buf.writerIndex() - 0;
        testupdateMsg = new byte[readLen];
        buf.readBytes(testupdateMsg, 0, readLen);
        MatcherAssert.assertThat((Object)testupdateMsg, (Matcher)Is.is((Object)updateMsg));
    }

    @Test
    public void pcepUpdateMsgTest7() throws PcepParseException {
        byte[] updateMsg = new byte[]{32, 11, 0, 72, 33, 16, 0, 20, 0, 0, 0, 0, 0, 0, 0, 3, 0, 17, 0, 2, 84, 49, 0, 0, 32, 16, 0, 44, 0, 0, 16, 3, 0, 18, 0, 16, -74, 2, 78, 31, 0, 1, -128, 1, -74, 2, 78, 31, -74, 2, 78, 32, 0, 17, 0, 2, 84, 49, 0, 0, 0, 20, 0, 4, 0, 0, 0, 8, 7, 16, 0, 4};
        byte[] testupdateMsg = new byte[]{0};
        ChannelBuffer buffer = ChannelBuffers.dynamicBuffer();
        buffer.writeBytes(updateMsg);
        PcepMessageReader reader = PcepFactories.getGenericReader();
        PcepMessage message = null;
        message = (PcepMessage)reader.readFrom(buffer);
        MatcherAssert.assertThat((Object)message, (Matcher)Matchers.instanceOf(PcepUpdateMsg.class));
        ChannelBuffer buf = ChannelBuffers.dynamicBuffer();
        message.writeTo(buf);
        testupdateMsg = buf.array();
        int readLen = buf.writerIndex() - 0;
        testupdateMsg = new byte[readLen];
        buf.readBytes(testupdateMsg, 0, readLen);
        MatcherAssert.assertThat((Object)testupdateMsg, (Matcher)Is.is((Object)updateMsg));
    }

    @Test
    public void pcepUpdateMsgTest8() throws PcepParseException {
        byte[] updateMsg = new byte[]{32, 11, 0, 80, 33, 16, 0, 20, 0, 0, 0, 0, 0, 0, 0, 3, 0, 17, 0, 2, 84, 49, 0, 0, 32, 16, 0, 44, 0, 0, 16, 3, 0, 18, 0, 16, -74, 2, 78, 31, 0, 1, -128, 1, -74, 2, 78, 31, -74, 2, 78, 32, 0, 17, 0, 2, 84, 49, 0, 0, 0, 20, 0, 4, 0, 0, 0, 8, 7, 16, 0, 12, 1, 8, 17, 1, 1, 1, 4, 0};
        byte[] testupdateMsg = new byte[]{0};
        ChannelBuffer buffer = ChannelBuffers.dynamicBuffer();
        buffer.writeBytes(updateMsg);
        PcepMessageReader reader = PcepFactories.getGenericReader();
        PcepMessage message = null;
        message = (PcepMessage)reader.readFrom(buffer);
        MatcherAssert.assertThat((Object)message, (Matcher)Matchers.instanceOf(PcepUpdateMsg.class));
        ChannelBuffer buf = ChannelBuffers.dynamicBuffer();
        message.writeTo(buf);
        testupdateMsg = buf.array();
        int readLen = buf.writerIndex() - 0;
        testupdateMsg = new byte[readLen];
        buf.readBytes(testupdateMsg, 0, readLen);
        MatcherAssert.assertThat((Object)testupdateMsg, (Matcher)Is.is((Object)updateMsg));
    }

    @Test
    public void pcepUpdateMsgTest9() throws PcepParseException {
        byte[] updateMsg = new byte[]{32, 11, 0, 88, 33, 16, 0, 20, 0, 0, 0, 0, 0, 0, 0, 3, 0, 17, 0, 2, 84, 49, 0, 0, 32, 16, 0, 44, 0, 0, 16, 3, 0, 18, 0, 16, -74, 2, 78, 31, 0, 1, -128, 1, -74, 2, 78, 31, -74, 2, 78, 32, 0, 17, 0, 2, 84, 49, 0, 0, 0, 20, 0, 4, 0, 0, 0, 8, 7, 16, 0, 20, 1, 8, 17, 1, 1, 1, 4, 0, 1, 8, 17, 1, 1, 1, 4, 0};
        byte[] testupdateMsg = new byte[]{0};
        ChannelBuffer buffer = ChannelBuffers.dynamicBuffer();
        buffer.writeBytes(updateMsg);
        PcepMessageReader reader = PcepFactories.getGenericReader();
        PcepMessage message = null;
        message = (PcepMessage)reader.readFrom(buffer);
        MatcherAssert.assertThat((Object)message, (Matcher)Matchers.instanceOf(PcepUpdateMsg.class));
        ChannelBuffer buf = ChannelBuffers.dynamicBuffer();
        message.writeTo(buf);
        testupdateMsg = buf.array();
        int readLen = buf.writerIndex() - 0;
        testupdateMsg = new byte[readLen];
        buf.readBytes(testupdateMsg, 0, readLen);
        MatcherAssert.assertThat((Object)testupdateMsg, (Matcher)Is.is((Object)updateMsg));
    }

    @Test
    public void pcepUpdateMsgTest10() throws PcepParseException {
        byte[] updateMsg = new byte[]{32, 11, 0, 108, 33, 16, 0, 20, 0, 0, 0, 0, 0, 0, 0, 3, 0, 17, 0, 2, 84, 49, 0, 0, 32, 16, 0, 44, 0, 0, 16, 3, 0, 18, 0, 16, -74, 2, 78, 31, 0, 1, -128, 1, -74, 2, 78, 31, -74, 2, 78, 32, 0, 17, 0, 2, 84, 49, 0, 0, 0, 20, 0, 4, 0, 0, 0, 8, 7, 16, 0, 20, 1, 8, 17, 1, 1, 1, 4, 0, 1, 8, 17, 1, 1, 1, 4, 0, 9, 16, 0, 20, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 7, 7, 0, 0};
        byte[] testupdateMsg = new byte[]{0};
        ChannelBuffer buffer = ChannelBuffers.dynamicBuffer();
        buffer.writeBytes(updateMsg);
        PcepMessageReader reader = PcepFactories.getGenericReader();
        PcepMessage message = null;
        message = (PcepMessage)reader.readFrom(buffer);
        MatcherAssert.assertThat((Object)message, (Matcher)Matchers.instanceOf(PcepUpdateMsg.class));
        ChannelBuffer buf = ChannelBuffers.dynamicBuffer();
        message.writeTo(buf);
        testupdateMsg = buf.array();
        int readLen = buf.writerIndex() - 0;
        testupdateMsg = new byte[readLen];
        buf.readBytes(testupdateMsg, 0, readLen);
        MatcherAssert.assertThat((Object)testupdateMsg, (Matcher)Is.is((Object)updateMsg));
    }

    @Test
    public void pcepUpdateMsgTest11() throws PcepParseException {
        byte[] updateMsg = new byte[]{32, 11, 0, 120, 33, 16, 0, 20, 0, 0, 0, 0, 0, 0, 0, 3, 0, 17, 0, 2, 84, 49, 0, 0, 32, 16, 0, 44, 0, 0, 16, 3, 0, 18, 0, 16, -74, 2, 78, 31, 0, 1, -128, 1, -74, 2, 78, 31, -74, 2, 78, 32, 0, 17, 0, 2, 84, 49, 0, 0, 0, 20, 0, 4, 0, 0, 0, 8, 7, 16, 0, 20, 1, 8, 17, 1, 1, 1, 4, 0, 1, 8, 17, 1, 1, 1, 4, 0, 9, 16, 0, 20, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 7, 7, 0, 0, 6, 16, 0, 12, 0, 0, 1, 3, 0, 0, 0, 32};
        byte[] testupdateMsg = new byte[]{0};
        ChannelBuffer buffer = ChannelBuffers.dynamicBuffer();
        buffer.writeBytes(updateMsg);
        PcepMessageReader reader = PcepFactories.getGenericReader();
        PcepMessage message = null;
        message = (PcepMessage)reader.readFrom(buffer);
        MatcherAssert.assertThat((Object)message, (Matcher)Matchers.instanceOf(PcepUpdateMsg.class));
        ChannelBuffer buf = ChannelBuffers.dynamicBuffer();
        message.writeTo(buf);
        testupdateMsg = buf.array();
        int readLen = buf.writerIndex() - 0;
        testupdateMsg = new byte[readLen];
        buf.readBytes(testupdateMsg, 0, readLen);
        MatcherAssert.assertThat((Object)testupdateMsg, (Matcher)Is.is((Object)updateMsg));
    }

    @Test
    public void pcepUpdateMsgTest12() throws PcepParseException {
        byte[] updateMsg = new byte[]{32, 11, 0, 112, 33, 16, 0, 12, 0, 0, 0, 0, 0, 0, 0, 3, 32, 16, 0, 44, 0, 0, 16, 3, 0, 18, 0, 16, -74, 2, 78, 31, 0, 1, -128, 1, -74, 2, 78, 31, -74, 2, 78, 32, 0, 17, 0, 2, 84, 49, 0, 0, 0, 20, 0, 4, 0, 0, 0, 8, 7, 16, 0, 20, 1, 8, 17, 1, 1, 1, 4, 0, 1, 8, 17, 1, 1, 1, 4, 0, 9, 16, 0, 20, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 7, 7, 0, 0, 6, 16, 0, 12, 0, 0, 1, 3, 0, 0, 0, 32};
        byte[] testupdateMsg = new byte[]{0};
        ChannelBuffer buffer = ChannelBuffers.dynamicBuffer();
        buffer.writeBytes(updateMsg);
        PcepMessageReader reader = PcepFactories.getGenericReader();
        PcepMessage message = null;
        message = (PcepMessage)reader.readFrom(buffer);
        MatcherAssert.assertThat((Object)message, (Matcher)Matchers.instanceOf(PcepUpdateMsg.class));
        ChannelBuffer buf = ChannelBuffers.dynamicBuffer();
        message.writeTo(buf);
        testupdateMsg = buf.array();
        int readLen = buf.writerIndex() - 0;
        testupdateMsg = new byte[readLen];
        buf.readBytes(testupdateMsg, 0, readLen);
        MatcherAssert.assertThat((Object)testupdateMsg, (Matcher)Is.is((Object)updateMsg));
    }

    @Test
    public void pcepUpdateMsgTest13() throws PcepParseException {
        byte[] updateMsg = new byte[]{32, 11, 0, 112, 33, 16, 0, 12, 0, 0, 0, 0, 0, 0, 0, 3, 32, 16, 0, 44, 0, 0, 16, 3, 0, 18, 0, 16, -74, 2, 78, 31, 0, 1, -128, 1, -74, 2, 78, 31, -74, 2, 78, 32, 0, 17, 0, 2, 84, 49, 0, 0, 0, 20, 0, 4, 0, 0, 0, 8, 7, 16, 0, 20, 1, 8, 17, 1, 1, 1, 4, 0, 1, 8, 17, 1, 1, 1, 4, 0, 9, 16, 0, 20, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 7, 7, 0, 0, 6, 16, 0, 12, 0, 0, 1, 3, 0, 0, 0, 32};
        byte[] testupdateMsg = new byte[]{0};
        ChannelBuffer buffer = ChannelBuffers.dynamicBuffer();
        buffer.writeBytes(updateMsg);
        PcepMessageReader reader = PcepFactories.getGenericReader();
        PcepMessage message = null;
        message = (PcepMessage)reader.readFrom(buffer);
        MatcherAssert.assertThat((Object)message, (Matcher)Matchers.instanceOf(PcepUpdateMsg.class));
        ChannelBuffer buf = ChannelBuffers.dynamicBuffer();
        message.writeTo(buf);
        testupdateMsg = buf.array();
        int readLen = buf.writerIndex() - 0;
        testupdateMsg = new byte[readLen];
        buf.readBytes(testupdateMsg, 0, readLen);
        MatcherAssert.assertThat((Object)testupdateMsg, (Matcher)Is.is((Object)updateMsg));
    }

    @Test
    public void pcepUpdateMsgTest14() throws PcepParseException {
        byte[] updateMsg = new byte[]{32, 11, 0, 104, 33, 16, 0, 12, 0, 0, 0, 0, 0, 0, 0, 3, 32, 16, 0, 36, 0, 0, 16, 3, 0, 18, 0, 16, -74, 2, 78, 31, 0, 1, -128, 1, -74, 2, 78, 31, -74, 2, 78, 32, 0, 17, 0, 2, 84, 49, 0, 0, 7, 16, 0, 20, 1, 8, 17, 1, 1, 1, 4, 0, 1, 8, 17, 1, 1, 1, 4, 0, 9, 16, 0, 20, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 7, 7, 0, 0, 6, 16, 0, 12, 0, 0, 1, 3, 0, 0, 0, 32};
        byte[] testupdateMsg = new byte[]{0};
        ChannelBuffer buffer = ChannelBuffers.dynamicBuffer();
        buffer.writeBytes(updateMsg);
        PcepMessageReader reader = PcepFactories.getGenericReader();
        PcepMessage message = null;
        message = (PcepMessage)reader.readFrom(buffer);
        MatcherAssert.assertThat((Object)message, (Matcher)Matchers.instanceOf(PcepUpdateMsg.class));
        ChannelBuffer buf = ChannelBuffers.dynamicBuffer();
        message.writeTo(buf);
        testupdateMsg = buf.array();
        int readLen = buf.writerIndex() - 0;
        testupdateMsg = new byte[readLen];
        buf.readBytes(testupdateMsg, 0, readLen);
        MatcherAssert.assertThat((Object)testupdateMsg, (Matcher)Is.is((Object)updateMsg));
    }

    @Test
    public void pcepUpdateMsgTest15() throws PcepParseException {
        byte[] updateMsg = new byte[]{32, 11, 0, 104, 33, 16, 0, 12, 0, 0, 0, 0, 0, 0, 0, 3, 32, 16, 0, 36, 0, 0, 16, 3, 0, 18, 0, 16, -74, 2, 78, 31, 0, 1, -128, 1, -74, 2, 78, 31, -74, 2, 78, 32, 0, 17, 0, 2, 84, 49, 0, 0, 7, 16, 0, 20, 1, 8, 17, 1, 1, 1, 4, 0, 1, 8, 17, 1, 1, 1, 4, 0, 9, 16, 0, 20, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 7, 7, 0, 0, 6, 16, 0, 12, 0, 0, 1, 3, 0, 0, 0, 32};
        byte[] testupdateMsg = new byte[]{0};
        ChannelBuffer buffer = ChannelBuffers.dynamicBuffer();
        buffer.writeBytes(updateMsg);
        PcepMessageReader reader = PcepFactories.getGenericReader();
        PcepMessage message = null;
        message = (PcepMessage)reader.readFrom(buffer);
        MatcherAssert.assertThat((Object)message, (Matcher)Matchers.instanceOf(PcepUpdateMsg.class));
        ChannelBuffer buf = ChannelBuffers.dynamicBuffer();
        message.writeTo(buf);
        testupdateMsg = buf.array();
        int readLen = buf.writerIndex() - 0;
        testupdateMsg = new byte[readLen];
        buf.readBytes(testupdateMsg, 0, readLen);
        MatcherAssert.assertThat((Object)testupdateMsg, (Matcher)Is.is((Object)updateMsg));
    }

    @Test
    public void pcepUpdateMsgTest16() throws PcepParseException {
        byte[] updateMsg = new byte[]{32, 11, 0, 96, 33, 16, 0, 12, 0, 0, 0, 0, 0, 0, 0, 3, 32, 16, 0, 28, 0, 0, 16, 3, 0, 18, 0, 16, -74, 2, 78, 31, 0, 1, -128, 1, -74, 2, 78, 31, -74, 2, 78, 32, 7, 16, 0, 20, 1, 8, 17, 1, 1, 1, 4, 0, 1, 8, 17, 1, 1, 1, 4, 0, 9, 16, 0, 20, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 7, 7, 0, 0, 6, 16, 0, 12, 0, 0, 1, 3, 0, 0, 0, 32};
        byte[] testupdateMsg = new byte[]{0};
        ChannelBuffer buffer = ChannelBuffers.dynamicBuffer();
        buffer.writeBytes(updateMsg);
        PcepMessageReader reader = PcepFactories.getGenericReader();
        PcepMessage message = null;
        message = (PcepMessage)reader.readFrom(buffer);
        MatcherAssert.assertThat((Object)message, (Matcher)Matchers.instanceOf(PcepUpdateMsg.class));
        ChannelBuffer buf = ChannelBuffers.dynamicBuffer();
        message.writeTo(buf);
        testupdateMsg = buf.array();
        int readLen = buf.writerIndex() - 0;
        testupdateMsg = new byte[readLen];
        buf.readBytes(testupdateMsg, 0, readLen);
        MatcherAssert.assertThat((Object)testupdateMsg, (Matcher)Is.is((Object)updateMsg));
    }

    @Test
    public void pcepUpdateMsgTest17() throws PcepParseException {
        byte[] updateMsg = new byte[]{32, 11, 0, 84, 33, 16, 0, 12, 0, 0, 0, 0, 0, 0, 0, 3, 32, 16, 0, 28, 0, 0, 16, 5, 0, 18, 0, 16, -74, 2, 78, 31, 0, 1, -128, 1, -74, 2, 78, 31, -74, 2, 78, 32, 7, 16, 0, 20, 1, 8, 17, 1, 1, 1, 4, 0, 1, 8, 17, 1, 1, 1, 4, 0, 9, 16, 0, 20, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 7, 7, 0, 0};
        byte[] testupdateMsg = new byte[]{0};
        ChannelBuffer buffer = ChannelBuffers.dynamicBuffer();
        buffer.writeBytes(updateMsg);
        PcepMessageReader reader = PcepFactories.getGenericReader();
        PcepMessage message = null;
        message = (PcepMessage)reader.readFrom(buffer);
        MatcherAssert.assertThat((Object)message, (Matcher)Matchers.instanceOf(PcepUpdateMsg.class));
        ChannelBuffer buf = ChannelBuffers.dynamicBuffer();
        message.writeTo(buf);
        testupdateMsg = buf.array();
        int readLen = buf.writerIndex() - 0;
        testupdateMsg = new byte[readLen];
        buf.readBytes(testupdateMsg, 0, readLen);
        MatcherAssert.assertThat((Object)testupdateMsg, (Matcher)Is.is((Object)updateMsg));
    }

    @Test
    public void pcepUpdateMsgTest18() throws PcepParseException {
        byte[] updateMsg = new byte[]{32, 11, 0, 76, 33, 16, 0, 12, 0, 0, 0, 0, 0, 0, 0, 3, 32, 16, 0, 28, 0, 0, 16, 3, 0, 18, 0, 16, -74, 2, 78, 31, 0, 1, -128, 1, -74, 2, 78, 31, -74, 2, 78, 32, 7, 16, 0, 20, 1, 8, 17, 1, 1, 1, 4, 0, 1, 8, 17, 1, 1, 1, 4, 0, 6, 16, 0, 12, 0, 0, 1, 3, 0, 0, 0, 32};
        byte[] testupdateMsg = new byte[]{0};
        ChannelBuffer buffer = ChannelBuffers.dynamicBuffer();
        buffer.writeBytes(updateMsg);
        PcepMessageReader reader = PcepFactories.getGenericReader();
        PcepMessage message = null;
        message = (PcepMessage)reader.readFrom(buffer);
        MatcherAssert.assertThat((Object)message, (Matcher)Matchers.instanceOf(PcepUpdateMsg.class));
        ChannelBuffer buf = ChannelBuffers.dynamicBuffer();
        message.writeTo(buf);
        testupdateMsg = buf.array();
        int readLen = buf.writerIndex() - 0;
        testupdateMsg = new byte[readLen];
        buf.readBytes(testupdateMsg, 0, readLen);
        MatcherAssert.assertThat((Object)testupdateMsg, (Matcher)Is.is((Object)updateMsg));
    }

    @Test
    public void pcepUpdateMsgTest19() throws PcepParseException {
        byte[] updateMsg = new byte[]{32, 11, 0, 88, 33, 16, 0, 12, 0, 0, 0, 0, 0, 0, 0, 3, 32, 16, 0, 28, 0, 0, 16, 3, 0, 18, 0, 16, -74, 2, 78, 31, 0, 1, -128, 1, -74, 2, 78, 31, -74, 2, 78, 32, 7, 16, 0, 20, 1, 8, 17, 1, 1, 1, 4, 0, 1, 8, 17, 1, 1, 1, 4, 0, 6, 16, 0, 12, 0, 0, 1, 3, 0, 0, 0, 32, 6, 16, 0, 12, 0, 0, 0, 2, 0, 0, 0, 1};
        byte[] testupdateMsg = new byte[]{0};
        ChannelBuffer buffer = ChannelBuffers.dynamicBuffer();
        buffer.writeBytes(updateMsg);
        PcepMessageReader reader = PcepFactories.getGenericReader();
        PcepMessage message = null;
        message = (PcepMessage)reader.readFrom(buffer);
        MatcherAssert.assertThat((Object)message, (Matcher)Matchers.instanceOf(PcepUpdateMsg.class));
        ChannelBuffer buf = ChannelBuffers.dynamicBuffer();
        message.writeTo(buf);
        testupdateMsg = buf.array();
        int readLen = buf.writerIndex() - 0;
        testupdateMsg = new byte[readLen];
        buf.readBytes(testupdateMsg, 0, readLen);
        MatcherAssert.assertThat((Object)testupdateMsg, (Matcher)Is.is((Object)updateMsg));
    }

    @Test
    public void pcepUpdateMsgTest20() throws PcepParseException {
        byte[] updateMsg = new byte[]{32, 11, 0, -128, 33, 16, 0, 20, 0, 0, 0, 0, 0, 0, 0, 3, 0, 17, 0, 2, 84, 49, 0, 0, 32, 16, 0, 44, 0, 0, 16, 3, 0, 18, 0, 16, -74, 2, 78, 31, 0, 1, -128, 1, -74, 2, 78, 31, -74, 2, 78, 32, 0, 17, 0, 2, 84, 49, 0, 0, 0, 20, 0, 4, 0, 0, 0, 8, 7, 16, 0, 20, 1, 8, 17, 1, 1, 1, 4, 0, 1, 8, 17, 1, 1, 1, 4, 0, 9, 16, 0, 20, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 7, 7, 0, 0, 5, 32, 0, 8, 0, 0, 0, 0, 6, 16, 0, 12, 0, 0, 1, 3, 0, 0, 0, 32};
        byte[] testupdateMsg = new byte[]{0};
        ChannelBuffer buffer = ChannelBuffers.dynamicBuffer();
        buffer.writeBytes(updateMsg);
        PcepMessageReader reader = PcepFactories.getGenericReader();
        PcepMessage message = null;
        message = (PcepMessage)reader.readFrom(buffer);
        MatcherAssert.assertThat((Object)message, (Matcher)Matchers.instanceOf(PcepUpdateMsg.class));
        ChannelBuffer buf = ChannelBuffers.dynamicBuffer();
        message.writeTo(buf);
        testupdateMsg = buf.array();
        int readLen = buf.writerIndex() - 0;
        testupdateMsg = new byte[readLen];
        buf.readBytes(testupdateMsg, 0, readLen);
        MatcherAssert.assertThat((Object)testupdateMsg, (Matcher)Is.is((Object)updateMsg));
    }

    @Test
    public void pcepUpdateMsgTest21() throws PcepParseException {
        byte[] updateMsg = new byte[]{32, 11, 0, 72, 33, 16, 0, 12, 0, 0, 0, 0, 0, 0, 0, 3, 32, 16, 0, 28, 0, 0, 16, 3, 0, 18, 0, 16, -74, 2, 78, 31, 0, 1, -128, 1, -74, 2, 78, 31, -74, 2, 78, 32, 7, 16, 0, 20, 1, 8, 17, 1, 1, 1, 4, 0, 1, 8, 17, 1, 1, 1, 4, 0, 5, 32, 0, 8, 0, 0, 0, 0};
        byte[] testupdateMsg = new byte[]{0};
        ChannelBuffer buffer = ChannelBuffers.dynamicBuffer();
        buffer.writeBytes(updateMsg);
        PcepMessageReader reader = PcepFactories.getGenericReader();
        PcepMessage message = null;
        message = (PcepMessage)reader.readFrom(buffer);
        MatcherAssert.assertThat((Object)message, (Matcher)Matchers.instanceOf(PcepUpdateMsg.class));
        ChannelBuffer buf = ChannelBuffers.dynamicBuffer();
        message.writeTo(buf);
        testupdateMsg = buf.array();
        int readLen = buf.writerIndex() - 0;
        testupdateMsg = new byte[readLen];
        buf.readBytes(testupdateMsg, 0, readLen);
        MatcherAssert.assertThat((Object)testupdateMsg, (Matcher)Is.is((Object)updateMsg));
    }

    @Test
    public void pcepUpdateMsgTest22() throws PcepParseException {
        byte[] updateMsg = new byte[]{32, 11, 0, 92, 33, 16, 0, 12, 0, 0, 0, 0, 0, 0, 0, 3, 32, 16, 0, 28, 0, 0, 16, 3, 0, 18, 0, 16, -74, 2, 78, 31, 0, 1, -128, 1, -74, 2, 78, 31, -74, 2, 78, 32, 7, 16, 0, 20, 1, 8, 17, 1, 1, 1, 4, 0, 1, 8, 17, 1, 1, 1, 4, 0, 9, 16, 0, 20, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 7, 7, 0, 0, 5, 32, 0, 8, 0, 0, 0, 0};
        byte[] testupdateMsg = new byte[]{0};
        ChannelBuffer buffer = ChannelBuffers.dynamicBuffer();
        buffer.writeBytes(updateMsg);
        PcepMessageReader reader = PcepFactories.getGenericReader();
        PcepMessage message = null;
        message = (PcepMessage)reader.readFrom(buffer);
        MatcherAssert.assertThat((Object)message, (Matcher)Matchers.instanceOf(PcepUpdateMsg.class));
        ChannelBuffer buf = ChannelBuffers.dynamicBuffer();
        message.writeTo(buf);
        testupdateMsg = buf.array();
        int readLen = buf.writerIndex() - 0;
        testupdateMsg = new byte[readLen];
        buf.readBytes(testupdateMsg, 0, readLen);
        MatcherAssert.assertThat((Object)testupdateMsg, (Matcher)Is.is((Object)updateMsg));
    }

    @Test
    public void pcepUpdateMsgTest23() throws PcepParseException {
        byte[] updateMsg = new byte[]{32, 11, 0, 104, 33, 16, 0, 12, 0, 0, 0, 0, 0, 0, 0, 3, 32, 16, 0, 28, 0, 0, 16, 3, 0, 18, 0, 16, -74, 2, 78, 31, 0, 1, -128, 1, -74, 2, 78, 31, -74, 2, 78, 32, 7, 16, 0, 20, 1, 8, 17, 1, 1, 1, 4, 0, 1, 8, 17, 1, 1, 1, 4, 0, 9, 16, 0, 20, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 7, 7, 0, 0, 5, 32, 0, 8, 0, 0, 0, 0, 6, 16, 0, 12, 0, 0, 1, 3, 0, 0, 0, 32};
        byte[] testupdateMsg = new byte[]{0};
        ChannelBuffer buffer = ChannelBuffers.dynamicBuffer();
        buffer.writeBytes(updateMsg);
        PcepMessageReader reader = PcepFactories.getGenericReader();
        PcepMessage message = null;
        message = (PcepMessage)reader.readFrom(buffer);
        MatcherAssert.assertThat((Object)message, (Matcher)Matchers.instanceOf(PcepUpdateMsg.class));
        ChannelBuffer buf = ChannelBuffers.dynamicBuffer();
        message.writeTo(buf);
        testupdateMsg = buf.array();
        int readLen = buf.writerIndex() - 0;
        testupdateMsg = new byte[readLen];
        buf.readBytes(testupdateMsg, 0, readLen);
        MatcherAssert.assertThat((Object)testupdateMsg, (Matcher)Is.is((Object)updateMsg));
    }

    @Test
    public void pcepUpdateMsgTest24() throws PcepParseException {
        byte[] updateMsg = new byte[]{32, 11, 0, 112, 33, 16, 0, 12, 0, 0, 0, 0, 0, 0, 0, 3, 32, 16, 0, 36, 0, 0, 16, 3, 0, 18, 0, 16, -74, 2, 78, 31, 0, 1, -128, 1, -74, 2, 78, 31, -74, 2, 78, 32, 0, 17, 0, 2, 84, 49, 0, 0, 7, 16, 0, 20, 1, 8, 17, 1, 1, 1, 4, 0, 1, 8, 17, 1, 1, 1, 4, 0, 9, 16, 0, 20, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 7, 7, 0, 0, 5, 32, 0, 8, 0, 0, 0, 0, 6, 16, 0, 12, 0, 0, 1, 3, 0, 0, 0, 32};
        byte[] testupdateMsg = new byte[]{0};
        ChannelBuffer buffer = ChannelBuffers.dynamicBuffer();
        buffer.writeBytes(updateMsg);
        PcepMessageReader reader = PcepFactories.getGenericReader();
        PcepMessage message = null;
        message = (PcepMessage)reader.readFrom(buffer);
        MatcherAssert.assertThat((Object)message, (Matcher)Matchers.instanceOf(PcepUpdateMsg.class));
        ChannelBuffer buf = ChannelBuffers.dynamicBuffer();
        message.writeTo(buf);
        testupdateMsg = buf.array();
        int readLen = buf.writerIndex() - 0;
        testupdateMsg = new byte[readLen];
        buf.readBytes(testupdateMsg, 0, readLen);
        MatcherAssert.assertThat((Object)testupdateMsg, (Matcher)Is.is((Object)updateMsg));
    }

    @Test
    public void pcepUpdateMsgTest25() throws PcepParseException {
        byte[] updateMsg = new byte[]{32, 11, 0, 112, 33, 16, 0, 12, 0, 0, 0, 0, 0, 0, 0, 3, 32, 16, 0, 36, 0, 0, 16, 3, 0, 18, 0, 16, -74, 2, 78, 31, 0, 1, -128, 1, -74, 2, 78, 31, -74, 2, 78, 32, 0, 17, 0, 2, 84, 49, 0, 0, 7, 16, 0, 20, 1, 8, 17, 1, 1, 1, 4, 0, 1, 8, 17, 1, 1, 1, 4, 0, 9, 16, 0, 20, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 7, 7, 0, 0, 5, 32, 0, 8, 0, 0, 0, 0, 6, 16, 0, 12, 0, 0, 1, 3, 0, 0, 0, 32};
        byte[] testupdateMsg = new byte[]{0};
        ChannelBuffer buffer = ChannelBuffers.dynamicBuffer();
        buffer.writeBytes(updateMsg);
        PcepMessageReader reader = PcepFactories.getGenericReader();
        PcepMessage message = null;
        message = (PcepMessage)reader.readFrom(buffer);
        MatcherAssert.assertThat((Object)message, (Matcher)Matchers.instanceOf(PcepUpdateMsg.class));
        ChannelBuffer buf = ChannelBuffers.dynamicBuffer();
        message.writeTo(buf);
        testupdateMsg = buf.array();
        int readLen = buf.writerIndex() - 0;
        testupdateMsg = new byte[readLen];
        buf.readBytes(testupdateMsg, 0, readLen);
        MatcherAssert.assertThat((Object)testupdateMsg, (Matcher)Is.is((Object)updateMsg));
    }

    @Test
    public void pcepUpdateMsgTest26() throws PcepParseException {
        byte[] updateMsg = new byte[]{32, 11, 0, 120, 33, 16, 0, 12, 0, 0, 0, 0, 0, 0, 0, 3, 32, 16, 0, 44, 0, 0, 16, 3, 0, 18, 0, 16, -74, 2, 78, 31, 0, 1, -128, 1, -74, 2, 78, 31, -74, 2, 78, 32, 0, 17, 0, 2, 84, 49, 0, 0, 0, 20, 0, 4, 0, 0, 0, 8, 7, 16, 0, 20, 1, 8, 17, 1, 1, 1, 4, 0, 1, 8, 17, 1, 1, 1, 4, 0, 9, 16, 0, 20, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 7, 7, 0, 0, 5, 32, 0, 8, 0, 0, 0, 0, 6, 16, 0, 12, 0, 0, 1, 3, 0, 0, 0, 32};
        byte[] testupdateMsg = new byte[]{0};
        ChannelBuffer buffer = ChannelBuffers.dynamicBuffer();
        buffer.writeBytes(updateMsg);
        PcepMessageReader reader = PcepFactories.getGenericReader();
        PcepMessage message = null;
        message = (PcepMessage)reader.readFrom(buffer);
        MatcherAssert.assertThat((Object)message, (Matcher)Matchers.instanceOf(PcepUpdateMsg.class));
        ChannelBuffer buf = ChannelBuffers.dynamicBuffer();
        message.writeTo(buf);
        testupdateMsg = buf.array();
        int readLen = buf.writerIndex() - 0;
        testupdateMsg = new byte[readLen];
        buf.readBytes(testupdateMsg, 0, readLen);
        MatcherAssert.assertThat((Object)testupdateMsg, (Matcher)Is.is((Object)updateMsg));
    }

    @Test
    public void pcepUpdateMsgTest27() throws PcepParseException {
        byte[] updateMsg = new byte[]{32, 11, 0, 120, 33, 16, 0, 12, 0, 0, 0, 0, 0, 0, 0, 3, 32, 16, 0, 44, 0, 0, 16, 3, 0, 18, 0, 16, -74, 2, 78, 31, 0, 1, -128, 1, -74, 2, 78, 31, -74, 2, 78, 32, 0, 17, 0, 2, 84, 49, 0, 0, 0, 20, 0, 4, 0, 0, 0, 8, 7, 16, 0, 20, 1, 8, 17, 1, 1, 1, 4, 0, 1, 8, 17, 1, 1, 1, 4, 0, 9, 16, 0, 20, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 7, 7, 0, 0, 5, 32, 0, 8, 0, 0, 0, 0, 6, 16, 0, 12, 0, 0, 1, 3, 0, 0, 0, 32};
        byte[] testupdateMsg = new byte[]{0};
        ChannelBuffer buffer = ChannelBuffers.dynamicBuffer();
        buffer.writeBytes(updateMsg);
        PcepMessageReader reader = PcepFactories.getGenericReader();
        PcepMessage message = null;
        message = (PcepMessage)reader.readFrom(buffer);
        MatcherAssert.assertThat((Object)message, (Matcher)Matchers.instanceOf(PcepUpdateMsg.class));
        ChannelBuffer buf = ChannelBuffers.dynamicBuffer();
        message.writeTo(buf);
        testupdateMsg = buf.array();
        int readLen = buf.writerIndex() - 0;
        testupdateMsg = new byte[readLen];
        buf.readBytes(testupdateMsg, 0, readLen);
        MatcherAssert.assertThat((Object)testupdateMsg, (Matcher)Is.is((Object)updateMsg));
    }

    @Test
    public void pcepUpdateMsgTest28() throws PcepParseException {
        byte[] updateMsg = new byte[]{32, 11, 0, -128, 33, 16, 0, 20, 0, 0, 0, 0, 0, 0, 0, 3, 0, 17, 0, 2, 84, 49, 0, 0, 32, 16, 0, 44, 0, 0, 16, 3, 0, 18, 0, 16, -74, 2, 78, 31, 0, 1, -128, 1, -74, 2, 78, 31, -74, 2, 78, 32, 0, 17, 0, 2, 84, 49, 0, 0, 0, 20, 0, 4, 0, 0, 0, 8, 7, 16, 0, 20, 1, 8, 17, 1, 1, 1, 4, 0, 1, 8, 17, 1, 1, 1, 4, 0, 9, 16, 0, 20, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 7, 7, 0, 0, 5, 32, 0, 8, 0, 0, 0, 0, 6, 16, 0, 12, 0, 0, 1, 3, 0, 0, 0, 32};
        byte[] testupdateMsg = new byte[]{0};
        ChannelBuffer buffer = ChannelBuffers.dynamicBuffer();
        buffer.writeBytes(updateMsg);
        PcepMessageReader reader = PcepFactories.getGenericReader();
        PcepMessage message = null;
        message = (PcepMessage)reader.readFrom(buffer);
        MatcherAssert.assertThat((Object)message, (Matcher)Matchers.instanceOf(PcepUpdateMsg.class));
        ChannelBuffer buf = ChannelBuffers.dynamicBuffer();
        message.writeTo(buf);
        testupdateMsg = buf.array();
        int readLen = buf.writerIndex() - 0;
        testupdateMsg = new byte[readLen];
        buf.readBytes(testupdateMsg, 0, readLen);
        MatcherAssert.assertThat((Object)testupdateMsg, (Matcher)Is.is((Object)updateMsg));
    }

    @Test
    public void pcepUpdateMsgTest29() throws PcepParseException {
        byte[] updateMsg = new byte[]{32, 11, 0, 104, 33, 16, 0, 12, 0, 0, 0, 0, 0, 0, 0, 3, 32, 16, 0, 28, 0, 0, 16, 3, 0, 18, 0, 16, -74, 2, 78, 31, 0, 1, -128, 1, -74, 2, 78, 31, -74, 2, 78, 32, 7, 16, 0, 20, 1, 8, 17, 1, 1, 1, 4, 0, 1, 8, 17, 1, 1, 1, 4, 0, 9, 16, 0, 20, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 7, 7, 0, 0, 5, 32, 0, 8, 0, 0, 0, 0, 6, 16, 0, 12, 0, 0, 1, 3, 0, 0, 0, 32};
        byte[] testupdateMsg = new byte[]{0};
        ChannelBuffer buffer = ChannelBuffers.dynamicBuffer();
        buffer.writeBytes(updateMsg);
        PcepMessageReader reader = PcepFactories.getGenericReader();
        PcepMessage message = null;
        message = (PcepMessage)reader.readFrom(buffer);
        MatcherAssert.assertThat((Object)message, (Matcher)Matchers.instanceOf(PcepUpdateMsg.class));
        ChannelBuffer buf = ChannelBuffers.dynamicBuffer();
        message.writeTo(buf);
        testupdateMsg = buf.array();
        int readLen = buf.writerIndex() - 0;
        testupdateMsg = new byte[readLen];
        buf.readBytes(testupdateMsg, 0, readLen);
        MatcherAssert.assertThat((Object)testupdateMsg, (Matcher)Is.is((Object)updateMsg));
    }

    @Test
    public void pcepUpdateMsgTest30() throws PcepParseException {
        byte[] updateMsg = new byte[]{32, 11, 0, 84, 33, 16, 0, 12, 0, 0, 0, 0, 0, 0, 0, 3, 32, 16, 0, 8, 0, 0, 16, 3, 7, 16, 0, 20, 1, 8, 17, 1, 1, 1, 4, 0, 1, 8, 17, 1, 1, 1, 4, 0, 9, 16, 0, 20, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 7, 7, 0, 0, 5, 32, 0, 8, 0, 0, 0, 0, 6, 16, 0, 12, 0, 0, 1, 3, 0, 0, 0, 32};
        byte[] testupdateMsg = new byte[]{0};
        ChannelBuffer buffer = ChannelBuffers.dynamicBuffer();
        buffer.writeBytes(updateMsg);
        PcepMessageReader reader = PcepFactories.getGenericReader();
        PcepMessage message = null;
        message = (PcepMessage)reader.readFrom(buffer);
        MatcherAssert.assertThat((Object)message, (Matcher)Matchers.instanceOf(PcepUpdateMsg.class));
        ChannelBuffer buf = ChannelBuffers.dynamicBuffer();
        message.writeTo(buf);
        testupdateMsg = buf.array();
        int readLen = buf.writerIndex() - 0;
        testupdateMsg = new byte[readLen];
        buf.readBytes(testupdateMsg, 0, readLen);
        MatcherAssert.assertThat((Object)testupdateMsg, (Matcher)Is.is((Object)updateMsg));
    }

    @Test
    public void pcepUpdateMsgTest31() throws PcepParseException {
        byte[] updateMsg = new byte[]{32, 11, 0, 92, 33, 16, 0, 12, 0, 0, 0, 0, 0, 0, 0, 3, 32, 16, 0, 16, 0, 0, 16, 3, 0, 20, 0, 4, 0, 0, 0, 8, 7, 16, 0, 20, 1, 8, 17, 1, 1, 1, 4, 0, 1, 8, 17, 1, 1, 1, 4, 0, 9, 16, 0, 20, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 7, 7, 0, 0, 5, 32, 0, 8, 0, 0, 0, 0, 6, 16, 0, 12, 0, 0, 1, 3, 0, 0, 0, 32};
        byte[] testupdateMsg = new byte[]{0};
        ChannelBuffer buffer = ChannelBuffers.dynamicBuffer();
        buffer.writeBytes(updateMsg);
        PcepMessageReader reader = PcepFactories.getGenericReader();
        PcepMessage message = null;
        message = (PcepMessage)reader.readFrom(buffer);
        MatcherAssert.assertThat((Object)message, (Matcher)Matchers.instanceOf(PcepUpdateMsg.class));
        ChannelBuffer buf = ChannelBuffers.dynamicBuffer();
        message.writeTo(buf);
        testupdateMsg = buf.array();
        int readLen = buf.writerIndex() - 0;
        testupdateMsg = new byte[readLen];
        buf.readBytes(testupdateMsg, 0, readLen);
        MatcherAssert.assertThat((Object)testupdateMsg, (Matcher)Is.is((Object)updateMsg));
    }

    @Test
    public void pcepUpdateMsgTest32() throws PcepParseException {
        byte[] updateMsg = new byte[]{32, 11, 0, 84, 33, 16, 0, 12, 0, 0, 0, 0, 0, 0, 0, 3, 32, 16, 0, 8, 0, 0, 16, 3, 7, 16, 0, 20, 1, 8, 17, 1, 1, 1, 4, 0, 1, 8, 17, 1, 1, 1, 4, 0, 9, 16, 0, 20, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 7, 7, 0, 0, 5, 32, 0, 8, 0, 0, 0, 0, 6, 16, 0, 12, 0, 0, 1, 3, 0, 0, 0, 32};
        byte[] testupdateMsg = new byte[]{0};
        ChannelBuffer buffer = ChannelBuffers.dynamicBuffer();
        buffer.writeBytes(updateMsg);
        PcepMessageReader reader = PcepFactories.getGenericReader();
        PcepMessage message = null;
        message = (PcepMessage)reader.readFrom(buffer);
        MatcherAssert.assertThat((Object)message, (Matcher)Matchers.instanceOf(PcepUpdateMsg.class));
        ChannelBuffer buf = ChannelBuffers.dynamicBuffer();
        message.writeTo(buf);
        testupdateMsg = buf.array();
        int readLen = buf.writerIndex() - 0;
        testupdateMsg = new byte[readLen];
        buf.readBytes(testupdateMsg, 0, readLen);
        MatcherAssert.assertThat((Object)testupdateMsg, (Matcher)Is.is((Object)updateMsg));
    }

    @Test
    public void pcepUpdateMsgTest33() throws PcepParseException {
        byte[] updateMsg = new byte[]{32, 11, 0, 92, 33, 16, 0, 12, 0, 0, 0, 0, 0, 0, 0, 3, 32, 16, 0, 16, 0, 0, 16, 3, 0, 17, 0, 2, 84, 49, 0, 0, 7, 16, 0, 20, 1, 8, 17, 1, 1, 1, 4, 0, 1, 8, 17, 1, 1, 1, 4, 0, 9, 16, 0, 20, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 7, 7, 0, 0, 5, 32, 0, 8, 0, 0, 0, 0, 6, 16, 0, 12, 0, 0, 1, 3, 0, 0, 0, 32};
        byte[] testupdateMsg = new byte[]{0};
        ChannelBuffer buffer = ChannelBuffers.dynamicBuffer();
        buffer.writeBytes(updateMsg);
        PcepMessageReader reader = PcepFactories.getGenericReader();
        PcepMessage message = null;
        message = (PcepMessage)reader.readFrom(buffer);
        MatcherAssert.assertThat((Object)message, (Matcher)Matchers.instanceOf(PcepUpdateMsg.class));
        ChannelBuffer buf = ChannelBuffers.dynamicBuffer();
        message.writeTo(buf);
        testupdateMsg = buf.array();
        int readLen = buf.writerIndex() - 0;
        testupdateMsg = new byte[readLen];
        buf.readBytes(testupdateMsg, 0, readLen);
        MatcherAssert.assertThat((Object)testupdateMsg, (Matcher)Is.is((Object)updateMsg));
    }

    @Test
    public void pcepUpdateMsgTest34() throws PcepParseException {
        byte[] updateMsg = new byte[]{32, 11, 0, 100, 33, 16, 0, 20, 0, 0, 0, 0, 0, 0, 0, 3, 0, 17, 0, 2, 84, 49, 0, 0, 32, 16, 0, 16, 0, 0, 16, 3, 0, 17, 0, 2, 84, 49, 0, 0, 7, 16, 0, 20, 1, 8, 17, 1, 1, 1, 4, 0, 1, 8, 17, 1, 1, 1, 4, 0, 9, 16, 0, 20, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 7, 7, 0, 0, 5, 32, 0, 8, 0, 0, 0, 0, 6, 16, 0, 12, 0, 0, 1, 3, 0, 0, 0, 32};
        byte[] testupdateMsg = new byte[]{0};
        ChannelBuffer buffer = ChannelBuffers.dynamicBuffer();
        buffer.writeBytes(updateMsg);
        PcepMessageReader reader = PcepFactories.getGenericReader();
        PcepMessage message = null;
        message = (PcepMessage)reader.readFrom(buffer);
        MatcherAssert.assertThat((Object)message, (Matcher)Matchers.instanceOf(PcepUpdateMsg.class));
        ChannelBuffer buf = ChannelBuffers.dynamicBuffer();
        message.writeTo(buf);
        testupdateMsg = buf.array();
        int readLen = buf.writerIndex() - 0;
        testupdateMsg = new byte[readLen];
        buf.readBytes(testupdateMsg, 0, readLen);
        MatcherAssert.assertThat((Object)testupdateMsg, (Matcher)Is.is((Object)updateMsg));
    }
}

