/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.pcepio.protocol.ver1;

import com.google.common.base.MoreObjects;
import java.util.LinkedList;
import java.util.ListIterator;
import org.jboss.netty.buffer.ChannelBuffer;
import org.onosproject.pcepio.exceptions.PcepParseException;
import org.onosproject.pcepio.protocol.PcepErrorObject;
import org.onosproject.pcepio.types.PcepObjectHeader;
import org.onosproject.pcepio.types.PcepValueType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PcepErrorObjectVer1
implements PcepErrorObject {
    protected static final Logger log = LoggerFactory.getLogger(PcepErrorObjectVer1.class);
    public static final byte ERROR_OBJ_TYPE = 1;
    public static final byte ERROR_OBJ_CLASS = 13;
    public static final byte ERROR_OBJECT_VERSION = 1;
    public static final short ERROR_OBJ_MINIMUM_LENGTH = 8;
    public static final int OBJECT_HEADER_LENGTH = 4;
    public static final PcepObjectHeader DEFAULT_ERROR_OBJECT_HEADER = new PcepObjectHeader(13, 1, false, false, 8);
    private PcepObjectHeader errorObjHeader;
    private byte yErrorType;
    private byte yErrorValue;
    private LinkedList<PcepValueType> llOptionalTlv;

    public PcepErrorObjectVer1(PcepObjectHeader errorObjHeader, byte yErrorType, byte yErrorValue, LinkedList<PcepValueType> llOptionalTlv) {
        this.errorObjHeader = errorObjHeader;
        this.yErrorType = yErrorType;
        this.yErrorValue = yErrorValue;
        this.llOptionalTlv = llOptionalTlv;
    }

    public void setLspObjHeader(PcepObjectHeader obj) {
        this.errorObjHeader = obj;
    }

    @Override
    public void setErrorType(byte yErrorType) {
        this.yErrorType = yErrorType;
    }

    @Override
    public void setErrorValue(byte yErrorValue) {
        this.yErrorValue = yErrorValue;
    }

    public PcepObjectHeader getErrorObjHeader() {
        return this.errorObjHeader;
    }

    @Override
    public int getErrorType() {
        return this.yErrorType;
    }

    @Override
    public byte getErrorValue() {
        return this.yErrorValue;
    }

    @Override
    public LinkedList<PcepValueType> getOptionalTlv() {
        return this.llOptionalTlv;
    }

    @Override
    public void setOptionalTlv(LinkedList<PcepValueType> llOptionalTlv) {
        this.llOptionalTlv = llOptionalTlv;
    }

    public static PcepErrorObject read(ChannelBuffer cb) {
        PcepObjectHeader errorObjHeader = PcepObjectHeader.read(cb);
        ChannelBuffer tempCb = cb.readBytes(errorObjHeader.getObjLen() - 4);
        tempCb.readByte();
        tempCb.readByte();
        byte yErrorType = tempCb.readByte();
        byte yErrorValue = tempCb.readByte();
        LinkedList<PcepValueType> llOptionalTlv = PcepErrorObjectVer1.parseOptionalTlv(tempCb);
        return new PcepErrorObjectVer1(errorObjHeader, yErrorType, yErrorValue, llOptionalTlv);
    }

    protected static LinkedList<PcepValueType> parseOptionalTlv(ChannelBuffer cb) {
        LinkedList<PcepValueType> llOutOptionalTlv = new LinkedList<PcepValueType>();
        byte[] yTemp = new byte[cb.readableBytes()];
        cb.readBytes(yTemp);
        return llOutOptionalTlv;
    }

    @Override
    public int write(ChannelBuffer cb) throws PcepParseException {
        int objStartIndex = cb.writerIndex();
        int objLenIndex = this.errorObjHeader.write(cb);
        if (objLenIndex <= 0) {
            throw new PcepParseException("While writing Error Object Header.");
        }
        cb.writeByte(0);
        cb.writeByte(0);
        cb.writeByte((int)this.yErrorType);
        cb.writeByte((int)this.yErrorValue);
        this.packOptionalTlv(cb);
        int length = cb.writerIndex() - objStartIndex;
        this.errorObjHeader.setObjLen((short)length);
        int pad = length % 4;
        if (pad != 0) {
            pad = 4 - pad;
            for (int i = 0; i < pad; ++i) {
                cb.writeByte(0);
            }
            length += pad;
        }
        cb.setShort(objLenIndex, (int)((short)length));
        return length;
    }

    protected int packOptionalTlv(ChannelBuffer cb) {
        ListIterator listIterator = this.llOptionalTlv.listIterator();
        int startIndex = cb.writerIndex();
        while (listIterator.hasNext()) {
            PcepValueType tlv = (PcepValueType)listIterator.next();
            if (tlv == null) {
                log.debug("TLV is null from OptionalTlv list");
                continue;
            }
            tlv.write(cb);
        }
        return cb.writerIndex() - startIndex;
    }

    public String toString() {
        return MoreObjects.toStringHelper(this.getClass()).add("ObjectHeader", (Object)this.errorObjHeader).add("ErrorType", (int)this.yErrorType).add("ErrorValue", (int)this.yErrorValue).add("OptionalTlv", this.llOptionalTlv).toString();
    }

    public static class Builder
    implements PcepErrorObject.Builder {
        private boolean bIsHeaderSet = false;
        private PcepObjectHeader errorObjHeader;
        private byte yErrorType;
        private byte yErrorValue;
        private boolean bIsPFlagSet = false;
        private boolean bPFlag;
        private boolean bIsIFlagSet = false;
        private boolean bIFlag;
        private LinkedList<PcepValueType> llOptionalTlv = new LinkedList();

        @Override
        public PcepErrorObject build() {
            PcepObjectHeader errorObjHeader;
            PcepObjectHeader pcepObjectHeader = errorObjHeader = this.bIsHeaderSet ? this.errorObjHeader : DEFAULT_ERROR_OBJECT_HEADER;
            if (this.bIsPFlagSet) {
                errorObjHeader.setPFlag(this.bPFlag);
            }
            if (this.bIsIFlagSet) {
                errorObjHeader.setIFlag(this.bIFlag);
            }
            return new PcepErrorObjectVer1(errorObjHeader, this.yErrorType, this.yErrorValue, this.llOptionalTlv);
        }

        @Override
        public PcepObjectHeader getErrorObjHeader() {
            return this.errorObjHeader;
        }

        @Override
        public Builder setErrorObjHeader(PcepObjectHeader obj) {
            this.errorObjHeader = obj;
            this.bIsHeaderSet = true;
            return this;
        }

        @Override
        public int getErrorType() {
            return this.yErrorType;
        }

        @Override
        public Builder setErrorType(byte value) {
            this.yErrorType = value;
            return this;
        }

        @Override
        public byte getErrorValue() {
            return this.yErrorValue;
        }

        @Override
        public Builder setErrorValue(byte value) {
            this.yErrorValue = value;
            return this;
        }

        @Override
        public Builder setOptionalTlv(LinkedList<PcepValueType> llOptionalTlv) {
            this.llOptionalTlv = llOptionalTlv;
            return this;
        }

        @Override
        public LinkedList<PcepValueType> getOptionalTlv() {
            return this.llOptionalTlv;
        }

        @Override
        public Builder setPFlag(boolean value) {
            this.bPFlag = value;
            this.bIsPFlagSet = true;
            return this;
        }

        @Override
        public Builder setIFlag(boolean value) {
            this.bIFlag = value;
            this.bIsIFlagSet = true;
            return this;
        }
    }
}

