/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.pcepio.protocol.ver1;

import com.google.common.base.MoreObjects;
import org.jboss.netty.buffer.ChannelBuffer;
import org.onosproject.pcepio.exceptions.PcepParseException;
import org.onosproject.pcepio.protocol.PcepFecObjectIPv4Adjacency;
import org.onosproject.pcepio.protocol.PcepVersion;
import org.onosproject.pcepio.types.PcepObjectHeader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PcepFecObjectIPv4AdjacencyVer1
implements PcepFecObjectIPv4Adjacency {
    protected static final Logger log = LoggerFactory.getLogger(PcepFecObjectIPv4AdjacencyVer1.class);
    public static final byte FEC_OBJ_TYPE = 3;
    public static final byte FEC_OBJ_CLASS = 36;
    public static final byte FEC_OBJECT_VERSION = 1;
    public static final short FEC_OBJ_MINIMUM_LENGTH = 12;
    public static final int MINIMUM_COMMON_HEADER_LENGTH = 4;
    static final PcepObjectHeader DEFAULT_FEC_OBJECT_HEADER = new PcepObjectHeader(36, 3, false, false, 12);
    private PcepObjectHeader fecObjHeader;
    private int localIPv4Address;
    private int remoteIPv4Address;

    public PcepFecObjectIPv4AdjacencyVer1(PcepObjectHeader fecObjHeader, int localIPv4Address, int remoteIPv4Address) {
        this.fecObjHeader = fecObjHeader;
        this.localIPv4Address = localIPv4Address;
        this.remoteIPv4Address = remoteIPv4Address;
    }

    public void setFecIpv4ObjHeader(PcepObjectHeader obj) {
        this.fecObjHeader = obj;
    }

    @Override
    public int getLocalIPv4Address() {
        return this.localIPv4Address;
    }

    @Override
    public void seLocalIPv4Address(int value) {
        this.localIPv4Address = value;
    }

    @Override
    public int getRemoteIPv4Address() {
        return this.remoteIPv4Address;
    }

    @Override
    public void seRemoteIPv4Address(int value) {
        this.remoteIPv4Address = value;
    }

    public static PcepFecObjectIPv4Adjacency read(ChannelBuffer cb) throws PcepParseException {
        PcepObjectHeader fecObjHeader = PcepObjectHeader.read(cb);
        ChannelBuffer tempCb = cb.readBytes(fecObjHeader.getObjLen() - 4);
        int localIPv4Address = tempCb.readInt();
        int remoteIPv4Address = tempCb.readInt();
        return new PcepFecObjectIPv4AdjacencyVer1(fecObjHeader, localIPv4Address, remoteIPv4Address);
    }

    @Override
    public int write(ChannelBuffer cb) throws PcepParseException {
        int objStartIndex = cb.writerIndex();
        int objLenIndex = this.fecObjHeader.write(cb);
        cb.writeInt(this.localIPv4Address);
        cb.writeInt(this.remoteIPv4Address);
        cb.setShort(objLenIndex, (int)((short)(cb.writerIndex() - objStartIndex)));
        return cb.writerIndex();
    }

    @Override
    public PcepVersion getVersion() {
        return PcepVersion.PCEP_1;
    }

    @Override
    public int getType() {
        return 3;
    }

    public String toString() {
        return MoreObjects.toStringHelper(this.getClass()).add("fecObjHeader", (Object)this.fecObjHeader).add("localIPv4Address", this.localIPv4Address).add("remoteIPv4Address", this.remoteIPv4Address).toString();
    }

    public static class Builder
    implements PcepFecObjectIPv4Adjacency.Builder {
        private boolean bIsHeaderSet = false;
        private boolean bIsLocalIPv4Addressset = false;
        private boolean bIsRemoteIPv4Addressset = false;
        private PcepObjectHeader fecObjHeader;
        int localIPv4Address;
        int remoteIPv4Address;
        private boolean bIsPFlagSet = false;
        private boolean bPFlag;
        private boolean bIsIFlagSet = false;
        private boolean bIFlag;

        @Override
        public PcepFecObjectIPv4Adjacency build() throws PcepParseException {
            PcepObjectHeader fecObjHeader;
            PcepObjectHeader pcepObjectHeader = fecObjHeader = this.bIsHeaderSet ? this.fecObjHeader : DEFAULT_FEC_OBJECT_HEADER;
            if (!this.bIsLocalIPv4Addressset) {
                throw new PcepParseException("Local IPv4 Address not set while building PcepFecObjectIPv4Adjacency object.");
            }
            if (!this.bIsRemoteIPv4Addressset) {
                throw new PcepParseException(" Remote IPv4 Address not set while building PcepFecObjectIPv4Adjacency object.");
            }
            if (this.bIsPFlagSet) {
                fecObjHeader.setPFlag(this.bPFlag);
            }
            if (this.bIsIFlagSet) {
                fecObjHeader.setIFlag(this.bIFlag);
            }
            return new PcepFecObjectIPv4AdjacencyVer1(fecObjHeader, this.localIPv4Address, this.remoteIPv4Address);
        }

        @Override
        public Builder setPFlag(boolean value) {
            this.bPFlag = value;
            this.bIsPFlagSet = true;
            return this;
        }

        @Override
        public Builder setIFlag(boolean value) {
            this.bIFlag = value;
            this.bIsIFlagSet = true;
            return this;
        }

        @Override
        public PcepObjectHeader getFecIpv4AdjacencyObjHeader() {
            return this.fecObjHeader;
        }

        @Override
        public Builder setFecIpv4AdjacencyObjHeader(PcepObjectHeader obj) {
            this.fecObjHeader = obj;
            this.bIsHeaderSet = true;
            return this;
        }

        @Override
        public int getLocalIPv4Address() {
            return this.localIPv4Address;
        }

        @Override
        public Builder seLocalIPv4Address(int value) {
            this.localIPv4Address = value;
            this.bIsLocalIPv4Addressset = true;
            return this;
        }

        @Override
        public int getRemoteIPv4Address() {
            return this.remoteIPv4Address;
        }

        @Override
        public Builder seRemoteIPv4Address(int value) {
            this.remoteIPv4Address = value;
            this.bIsRemoteIPv4Addressset = true;
            return this;
        }
    }
}

