/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.pcepio.protocol.ver1;

import com.google.common.base.MoreObjects;
import org.jboss.netty.buffer.ChannelBuffer;
import org.onosproject.pcepio.exceptions.PcepParseException;
import org.onosproject.pcepio.protocol.PcepFecObjectIPv4UnnumberedAdjacency;
import org.onosproject.pcepio.protocol.PcepVersion;
import org.onosproject.pcepio.types.PcepObjectHeader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PcepFecObjectIPv4UnnumberedAdjacencyVer1
implements PcepFecObjectIPv4UnnumberedAdjacency {
    protected static final Logger log = LoggerFactory.getLogger(PcepFecObjectIPv4UnnumberedAdjacencyVer1.class);
    public static final byte FEC_OBJ_TYPE = 5;
    public static final byte FEC_OBJ_CLASS = 63;
    public static final byte FEC_OBJECT_VERSION = 1;
    public static final short FEC_OBJ_MINIMUM_LENGTH = 20;
    public static final int MINIMUM_COMMON_HEADER_LENGTH = 4;
    static final PcepObjectHeader DEFAULT_FEC_OBJECT_HEADER = new PcepObjectHeader(63, 5, false, false, 20);
    private PcepObjectHeader fecObjHeader;
    private int localNodeID;
    private int localInterfaceID;
    private int remoteNodeID;
    private int remoteInterfaceID;

    public PcepFecObjectIPv4UnnumberedAdjacencyVer1(PcepObjectHeader fecObjHeader, int localNodeID, int localInterfaceID, int remoteNodeID, int remoteInterfaceID) {
        this.fecObjHeader = fecObjHeader;
        this.localNodeID = localNodeID;
        this.localInterfaceID = localInterfaceID;
        this.remoteNodeID = remoteNodeID;
        this.remoteInterfaceID = remoteInterfaceID;
    }

    public void setFecIpv4UnnumberedAdjacencyObjHeader(PcepObjectHeader obj) {
        this.fecObjHeader = obj;
    }

    @Override
    public void setLocalNodeID(int localNodeID) {
        this.localNodeID = localNodeID;
    }

    public PcepObjectHeader getFecIpv4UnnumberedAdjacencyObjHeader() {
        return this.fecObjHeader;
    }

    @Override
    public int getLocalNodeID() {
        return this.localNodeID;
    }

    @Override
    public int getLocalInterfaceID() {
        return this.localInterfaceID;
    }

    @Override
    public void setLocalInterfaceID(int localInterfaceID) {
        this.localInterfaceID = localInterfaceID;
    }

    @Override
    public int getRemoteNodeID() {
        return this.remoteNodeID;
    }

    @Override
    public void setRemoteNodeID(int remoteNodeID) {
        this.remoteNodeID = remoteNodeID;
    }

    @Override
    public int getRemoteInterfaceID() {
        return this.remoteInterfaceID;
    }

    @Override
    public void setRemoteInterfaceID(int remoteInterfaceID) {
        this.remoteInterfaceID = remoteInterfaceID;
    }

    public static PcepFecObjectIPv4UnnumberedAdjacency read(ChannelBuffer cb) throws PcepParseException {
        PcepObjectHeader fecObjHeader = PcepObjectHeader.read(cb);
        ChannelBuffer tempCb = cb.readBytes(fecObjHeader.getObjLen() - 4);
        int localNodeID = tempCb.readInt();
        int localInterfaceID = tempCb.readInt();
        int remoteNodeID = tempCb.readInt();
        int remoteInterfaceID = tempCb.readInt();
        return new PcepFecObjectIPv4UnnumberedAdjacencyVer1(fecObjHeader, localNodeID, localInterfaceID, remoteNodeID, remoteInterfaceID);
    }

    @Override
    public int write(ChannelBuffer cb) throws PcepParseException {
        int objStartIndex = cb.writerIndex();
        int objLenIndex = this.fecObjHeader.write(cb);
        cb.writeInt(this.localNodeID);
        cb.writeInt(this.localInterfaceID);
        cb.writeInt(this.remoteNodeID);
        cb.writeInt(this.remoteInterfaceID);
        cb.setShort(objLenIndex, (int)((short)(cb.writerIndex() - objStartIndex)));
        return cb.writerIndex();
    }

    @Override
    public PcepVersion getVersion() {
        return PcepVersion.PCEP_1;
    }

    @Override
    public int getType() {
        return 5;
    }

    public String toString() {
        return MoreObjects.toStringHelper(this.getClass()).add("LocalNodeID: ", this.localNodeID).add("LocalInterfaceID: ", this.localInterfaceID).add("RemoteNodeID: ", this.remoteNodeID).add("RemoteInterfaceID: ", this.remoteInterfaceID).toString();
    }

    public static class Builder
    implements PcepFecObjectIPv4UnnumberedAdjacency.Builder {
        private boolean bIsHeaderSet = false;
        private boolean bIsLocalNodeIDset = false;
        private boolean bIsLocalInterfaceIDset = false;
        private boolean bIsRemoteNodeIDset = false;
        private boolean bIsRemoteInterfaceIDset = false;
        private PcepObjectHeader fecObjHeader;
        private int localNodeID;
        private int localInterfaceID;
        private int remoteNodeID;
        private int remoteInterfaceID;
        private boolean bIsPFlagSet = false;
        private boolean bPFlag;
        private boolean bIsIFlagSet = false;
        private boolean bIFlag;

        @Override
        public PcepFecObjectIPv4UnnumberedAdjacency build() throws PcepParseException {
            PcepObjectHeader fecObjHeader;
            PcepObjectHeader pcepObjectHeader = fecObjHeader = this.bIsHeaderSet ? this.fecObjHeader : DEFAULT_FEC_OBJECT_HEADER;
            if (!this.bIsLocalNodeIDset) {
                throw new PcepParseException(" Local Node ID not set while building PcepFecObjectIPv4UnnumberedAdjacency object.");
            }
            if (!this.bIsLocalInterfaceIDset) {
                throw new PcepParseException(" Local Interface ID not set while building PcepFecObjectIPv4UnnumberedAdjacency object.");
            }
            if (!this.bIsRemoteNodeIDset) {
                throw new PcepParseException(" Remote Node ID not set while building PcepFecObjectIPv4UnnumberedAdjacency object.");
            }
            if (!this.bIsRemoteInterfaceIDset) {
                throw new PcepParseException(" Remote Interface ID not set while building PcepFecObjectIPv4UnnumberedAdjacency object.");
            }
            if (this.bIsPFlagSet) {
                fecObjHeader.setPFlag(this.bPFlag);
            }
            if (this.bIsIFlagSet) {
                fecObjHeader.setIFlag(this.bIFlag);
            }
            return new PcepFecObjectIPv4UnnumberedAdjacencyVer1(fecObjHeader, this.localNodeID, this.localInterfaceID, this.remoteNodeID, this.remoteInterfaceID);
        }

        @Override
        public Builder setPFlag(boolean value) {
            this.bPFlag = value;
            this.bIsPFlagSet = true;
            return this;
        }

        @Override
        public Builder setIFlag(boolean value) {
            this.bIFlag = value;
            this.bIsIFlagSet = true;
            return this;
        }

        @Override
        public PcepObjectHeader getFecIpv4UnnumberedAdjacencyObjHeader() {
            return this.fecObjHeader;
        }

        @Override
        public Builder setFecIpv4UnnumberedAdjacencyObjHeader(PcepObjectHeader obj) {
            this.fecObjHeader = obj;
            this.bIsHeaderSet = true;
            return this;
        }

        @Override
        public int getLocalNodeID() {
            return this.localNodeID;
        }

        @Override
        public Builder setLocalNodeID(int value) {
            this.localNodeID = value;
            this.bIsLocalNodeIDset = true;
            return this;
        }

        @Override
        public int getLocalInterfaceID() {
            return this.localInterfaceID;
        }

        @Override
        public Builder setLocalInterfaceID(int value) {
            this.localInterfaceID = value;
            this.bIsLocalInterfaceIDset = true;
            return this;
        }

        @Override
        public int getRemoteNodeID() {
            return this.remoteNodeID;
        }

        @Override
        public Builder setRemoteNodeID(int value) {
            this.remoteNodeID = value;
            this.bIsRemoteNodeIDset = true;
            return this;
        }

        @Override
        public int getRemoteInterfaceID() {
            return this.remoteInterfaceID;
        }

        @Override
        public Builder setRemoteInterfaceID(int value) {
            this.remoteInterfaceID = value;
            this.bIsRemoteInterfaceIDset = true;
            return this;
        }
    }
}

