/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.pcepio.protocol.ver1;

import com.google.common.base.MoreObjects;
import org.jboss.netty.buffer.ChannelBuffer;
import org.onosproject.pcepio.exceptions.PcepParseException;
import org.onosproject.pcepio.protocol.PcepKeepaliveMsg;
import org.onosproject.pcepio.protocol.PcepMessageReader;
import org.onosproject.pcepio.protocol.PcepMessageWriter;
import org.onosproject.pcepio.protocol.PcepType;
import org.onosproject.pcepio.protocol.PcepVersion;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class PcepKeepaliveMsgVer1
implements PcepKeepaliveMsg {
    protected static final Logger log = LoggerFactory.getLogger(PcepKeepaliveMsgVer1.class);
    public static final byte PACKET_VERSION = 1;
    public static final int PACKET_MINIMUM_LENGTH = 4;
    public static final PcepType MSG_TYPE = PcepType.KEEP_ALIVE;
    public static final Reader READER = new Reader();
    static final Writer WRITER = new Writer();

    PcepKeepaliveMsgVer1() {
    }

    @Override
    public void writeTo(ChannelBuffer cb) {
        WRITER.write(cb, this);
    }

    @Override
    public PcepVersion getVersion() {
        return PcepVersion.PCEP_1;
    }

    @Override
    public PcepType getType() {
        return MSG_TYPE;
    }

    public String toString() {
        return MoreObjects.toStringHelper(this.getClass()).toString();
    }

    static class Writer
    implements PcepMessageWriter<PcepKeepaliveMsgVer1> {
        Writer() {
        }

        @Override
        public void write(ChannelBuffer cb, PcepKeepaliveMsgVer1 message) {
            int startIndex = cb.writerIndex();
            cb.writeByte(32);
            cb.writeByte((int)MSG_TYPE.getType());
            int msgLenIndex = cb.writerIndex();
            cb.writeShort(0);
            int length = cb.writerIndex() - startIndex;
            cb.setShort(msgLenIndex, (int)((short)length));
        }
    }

    static class Builder
    implements PcepKeepaliveMsg.Builder {
        Builder() {
        }

        @Override
        public PcepVersion getVersion() {
            return PcepVersion.PCEP_1;
        }

        @Override
        public PcepType getType() {
            return PcepType.KEEP_ALIVE;
        }

        @Override
        public PcepKeepaliveMsg build() {
            return new PcepKeepaliveMsgVer1();
        }
    }

    static class Reader
    implements PcepMessageReader<PcepKeepaliveMsg> {
        Reader() {
        }

        @Override
        public PcepKeepaliveMsg readFrom(ChannelBuffer cb) throws PcepParseException {
            if (cb.readableBytes() < 4) {
                throw new PcepParseException("Packet size is less than the minimum required length.");
            }
            byte version = cb.readByte();
            if ((version = (byte)(version >> 5)) != 1) {
                throw new PcepParseException("Wrong version: Expected=PcepVersion.KEEP_ALIVE_1(2), got=" + version);
            }
            byte type = cb.readByte();
            if (type != MSG_TYPE.getType()) {
                throw new PcepParseException("Wrong type: Expected=PcepType.KEEP_ALIVE_1(2), got=" + type);
            }
            short length = cb.readShort();
            if (length < 4) {
                throw new PcepParseException("Wrong length: Expected to be >= 4, was: " + length);
            }
            return new PcepKeepaliveMsgVer1();
        }
    }
}

