/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.pcepio.protocol.ver1;

import com.google.common.base.MoreObjects;
import java.util.LinkedList;
import java.util.ListIterator;
import org.jboss.netty.buffer.ChannelBuffer;
import org.onosproject.pcepio.exceptions.PcepParseException;
import org.onosproject.pcepio.protocol.PcepLabelObject;
import org.onosproject.pcepio.protocol.ver1.PcepLspObjectVer1;
import org.onosproject.pcepio.types.NexthopIPv4addressTlv;
import org.onosproject.pcepio.types.NexthopIPv6addressTlv;
import org.onosproject.pcepio.types.NexthopUnnumberedIPv4IDTlv;
import org.onosproject.pcepio.types.PcepObjectHeader;
import org.onosproject.pcepio.types.PcepValueType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PcepLabelObjectVer1
implements PcepLabelObject {
    protected static final Logger log = LoggerFactory.getLogger(PcepLspObjectVer1.class);
    public static final byte LABEL_OBJ_TYPE = 1;
    public static final byte LABEL_OBJ_CLASS = 35;
    public static final byte LABEL_OBJECT_VERSION = 1;
    public static final byte OBJECT_HEADER_LENGTH = 4;
    public static final boolean DEFAULT_OFLAG = false;
    public static final short LABEL_OBJ_MINIMUM_LENGTH = 12;
    public static final int OFLAG_SET = 1;
    public static final int OFLAG_RESET = 0;
    public static final int MINIMUM_COMMON_HEADER_LENGTH = 4;
    static final PcepObjectHeader DEFAULT_LABEL_OBJECT_HEADER = new PcepObjectHeader(35, 1, false, false, 12);
    private PcepObjectHeader labelObjHeader;
    private boolean bOFlag;
    private int label;
    private LinkedList<PcepValueType> llOptionalTlv;

    public PcepLabelObjectVer1(PcepObjectHeader labelObjHeader, boolean bOFlag, int label, LinkedList<PcepValueType> llOptionalTlv) {
        this.labelObjHeader = labelObjHeader;
        this.bOFlag = bOFlag;
        this.label = label;
        this.llOptionalTlv = llOptionalTlv;
    }

    @Override
    public LinkedList<PcepValueType> getOptionalTlv() {
        return this.llOptionalTlv;
    }

    @Override
    public void setOptionalTlv(LinkedList<PcepValueType> llOptionalTlv) {
        this.llOptionalTlv = llOptionalTlv;
    }

    @Override
    public boolean getOFlag() {
        return this.bOFlag;
    }

    @Override
    public void setOFlag(boolean value) {
        this.bOFlag = value;
    }

    @Override
    public int getLabel() {
        return this.label;
    }

    @Override
    public void setLabel(int value) {
        this.label = value;
    }

    public static PcepLabelObject read(ChannelBuffer cb) throws PcepParseException {
        LinkedList<PcepValueType> llOptionalTlv = new LinkedList();
        PcepObjectHeader labelObjHeader = PcepObjectHeader.read(cb);
        ChannelBuffer tempCb = cb.readBytes(labelObjHeader.getObjLen() - 4);
        int iTemp = tempCb.readInt();
        boolean bOFlag = (iTemp & 1) == 1;
        int label = tempCb.readInt();
        llOptionalTlv = PcepLabelObjectVer1.parseOptionalTlv(tempCb);
        return new PcepLabelObjectVer1(labelObjHeader, bOFlag, label, llOptionalTlv);
    }

    @Override
    public int write(ChannelBuffer cb) throws PcepParseException {
        int objStartIndex = cb.writerIndex();
        int objLenIndex = this.labelObjHeader.write(cb);
        if (objLenIndex <= 0) {
            throw new PcepParseException(" ObjectLength Index is " + objLenIndex);
        }
        byte oFlag = (byte)(this.bOFlag ? 1 : 0);
        cb.writeInt((int)oFlag);
        cb.writeInt(this.label);
        this.packOptionalTlv(cb);
        int length = cb.writerIndex() - objStartIndex;
        this.labelObjHeader.setObjLen((short)length);
        cb.setShort(objLenIndex, (int)((short)length));
        return cb.writerIndex();
    }

    protected static LinkedList<PcepValueType> parseOptionalTlv(ChannelBuffer cb) throws PcepParseException {
        LinkedList<PcepValueType> llOutOptionalTlv = new LinkedList<PcepValueType>();
        while (4 <= cb.readableBytes()) {
            PcepValueType tlv;
            short hType = cb.readShort();
            short hLength = cb.readShort();
            int iValue = 0;
            switch (hType) {
                case 2: {
                    iValue = cb.readInt();
                    tlv = new NexthopIPv4addressTlv(iValue);
                    break;
                }
                case 100: {
                    byte[] ipv6Value = new byte[16];
                    cb.readBytes(ipv6Value, 0, 16);
                    tlv = new NexthopIPv6addressTlv(ipv6Value);
                    break;
                }
                case 1: {
                    tlv = NexthopUnnumberedIPv4IDTlv.read(cb);
                    break;
                }
                default: {
                    throw new PcepParseException("Unsupported TLV type :" + hType);
                }
            }
            int pad = hLength % 4;
            if (0 < pad && (pad = 4 - pad) <= cb.readableBytes()) {
                cb.skipBytes(pad);
            }
            llOutOptionalTlv.add(tlv);
        }
        if (0 < cb.readableBytes()) {
            throw new PcepParseException("Optional Tlv parsing error. Extra bytes received.");
        }
        return llOutOptionalTlv;
    }

    protected int packOptionalTlv(ChannelBuffer cb) {
        ListIterator listIterator = this.llOptionalTlv.listIterator();
        while (listIterator.hasNext()) {
            PcepValueType tlv = (PcepValueType)listIterator.next();
            if (tlv == null) {
                log.debug("tlv is null from OptionalTlv list");
                continue;
            }
            tlv.write(cb);
        }
        return cb.writerIndex();
    }

    public String toString() {
        return MoreObjects.toStringHelper(this.getClass()).add("OFlag", this.bOFlag).add("label", this.label).add("OptionalTlvList", this.llOptionalTlv).toString();
    }

    public static class Builder
    implements PcepLabelObject.Builder {
        private boolean bIsHeaderSet = false;
        private boolean bIsOFlagSet = false;
        private boolean bIsLabelSet = false;
        private PcepObjectHeader labelObjHeader;
        private boolean bOFlag;
        private int label;
        LinkedList<PcepValueType> llOptionalTlv = new LinkedList();
        private boolean bIsPFlagSet = false;
        private boolean bPFlag;
        private boolean bIsIFlagSet = false;
        private boolean bIFlag;

        @Override
        public PcepLabelObject build() throws PcepParseException {
            boolean bOFlag;
            PcepObjectHeader labelObjHeader = this.bIsHeaderSet ? this.labelObjHeader : DEFAULT_LABEL_OBJECT_HEADER;
            boolean bl = bOFlag = this.bIsOFlagSet ? this.bOFlag : false;
            if (!this.bIsLabelSet) {
                throw new PcepParseException(" Label NOT Set while building PcepLabelObject.");
            }
            if (this.bIsPFlagSet) {
                labelObjHeader.setPFlag(this.bPFlag);
            }
            if (this.bIsIFlagSet) {
                labelObjHeader.setIFlag(this.bIFlag);
            }
            return new PcepLabelObjectVer1(labelObjHeader, bOFlag, this.label, this.llOptionalTlv);
        }

        @Override
        public PcepObjectHeader getLabelObjHeader() {
            return this.labelObjHeader;
        }

        @Override
        public Builder setLabelObjHeader(PcepObjectHeader obj) {
            this.labelObjHeader = obj;
            this.bIsHeaderSet = true;
            return this;
        }

        @Override
        public boolean getOFlag() {
            return this.bOFlag;
        }

        @Override
        public Builder setOFlag(boolean value) {
            this.bOFlag = value;
            this.bIsOFlagSet = true;
            return this;
        }

        @Override
        public int getLabel() {
            return this.label;
        }

        @Override
        public Builder setLabel(int value) {
            this.label = value;
            this.bIsLabelSet = true;
            return this;
        }

        @Override
        public LinkedList<PcepValueType> getOptionalTlv() {
            return this.llOptionalTlv;
        }

        @Override
        public Builder setOptionalTlv(LinkedList<PcepValueType> llOptionalTlv) {
            this.llOptionalTlv = llOptionalTlv;
            return this;
        }

        @Override
        public Builder setPFlag(boolean value) {
            this.bPFlag = value;
            this.bIsPFlagSet = true;
            return this;
        }

        @Override
        public Builder setIFlag(boolean value) {
            this.bIFlag = value;
            this.bIsIFlagSet = true;
            return this;
        }
    }
}

