/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.pcepio.protocol.ver1;

import com.google.common.base.MoreObjects;
import java.util.LinkedList;
import java.util.ListIterator;
import org.jboss.netty.buffer.ChannelBuffer;
import org.onosproject.pcepio.exceptions.PcepParseException;
import org.onosproject.pcepio.protocol.PcepLabelRange;
import org.onosproject.pcepio.protocol.PcepLabelRangeObject;
import org.onosproject.pcepio.protocol.PcepSrpObject;
import org.onosproject.pcepio.protocol.ver1.PcepLabelRangeObjectVer1;
import org.onosproject.pcepio.protocol.ver1.PcepSrpObjectVer1;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PcepLabelRangeVer1
implements PcepLabelRange {
    protected static final Logger log = LoggerFactory.getLogger(PcepLabelRangeVer1.class);
    private PcepSrpObject srpObject;
    private LinkedList<PcepLabelRangeObject> llLabelRangeList;

    public PcepLabelRangeVer1() {
        this.srpObject = null;
        this.llLabelRangeList = null;
    }

    PcepLabelRangeVer1(PcepSrpObject srpObj, LinkedList<PcepLabelRangeObject> llLabelRangeList) {
        this.srpObject = srpObj;
        this.llLabelRangeList = llLabelRangeList;
    }

    @Override
    public PcepSrpObject getSrpObject() {
        return this.srpObject;
    }

    @Override
    public void setSrpObject(PcepSrpObject srpObject) {
        this.srpObject = srpObject;
    }

    @Override
    public LinkedList<PcepLabelRangeObject> getLabelRangeList() {
        return this.llLabelRangeList;
    }

    @Override
    public void setLabelRangeList(LinkedList<PcepLabelRangeObject> ll) {
        this.llLabelRangeList = ll;
    }

    public static PcepLabelRange read(ChannelBuffer cb) throws PcepParseException {
        PcepSrpObject srpObj = null;
        srpObj = PcepSrpObjectVer1.read(cb);
        if (srpObj == null) {
            throw new PcepParseException("Exception while parsing srp object");
        }
        LinkedList<PcepLabelRangeObject> llLabelRangeList = new LinkedList<PcepLabelRangeObject>();
        boolean bFoundLabelRangeObj = false;
        while (0 < cb.readableBytes()) {
            PcepLabelRangeObject lrObj = PcepLabelRangeObjectVer1.read(cb);
            if (lrObj == null) {
                throw new PcepParseException("Exception while parsing label range object");
            }
            llLabelRangeList.add(lrObj);
            bFoundLabelRangeObj = true;
        }
        if (!bFoundLabelRangeObj) {
            throw new PcepParseException("At least one LABEL-RANGE MUST be present.");
        }
        return new PcepLabelRangeVer1(srpObj, llLabelRangeList);
    }

    @Override
    public int write(ChannelBuffer cb) throws PcepParseException {
        int objStartIndex = cb.writerIndex();
        int objLenIndex = this.srpObject.write(cb);
        if (objLenIndex <= 0) {
            throw new PcepParseException("bjectLength is " + objLenIndex);
        }
        ListIterator listIterator = this.llLabelRangeList.listIterator();
        while (listIterator.hasNext()) {
            ((PcepLabelRangeObject)listIterator.next()).write(cb);
        }
        int length = cb.writerIndex() - objStartIndex;
        int pad = length % 4;
        if (pad != 0) {
            pad = 4 - pad;
            for (int i = 0; i < pad; ++i) {
                cb.writeByte(0);
            }
            length += pad;
        }
        cb.setShort(objLenIndex, (int)((short)length));
        return length;
    }

    public String toString() {
        return MoreObjects.toStringHelper(this.getClass()).add("srpObject", (Object)this.srpObject).add("LabelRangeList", this.llLabelRangeList).toString();
    }
}

